// --------------------------------------------------------------------
// Copyright (c) 2001 by Lattice Semiconductor Corporation
// --------------------------------------------------------------------
//
//
//                     Lattice Semiconductor Corporation
//                     5555 NE Moore Court
//                     Hillsboro, OR 97214
//                     U.S.A
//
//                     TEL: 1-800-Lattice (USA and Canada)
//                          408-826-6000 (other locations)
//
//                     web: http://www.latticesemi.com/
//                     email: techsupport@latticesemi.com
//
// --------------------------------------------------------------------
//
// Simulation Library File for ispXPGA
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            :| Mod. Date   :| Changes Made:
//   V1.0 :| TSE               :| 04/28/2005  :| Pre-Release
//       change SC_BRAM_16K_L
//       change SC_DPRAM_16K_L to fix DTS26157
//       add SDLAT, SDLATSH, SDLATRH
// --------------------------------------------------------------------
//   V2.0 :| TSE               :| 06/16/2005  :| Pre-Release
//   affected modules:
//      RAMB512X9DSR
//	RAMB512X9DSR_1
//	RAMB256X18DSR
//	RAMB256X18DSR_1 
//   avoid incorrectly latching unknown values to write address
// --------------------------------------------------------------------
//   V3.0 :| TSE               :| 10/15/2005  :| Pre-Release
//   SC_BRAM_16K_L:
//      update read data when rd_addr_msb,lsb change
//   SC_SPRAM_16K_L:  
//      1/ send pulsed enables to BRAM rather that 
//         one-clock-cycle-wide signals
//      2/ change REN_pulse to read-before-write 
//   RAMB512X9DSR
//   RAMB512X9DSR_1
//   RAMB256X18DSR
//   RAMB256X18DSR_1: 
//      Completely restructured to no longer use gated clocks
//      to control rd and wr. This is to avoid potenial race 
//      conditions
// --------------------------------------------------------------------



//$Header: R:/src/mod_kits/ispXPGA/Verilog/rcs/LAVA1.v 1.97 2004/01/28 22:42:35Z jli Exp $ 
`timescale 10ps / 10ps

`define in1_LUT_min 0.00
`define in1_LUT_max 0.00
`define in1_LUT_typ 0.00

`define in2_LUT_min 0.00
`define in2_LUT_max 0.00
`define in2_LUT_typ 0.00

`define in3_LUT_min 0.00
`define in3_LUT_max 0.00
`define in3_LUT_typ 0.00

`define in4_LUT_min 0.00
`define in4_LUT_max 0.00
`define in4_LUT_typ 0.00

`define CLB_REG_CLK_out_min 1.00
`define CLB_REG_CLK_out_max 1.00
`define CLB_REG_CLK_out_typ 1.00

`define CLB_LAT_D_out_min 0.00
`define CLB_LAT_D_out_max 0.00
`define CLB_LAT_D_out_typ 0.00

`define CLB_REG_S_out_min 0.00
`define CLB_REG_S_out_max 0.00
`define CLB_REG_S_out_typ 0.00

`define CLB_REG_R_out_min 0.00
`define CLB_REG_R_out_max 0.00
`define CLB_REG_R_out_typ 0.00

`define CLB_REG_SETUP_min 0.00
`define CLB_REG_SETUP_max 0.00
`define CLB_REG_SETUP_typ 0.00

`define CLB_REG_HOLD_min 0.00
`define CLB_REG_HOLD_max 0.00
`define CLB_REG_HOLD_typ 0.00

`define CLB_REG_RECOVERY_min 0.00
`define CLB_REG_RECOVERY_max 0.00
`define CLB_REG_RECOVERY_typ 0.00

`define CLB_REG_RHOLD_min 0.00
`define CLB_REG_RHOLD_max 0.00
`define CLB_REG_RHOLD_typ 0.00

`define CLB_REG_WIDTH_min 0.00
`define CLB_REG_WIDTH_max 0.00
`define CLB_REG_WIDTH_typ 0.00

`define CLB_REG_PERIOD_min 0.00
`define CLB_REG_PERIOD_max 0.00
`define CLB_REG_PERIOD_typ 0.00

`define IOB_INPUT_REG_CLK_out_min 0.00
`define IOB_INPUT_REG_CLK_out_max 0.00
`define IOB_INPUT_REG_CLK_out_typ 0.00
 
`define IOB_INPUT_REG_R_out_min 0.00
`define IOB_INPUT_REG_R_out_max 0.00
`define IOB_INPUT_REG_R_out_typ 0.00
 
`define IOB_INPUT_REG_S_out_min 0.00
`define IOB_INPUT_REG_S_out_max 0.00
`define IOB_INPUT_REG_S_out_typ 0.00
 
`define IOB_INPUT_LAT_D_out_min 0.00
`define IOB_INPUT_LAT_D_out_max 0.00
`define IOB_INPUT_LAT_D_out_typ 0.00

`define IOB_INPUT_LAT_R_out_min 0.00
`define IOB_INPUT_LAT_R_out_max 0.00
`define IOB_INPUT_LAT_R_out_typ 0.00

`define IOB_INPUT_LAT_S_out_min 0.00
`define IOB_INPUT_LAT_S_out_max 0.00
`define IOB_INPUT_LAT_S_out_typ 0.00

`define IOB_INPUT_REG_SETUP_min 0.00
`define IOB_INPUT_REG_SETUP_max 0.00
`define IOB_INPUT_REG_SETUP_typ 0.00
 
`define IOB_INPUT_REG_HOLD_min 0.00
`define IOB_INPUT_REG_HOLD_max 0.00
`define IOB_INPUT_REG_HOLD_typ 0.00
 
`define IOB_INPUT_REG_RECOVERY_min 0.00
`define IOB_INPUT_REG_RECOVERY_max 0.00
`define IOB_INPUT_REG_RECOVERY_typ 0.00
 
`define IOB_INPUT_REG_RHOLD_min 0.00
`define IOB_INPUT_REG_RHOLD_max 0.00
`define IOB_INPUT_REG_RHOLD_typ 0.00
 
`define IOB_INPUT_REG_WIDTH_min 0.00
`define IOB_INPUT_REG_WIDTH_max 0.00
`define IOB_INPUT_REG_WIDTH_typ 0.00
 
`define IOB_INPUT_REG_PERIOD_min 0.00
`define IOB_INPUT_REG_PERIOD_max 0.00
`define IOB_INPUT_REG_PERIOD_typ 0.00

`define IOB_OUTPUT_REG_CLK_out_min 0.00
`define IOB_OUTPUT_REG_CLK_out_max 0.00
`define IOB_OUTPUT_REG_CLK_out_typ 0.00
 
`define IOB_OUTPUT_REG_R_out_min 0.00
`define IOB_OUTPUT_REG_R_out_max 0.00
`define IOB_OUTPUT_REG_R_out_typ 0.00
 
`define IOB_OUTPUT_REG_S_out_min 0.00
`define IOB_OUTPUT_REG_S_out_max 0.00
`define IOB_OUTPUT_REG_S_out_typ 0.00
 
`define IOB_OUTPUT_LAT_D_out_min 0.00
`define IOB_OUTPUT_LAT_D_out_max 0.00
`define IOB_OUTPUT_LAT_D_out_typ 0.00

`define IOB_OUTPUT_REG_SETUP_min 0.00
`define IOB_OUTPUT_REG_SETUP_max 0.00
`define IOB_OUTPUT_REG_SETUP_typ 0.00
 
`define IOB_OUTPUT_REG_HOLD_min 0.00
`define IOB_OUTPUT_REG_HOLD_max 0.00
`define IOB_OUTPUT_REG_HOLD_typ 0.00
 
`define IOB_OUTPUT_REG_WIDTH_min 0.00
`define IOB_OUTPUT_REG_WIDTH_max 0.00
`define IOB_OUTPUT_REG_WIDTH_typ 0.00
 
`define IOB_OUTPUT_REG_PERIOD_min 0.00  
`define IOB_OUTPUT_REG_PERIOD_max 0.00
`define IOB_OUTPUT_REG_PERIOD_typ 0.00

`define IN_BUF_min 1.00
`define IN_BUF_max 1.00
`define IN_BUF_typ 1.00

`define IO_delay_min 0.00
`define IO_delay_max 0.00
`define IO_delay_typ 0.00

`define OUT_BUF_min 0.00
`define OUT_BUF_max 0.00
`define OUT_BUF_typ 0.00

`define IN_PAD_min 0.00
`define IN_PAD_max 0.00
`define IN_PAD_typ 0.00

`define OUT_PAD_min 0.00
`define OUT_PAD_max 0.00
`define OUT_PAD_typ 0.00

`define CLB_ADD_CIN_COUT_min 0.00
`define CLB_ADD_CIN_COUT_typ 0.00
`define CLB_ADD_CIN_COUT_max 0.00


`celldefine
`timescale  10 ps / 10 ps
module B_KEEPER (X);

    inout X;
    reg   tmp_in;

    always @(X)
	if (X)
	    tmp_in <= 1;
	else
	    tmp_in <= 0;

    buf (pull1, pull0) B1 (X, tmp_in);

endmodule
`endcelldefine

`celldefine 
`timescale 10 ps / 10 ps
 
module SPLL (CLK_OUT,CLK_IN); 
parameter in_freq = "100.00";
parameter clk_out_to_pin = "off";
parameter wake_on_lock = "off";
input CLK_IN; 
output CLK_OUT; 
supply0 GND; 
supply1 VCC; 
buf INS1 (CLK_OUT, CLK_IN); 
 
specify 
 
(CLK_IN => CLK_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 


`timescale  10 ps / 10 ps
`celldefine 

`timescale  10 ps / 10 ps

module STDPLL (CLK_IN, CLK_OUT, PLL_LOCK);

parameter   in_freq  = "100.00";
parameter   clk_out_to_pin = "off";
parameter   wake_on_lock = "off";
parameter   div      = "32";
parameter   post     = "12";
parameter   mult     = "10";
parameter   pll_dly  = "2";
parameter   secdiv   = "1";
parameter   lock_cyc   = 2;
real clockboost;

input  CLK_IN;
output CLK_OUT, PLL_LOCK;
wire    CLK_OUT, PLL_LOCK;
wire    CLK_OUT_node, PLL_LOCK_node;

wire   clkin_in;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] post_r;
integer post_i;
initial post_r = post;
initial post_i = 10 * convert_int(post_r[15:8]) + convert_int(post_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = pll_dly;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, CLK_IN);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       //clklock_half_period_minus_dly0 = clklock_half_period0 + 100.0 * pll_dly_re; 
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       //clklock_half_period_minus_dly1 = clklock_half_period1 + 100.0 * pll_dly_re; 
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign PLL_LOCK_node = PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0) ;
assign CLK_OUT_node = (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
buf INSXQ1 (PLL_LOCK,PLL_LOCK_node);
buf INSXQ2 (CLK_OUT,CLK_OUT_node);
function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else if (int_str == "-")
      convert_int = -1;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction
specify
      (CLK_IN => CLK_OUT)  =  0:0:0, 0:0:0;
      (CLK_IN => PLL_LOCK) =  0:0:0, 0:0:0;
endspecify
endmodule
`endcelldefine

`timescale  10 ps / 10 ps

`celldefine 
`timescale 10 ps / 10 ps

module STDPLLX (CLK_IN, PLL_FBK, PLL_RST,CLK_OUT, PLL_LOCK, SEC_OUT);

parameter   in_freq    = "100.0";
parameter   div        = "2";
parameter   post       = "1";
parameter   mult       = "1";
parameter   pll_dly    = "0";
parameter   secdiv     = "1";
parameter   clk_out_to_pin = "off";
parameter   wake_on_lock = "off";
parameter   pll_fbk_attribute = "clktree";
parameter   lock_cyc   = 2;
integer     clockboost;

input  CLK_IN, PLL_FBK, PLL_RST;
output CLK_OUT, PLL_LOCK, SEC_OUT;
wire   CLK_OUT, PLL_LOCK;
wire   CLK_OUT_node, PLL_LOCK_node, SEC_OUT_node;

wire   clkin_in;

time   new_delay;
time   secd_delay1;
time   secd_delay0;
time   secd_delay;
time   secd_delay_minus1;
time   secd_delay_minus0;

time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period;
time   clklock_half_period0;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] secdiv_r;
integer secdiv_i;
initial secdiv_r = secdiv;
initial secdiv_i = 10 * convert_int(secdiv_r[15:8]) + convert_int(secdiv_r[7:0]);

reg [15:0] post_r;
integer post_i;
initial post_r = post;
initial post_i = 10 * convert_int(post_r[15:8]) + convert_int(post_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = pll_dly;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;

initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end

reg PLL_RST_int;

initial
begin
     case(PLL_RST)
       1'bZ : PLL_RST_int = 1'b0;
       1'bX : PLL_RST_int = 1'b0;
       1'b0 : PLL_RST_int = PLL_RST;
       1'b1 : PLL_RST_int = PLL_RST;
     endcase
end

always@(PLL_RST)
begin
     case(PLL_RST)
       1'bZ : PLL_RST_int = 1'b0;
       1'bX : PLL_RST_int = 1'b0;
       1'b0 : PLL_RST_int = PLL_RST;
       1'b1 : PLL_RST_int = PLL_RST;
     endcase
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, CLK_IN);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

//always @(posedge clkin_in) 
//begin
//    casez(PLL_FBK)
//        1'bX : $display("Error : PLL feedback unknown.");
//    endcase
//end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       //clklock_half_period_minus_dly0 = clklock_half_period0 + 100.0 * pll_dly_re; 
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
       secd_delay0 = clklock_half_period0 * secdiv_i;
       secd_delay_minus0 = clklock_half_period0 * secdiv_i + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       //clklock_half_period_minus_dly1 = clklock_half_period1 + 100.0 * pll_dly_re; 
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
       secd_delay1 = clklock_half_period1 * secdiv_i;
       secd_delay_minus1 = clklock_half_period1 * secdiv_i + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
secd_delay = (secd_delay0 + secd_delay1)/2.0;
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end

always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1 && !PLL_RST_int)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1 && !PLL_RST_int)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;
reg SEC_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
	SEC_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
    SEC_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg SEC_OUT_sig_3d;
reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

reg start_SEC_OUT;

initial 
begin
SEC_OUT_sig_3d = 1'b0; start_SEC_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    //#secd_delay_minus0 SEC_OUT_sig_3d = 1'b1; start_SEC_OUT = 1'b1;
    #clklock_half_period_minus_dly0 SEC_OUT_sig_3d = 1'b1; start_SEC_OUT = 1'b1;
  end
end

always @(start_SEC_OUT)
begin
      while (start_SEC_OUT) 
      begin
         #secd_delay 
         SEC_OUT_sig_3d = ~ SEC_OUT_sig_3d;
         #secd_delay 
         SEC_OUT_sig_3d = ~ SEC_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign PLL_LOCK_node = !PLL_RST_int && (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign CLK_OUT_node = !PLL_RST_int && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
buf INSXQ1 (PLL_LOCK,PLL_LOCK_node);
buf INSXQ2 (CLK_OUT,CLK_OUT_node);

reg SEC_OUT_sig_d_not;
initial
begin
    SEC_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #secd_delay 
         SEC_OUT_sig_d_not = ~ SEC_OUT_sig_d_not;
         #secd_delay 
         SEC_OUT_sig_d_not = ~ SEC_OUT_sig_d_not;
      end
end

wire SEC_OUT_sig_d = ~SEC_OUT_sig_d_not && SEC_OUT_sig_d_start;

wire SEC_OUT_plus_delay;

assign #new_delay SEC_OUT_plus_delay = SEC_OUT_sig_d;


assign SEC_OUT_node = !PLL_RST_int && (SEC_OUT_plus_delay && (pll_dly_re >=0) || SEC_OUT_sig_3d && (pll_dly_re<0));
buf INSXQ3 (SEC_OUT,SEC_OUT_node);

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else if (int_str == "-")
      convert_int = -1;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(PLL_RST => PLL_LOCK) =  0:0:0, 0:0:0;
(CLK_IN => CLK_OUT)   =   0:0:0, 0:0:0;
(CLK_IN => PLL_LOCK)  =   0:0:0, 0:0:0;
(CLK_IN => SEC_OUT)   =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 

`celldefine

module AS_LSB (S0,COUT,A0,B0,CIN,AS); 
input A0,B0,CIN,AS; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
xnor INS2 (out_1, B0, AS); 
xnor INS3 (out_2, CIN, AS); 
and  INS4 (out_3, A0, out_1); 
and  INS5 (out_4, A0, out_2); 
and  INS6 (out_5, out_1, out_2); 
or   INS7 (COUT, out_3, out_4, out_5); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine


`celldefine

module CCU_AS_LSB (S0,COUT,A0,B0,AS); 
input A0,B0,AS; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, cin, B0); 
xnor INS2 (out_1, B0, AS); 
xnor INS3 (out_2, cin, AS); 
and  INS4 (out_3, A0, out_1); 
and  INS5 (out_4, A0, out_2); 
and  INS6 (out_5, out_1, out_2); 
or   INS7 (COUT, out_3, out_4, out_5); 
not  INS8 (cin, AS); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module BI_DIR (O,I0,IO,OE);
input I0,OE;
inout IO;
output O;

supply0 GND;
supply1 VCC;

buf INS1 (O, IO);
bufif1 INS2 (IO, I0, OE);

specify

(I0 => IO) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => IO) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(IO => O) =  `IO_delay_min:`IO_delay_typ:`IO_delay_max, `IO_delay_min:`IO_delay_typ:`IO_delay_max;

endspecify


endmodule
`endcelldefine

`celldefine

module BUFEI (O,I0,OE);
input I0,OE;
output O;
supply0 GND;
supply1 VCC;
bufif0 INS1 (O, I0, OE);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module LSB_CY (COUT,I0); 
input I0; 
output COUT; 
supply0 GND; 
supply1 VCC; 
buf INS1 (COUT, I0); 
 
specify 
 
(I0 => COUT) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

`celldefine

module LSB_CYI (COUT,I0); 
input I0; 
output COUT; 
supply0 GND; 
supply1 VCC; 
not INS1 (COUT, I0); 
 
specify 
 
(I0 => COUT) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_OUT (O,CI); 
input CI; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, CI); 
 
specify 
 
(CI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BUF (COUT,CI); 
input CI; 
output COUT; 
supply0 GND; 
supply1 VCC; 
buf INS1 (COUT, CI); 
 
specify 
 
(CI => COUT) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module FT_BUF (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module BUFF (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module BUFTH (O,I0,OE);
input I0,OE;
output O;
supply0 GND;
supply1 VCC;
bufif1 INS1 (O, I0, OE);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module BUFTI (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC; 
bufif1 INS1 (O, I0, OE); 
 
specify 
 
(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max; 
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module BUFTL (O,I0,OE);
input I0,OE;
output O;
supply0 GND;
supply1 VCC;
bufif0 INS1 (O, I0, OE);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine



`celldefine

module CCU_ABS (S0,COUT,D,PN,CIN); 
input D,PN,CIN; 
output S0,COUT; 
supply0 GND; 
supply1 VCC; 
 
not INS1(pn,PN); 
not INS3(d,D); 

and INS2(o1,pn,D); 
xor INS4(cin,d,CIN); 
and INS5(o2,PN,cin); 
or INS6(S0,o1,o2); 
and INS7(o3,d,CIN); 
and INS8(COUT,PN,o3); 
 
specify 
 
(D => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(PN => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(CIN => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(D => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(PN => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(CIN => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
endmodule 
 

`endcelldefine
`celldefine

module CCU_ADD (S0,COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
and  INS2 (out_1, A0, B0); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_GEN (S0,COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
and  INS2 (out_1, A0, B0); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine
module CCU_GEN1 (S0,COUT,A0,B0,CIN,D); 
input A0,B0,CIN,D; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
and  INS2 (out_1, A0, B0); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 
`endcelldefine

`celldefine
module CCU_GEN2 (S0,COUT,A0,B0,CIN,D); 
input A0,B0,CIN,D; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
and  INS2 (out_1, A0, B0); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 
`endcelldefine

`celldefine

module CCU_ADD_2S (S0,COUT,A0,B0,SEL,CIN);
input A0,B0,CIN,SEL;
output S0,COUT;

supply0 GND;
supply1 VCC;

not  INS0_0 (inv_A0, A0);
and  INS0_1 (adj_A0, inv_A0, SEL);
xor  INS1 (S0, adj_A0, CIN, B0);
and  INS2 (out_1, adj_A0, B0);
and  INS3 (out_2, adj_A0, CIN);
and  INS4 (out_3, CIN, B0);
or   INS5 (COUT, out_1, out_2, out_3);


specify

(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(SEL => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;
(SEL => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max;

endspecify


endmodule

`endcelldefine



`celldefine

module CCU_AGB (COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output COUT; 
supply0 GND; 
supply1 VCC; 
 
not INS1(b,B0); 
and INS2(a,A0,b); 
xnor INS3(a1,A0,B0); 
and INS4(a2,a1,CIN); 
or INS5(COUT,a,a2); 
 
specify 
 
(A0 => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B0 => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(CIN => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
endmodule 
 

`endcelldefine
`celldefine

module CCU_AGBS (COUT,S0,A0,B0,CIN); 
input A0,B0,CIN; 
output COUT,S0; 
supply0 GND; 
supply1 VCC; 
 
not  INS1 (b,B0); 
and  INS2 (a,A0,b); 
xnor INS3 (a1,A0,B0); 
and  INS4 (a2,a1,CIN); 
or   INS5 (COUT,a,a2); 
xor  INS6 (S0, A0, b, CIN);
 
specify 
 
(A0 => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B0 => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(CIN => COUT) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(A0 => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B0 => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(CIN => S0) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
endmodule 
 

`endcelldefine
`celldefine

module CCU_AS (S0,COUT,A0,B0,CIN,AS); 
input A0,B0,CIN,AS; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor INS1 (S0, A0, CIN, out_1); 
xnor INS2 (out_1, AS, B0); 
or  INS3 (out_2, CIN, A0); 
and INS4 (out_3, out_1, out_2); 
and INS5 (out_4, CIN, A0); 
or  INS6 (COUT, out_4, out_3); 
 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BTH (P,COUT,A0, A1, D0, AS, SH, NOP, CIN);
input  A0, A1, D0, AS, SH, NOP, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS1  (SH_B, SH);
and  INS2  (out1, SH_B, A0);
and  INS3  (out2, SH,   A1);
or   INS4  (out3, out1, out2);

xor  INS5  (out4, AS, out3);

xor  INS6  (out5, out4, D0, CIN);
and  INS7  (out6, out4, D0);
and  INS8  (out7, out4, CIN);
and  INS9  (out8, D0, CIN);
or   INS10 (COUT, out6, out7, out8);

not  INS11 (NOP_B, NOP);
and  INS12 (out9, NOP_B, out5);
and  INS13 (out10, NOP, D0);
or   INS14 (P, out9, out10);


 
specify 
 
(A0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SH  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SH  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine
module CCU_MULT (P,COUT,A0, A1, B0, B1, CIN);
input  A0, A1, B0, B1, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
and  INS1  (out1, A0, B0);
and  INS2  (out2, A1, B1);

xor  INS3 (P, out1, CIN, out2); 
and  INS4 (out_1, out1, out2); 
and  INS5 (out_2, out1, CIN); 
and  INS6 (out_3, CIN, out2); 
or   INS7 (COUT, out_1, out_2, out_3); 

specify 
 
(A0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine





`celldefine

module CCU_BTH_LSTC (P,COUT,A0,A1, ADD, CIN);
input  A0, A1, CIN, ADD;
output P, COUT; 
 
supply0 GND; 
supply1 VCC; 

and  INS1  (out1, A1, ADD);

and  INS2  (out2, A0, CIN);
and  INS3  (out3, out1, CIN);
and  INS4  (out4, A0, out1);

or   INS5  (COUT, out2, out3, out4);

xor  INS6  (P, out1, A0, CIN);
 

 
specify 
 
(A0 => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1 => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(ADD => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(ADD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BTH_TC_LSB (P,COUT,A0, A1, AS, SH, NOP, CIN);
input  A0, A1, AS, SH, NOP, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS1  (SH_B, SH);
and  INS2  (out1, SH_B, A0);
and  INS3  (out2, SH,   A1);
or   INS4  (out3, out1, out2);

xor  INS5  (out4, AS, out3);

xor  INS6  (out5, out4, CIN);
and  INS8  (COUT, out4, CIN);

not  INS9  (NOP_B, NOP);
and  INS10 (P, NOP_B, out5);


 
specify 
 
(A0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SH  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SH  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BTH_TC_MSB (P,COUT,A0, D0, AS, NOP, CIN);
input  A0, D0, AS, NOP, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 

xor  INS5  (out4, AS, A0);

xor  INS6  (out5, out4, D0, CIN);
and  INS7  (out6, out4, D0);
and  INS8  (out7, out4, CIN);
and  INS9  (out8, D0, CIN);
or   INS10 (COUT, out6, out7, out8);

not  INS11 (NOP_B, NOP);
and  INS12 (out9, NOP_B, out5);
and  INS13 (out10, NOP, D0);
or   INS14 (P, out9, out10);


 
specify 
 
(A0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BTH_UNS_LSB (P,COUT,A0, A1, B0, B1, CIN);
input  A0, A1, B0, B1, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
and  INS1  (out1, A0, B0);
and  INS2  (out2, A1, B1);

and  INS3  (out3, out1, CIN);
and  INS4  (out4, out2, CIN);
and  INS5  (out5, out1, out2);

or   INS6  (COUT, out3, out4, out5);

xor  INS7  (P, out1, out2, CIN);


 
specify 
 
(A0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B1  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B1  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_BTH_UNS_MSB (P,COUT, D0, AS, NOP, CIN);
input  D0, AS, NOP, CIN ;
output P,COUT; 
 
supply0 GND; 
supply1 VCC; 
 

and  INS1  (out1, D0, CIN);
and  INS2  (out2, AS, CIN);
and  INS3  (out3, AS, D0);

or   INS4  (COUT, out1, out2, out3);

xor  INS5  (out4, AS, D0, CIN);

not  INS6  (NOP_B, NOP);
and  INS7  (out5, D0, NOP);
and  INS8  (out6, NOP_B, out4);
or   INS9  (P, out5, out6);

specify 
 
(D0  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => P) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D0  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(AS  => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(NOP => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_DC (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xnor  INS1 (S0, D, CIN); 
or    INS2 (COUT,D,CIN);

 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_DCP (S0,COUT,D, SD, LOAD, CIN);
input D, SD, LOAD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 


not  INS1 (LOAD_B, LOAD);
and  INS2 (out_1, LOAD, SD);
and  INS3 (out_2, D, LOAD_B);
or   INS4 (out_3, out_1, out_2);
xnor INS5 (S0, out_3, CIN);

or   INS6 (COUT , out_3, CIN);

specify 
 
(D => S0)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => S0)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => COUT)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_RCD_AS (COUT,AS,B2);
input B2;
output COUT,AS;
supply0 GND;
supply1 VCC;

buf INS1 (COUT, B2);
buf INS2 (AS, B2);

specify

(B2 => COUT) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(B2 => AS) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module CCU_RCD (AS, SH, NOP, B0, B1, B2);
input B0, B1, B2 ;
output AS, SH, NOP;
supply0 GND; 
supply1 VCC; 
 
not  INS1  (B0_B, B0);
not  INS2  (B1_B, B1);
not  INS3  (B2_B, B2);

and  INS4  (out1, B0_B, B1_B, B2);
and  INS5  (out2, B0,   B1,   B2_B);
or   INS6  (SH,   out1, out2);

buf  INS8  (AS, B2);

and  INS9   (out4, B0_B, B1_B, B2_B);
and  INS10  (out5, B0, B1, B2);
or   INS11  (NOP, out5, out4);

 
specify 
 
(B0 => AS)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B1 => AS)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => AS)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B0 => SH)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B1 => SH)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => SH)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B0 => NOP) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B1 => NOP) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => NOP) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
endmodule 
 

`endcelldefine
`celldefine

module CCU_RCD_LSB (AS, SH, NOP, B1, B2);
input  B1, B2 ;
output AS, SH, NOP;
supply0 GND; 
supply1 VCC; 
 
not  INS2  (B1_B, B1);
not  INS3  (B2_B, B2);

and  INS5  (SH, B1_B, B2);

buf  INS8  (AS, B2);

and  INS9   (NOP, B1_B, B2_B);

 
specify 
 
(B1 => AS)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => AS)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B1 => SH)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => SH)  =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B1 => NOP) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(B2 => NOP) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
endmodule 
 

`endcelldefine
`celldefine

module CCU_SUB (S0,COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS0 (B0_B, B0);
xor  INS1 (S0, A0, CIN, B0_B); 
and  INS2 (out_1, A0, B0_B); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0_B); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(A0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(B0 => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_UC (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor   INS1 (S0, D, CIN); 
and   INS2 (COUT,D,CIN);

 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_UCP (S0,COUT,D, SD, LOAD, CIN);
input D, SD, LOAD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 


not  INS1 (LOAD_B, LOAD);
and  INS2 (out_1, LOAD, SD);
and  INS3 (out_2, D, LOAD_B);
or   INS4 (out_3, out_1, out_2);
xor  INS5 (S0, out_3, CIN);

and  INS6 (COUT, out_3, CIN);

specify 
 
(D => S0)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => S0)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => COUT)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_UDC (S0,COUT, D, UD,CIN); 
input D, UD, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS1 (UD_B, UD);
xor  INS2 (S0, D, UD_B, CIN); 
and  INS3 (out_1, D, UD_B);
and  INS4 (out_2, D, CIN);
and  INS5 (out_3, CIN, UD_B); 
or   INS6 (COUT, out_1, out_2, out_3); 

 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CCU_UDCP (S0,COUT,D, SD, LOAD, UD, CIN);
input D, SD, LOAD, UD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 

not  INS1 (LOAD_B, LOAD);
not  INS2 (UD_B, UD);
and  INS3 (out_1, LOAD, SD);
xor  INS4 (out_2, D, UD_B, CIN);
and  INS5 (out_3, LOAD_B, out_2);
or   INS6 (S0, out_1, out_3);

and  INS7 (out_4, D, UD_B);
and  INS8 (out_5, D, CIN);
and  INS9 (out_6, UD_B, CIN);
or   INS10 (COUT, out_4, out_5, out_6);
 
specify 
 
(D => S0)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => S0)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => S0)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => COUT)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => COUT)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 

endmodule 

`endcelldefine

`celldefine

module CLKI(O,PAD);
input PAD;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, PAD);

specify

(PAD => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine

module GCLKBUFI(O,I0);
input I0;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, I0);

specify

(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine
module GCLKBUF(O,CI);
input CI;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, CI);

specify

(CI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine


`celldefine

module CYAND2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
(I1 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CYMUX2 (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module CYXOR2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
xor INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
(I1 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module GSROR2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
(I1 => O) =  `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max, `in2_LUT_min:`in2_LUT_typ:`in2_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module DC_LSB (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, D, CIN); 
and  INS2 (COUT, D, CIN);

 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module DFF (Q,D,CLK); 
input D,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
LAVA1_DFF_X INS1 (Q_int, D, CLK, VCC, VCC, notifier); 
`else 
LAVA1_DFF INS4 (Q_int, D, CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
$setuphold(posedge CLK, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge CLK, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module DFFCB (Q,D,CLK,CE); 
input D,CLK,CE; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS1 (Q_int, D, CLK, VCC, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE INS4 (Q_int, D, CLK, VCC, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(posedge CLK &&& (CE == 0), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(posedge CLK , negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (CE == 0), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE == 0), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module DFFCBLSH (Q,D,SD,LD,CLK,CE); 
input D,CLK,SD,LD,CE; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS1 (Q_int, D_int, CLK, VCC, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE INS4 (Q_int, D_int, CLK, VCC, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS8 (CEB, CE);
not INS12 (LD_B, LD);
and INS9 (out1, LD_B, D);
and INS10 (out2, LD, SD);
or  INS11 (D_int, out1, out2);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
 
$setuphold(posedge CLK &&& (CE == 0), D , `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(posedge CLK, negedge CE, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (CE == 0), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE == 0), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
  
$setuphold(posedge CLK &&& (CE == 0), SD ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 


endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module DFFCBLSH_1 (Q,D,SD,LD,CLK,CE); 
input D,CLK,SD,LD,CE; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_1_X INS1 (Q_int, D_int, CLK, VCC, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE_1 INS4 (Q_int, D_int, CLK, VCC, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS8 (CEB, CE);
not INS12 (LD_B, LD);
and INS9 (out1, LD_B, D);
and INS10 (out2, LD, SD);
or  INS11 (D_int, out1, out2);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(negedge CLK &&& (CE == 0), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(negedge CLK , negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$width(negedge CLK &&& (CE == 0), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE == 0), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
$setuphold(negedge CLK &&& (CE == 0), SD ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 


endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine

module DFFCBRH (Q,D,CLK,CE,R); 
input D,CLK,CE,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS1 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE INS7 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
and INS6 (CE_NR, CEB, R2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (CE_NR), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(posedge CLK , negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (CE_NR), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE_NR), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$recovery(negedge R , posedge CLK &&& (CE == 0), `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge CLK &&& (CE == 0), negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module DFFCBRH_1 (Q,D,CLK,CE,R); 
input D,CLK,CE,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_1_X INS1 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE_1 INS7 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
and INS6 (CE_NR, CEB, R2); 
not INS8 (CEB, CE); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& (CE_NR), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$setuphold(negedge CLK , negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (CE_NR), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE_NR), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge R , negedge CLK &&& (CE == 0), `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge CLK &&& (CE == 0), negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine

module DFFCBSH (Q,D,CLK,CE,S); 
input D,CLK,CE,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS1 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`else 
LAVA1_DFF_CE INS7 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
not INS5 (S2, S); 
and INS6 (CE_NS, CEB, S2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (CE_NS), D, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$width(posedge CLK &&& (CE_NS), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE_NS), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S , posedge CLK &&& (CE == 0), `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge CLK &&& (CE == 0), negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 

$setuphold(posedge CLK ,negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module DFFCBSH_1 (Q,D,CLK,CE,S); 
input D,CLK,CE,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_1_X INS1 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`else 
LAVA1_DFF_CE_1 INS7 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
not INS5 (S2, S); 
and INS6 (CE_NS, CEB, S2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& (CE_NS), D, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (CE_NS), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE_NS), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S , negedge CLK &&& (CE == 0), `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge CLK &&& (CE == 0), negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier);
 
$setuphold(negedge CLK ,negedge  CE, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFCBSRH (Q,D,CLK,CE,SR); 
input D,CLK,CE,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_CE_X INS1 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`else 
LAVA1_DFFS_CE INS7 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
not INS5 (R2, SR); 
and INS6 (CE_NR, CEB, R2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (CE_NR), D, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(posedge CLK , negedge CE , `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (CE_NR), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE_NR), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
$setuphold(posedge CLK &&& (CE == 0), posedge SR, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFCBSRH_1 (Q,D,CLK,CE,SR); 
input D,CLK,CE,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_CE_1_X INS1 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`else 
LAVA1_DFFS_CE_1 INS7 (Q_int, D, CLK, R1, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
not INS5 (R2, SR); 
and INS6 (CE_NR, CEB, R2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& (CE_NR), D, `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(negedge CLK , negedge CE , `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$width(negedge CLK &&& (CE_NR), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE_NR), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$setuphold(negedge CLK &&& (CE == 0), posedge SR ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFCBSSH (Q,D,CLK,CE,SS); 
input D,CLK,CE,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_CE_X INS1 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`else 
LAVA1_DFFS_CE INS7 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
not INS5 (S2, SS); 
and INS6 (CE_NS, CEB, S2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (CE_NS), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (CE_NS), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (CE_NS), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$setuphold(posedge CLK &&& (CE == 0), posedge SS , `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 

$setuphold(posedge CLK ,negedge  CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFCBSSH_1 (Q,D,CLK,CE,SS); 
input D,CLK,CE,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_CE_1_X INS1 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`else 
LAVA1_DFFS_CE_1 INS7 (Q_int, D, CLK, VCC, S1, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
not INS5 (S2, SS); 
and INS6 (CE_NS, CEB, S2); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& (CE_NS), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (CE_NS), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE_NS), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
 
$setuphold(negedge CLK &&& (CE == 0), posedge SS ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 

$setuphold(negedge CLK ,negedge  CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFCB_1 (Q,D,CLK,CE); 
input D,CLK,CE; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_CE_1_X INS1 (Q_int, D, CLK, VCC, VCC, CEB, notifier); 
`else 
LAVA1_DFF_CE_1 INS4 (Q_int, D, CLK, VCC, VCC, CEB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS8 (CEB, CE);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(negedge CLK &&& (CE == 0), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$setuphold(negedge CLK , negedge CE ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (CE == 0), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (CE == 0), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine

module DFFLSH (Q,D,SD,LD,CLK); 
input D,SD,LD,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
LAVA1_DFF_X INS1 (Q_int, D_int, CLK, VCC, VCC, notifier); 
`else 
LAVA1_DFF INS4 (Q_int, D_int, CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
buf INS2 (Q, Q_reg); 
not INS8 (LD_B, LD);
and INS9 (out1, LD_B, D);
and INS10 (out2, LD, SD);
or  INS11 (D_int, out1, out2);
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(posedge CLK, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
$setuphold(posedge CLK, SD ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

endspecify 
 
 
endmodule 

`endcelldefine
`celldefine 
 
module DFFLSH_1 (Q,D,SD,LD,CLK); 
input D,SD,LD,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
LAVA1_DFF_1_X INS1 (Q_int, D_int, CLK, VCC, VCC, notifier); 
`else 
LAVA1_DFF_1 INS4 (Q_int, D_int, CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
buf INS2 (Q, Q_reg); 
not INS8 (LD_B, LD);
and INS9 (out1, LD_B, D);
and INS10 (out2, LD, SD);
or  INS11 (D_int, out1, out2);

 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(negedge CLK, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$setuphold(negedge CLK, SD ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine

module DFFRH (Q,D,CLK,R); 
input D,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_X INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`else 
LAVA1_DFF INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge  R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);
 
$setuphold(posedge CLK &&& R2, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$width(posedge CLK &&& R2, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& R2, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
 
$recovery(negedge R, posedge CLK, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge CLK, negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module DFFRH_1 (Q,D,CLK,R); 
input D,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_1_X INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`else 
LAVA1_DFF_1 INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge  R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& R2, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& R2, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& R2, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge R, negedge CLK, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge CLK, negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine

module DFFSH (Q,D,CLK,S); 
input D,CLK,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_X INS1 (Q_int, D, CLK, VCC, S1, notifier); 
`else 
LAVA1_DFF INS5 (Q_int, D, CLK, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (S1), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& (S1), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (S1), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S, posedge CLK, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge CLK, negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module DFFSH_1 (Q,D,CLK,S); 
input D,CLK,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFF_1_X INS1 (Q_int, D, CLK, VCC, S1, notifier); 
`else 
LAVA1_DFF_1 INS5 (Q_int, D, CLK, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);
  
$setuphold(negedge CLK &&& (S1), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (S1), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (S1), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S, negedge CLK, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge CLK, negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFSRH (Q,D,CLK,SR); 
input D,CLK,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_X INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`else 
LAVA1_DFFS INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
not INS5 (R2, SR); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge  SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& R2, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(posedge CLK &&& R2, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& R2, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$setuphold(posedge CLK, posedge SR ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFSRH_1 (Q,D,CLK,SR); 
input D,CLK,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_1_X INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`else 
LAVA1_DFFS_1 INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
not INS5 (R2, SR); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge  SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& R2, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& R2, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& R2, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 

$setuphold(negedge CLK, posedge SR ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFSSH (Q,D,CLK,SS); 
input D,CLK,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_X INS1 (Q_int, D, CLK, VCC, S1, notifier); 
`else 
LAVA1_DFFS INS5 (Q_int, D, CLK, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(posedge CLK &&& (S1), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
 
$width(posedge CLK &&& (S1), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (S1), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
 
$setuphold(posedge CLK, posedge SS ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine
module DFFSSH_1 (Q,D,CLK,SS); 
input D,CLK,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_DFFS_1_X INS1 (Q_int, D, CLK, VCC, S1, notifier); 
`else 
LAVA1_DFFS_1 INS5 (Q_int, D, CLK, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
//(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 

$setuphold(negedge CLK &&& (S1), D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK &&& (S1), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK &&& (S1), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
 
$setuphold(negedge CLK, posedge SS ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
`celldefine 
 
module DFF_1 (Q,D,CLK); 
input D,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
LAVA1_DFF_1_X INS1 (Q_int, D, CLK, VCC, VCC, notifier); 
`else 
LAVA1_DFF_1 INS4 (Q_int, D, CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 

$setuphold(negedge CLK, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 

$width(negedge CLK, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge CLK, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine

module DLAT (Q,D,LAT); 
input D,LAT; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;

supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT_level_b, VCC, VCC, notifier); 
`else 
LAVA1_LATCH INS4 (Q_int, D, LAT_level_b, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 

$setuphold(negedge LAT, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge LAT, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

`celldefine

module SDLAT (Q,D,CLK,CLK_EN); 
input D,CLK,CLK_EN; 
output Q; 

reg notifier; 
reg Q_reg; 
reg LAT;
 
supply0 GND; 
supply1 VCC; 

always @ (posedge CLK) 
   LAT <= CLK_EN;

`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT, VCC, VCC, notifier); 
`else 
LAVA1_LATCH INS4 (Q_int, D, LAT, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 

specify 
 
(CLK => Q) = 
   ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max,
     `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = 
   ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, 
     `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 

$setuphold( posedge CLK, CLK_EN ,
   `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max,
   `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
/********
$setuphold(  negedge LAT, D ,
   `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max,                       `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);

$width(posedge LAT, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
*********/ 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine



module DLATRH (Q,D,LAT,R); 
input D,LAT,R; 
output Q; 
reg notifier; 
reg Q_reg; 

wire LAT_level;
 
supply0 GND; 
supply1 VCC; 


wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`else 
LAVA1_LATCH INS5 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);  
$setuphold(negedge LAT, D &&& R1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge LAT &&& R1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& R1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge R, negedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge LAT, negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine


//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
`celldefine

module SDLATRH (Q,D,CLK,CLK_EN,R); 
input D,CLK,CLK_EN,R; 
output Q; 
reg notifier; 
reg Q_reg; 
reg LAT; 

supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT, R1, VCC, notifier); 
`else 
LAVA1_LATCH INS5 (Q_int, D, LAT, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 

always @ (posedge CLK)
   LAT <= CLK_EN;
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
 
specify 
(CLK => Q) =   
   ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max,
     `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max);
(D => Q) =
   ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max,
     `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max);
(R => Q) = ( 
   `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, 
   `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 

$width(posedge R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);  

$setuphold(posedge CLK, CLK_EN,
   `CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, 
   `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);

/*******************************************
$setuphold(negedge LAT, D &&& R1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge LAT &&& R1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& R1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge R, negedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge LAT, negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
**********************************************/ 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine
module DLATRH_1 (Q,D,LAT,R); 
input D,LAT,R; 
output Q; 
reg notifier; 
reg Q_reg; 

wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;
LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCH_1_X INS1 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`else 
LAVA1_LATCH_1 INS5 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(R => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
$width(posedge R, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$setuphold(posedge LAT, D &&& R1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$width(negedge LAT &&& R1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge LAT &&& R1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge R, posedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge LAT, negedge R , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
  
`celldefine

module DLATSH (Q,D,LAT,S); 
input D,LAT,S; 
output Q; 
reg notifier, notifier2; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);
 
`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`else 
LAVA1_LATCH INS5 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$setuphold(negedge LAT, D &&& S1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge LAT &&& S1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& S1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S, negedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge LAT, negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
`celldefine

module SDLATSH (Q,D,CLK,CLK_EN,S); 
input D,CLK,CLK_EN,S; 
output Q; 
reg notifier; 
reg Q_reg; 
reg LAT;
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
LAVA1_LATCH_X INS1 (Q_int, D, LAT, VCC, S1, notifier); 
`else 
LAVA1_LATCH INS5 (Q_int, D, LAT, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 

always @ (posedge CLK)
   LAT <= CLK_EN;


specify 

(CLK => Q) =   
   ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max,
     `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max);
(D => Q) =
   ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max,
     `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max);
(S => Q) = ( 
   `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, 
   `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 

$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
/************************************
$setuphold(negedge LAT, D &&& S1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge LAT &&& S1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& S1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S, negedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(negedge LAT, negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
************************************/ 
endspecify 
 
endmodule 
`endcelldefine


`celldefine
module DLATSH_1 (Q,D,LAT,S); 
input D,LAT,S; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);
 
`ifdef xmodel 
LAVA1_LATCH_1_X INS1 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`else 
LAVA1_LATCH_1 INS5 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(S => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
$width(posedge S, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$setuphold(posedge LAT, D &&& S1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(negedge LAT &&& S1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge LAT &&& S1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$recovery(negedge S, posedge LAT, `CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, notifier); 
$hold(posedge LAT, negedge S , `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine
module DLATSRH (Q,D,LAT,SR); 
input D,LAT,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;
LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCHS_X INS1 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`else 
LAVA1_LATCHS INS5 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$setuphold(negedge LAT, D &&& R1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$width(posedge LAT &&& R1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& R1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$setuphold(negedge LAT, posedge SR ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
  
`celldefine
module DLATSRH_1 (Q,D,LAT,SR); 
input D,LAT,SR; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 


wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);
 
`ifdef xmodel 
LAVA1_LATCHS_1_X INS1 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`else 
LAVA1_LATCHS_1 INS5 (Q_int, D, LAT_level_b, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, SR); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(SR => Q) = ( `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max, `CLB_REG_R_out_min:`CLB_REG_R_out_typ:`CLB_REG_R_out_max); 
//$width(posedge SR, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);
$setuphold(posedge LAT, D &&& R1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$width(negedge LAT &&& R1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge LAT &&& R1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
$setuphold(posedge LAT, posedge SR ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
  
`celldefine
module DLATSSH (Q,D,LAT,SS); 
input D,LAT,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCHS_X INS1 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`else 
LAVA1_LATCHS INS5 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);
$setuphold(negedge LAT, D &&& S1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$width(posedge LAT &&& S1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge LAT &&& S1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
$setuphold(negedge LAT, posedge SS ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine
module DLATSSH_1 (Q,D,LAT,SS); 
input D,LAT,SS; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);

 
`ifdef xmodel 
LAVA1_LATCHS_1_X INS1 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`else 
LAVA1_LATCHS_1 INS5 (Q_int, D, LAT_level_b, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, SS); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
(SS => Q) = ( `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max, `CLB_REG_S_out_min:`CLB_REG_S_out_typ:`CLB_REG_S_out_max); 
//$width(posedge SS, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier);
$setuphold(posedge LAT, D &&& S1,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(negedge LAT &&& S1, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge LAT &&& S1, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier);
$setuphold(posedge LAT, posedge SS ,`CLB_REG_RECOVERY_min:`CLB_REG_RECOVERY_typ:`CLB_REG_RECOVERY_max, `CLB_REG_RHOLD_min:`CLB_REG_RHOLD_typ:`CLB_REG_RHOLD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine
module DLAT_1 (Q,D,LAT); 
input D,LAT; 
output Q; 
reg notifier; 
reg Q_reg; 
wire LAT_level;
 
supply0 GND; 
supply1 VCC; 

wire LAT_level_b = (LAT_level === 1'b1) ? 1'b1 : 1'b0;

LAVA1_DFF DFF_INS(LAT_level,1'b1,LAT,1'b1,1'b1,notifier2);
 
`ifdef xmodel 
LAVA1_LATCH_1_X INS1 (Q_int, D, LAT_level_b, VCC, VCC, notifier); 
`else 
LAVA1_LATCH_1 INS4 (Q_int, D, LAT_level_b, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(LAT => Q) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
(D => Q) = ( `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max, `CLB_LAT_D_out_min:`CLB_LAT_D_out_typ:`CLB_LAT_D_out_max); 
$setuphold(posedge LAT, D ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(negedge LAT, `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(negedge LAT, `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine

module GND (X);
output X;

supply0 GND;
supply1 VCC;

assign X = GND;

specify


endspecify


endmodule
`endcelldefine

`celldefine

module SRBUF (O,CI);
input CI;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, CI);

specify

(CI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine

module SRBUFINV (O,CI); 
input CI; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, CI); 
 
specify 
 
(CI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module SRBUFI (O,I0);
input I0;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, I0);

specify

(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine

module SRBUFIINV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module GSRBUF (O,SRI);
input SRI;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, SRI);

specify

(SRI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine

module GSRBUFINV (O,SRI); 
input SRI; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, SRI); 
 
specify 
 
(SRI => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module GSRBUFI (O,I0);
input I0;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, I0);

specify

(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max;

endspecify


endmodule
`endcelldefine

`celldefine

module GSRBUFIINV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module IBUF (O,I0);
input I0;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, I0);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module IBUFINV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module LVDSIN (O,P_IN,N_IN); 
input P_IN,N_IN; 
output O; 
 
buf INS1 (O, P_IN); 
 
specify 
 
(P_IN => O) =  0:0:0, 0:0:0; 
(N_IN => O) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine

`celldefine

module LVDSOUT (P_OUT,N_OUT,I); 
input I; 
output P_OUT,N_OUT; 
 
buf INS1 (P_OUT, I); 
not INS2 (N_OUT, I);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0; 
(I => N_OUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine
 
 
`celldefine 
 
module LVDSTRI (N_OUT,P_OUT,I,OE); 
input I,OE; 
output N_OUT, P_OUT; 
supply0 GND; 
supply1 VCC; 
bufif1 INS1 (P_OUT, I, OE); 
notif1 INS2 (N_OUT, I, OE);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0;
(I => N_OUT) =  0:0:0, 0:0:0;
(OE => P_OUT) =  0:0:0, 0:0:0;
(OE => N_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine 
 
module LVDSIO (O,I,P_IO,N_IO,OE); 
input I,OE; 
inout P_IO,N_IO; 
output O; 
 
supply0 GND; 
supply1 VCC; 
 
buf INS1 (O, P_IO); 
bufif1 INS2 (P_IO, I, OE); 
notif1 INS3 (N_IO, I, OE);
 
specify 
 
(I => P_IO) = 0:0:0, 0:0:0;
(I => N_IO) = 0:0:0, 0:0:0;
(OE => P_IO) = 0:0:0, 0:0:0;
(OE => N_IO) = 0:0:0, 0:0:0;
(P_IO => O) =  0:0:0, 0:0:0;
(N_IO => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine

module LVPECLIN (O,P_IN,N_IN); 
input P_IN,N_IN; 
output O; 
 
buf INS1 (O, P_IN); 
 
specify 
 
(P_IN => O) =  0:0:0, 0:0:0; 
(N_IN => O) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine

`celldefine

module LVPECLOUT (P_OUT,N_OUT,I); 
input I; 
output P_OUT,N_OUT; 
 
buf INS1 (P_OUT, I); 
not INS2 (N_OUT, I);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0; 
(I => N_OUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine
 
 
`celldefine 
 
module LVPECLTRI (N_OUT,P_OUT,I,OE); 
input I,OE; 
output N_OUT, P_OUT; 
supply0 GND; 
supply1 VCC; 
bufif1 INS1 (P_OUT, I, OE); 
notif1 INS2 (N_OUT, I, OE);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0;
(I => N_OUT) =  0:0:0, 0:0:0;
(OE => P_OUT) =  0:0:0, 0:0:0;
(OE => N_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

 
`celldefine

module BLVDSIN (O,P_IN,N_IN); 
input P_IN,N_IN; 
output O; 
 
buf INS1 (O, P_IN); 
 
specify 
 
(P_IN => O) =  0:0:0, 0:0:0; 
(N_IN => O) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine

`celldefine

module BLVDSOUT (P_OUT,N_OUT,I); 
input I; 
output P_OUT,N_OUT; 
 
buf INS1 (P_OUT, I); 
not INS2 (N_OUT, I);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0; 
(I => N_OUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine
 
 
`celldefine 
 
module BLVDSTRI (N_OUT,P_OUT,I,OE); 
input I,OE; 
output N_OUT, P_OUT; 
supply0 GND; 
supply1 VCC; 
bufif1 INS1 (P_OUT, I, OE); 
notif1 INS2 (N_OUT, I, OE);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0;
(I => N_OUT) =  0:0:0, 0:0:0;
(OE => P_OUT) =  0:0:0, 0:0:0;
(OE => N_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine 
 
module BLVDSIO (O,I,P_IO,N_IO,OE); 
input I,OE; 
inout P_IO,N_IO; 
output O; 
 
supply0 GND; 
supply1 VCC; 
 
buf INS1 (O, P_IO); 
bufif1 INS2 (P_IO, I, OE); 
notif1 INS3 (N_IO, I, OE);
 
specify 
 
(I => P_IO) = 0:0:0, 0:0:0;
(I => N_IO) = 0:0:0, 0:0:0;
(OE => P_IO) = 0:0:0, 0:0:0;
(OE => N_IO) = 0:0:0, 0:0:0;
(P_IO => O) =  0:0:0, 0:0:0;
(N_IO => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 

`celldefine

module INV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module INVTH (O,I0,OE);
input I0,OE;
output O;
supply0 GND;
supply1 VCC;
bufif1 INS1 (O, O1, OE);
not INS2 (O1,I0);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module INVTL (O,I0,OE);
input I0,OE;
output O;
supply0 GND;
supply1 VCC;
bufif0 INS1 (O, O1, OE);
not INS2 (O1, I0);

specify

(I0 => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;
(OE => O) =  `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max, `IN_BUF_min:`IN_BUF_typ:`IN_BUF_max;

endspecify


endmodule
`endcelldefine

`celldefine

module JTAG (TDO,TDI,TCLK,TMOD);
input TDI,TCLK,TMOD;
output TDO;
supply0 GND;
supply1 VCC;

specify


endspecify


endmodule
`endcelldefine

`celldefine

module LUT1 (O, I0);

parameter  [1:0]init = 2'h0 ;

input   I0;
output  O;
wire    y,i0;

buf INST0 (i0,I0);
buf INST1 (O,y);

LAVA_lut_mux2 (y, init[0], init[1], i0);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule
`endcelldefine

`celldefine

module LUT2 (O, I0, I1);

parameter  [3:0]init = 4'h0 ;

input   I0,I1;
output  O;
wire    y,i0,i1;

buf INST0 (i0,I0);
buf INST1 (i1,I1);
buf INST2 (O,y);

LAVA_lut_mux4 (y, init[3], init[2], init[1], init[0], i1, i0);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I1 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule
`endcelldefine


`celldefine
module LUT3 (O, I0, I1, I2);

parameter  [7:0]init = 8'h00 ;

input   I0,I1,I2;
output  O;
wire    y,y0,y1,i0,i1,i2;

buf INST0 (i0,I0);
buf INST1 (i1,I1);
buf INST2 (i2,I2);
buf INST3 (O,y);

LAVA_lut_mux4 (y1, init[7], init[6], init[5], init[4], i1, i0);
LAVA_lut_mux4 (y0, init[3], init[2], init[1], init[0], i1, i0);
LAVA_lut_mux2 (y, y0, y1, i2);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I1 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I2 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify


endmodule
`endcelldefine

`celldefine
module LUT4 (O, I0, I1, I2, I3);

parameter  [15:0]init = 16'h0000 ;

input   I0, I1, I2, I3;
output  O;
wire    y,y0,y1,y2,y3,i0,i1,i2,i3;

buf INST0 (i0,I0);
buf INST1 (i1,I1);
buf INST2 (i2,I2);
buf INST3 (i3,I3);
buf INST4 (O,y);

LAVA_lut_mux4 (y3, init[15], init[14], init[13], init[12], i1, i0);
LAVA_lut_mux4 (y2, init[11], init[10], init[9], init[8], i1, i0);
LAVA_lut_mux4 (y1, init[7], init[6], init[5], init[4], i1, i0);
LAVA_lut_mux4 (y0, init[3], init[2], init[1], init[0], i1, i0);
LAVA_lut_mux4 (y, y3, y2, y1, y0, i3, i2);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I1 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I2 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I3 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

	
endmodule
`endcelldefine

`celldefine


module LUT5 (O, I0, I1, I2, I3, I4);

parameter  [31:0]init = 32'h0000_0000 ;

input   I0, I1, I2, I3, I4;
output  O;
wire    y,y0,y1,y2,y3,y4,y5,y6,y7,y8,y9,i0,i1,i2,i3,i4;

buf INST0 (i0,I0);
buf INST1 (i1,I1);
buf INST2 (i2,I2);
buf INST3 (i3,I3);
buf INST4 (i4,I4);
buf INST5 (O,y);

LAVA_lut_mux4 (y7, init[31], init[30], init[29], init[28], i1, i0);
LAVA_lut_mux4 (y6, init[27], init[26], init[25], init[24], i1, i0);
LAVA_lut_mux4 (y5, init[23], init[22], init[21], init[20], i1, i0);
LAVA_lut_mux4 (y4, init[19], init[18], init[17], init[16], i1, i0);
LAVA_lut_mux4 (y3, init[15], init[14], init[13], init[12], i1, i0);
LAVA_lut_mux4 (y2, init[11], init[10], init[9], init[8], i1, i0);
LAVA_lut_mux4 (y1, init[7], init[6], init[5], init[4], i1, i0);
LAVA_lut_mux4 (y0, init[3], init[2], init[1], init[0], i1, i0);
LAVA_lut_mux4 (y9, y7, y6, y5, y4, i3, i2);
LAVA_lut_mux4 (y8, y3, y2, y1, y0, i3, i2);
LAVA_lut_mux2 (y, y8, y9, i4);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I1 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I2 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I3 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I4 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule
`endcelldefine

`celldefine

module LUT6 (O, I0, I1, I2, I3, I4, I5);

parameter  [63:0]init = 64'h0000_0000_0000_0000 ;

input   I0, I1, I2, I3, I4, I5;
output  O;
wire    y,y0,y1,y2,y3,y4,y5,y6,y7,y8,y9;
wire    y10,y11,y12,y13,y14,y15,y16,y17,y18,y19;
wire    i0,i1,i2,i3,i4,i5;

buf INST0 (i0,I0);
buf INST1 (i1,I1);
buf INST2 (i2,I2);
buf INST3 (i3,I3);
buf INST4 (i4,I4);
buf INST5 (i5,I5);
buf INST6 (O,y);

LAVA_lut_mux4 (y15, init[63], init[62], init[61], init[60], i1, i0);
LAVA_lut_mux4 (y14, init[59], init[58], init[57], init[56], i1, i0);
LAVA_lut_mux4 (y13, init[55], init[54], init[53], init[52], i1, i0);
LAVA_lut_mux4 (y12, init[51], init[50], init[49], init[48], i1, i0);
LAVA_lut_mux4 (y11, init[47], init[46], init[45], init[44], i1, i0);
LAVA_lut_mux4 (y10, init[43], init[42], init[41], init[40], i1, i0);
LAVA_lut_mux4 (y9, init[39], init[38], init[37], init[36], i1, i0);
LAVA_lut_mux4 (y8, init[35], init[34], init[33], init[32], i1, i0);
LAVA_lut_mux4 (y7, init[31], init[30], init[29], init[28], i1, i0);
LAVA_lut_mux4 (y6, init[27], init[26], init[25], init[24], i1, i0);
LAVA_lut_mux4 (y5, init[23], init[22], init[21], init[20], i1, i0);
LAVA_lut_mux4 (y4, init[19], init[18], init[17], init[16], i1, i0);
LAVA_lut_mux4 (y3, init[15], init[14], init[13], init[12], i1, i0);
LAVA_lut_mux4 (y2, init[11], init[10], init[9], init[8], i1, i0);
LAVA_lut_mux4 (y1, init[7], init[6], init[5], init[4], i1, i0);
LAVA_lut_mux4 (y0, init[3], init[2], init[1], init[0], i1, i0);
LAVA_lut_mux4 (y19, y15, y14, y13, y12, i3, i2);
LAVA_lut_mux4 (y18, y11, y10, y9, y8, i3, i2);
LAVA_lut_mux4 (y17, y7, y6, y5, y4, i3, i2);
LAVA_lut_mux4 (y16, y3, y2, y1, y0, i3, i2);
LAVA_lut_mux4 (y, y19, y18, y17, y16, i5, i4);

specify

    (I0 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I1 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I2 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I3 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I4 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);
    (I5 => O) = (0.1:0.1:0.1, 0.1:0.1:0.1);

endspecify

endmodule

`endcelldefine

`celldefine

module MUX2 (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 

reg    Zb;
wire D0b, D1b, SDb;

      function DataSame;
        input a, b;
        begin
          if (a === b)
            DataSame = a;
          else
            DataSame = 1'bx;
        end
      endfunction

      always @(D0b or D1b or SDb)
      begin
      case (SDb)
        1'b0 :  Zb = D0b;
        1'b1 :  Zb = D1b;
        default Zb = DataSame(D0b, D1b);
      endcase
      end

   buf  (D0b, I0);
   buf  (D1b, I1);
   buf  (SDb, S0);
   buf  (O, Zb);
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 


`celldefine

module MUXL6C (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module MUX2A (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS0 (I0_, I0); 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0_, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module MUX2B (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS0 (I1_, I1); 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1_, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module MUX4 (O,I0,I1,I2,I3,S0,S1); 
input I0,I1,I2,I3,S0,S1; 
output O; 
supply0 GND; 
supply1 VCC; 
 
 
not INS1 (S0_inv, S0); 
not INS9 (S1_inv, S1); 
and INS3 (out_1, I0, S0_inv, S1_inv); 
and INS4 (out_2, I1, S0, S1_inv); 
and INS5 (out_3, I2, S0_inv, S1); 
and INS6 (out_4, I3, S0, S1); 
or  INS7 (O, out_1, out_2, out_3, out_4); 
 
specify 
 
(S0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I2 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I3 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine
module MUX8 (O,I0,I1,I2,I3,I4,I5,I6,I7,S0,S1,S2); 
input I0,I1,I2,I3,I4,I5,I6,I7,S0,S1,S2; 
output O; 
supply0 GND; 
supply1 VCC; 
 
 
not INS1 (S0_inv, S0); 
not INS2 (S1_inv, S1); 
not INS3 (S2_inv, S2); 

and INS4  (out_1, I0, S2_inv, S1_inv, S0_inv); 
and INS5  (out_2, I1, S2_inv, S1_inv, S0    ); 
and INS6  (out_3, I2, S2_inv, S1    , S0_inv); 
and INS7  (out_4, I3, S2_inv, S1    , S0    ); 
and INS8  (out_5, I4, S2    , S1_inv, S0_inv); 
and INS9  (out_6, I5, S2    , S1_inv, S0    ); 
and INS10 (out_7, I6, S2    , S1    , S0_inv); 
and INS11 (out_8, I7, S2    , S1    , S0    ); 
or  INS12 (O, out_1, out_2, out_3, out_4, out_5, out_6, out_7, out_8); 
 
specify 
 
(S0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S2 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I2 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I3 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I4 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I5 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I6 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I7 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine
module MUX8C (O,I0,I1,I2,I3,I4,I5,I6,I7,S0,S1,S2,S3, MI); 
input I0,I1,I2,I3,I4,I5,I6,I7,S0,S1,S2,S3, MI; 
output O; 
supply0 GND; 
supply1 VCC; 
 
 
not INS1 (S0_inv, S0); 
not INS2 (S1_inv, S1); 
not INS3 (S2_inv, S2); 
not INS14 (S3_inv, S3); 

and INS4  (out_1, I0, S2_inv, S1_inv, S0_inv); 
and INS5  (out_2, I1, S2_inv, S1_inv, S0    ); 
and INS6  (out_3, I2, S2_inv, S1    , S0_inv); 
and INS7  (out_4, I3, S2_inv, S1    , S0    ); 
and INS8  (out_5, I4, S2    , S1_inv, S0_inv); 
and INS9  (out_6, I5, S2    , S1_inv, S0    ); 
and INS10 (out_7, I6, S2    , S1    , S0_inv); 
and INS11 (out_8, I7, S2    , S1    , S0    ); 
or  INS12 (m8_out, out_1, out_2, out_3, out_4, out_5, out_6, out_7, out_8); 

and INS15 (out_9,  S3,     MI);
and INS16 (out_10, S3_inv, m8_out);
or  INS17 (O, out_9, out_10);
 
specify 
 
(S0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S2 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(S3 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I0 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I1 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I2 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I3 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I4 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I5 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I6 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(I7 => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
(MI => O) =  `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max, `in3_LUT_min+`in2_LUT_min:`in3_LUT_typ+`in2_LUT_typ:`in3_LUT_max+`in2_LUT_max; 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine

module MUXL5 (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module MUXL6 (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I0 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
(I1 => O) =  `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max, `in3_LUT_min:`in3_LUT_typ:`in3_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module OBUF (O,I0);
input I0;
output O;
supply0 GND;
supply1 VCC;
buf INS1 (O, I0);

specify

(I0 => O) =  `OUT_BUF_min:`OUT_BUF_typ:`OUT_BUF_max,`OUT_BUF_min:`OUT_BUF_typ:`OUT_BUF_max ;

endspecify


endmodule
`endcelldefine

`celldefine

module OBUFINV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max, `in1_LUT_min:`in1_LUT_typ:`in1_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module PUC ;
supply0 GND;
supply1 VCC;

specify


endspecify


endmodule
`endcelldefine

`celldefine

module RBC;
supply0 GND;
supply1 VCC;

specify


endspecify


endmodule
`endcelldefine


`celldefine

module SHIFT8 (SO, SI, A0, A1, A2, EN, CLK);
input SI, A0, A1, A2, EN, CLK ;
output SO; 
reg notifier; 
reg Q0_reg, Q1_reg, Q2_reg, Q3_reg, Q4_reg, Q5_reg, Q6_reg, Q7_reg; 
 
supply0 GND; 
supply1 VCC; 

// Shift register #1
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS1 (Q0_int, SI, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS2 (Q0_int, SI, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q0_reg = 0; 
`endif 
 
        always @(Q0_int) Q0_reg = Q0_int; 
// Shift register #2
`ifdef xmodel 
LAVA1_DFF_CE_X INS3 (Q1_int, Q0, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS4 (Q1_int, Q0, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q1_reg = 0; 
`endif 
 
        always @(Q1_int) Q1_reg = Q1_int; 
// Shift register #3
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS5 (Q2_int, Q1, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS6 (Q2_int, Q1, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q2_reg = 0; 
`endif 
 
        always @(Q2_int) Q2_reg = Q2_int; 
// Shift register #4
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS7 (Q3_int, Q2, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS8 (Q3_int, Q2, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q3_reg = 0; 
`endif 
 
        always @(Q3_int) Q3_reg = Q3_int; 
// Shift register #5
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS9 (Q4_int, Q3, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS10 (Q4_int, Q3, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q4_reg = 0; 
`endif 
 
        always @(Q4_int) Q4_reg = Q4_int; 
// Shift register #6
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS11 (Q5_int, Q4, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS12 (Q5_int, Q4, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q5_reg = 0; 
`endif 
 
        always @(Q5_int) Q5_reg = Q5_int; 
// Shift register #7
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS13 (Q6_int, Q5, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS14 (Q6_int, Q5, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q6_reg = 0; 
`endif 
 
        always @(Q6_int) Q6_reg = Q6_int; 
// Shift register #8
 
`ifdef xmodel 
LAVA1_DFF_CE_X INS15 (Q7_int, Q6, CLK, VCC, VCC, ENB, notifier); 
`else 
LAVA1_DFF_CE INS16 (Q7_int, Q6, CLK, VCC, VCC, ENB, notifier); 
`endif 
 
`ifdef PUC 
        initial Q7_reg = 0; 
`endif 
 
        always @(Q7_int) Q7_reg = Q7_int; 
 
 
not INS17 (ENB, EN);
 
buf INS18 (Q0, Q0_reg); 
buf INS19 (Q1, Q1_reg); 
buf INS20 (Q2, Q2_reg); 
buf INS21 (Q3, Q3_reg); 
buf INS22 (Q4, Q4_reg); 
buf INS23 (Q5, Q5_reg); 
buf INS24 (Q6, Q6_reg); 
buf INS25 (Q7, Q7_reg); 

not INS26 (A0_inv, A0); 
not INS27 (A1_inv, A1); 
not INS28 (A2_inv, A2); 

and INS29  (out_1, Q7, A2_inv, A1_inv, A0_inv); 
and INS30  (out_2, Q6, A2_inv, A1_inv, A0    ); 
and INS31  (out_3, Q5, A2_inv, A1    , A0_inv); 
and INS32  (out_4, Q4, A2_inv, A1    , A0    ); 
and INS33  (out_5, Q3, A2    , A1_inv, A0_inv); 
and INS34  (out_6, Q2, A2    , A1_inv, A0    ); 
and INS35  (out_7, Q1, A2    , A1    , A0_inv); 
and INS36  (out_8, Q0, A2    , A1    , A0    ); 
or  INS37  (SO, out_1, out_2, out_3, out_4, out_5, out_6, out_7, out_8); 
 

 
specify 
 
(CLK => SO) = ( `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max, `CLB_REG_CLK_out_min:`CLB_REG_CLK_out_typ:`CLB_REG_CLK_out_max); 
$setuphold(posedge CLK &&& (EN == 0), SI ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$setuphold(posedge CLK &&& (EN == 0), A0 ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$setuphold(posedge CLK &&& (EN == 0), A1 ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$setuphold(posedge CLK &&& (EN == 0), A2 ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier);
$setuphold(posedge CLK , negedge EN ,`CLB_REG_SETUP_min:`CLB_REG_SETUP_typ:`CLB_REG_SETUP_max, `CLB_REG_HOLD_min:`CLB_REG_HOLD_typ:`CLB_REG_HOLD_max, notifier); 
$width(posedge CLK &&& (EN == 0), `CLB_REG_WIDTH_min:`CLB_REG_WIDTH_typ:`CLB_REG_WIDTH_max, 0, notifier); 
$period(posedge CLK &&& (EN == 0), `CLB_REG_PERIOD_min:`CLB_REG_PERIOD_typ:`CLB_REG_PERIOD_max, notifier); 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module UCP_LSB (S0,COUT,D, SD, LOAD, CYIBAR);
input D, SD, LOAD, CYIBAR ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 


not  INS0 (CYIBAR_B, CYIBAR);
not  INS1 (LOAD_B, LOAD);
and  INS2 (out_1, LOAD, SD);
and  INS3 (out_2, D, LOAD_B);
or   INS4 (out_3, out_1, out_2);
xor  INS5 (S0, out_3, CYIBAR_B);

and  INS6 (COUT, out_3, CYIBAR_B);

specify 
 
(D => S0)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => S0)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CYIBAR => S0)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT)    =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(SD => COUT)   =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(LOAD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CYIBAR => COUT)  =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module UC_LSB (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, D, CIN); 
and  INS2 (COUT, D, CIN);

 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CIN => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module UDC_LSB (S0,COUT, D, UD, CYIBAR); 
input D, UD, CYIBAR; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS1 (CYIBAR_B, CYIBAR);
xor  INS2 (S0, D, UD, CYIBAR_B);

and  INS3 (out_1, D, UD);
and  INS4 (out_2, D, CYIBAR_B);
and  INS5 (out_3, UD, CYIBAR_B);
or   INS6 (COUT, out_1, out_2, out_3);
 
specify 
 
(D => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CYIBAR => S0) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(D => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(UD => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
(CYIBAR => COUT) =  `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max, `in4_LUT_min:`in4_LUT_typ:`in4_LUT_max; 
 
endspecify 
 
 
endmodule 

`endcelldefine
`celldefine

module VCC (X);
output X;

supply0 GND;
supply1 VCC;

assign X = VCC;

specify


endspecify


endmodule
`endcelldefine

`celldefine
module RAM16X1D (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, DPAD0, DPAD1, DPAD2, DPAD3, RDATA, DPRDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  DPAD0;
input  DPAD1;
input  DPAD2;
input  DPAD3;

output RDATA;
output DPRDATA;
reg    RDATA_reg;
reg    DPRDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 15;

reg  mem [15 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;

integer i;

reg WE_AD;
wire [3:0] AD, DPAD;

assign AD = {AD3, AD2, AD1, AD0};
assign DPAD = {DPAD3, DPAD2, DPAD1, DPAD0};

always @(WE or AD or DPAD)
begin
	if (WE == 1 && AD == DPAD)
	  WE_AD = 1;
	else
	  WE_AD =0;
end


parameter  [15:0]init  = 16'hFFFF;

initial
begin

   for (i= 0; i< 16; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;

end

function valid_address;
input AD0, AD1, AD2, AD3;
begin
	valid_address = (^({AD0, AD1, AD2, AD3}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

task read_mem_dp;
input DPAD0, DPAD1, DPAD2, DPAD3;
begin
        casez({valid_address (DPAD0, DPAD1, DPAD2, DPAD3)})
                1'b0 : begin
                          DPRDATA_reg = 1'bx;
                          $display ("WARNING : Add. unknown , read enabled") ;
                       end
                1'b1 : begin
                                DPRDATA_reg = mem[{DPAD3, DPAD2, DPAD1, DPAD0}] ;
                       end
        endcase
end
endtask


always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b011 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3,WDATA);
                         end
		3'b01x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3);
		         end
		3'b010,
		3'b10?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or DPAD0 or DPAD1 or DPAD2 or DPAD3 or WCLK)
begin
	read_mem (AD0, AD1, AD2, AD3);
	read_mem_dp (DPAD0, DPAD1, DPAD2, DPAD3);
end

always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf0 (RDATA, y);
buf instbuf1 (DPRDATA, y1);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);
LAVA_lut_mux2 (y1, DPRDATA_reg, RDATA_reg, WE_AD);

specify
	$width (posedge WCLK, 1, 0, notifier0);

	$setuphold  (posedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (posedge WCLK, WE, 1, 0, notifier2);
	$setuphold  (posedge WCLK, AD3, 1, 0, notifier3);
	$setuphold  (posedge WCLK, AD2, 1, 0, notifier4);
	$setuphold  (posedge WCLK, AD1, 1, 0, notifier5);
	$setuphold  (posedge WCLK, AD0, 1, 0, notifier6);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(WCLK => DPRDATA) = (1:1:1, 1:1:1);

	(DPAD0 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD1 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD2 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD3 => DPRDATA) = (1:1:1, 1:1:1);

	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM16X1D_1 (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, DPAD0, DPAD1, DPAD2, DPAD3, RDATA, DPRDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  DPAD0;
input  DPAD1;
input  DPAD2;
input  DPAD3;

output RDATA;
output DPRDATA;
reg    RDATA_reg;
reg    DPRDATA_reg;

// parameter word_depth = 0,
// 	  addr_width = 15;

reg  mem [15 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;

integer i;

reg WE_AD;
wire [3:0] AD, DPAD;

assign AD = {AD3, AD2, AD1, AD0};
assign DPAD = {DPAD3, DPAD2, DPAD1, DPAD0};

always @(WE or AD or DPAD)
begin
	if (WE == 1 && AD == DPAD)
	  WE_AD = 1;
	else
	  WE_AD =0;
end

parameter  [15:0]init  = 16'hFFFF;

initial
begin

   for (i= 0; i< 16; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;

end

function valid_address;
input AD0, AD1, AD2, AD3;
begin
	valid_address = (^({AD0, AD1, AD2, AD3}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

task read_mem_dp;
input DPAD0, DPAD1, DPAD2, DPAD3;
begin
        casez({valid_address (DPAD0, DPAD1, DPAD2, DPAD3)})
                1'b0 : begin
                          DPRDATA_reg = 1'bx;
                          $display ("WARNING : Add. unknown , read enabled") ;
                       end
                1'b1 : begin
                                DPRDATA_reg = mem[{DPAD3, DPAD2, DPAD1, DPAD0}] ;
                       end
        endcase
end
endtask


always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b101 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3,WDATA);
                         end
		3'b10x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3);
		         end
		3'b100,
		3'b01?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or DPAD0 or DPAD1 or DPAD2 or DPAD3 or WCLK)
begin
	read_mem (AD0, AD1, AD2, AD3);
	read_mem_dp (DPAD0, DPAD1, DPAD2, DPAD3);
end

always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf0 (RDATA, y);
buf instbuf1 (DPRDATA, y1);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);
LAVA_lut_mux2 (y1, DPRDATA_reg, RDATA_reg, WE_AD);


specify
	$width (negedge WCLK, 1, 0, notifier0);

	$setuphold  (negedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (negedge WCLK, WE, 1, 0, notifier2);
	$setuphold  (negedge WCLK, AD3, 1, 0, notifier3);
	$setuphold  (negedge WCLK, AD2, 1, 0, notifier4);
	$setuphold  (negedge WCLK, AD1, 1, 0, notifier5);
	$setuphold  (negedge WCLK, AD0, 1, 0, notifier6);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(WCLK => DPRDATA) = (1:1:1, 1:1:1);

	(DPAD0 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD1 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD2 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD3 => DPRDATA) = (1:1:1, 1:1:1);

	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);


endspecify
endmodule
`endcelldefine

`celldefine
module RAM16X1S (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;

output RDATA;
reg    RDATA_reg;


//parameter word_depth = 0,
//	  addr_width = 15;

reg  mem [15 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;

integer i;

parameter  [15:0]init  = 16'hFFFF;

initial
begin

   for (i= 0; i< 16; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;

end


function valid_address;
input AD0, AD1, AD2, AD3;
begin
	valid_address = (^({AD0, AD1, AD2, AD3}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b011 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3,WDATA);
                         end
		3'b01x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3);
		         end
		3'b010,
		3'b10?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or WE)
begin
    if (WE == 1'b0)
	begin :read  read_mem (AD0, AD1, AD2, AD3);
	end
end

always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0:  ;
		1'b1 : begin
			disable write;
			mem[{AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 
	)
begin
	casez(WE)
		1'b0: ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf(RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (posedge WCLK, 1, 0, notifier0);

	$setuphold  (posedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (posedge WCLK, WE, 1, 0, notifier2);
	$setuphold  (posedge WCLK, AD3, 1, 0, notifier3);
	$setuphold  (posedge WCLK, AD2, 1, 0, notifier4);
	$setuphold  (posedge WCLK, AD1, 1, 0, notifier5);
	$setuphold  (posedge WCLK, AD0, 1, 0, notifier6);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM16X1S_1 (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;

output RDATA;
reg    RDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 15;

reg  mem [15 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;

integer i;

parameter  [15:0]init  = 16'hFFFF;

initial
begin

   for (i= 0; i< 16; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;

end

function valid_address;
input AD0, AD1, AD2, AD3;
begin
	valid_address = (^({AD0, AD1, AD2, AD3}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3;
begin
	casez({valid_address (AD0, AD1, AD2, AD3)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b101 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3,WDATA);
                         end
		3'b10x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3);
		         end
                3'b100,
		3'b01?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or WE)
begin
    if (WE == 1'b0)
        begin :read  read_mem (AD0, AD1, AD2, AD3);
        end
end



always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0: ;
		1'b1 : begin
			disable write;
			mem[{AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 
	)
begin
	casez(WE)
		1'b0:;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf(RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (negedge WCLK, 1, 0, notifier0);

	$setuphold  (negedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (negedge WCLK, WE, 1, 0, notifier2);
	$setuphold  (negedge WCLK, AD3, 1, 0, notifier3);
	$setuphold  (negedge WCLK, AD2, 1, 0, notifier4);
	$setuphold  (negedge WCLK, AD1, 1, 0, notifier5);
	$setuphold  (negedge WCLK, AD0, 1, 0, notifier6);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);


endspecify
endmodule
`endcelldefine

`celldefine
module RAM32X1D (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, DPAD0, DPAD1, DPAD2, DPAD3, DPAD4, RDATA, DPRDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  DPAD0;
input  DPAD1;
input  DPAD2;
input  DPAD3;
input  DPAD4;

output RDATA;
output DPRDATA;
reg    RDATA_reg;
reg    DPRDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 31;

reg  mem [31 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;

integer i;

reg WE_AD;
wire [4:0] AD, DPAD;

assign AD = {AD4, AD3, AD2, AD1, AD0};
assign DPAD = {DPAD4, DPAD3, DPAD2, DPAD1, DPAD0};

always @(WE or AD or DPAD)
begin
	if (WE == 1 && AD == DPAD)
	  WE_AD = 1;
	else
	  WE_AD =0;
end

parameter  [31:0]init  = 32'hFFFFFFFF;

initial
begin

   for (i= 0; i< 32; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;

end

function valid_address;
input AD0, AD1, AD2, AD3, AD4;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem_dp;
input DPAD0, DPAD1, DPAD2, DPAD3, DPAD4;
begin
        casez({valid_address (DPAD0, DPAD1, DPAD2, DPAD3, DPAD4)})
                1'b0 : begin
                          DPRDATA_reg = 1'bx;
                          $display ("WARNING : Add. unknown , read enabled") ;
                       end
                1'b1 : begin
                                DPRDATA_reg = mem[{DPAD4, DPAD3, DPAD2, DPAD1, DPAD0}] ;
                       end
        endcase
end
endtask


task read_mem;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b011 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4,WDATA);
                         end
		3'b01x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4);
		         end
		3'b010,
		3'b10?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or  DPAD0 or DPAD1 or DPAD2 or DPAD3 or DPAD4 or WCLK)
begin

	read_mem (AD0, AD1, AD2, AD3, AD4);
	read_mem_dp (DPAD0, DPAD1, DPAD2, DPAD3, DPAD4);

end



always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf0 (RDATA, y);
buf instbuf1 (DPRDATA, y1);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);
LAVA_lut_mux2 (y1, DPRDATA_reg, RDATA_reg, WE_AD);


specify
	$width (posedge WCLK, 1, 0, notifier0);

	$setuphold  (posedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (posedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (posedge WCLK, AD4, 1, 0, notifier3);
	$setuphold  (posedge WCLK, AD3, 1, 0, notifier4);
	$setuphold  (posedge WCLK, AD2, 1, 0, notifier5);
	$setuphold  (posedge WCLK, AD1, 1, 0, notifier6);
	$setuphold  (posedge WCLK, AD0, 1, 0, notifier7);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(WCLK => DPRDATA) = (1:1:1, 1:1:1);

	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);

	(DPAD0 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD1 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD2 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD3 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD4 => DPRDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM32X1D_1 (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, DPAD0, DPAD1, DPAD2, DPAD3, DPAD4, RDATA, DPRDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  DPAD0;
input  DPAD1;
input  DPAD2;
input  DPAD3;
input  DPAD4;

output RDATA;
output DPRDATA;
reg    RDATA_reg;
reg    DPRDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 31;

reg  mem [31 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;


integer i;

reg WE_AD;
wire [4:0] AD, DPAD;

assign AD = {AD4, AD3, AD2, AD1, AD0};
assign DPAD = {DPAD4, DPAD3, DPAD2, DPAD1, DPAD0};

always @(WE or AD or DPAD)
begin
	if (WE == 1 && AD == DPAD)
	  WE_AD = 1;
	else
	  WE_AD =0;
end

parameter  [31:0]init  = 32'hFFFFFFFF;

initial
begin

   for (i= 0; i< 32; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;

end

function valid_address;
input AD0, AD1, AD2, AD3, AD4;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem_dp;
input DPAD0, DPAD1, DPAD2, DPAD3, DPAD4;
begin
        casez({valid_address (DPAD0, DPAD1, DPAD2, DPAD3, DPAD4)})
                1'b0 : begin
                          DPRDATA_reg = 1'bx;
                          $display ("WARNING : Add. unknown , read enabled") ;
                       end
                1'b1 : begin
                                DPRDATA_reg = mem[{DPAD4, DPAD3, DPAD2, DPAD1, DPAD0}] ;
                       end
        endcase
end
endtask


task read_mem;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b101 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4,WDATA);
                         end
		3'b10x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4);
		         end
		3'b100,
		3'b01?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or  DPAD0 or DPAD1 or DPAD2 or DPAD3 or DPAD4 or WCLK)
begin
  
	read_mem (AD0, AD1, AD2, AD3, AD4);
	read_mem_dp (DPAD0, DPAD1, DPAD2, DPAD3, DPAD4);

end



always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf0 (RDATA, y);
buf instbuf1 (DPRDATA, y1);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);
LAVA_lut_mux2 (y1, DPRDATA_reg, RDATA_reg, WE_AD);

specify
	$width (negedge WCLK, 1, 0, notifier0);
	$setuphold  (negedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (negedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (negedge WCLK, AD4, 1, 0, notifier3);
	$setuphold  (negedge WCLK, AD3, 1, 0, notifier4);
	$setuphold  (negedge WCLK, AD2, 1, 0, notifier5);
	$setuphold  (negedge WCLK, AD1, 1, 0, notifier6);
	$setuphold  (negedge WCLK, AD0, 1, 0, notifier7);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(WCLK => DPRDATA) = (1:1:1, 1:1:1);

	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);

	(DPAD0 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD1 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD2 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD3 => DPRDATA) = (1:1:1, 1:1:1);
	(DPAD4 => DPRDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM32X1S (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;

output RDATA;
reg    RDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 31;

reg  mem [31 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;


integer i;

parameter  [31:0]init  = 32'hFFFFFFFF;

initial
begin

   for (i= 0; i< 32; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;

end


function valid_address;
input AD0, AD1, AD2, AD3, AD4;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b011 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4,WDATA);
                         end
		3'b01x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4);
		         end
		3'b010,
		3'b10?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or WE)
begin
    if (WE == 1'b0)
        begin :read  read_mem (AD0, AD1, AD2, AD3, AD4);
        end
end



always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf (RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (posedge WCLK, 1, 0, notifier0);
	$setuphold  (posedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (posedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (posedge WCLK, AD4, 1, 0, notifier3);
	$setuphold  (posedge WCLK, AD3, 1, 0, notifier4);
	$setuphold  (posedge WCLK, AD2, 1, 0, notifier5);
	$setuphold  (posedge WCLK, AD1, 1, 0, notifier6);
	$setuphold  (posedge WCLK, AD0, 1, 0, notifier7);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM32X1S_1 (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;

output RDATA;
reg    RDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 31;

reg  mem [31 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;
reg  notifier8;
reg  notifier9;
reg  notifier10;
reg  notifier11;
reg  notifier12;
reg  notifier13;
reg  notifier14;


integer i;

parameter  [31:0]init  = 32'hFFFFFFFF;

initial
begin

   for (i= 0; i< 32; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;


end

function valid_address;
input AD0, AD1, AD2, AD3, AD4;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3, AD4;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b101 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4,WDATA);
                         end
		3'b10x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4);
		         end
		3'b100,
		3'b01?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or WE)
begin
    if (WE == 1'b0)
        begin :read  read_mem (AD0, AD1, AD2, AD3, AD4);
        end
end



always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf (RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (negedge WCLK, 1, 0, notifier0);
	$setuphold  (negedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (negedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (negedge WCLK, AD4, 1, 0, notifier3);
	$setuphold  (negedge WCLK, AD3, 1, 0, notifier4);
	$setuphold  (negedge WCLK, AD2, 1, 0, notifier5);
	$setuphold  (negedge WCLK, AD1, 1, 0, notifier6);
	$setuphold  (negedge WCLK, AD0, 1, 0, notifier7);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM64X1S (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, AD5,  RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;

output RDATA;
reg    RDATA_reg;

//parameter word_depth = 0,
//	  addr_width = 63;

reg  mem [63 : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;
reg  notifier8;


integer i;

parameter  [63:0]init  = 64'hFFFFFFFFFFFFFFFF;

initial
begin

   for (i= 0; i< 64; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;

end


function valid_address;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4, AD5}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, AD5, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD5, AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD5, AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b011 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4, AD5,WDATA);
                         end
		3'b01x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4, AD5);
		         end
		3'b010,
		3'b10?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or AD5 or WE)
begin
    if (WE == 1'b0)
        begin :read  read_mem (AD0, AD1, AD2, AD3, AD4, AD5);
        end
end


always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD5, AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 or
	  notifier8 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf (RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (posedge WCLK, 1, 0, notifier0);
	$setuphold  (posedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (posedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (posedge WCLK, AD5, 1, 0, notifier3);
	$setuphold  (posedge WCLK, AD4, 1, 0, notifier4);
	$setuphold  (posedge WCLK, AD3, 1, 0, notifier5);
	$setuphold  (posedge WCLK, AD2, 1, 0, notifier6);
	$setuphold  (posedge WCLK, AD1, 1, 0, notifier7);
	$setuphold  (posedge WCLK, AD0, 1, 0, notifier8);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);
	(AD5 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAM64X1S_1 (WE, WDATA, WCLK, AD0, AD1, AD2, AD3, AD4, AD5,  RDATA);

input  WE;
input  WDATA;
input  WCLK;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;

output RDATA;
reg    RDATA_reg;

parameter word_depth = 0,
	  addr_width = 63;

reg  [word_depth :0]  mem [addr_width : 0];
reg  last_wclk;

reg  notifier0;
reg  notifier1;
reg  notifier2;
reg  notifier3;
reg  notifier4;
reg  notifier5;
reg  notifier6;
reg  notifier7;
reg  notifier8;

integer i;

parameter  [63:0]init  = 64'hFFFFFFFFFFFFFFFF;

initial
begin

   for (i= 0; i< 64; i = i+1)
   begin
        mem[i] = {init[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;

end


function valid_address;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	valid_address = (^({AD0, AD1, AD2, AD3, AD4, AD5}) !== 1'bx);
end
endfunction

task write_mem;
input AD0, AD1, AD2, AD3, AD4, AD5, WDATA;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : $display ("WARNING : Address unknown , Write is enabled ");
		1'b1 : begin
			mem[{AD5, AD4, AD3, AD2, AD1, AD0}] = WDATA;
		       end
	endcase
end
endtask

task write_mem_x;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : $display ("WARNING : WE and Address are unknown");
		1'b1 : $display ("WARNING : WE is unkown "); 
	endcase
end
endtask

task read_mem;
input AD0, AD1, AD2, AD3, AD4, AD5;
begin
	casez({valid_address (AD0, AD1, AD2, AD3, AD4, AD5)})
		1'b0 : begin
			  RDATA_reg = 1'bx;
			  $display ("WARNING : Add. unknown , read enabled") ;
		       end
		1'b1 : begin 
				RDATA_reg = mem[{AD5, AD4, AD3, AD2, AD1, AD0}] ;
		       end
	endcase
end
endtask

always @(WCLK)
begin
	casez({last_wclk, WCLK,WE})
		3'b101 : begin : write
                                 write_mem (AD0, AD1, AD2, AD3, AD4, AD5,WDATA);
                         end
		3'b10x : begin : mem_x
				 write_mem_x (AD0, AD1, AD2, AD3, AD4, AD5);
		         end
		3'b100,
		3'b01?,
		3'b00?,
		3'b11?,
		3'b0x?,
		3'bx0?,
		3'b1x?,
		3'bx1? : ;
	endcase
	last_wclk = WCLK ;
end

always @(AD0 or AD1 or AD2 or AD3 or AD4 or AD5 or WE)
begin
    if (WE == 1'b0)
        begin :read  read_mem (AD0, AD1, AD2, AD3, AD4, AD5);
        end
end

always @(notifier0)
begin
disable write;
end

always @(notifier1 or notifier2)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
			mem[{AD5, AD4, AD3, AD2, AD1, AD0}] = 1'bx;
		       end
	endcase
end

always @(
	  notifier3 or
	  notifier4 or
	  notifier5 or
	  notifier6 or
	  notifier7 or
	  notifier8 
	)
begin
	casez(WE)
		1'b0 : ;
		1'b1 : begin
			disable write;
		       end
	endcase
end

buf instbuf (RDATA, y);
LAVA_lut_mux2 (y, RDATA_reg, WDATA, WE);

specify
	$width (negedge WCLK, 1, 0, notifier0);
	$setuphold  (negedge WCLK, WDATA, 1, 0, notifier1);
	$setuphold  (negedge WCLK, WE,  1, 0, notifier2);
	$setuphold  (negedge WCLK, AD5, 1, 0, notifier3);
	$setuphold  (negedge WCLK, AD4, 1, 0, notifier4);
	$setuphold  (negedge WCLK, AD3, 1, 0, notifier5);
	$setuphold  (negedge WCLK, AD2, 1, 0, notifier6);
	$setuphold  (negedge WCLK, AD1, 1, 0, notifier7);
	$setuphold  (negedge WCLK, AD0, 1, 0, notifier8);

	(WCLK => RDATA) = (1:1:1, 1:1:1);
	(AD0 => RDATA) = (1:1:1, 1:1:1);
	(AD1 => RDATA) = (1:1:1, 1:1:1);
	(AD2 => RDATA) = (1:1:1, 1:1:1);
	(AD3 => RDATA) = (1:1:1, 1:1:1);
	(AD4 => RDATA) = (1:1:1, 1:1:1);
	(AD5 => RDATA) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB256X18DAF (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};



//not I_00 (INV_WEN0, WEN0);
and I_01 (con0,  OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
reg   [7:0]  WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56;

reg AD_EQ;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  //added to fix initial value overwritten to x problem 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
      begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	   begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	   end
   	else
		ramout_w_A = memA[ADDA];
      end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;


//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B) //added to fix initial value overwritten to x problem 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	  begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	  end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end
//////End data conflict check
specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier12);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier13);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier14);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier20);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier21);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier22);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier33);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier34);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier35);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier36);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier37);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier38);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier40);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier42);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier43);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier44);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier45);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier46);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier47);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier48);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier49);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier50);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier51);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier52);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier53);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier54);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier55);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier56);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => DA8) = (1:1:1, 1:1:1);
	(ADDA0 => DA9) = (1:1:1, 1:1:1);
	(ADDA0 => DA10) = (1:1:1, 1:1:1);
	(ADDA0 => DA11) = (1:1:1, 1:1:1);
	(ADDA0 => DA12) = (1:1:1, 1:1:1);
	(ADDA0 => DA13) = (1:1:1, 1:1:1);
	(ADDA0 => DA14) = (1:1:1, 1:1:1);
	(ADDA0 => DA15) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);
	(ADDA0 => EDA1) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => DA8) = (1:1:1, 1:1:1);
	(ADDA1 => DA9) = (1:1:1, 1:1:1);
	(ADDA1 => DA10) = (1:1:1, 1:1:1);
	(ADDA1 => DA11) = (1:1:1, 1:1:1);
	(ADDA1 => DA12) = (1:1:1, 1:1:1);
	(ADDA1 => DA13) = (1:1:1, 1:1:1);
	(ADDA1 => DA14) = (1:1:1, 1:1:1);
	(ADDA1 => DA15) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);
	(ADDA1 => EDA1) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => DA8) = (1:1:1, 1:1:1);
	(ADDA2 => DA9) = (1:1:1, 1:1:1);
	(ADDA2 => DA10) = (1:1:1, 1:1:1);
	(ADDA2 => DA11) = (1:1:1, 1:1:1);
	(ADDA2 => DA12) = (1:1:1, 1:1:1);
	(ADDA2 => DA13) = (1:1:1, 1:1:1);
	(ADDA2 => DA14) = (1:1:1, 1:1:1);
	(ADDA2 => DA15) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);
	(ADDA2 => EDA1) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => DA8) = (1:1:1, 1:1:1);
	(ADDA3 => DA9) = (1:1:1, 1:1:1);
	(ADDA3 => DA10) = (1:1:1, 1:1:1);
	(ADDA3 => DA11) = (1:1:1, 1:1:1);
	(ADDA3 => DA12) = (1:1:1, 1:1:1);
	(ADDA3 => DA13) = (1:1:1, 1:1:1);
	(ADDA3 => DA14) = (1:1:1, 1:1:1);
	(ADDA3 => DA15) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);
	(ADDA3 => EDA1) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => DA8) = (1:1:1, 1:1:1);
	(ADDA4 => DA9) = (1:1:1, 1:1:1);
	(ADDA4 => DA10) = (1:1:1, 1:1:1);
	(ADDA4 => DA11) = (1:1:1, 1:1:1);
	(ADDA4 => DA12) = (1:1:1, 1:1:1);
	(ADDA4 => DA13) = (1:1:1, 1:1:1);
	(ADDA4 => DA14) = (1:1:1, 1:1:1);
	(ADDA4 => DA15) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);
	(ADDA4 => EDA1) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => DA8) = (1:1:1, 1:1:1);
	(ADDA5 => DA9) = (1:1:1, 1:1:1);
	(ADDA5 => DA10) = (1:1:1, 1:1:1);
	(ADDA5 => DA11) = (1:1:1, 1:1:1);
	(ADDA5 => DA12) = (1:1:1, 1:1:1);
	(ADDA5 => DA13) = (1:1:1, 1:1:1);
	(ADDA5 => DA14) = (1:1:1, 1:1:1);
	(ADDA5 => DA15) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);
	(ADDA5 => EDA1) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => DA8) = (1:1:1, 1:1:1);
	(ADDA6 => DA9) = (1:1:1, 1:1:1);
	(ADDA6 => DA10) = (1:1:1, 1:1:1);
	(ADDA6 => DA11) = (1:1:1, 1:1:1);
	(ADDA6 => DA12) = (1:1:1, 1:1:1);
	(ADDA6 => DA13) = (1:1:1, 1:1:1);
	(ADDA6 => DA14) = (1:1:1, 1:1:1);
	(ADDA6 => DA15) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);
	(ADDA6 => EDA1) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => DA8) = (1:1:1, 1:1:1);
	(ADDA7 => DA9) = (1:1:1, 1:1:1);
	(ADDA7 => DA10) = (1:1:1, 1:1:1);
	(ADDA7 => DA11) = (1:1:1, 1:1:1);
	(ADDA7 => DA12) = (1:1:1, 1:1:1);
	(ADDA7 => DA13) = (1:1:1, 1:1:1);
	(ADDA7 => DA14) = (1:1:1, 1:1:1);
	(ADDA7 => DA15) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);
	(ADDA7 => EDA1) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => DB8) = (1:1:1, 1:1:1);
	(ADDB0 => DB9) = (1:1:1, 1:1:1);
	(ADDB0 => DB10) = (1:1:1, 1:1:1);
	(ADDB0 => DB11) = (1:1:1, 1:1:1);
	(ADDB0 => DB12) = (1:1:1, 1:1:1);
	(ADDB0 => DB13) = (1:1:1, 1:1:1);
	(ADDB0 => DB14) = (1:1:1, 1:1:1);
	(ADDB0 => DB15) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);
	(ADDB0 => EDB1) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => DB8) = (1:1:1, 1:1:1);
	(ADDB1 => DB9) = (1:1:1, 1:1:1);
	(ADDB1 => DB10) = (1:1:1, 1:1:1);
	(ADDB1 => DB11) = (1:1:1, 1:1:1);
	(ADDB1 => DB12) = (1:1:1, 1:1:1);
	(ADDB1 => DB13) = (1:1:1, 1:1:1);
	(ADDB1 => DB14) = (1:1:1, 1:1:1);
	(ADDB1 => DB15) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);
	(ADDB1 => EDB1) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => DB8) = (1:1:1, 1:1:1);
	(ADDB2 => DB9) = (1:1:1, 1:1:1);
	(ADDB2 => DB10) = (1:1:1, 1:1:1);
	(ADDB2 => DB11) = (1:1:1, 1:1:1);
	(ADDB2 => DB12) = (1:1:1, 1:1:1);
	(ADDB2 => DB13) = (1:1:1, 1:1:1);
	(ADDB2 => DB14) = (1:1:1, 1:1:1);
	(ADDB2 => DB15) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);
	(ADDB2 => EDB1) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => DB8) = (1:1:1, 1:1:1);
	(ADDB3 => DB9) = (1:1:1, 1:1:1);
	(ADDB3 => DB10) = (1:1:1, 1:1:1);
	(ADDB3 => DB11) = (1:1:1, 1:1:1);
	(ADDB3 => DB12) = (1:1:1, 1:1:1);
	(ADDB3 => DB13) = (1:1:1, 1:1:1);
	(ADDB3 => DB14) = (1:1:1, 1:1:1);
	(ADDB3 => DB15) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);
	(ADDB3 => EDB1) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => DB8) = (1:1:1, 1:1:1);
	(ADDB4 => DB9) = (1:1:1, 1:1:1);
	(ADDB4 => DB10) = (1:1:1, 1:1:1);
	(ADDB4 => DB11) = (1:1:1, 1:1:1);
	(ADDB4 => DB12) = (1:1:1, 1:1:1);
	(ADDB4 => DB13) = (1:1:1, 1:1:1);
	(ADDB4 => DB14) = (1:1:1, 1:1:1);
	(ADDB4 => DB15) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);
	(ADDB4 => EDB1) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => DB8) = (1:1:1, 1:1:1);
	(ADDB5 => DB9) = (1:1:1, 1:1:1);
	(ADDB5 => DB10) = (1:1:1, 1:1:1);
	(ADDB5 => DB11) = (1:1:1, 1:1:1);
	(ADDB5 => DB12) = (1:1:1, 1:1:1);
	(ADDB5 => DB13) = (1:1:1, 1:1:1);
	(ADDB5 => DB14) = (1:1:1, 1:1:1);
	(ADDB5 => DB15) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);
	(ADDB5 => EDB1) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => DB8) = (1:1:1, 1:1:1);
	(ADDB6 => DB9) = (1:1:1, 1:1:1);
	(ADDB6 => DB10) = (1:1:1, 1:1:1);
	(ADDB6 => DB11) = (1:1:1, 1:1:1);
	(ADDB6 => DB12) = (1:1:1, 1:1:1);
	(ADDB6 => DB13) = (1:1:1, 1:1:1);
	(ADDB6 => DB14) = (1:1:1, 1:1:1);
	(ADDB6 => DB15) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);
	(ADDB6 => EDB1) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => DB8) = (1:1:1, 1:1:1);
	(ADDB7 => DB9) = (1:1:1, 1:1:1);
	(ADDB7 => DB10) = (1:1:1, 1:1:1);
	(ADDB7 => DB11) = (1:1:1, 1:1:1);
	(ADDB7 => DB12) = (1:1:1, 1:1:1);
	(ADDB7 => DB13) = (1:1:1, 1:1:1);
	(ADDB7 => DB14) = (1:1:1, 1:1:1);
	(ADDB7 => DB15) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);
	(ADDB7 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB256X18DAF_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};

not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
reg   [7:0]  WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56;

reg AD_EQ;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)      //added to fix initial value overwritten to x problem 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
      begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	   begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	   end
   	else
		ramout_w_A = memA[ADDA];
      end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  // added to fix initial value overwritten to x problem 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	  begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	  end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier12);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier13);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier14);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier20);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier21);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier22);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier33);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier34);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier35);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier36);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier37);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier38);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier40);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier42);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier43);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier44);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier45);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier46);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier47);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier48);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier49);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier50);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier51);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier52);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier53);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier54);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier55);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier56);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => DA8) = (1:1:1, 1:1:1);
	(ADDA0 => DA9) = (1:1:1, 1:1:1);
	(ADDA0 => DA10) = (1:1:1, 1:1:1);
	(ADDA0 => DA11) = (1:1:1, 1:1:1);
	(ADDA0 => DA12) = (1:1:1, 1:1:1);
	(ADDA0 => DA13) = (1:1:1, 1:1:1);
	(ADDA0 => DA14) = (1:1:1, 1:1:1);
	(ADDA0 => DA15) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);
	(ADDA0 => EDA1) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => DA8) = (1:1:1, 1:1:1);
	(ADDA1 => DA9) = (1:1:1, 1:1:1);
	(ADDA1 => DA10) = (1:1:1, 1:1:1);
	(ADDA1 => DA11) = (1:1:1, 1:1:1);
	(ADDA1 => DA12) = (1:1:1, 1:1:1);
	(ADDA1 => DA13) = (1:1:1, 1:1:1);
	(ADDA1 => DA14) = (1:1:1, 1:1:1);
	(ADDA1 => DA15) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);
	(ADDA1 => EDA1) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => DA8) = (1:1:1, 1:1:1);
	(ADDA2 => DA9) = (1:1:1, 1:1:1);
	(ADDA2 => DA10) = (1:1:1, 1:1:1);
	(ADDA2 => DA11) = (1:1:1, 1:1:1);
	(ADDA2 => DA12) = (1:1:1, 1:1:1);
	(ADDA2 => DA13) = (1:1:1, 1:1:1);
	(ADDA2 => DA14) = (1:1:1, 1:1:1);
	(ADDA2 => DA15) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);
	(ADDA2 => EDA1) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => DA8) = (1:1:1, 1:1:1);
	(ADDA3 => DA9) = (1:1:1, 1:1:1);
	(ADDA3 => DA10) = (1:1:1, 1:1:1);
	(ADDA3 => DA11) = (1:1:1, 1:1:1);
	(ADDA3 => DA12) = (1:1:1, 1:1:1);
	(ADDA3 => DA13) = (1:1:1, 1:1:1);
	(ADDA3 => DA14) = (1:1:1, 1:1:1);
	(ADDA3 => DA15) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);
	(ADDA3 => EDA1) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => DA8) = (1:1:1, 1:1:1);
	(ADDA4 => DA9) = (1:1:1, 1:1:1);
	(ADDA4 => DA10) = (1:1:1, 1:1:1);
	(ADDA4 => DA11) = (1:1:1, 1:1:1);
	(ADDA4 => DA12) = (1:1:1, 1:1:1);
	(ADDA4 => DA13) = (1:1:1, 1:1:1);
	(ADDA4 => DA14) = (1:1:1, 1:1:1);
	(ADDA4 => DA15) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);
	(ADDA4 => EDA1) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => DA8) = (1:1:1, 1:1:1);
	(ADDA5 => DA9) = (1:1:1, 1:1:1);
	(ADDA5 => DA10) = (1:1:1, 1:1:1);
	(ADDA5 => DA11) = (1:1:1, 1:1:1);
	(ADDA5 => DA12) = (1:1:1, 1:1:1);
	(ADDA5 => DA13) = (1:1:1, 1:1:1);
	(ADDA5 => DA14) = (1:1:1, 1:1:1);
	(ADDA5 => DA15) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);
	(ADDA5 => EDA1) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => DA8) = (1:1:1, 1:1:1);
	(ADDA6 => DA9) = (1:1:1, 1:1:1);
	(ADDA6 => DA10) = (1:1:1, 1:1:1);
	(ADDA6 => DA11) = (1:1:1, 1:1:1);
	(ADDA6 => DA12) = (1:1:1, 1:1:1);
	(ADDA6 => DA13) = (1:1:1, 1:1:1);
	(ADDA6 => DA14) = (1:1:1, 1:1:1);
	(ADDA6 => DA15) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);
	(ADDA6 => EDA1) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => DA8) = (1:1:1, 1:1:1);
	(ADDA7 => DA9) = (1:1:1, 1:1:1);
	(ADDA7 => DA10) = (1:1:1, 1:1:1);
	(ADDA7 => DA11) = (1:1:1, 1:1:1);
	(ADDA7 => DA12) = (1:1:1, 1:1:1);
	(ADDA7 => DA13) = (1:1:1, 1:1:1);
	(ADDA7 => DA14) = (1:1:1, 1:1:1);
	(ADDA7 => DA15) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);
	(ADDA7 => EDA1) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => DB8) = (1:1:1, 1:1:1);
	(ADDB0 => DB9) = (1:1:1, 1:1:1);
	(ADDB0 => DB10) = (1:1:1, 1:1:1);
	(ADDB0 => DB11) = (1:1:1, 1:1:1);
	(ADDB0 => DB12) = (1:1:1, 1:1:1);
	(ADDB0 => DB13) = (1:1:1, 1:1:1);
	(ADDB0 => DB14) = (1:1:1, 1:1:1);
	(ADDB0 => DB15) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);
	(ADDB0 => EDB1) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => DB8) = (1:1:1, 1:1:1);
	(ADDB1 => DB9) = (1:1:1, 1:1:1);
	(ADDB1 => DB10) = (1:1:1, 1:1:1);
	(ADDB1 => DB11) = (1:1:1, 1:1:1);
	(ADDB1 => DB12) = (1:1:1, 1:1:1);
	(ADDB1 => DB13) = (1:1:1, 1:1:1);
	(ADDB1 => DB14) = (1:1:1, 1:1:1);
	(ADDB1 => DB15) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);
	(ADDB1 => EDB1) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => DB8) = (1:1:1, 1:1:1);
	(ADDB2 => DB9) = (1:1:1, 1:1:1);
	(ADDB2 => DB10) = (1:1:1, 1:1:1);
	(ADDB2 => DB11) = (1:1:1, 1:1:1);
	(ADDB2 => DB12) = (1:1:1, 1:1:1);
	(ADDB2 => DB13) = (1:1:1, 1:1:1);
	(ADDB2 => DB14) = (1:1:1, 1:1:1);
	(ADDB2 => DB15) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);
	(ADDB2 => EDB1) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => DB8) = (1:1:1, 1:1:1);
	(ADDB3 => DB9) = (1:1:1, 1:1:1);
	(ADDB3 => DB10) = (1:1:1, 1:1:1);
	(ADDB3 => DB11) = (1:1:1, 1:1:1);
	(ADDB3 => DB12) = (1:1:1, 1:1:1);
	(ADDB3 => DB13) = (1:1:1, 1:1:1);
	(ADDB3 => DB14) = (1:1:1, 1:1:1);
	(ADDB3 => DB15) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);
	(ADDB3 => EDB1) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => DB8) = (1:1:1, 1:1:1);
	(ADDB4 => DB9) = (1:1:1, 1:1:1);
	(ADDB4 => DB10) = (1:1:1, 1:1:1);
	(ADDB4 => DB11) = (1:1:1, 1:1:1);
	(ADDB4 => DB12) = (1:1:1, 1:1:1);
	(ADDB4 => DB13) = (1:1:1, 1:1:1);
	(ADDB4 => DB14) = (1:1:1, 1:1:1);
	(ADDB4 => DB15) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);
	(ADDB4 => EDB1) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => DB8) = (1:1:1, 1:1:1);
	(ADDB5 => DB9) = (1:1:1, 1:1:1);
	(ADDB5 => DB10) = (1:1:1, 1:1:1);
	(ADDB5 => DB11) = (1:1:1, 1:1:1);
	(ADDB5 => DB12) = (1:1:1, 1:1:1);
	(ADDB5 => DB13) = (1:1:1, 1:1:1);
	(ADDB5 => DB14) = (1:1:1, 1:1:1);
	(ADDB5 => DB15) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);
	(ADDB5 => EDB1) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => DB8) = (1:1:1, 1:1:1);
	(ADDB6 => DB9) = (1:1:1, 1:1:1);
	(ADDB6 => DB10) = (1:1:1, 1:1:1);
	(ADDB6 => DB11) = (1:1:1, 1:1:1);
	(ADDB6 => DB12) = (1:1:1, 1:1:1);
	(ADDB6 => DB13) = (1:1:1, 1:1:1);
	(ADDB6 => DB14) = (1:1:1, 1:1:1);
	(ADDB6 => DB15) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);
	(ADDB6 => EDB1) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => DB8) = (1:1:1, 1:1:1);
	(ADDB7 => DB9) = (1:1:1, 1:1:1);
	(ADDB7 => DB10) = (1:1:1, 1:1:1);
	(ADDB7 => DB11) = (1:1:1, 1:1:1);
	(ADDB7 => DB12) = (1:1:1, 1:1:1);
	(ADDB7 => DB13) = (1:1:1, 1:1:1);
	(ADDB7 => DB14) = (1:1:1, 1:1:1);
	(ADDB7 => DB15) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);
	(ADDB7 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine


`celldefine
module RAMB256X18DAR (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};



//not I_00 (INV_WEN0, WEN0);
and I_01 (con0,  OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
reg   [7:0]  WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56;

reg AD_EQ;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK0 == 1'b1) && (WEN0!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
      begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	   begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	   end
   	else
		ramout_w_A = memA[ADDA];
      end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end

always @(posedge WR_CLK_B)
begin
    if ((RWCLK1 == 1'b1) && (WEN1!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_B;
	memA[latched_add_B] = 18'bx;
     end
end
	
always @(posedge WR_CLK_B)
begin : write_B
   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
     begin
	// if WRBD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_B] = DIN_B;
end

 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	  begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	  end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check


specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier12);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier13);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier14);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier20);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier21);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier22);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier33);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier34);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier35);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier36);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier37);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier38);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier40);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier42);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier43);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier44);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier45);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier46);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier47);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier48);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier49);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier50);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier51);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier52);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier53);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier54);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier55);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier56);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => DA8) = (1:1:1, 1:1:1);
	(ADDA0 => DA9) = (1:1:1, 1:1:1);
	(ADDA0 => DA10) = (1:1:1, 1:1:1);
	(ADDA0 => DA11) = (1:1:1, 1:1:1);
	(ADDA0 => DA12) = (1:1:1, 1:1:1);
	(ADDA0 => DA13) = (1:1:1, 1:1:1);
	(ADDA0 => DA14) = (1:1:1, 1:1:1);
	(ADDA0 => DA15) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);
	(ADDA0 => EDA1) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => DA8) = (1:1:1, 1:1:1);
	(ADDA1 => DA9) = (1:1:1, 1:1:1);
	(ADDA1 => DA10) = (1:1:1, 1:1:1);
	(ADDA1 => DA11) = (1:1:1, 1:1:1);
	(ADDA1 => DA12) = (1:1:1, 1:1:1);
	(ADDA1 => DA13) = (1:1:1, 1:1:1);
	(ADDA1 => DA14) = (1:1:1, 1:1:1);
	(ADDA1 => DA15) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);
	(ADDA1 => EDA1) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => DA8) = (1:1:1, 1:1:1);
	(ADDA2 => DA9) = (1:1:1, 1:1:1);
	(ADDA2 => DA10) = (1:1:1, 1:1:1);
	(ADDA2 => DA11) = (1:1:1, 1:1:1);
	(ADDA2 => DA12) = (1:1:1, 1:1:1);
	(ADDA2 => DA13) = (1:1:1, 1:1:1);
	(ADDA2 => DA14) = (1:1:1, 1:1:1);
	(ADDA2 => DA15) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);
	(ADDA2 => EDA1) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => DA8) = (1:1:1, 1:1:1);
	(ADDA3 => DA9) = (1:1:1, 1:1:1);
	(ADDA3 => DA10) = (1:1:1, 1:1:1);
	(ADDA3 => DA11) = (1:1:1, 1:1:1);
	(ADDA3 => DA12) = (1:1:1, 1:1:1);
	(ADDA3 => DA13) = (1:1:1, 1:1:1);
	(ADDA3 => DA14) = (1:1:1, 1:1:1);
	(ADDA3 => DA15) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);
	(ADDA3 => EDA1) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => DA8) = (1:1:1, 1:1:1);
	(ADDA4 => DA9) = (1:1:1, 1:1:1);
	(ADDA4 => DA10) = (1:1:1, 1:1:1);
	(ADDA4 => DA11) = (1:1:1, 1:1:1);
	(ADDA4 => DA12) = (1:1:1, 1:1:1);
	(ADDA4 => DA13) = (1:1:1, 1:1:1);
	(ADDA4 => DA14) = (1:1:1, 1:1:1);
	(ADDA4 => DA15) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);
	(ADDA4 => EDA1) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => DA8) = (1:1:1, 1:1:1);
	(ADDA5 => DA9) = (1:1:1, 1:1:1);
	(ADDA5 => DA10) = (1:1:1, 1:1:1);
	(ADDA5 => DA11) = (1:1:1, 1:1:1);
	(ADDA5 => DA12) = (1:1:1, 1:1:1);
	(ADDA5 => DA13) = (1:1:1, 1:1:1);
	(ADDA5 => DA14) = (1:1:1, 1:1:1);
	(ADDA5 => DA15) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);
	(ADDA5 => EDA1) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => DA8) = (1:1:1, 1:1:1);
	(ADDA6 => DA9) = (1:1:1, 1:1:1);
	(ADDA6 => DA10) = (1:1:1, 1:1:1);
	(ADDA6 => DA11) = (1:1:1, 1:1:1);
	(ADDA6 => DA12) = (1:1:1, 1:1:1);
	(ADDA6 => DA13) = (1:1:1, 1:1:1);
	(ADDA6 => DA14) = (1:1:1, 1:1:1);
	(ADDA6 => DA15) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);
	(ADDA6 => EDA1) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => DA8) = (1:1:1, 1:1:1);
	(ADDA7 => DA9) = (1:1:1, 1:1:1);
	(ADDA7 => DA10) = (1:1:1, 1:1:1);
	(ADDA7 => DA11) = (1:1:1, 1:1:1);
	(ADDA7 => DA12) = (1:1:1, 1:1:1);
	(ADDA7 => DA13) = (1:1:1, 1:1:1);
	(ADDA7 => DA14) = (1:1:1, 1:1:1);
	(ADDA7 => DA15) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);
	(ADDA7 => EDA1) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => DB8) = (1:1:1, 1:1:1);
	(ADDB0 => DB9) = (1:1:1, 1:1:1);
	(ADDB0 => DB10) = (1:1:1, 1:1:1);
	(ADDB0 => DB11) = (1:1:1, 1:1:1);
	(ADDB0 => DB12) = (1:1:1, 1:1:1);
	(ADDB0 => DB13) = (1:1:1, 1:1:1);
	(ADDB0 => DB14) = (1:1:1, 1:1:1);
	(ADDB0 => DB15) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);
	(ADDB0 => EDB1) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => DB8) = (1:1:1, 1:1:1);
	(ADDB1 => DB9) = (1:1:1, 1:1:1);
	(ADDB1 => DB10) = (1:1:1, 1:1:1);
	(ADDB1 => DB11) = (1:1:1, 1:1:1);
	(ADDB1 => DB12) = (1:1:1, 1:1:1);
	(ADDB1 => DB13) = (1:1:1, 1:1:1);
	(ADDB1 => DB14) = (1:1:1, 1:1:1);
	(ADDB1 => DB15) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);
	(ADDB1 => EDB1) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => DB8) = (1:1:1, 1:1:1);
	(ADDB2 => DB9) = (1:1:1, 1:1:1);
	(ADDB2 => DB10) = (1:1:1, 1:1:1);
	(ADDB2 => DB11) = (1:1:1, 1:1:1);
	(ADDB2 => DB12) = (1:1:1, 1:1:1);
	(ADDB2 => DB13) = (1:1:1, 1:1:1);
	(ADDB2 => DB14) = (1:1:1, 1:1:1);
	(ADDB2 => DB15) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);
	(ADDB2 => EDB1) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => DB8) = (1:1:1, 1:1:1);
	(ADDB3 => DB9) = (1:1:1, 1:1:1);
	(ADDB3 => DB10) = (1:1:1, 1:1:1);
	(ADDB3 => DB11) = (1:1:1, 1:1:1);
	(ADDB3 => DB12) = (1:1:1, 1:1:1);
	(ADDB3 => DB13) = (1:1:1, 1:1:1);
	(ADDB3 => DB14) = (1:1:1, 1:1:1);
	(ADDB3 => DB15) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);
	(ADDB3 => EDB1) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => DB8) = (1:1:1, 1:1:1);
	(ADDB4 => DB9) = (1:1:1, 1:1:1);
	(ADDB4 => DB10) = (1:1:1, 1:1:1);
	(ADDB4 => DB11) = (1:1:1, 1:1:1);
	(ADDB4 => DB12) = (1:1:1, 1:1:1);
	(ADDB4 => DB13) = (1:1:1, 1:1:1);
	(ADDB4 => DB14) = (1:1:1, 1:1:1);
	(ADDB4 => DB15) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);
	(ADDB4 => EDB1) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => DB8) = (1:1:1, 1:1:1);
	(ADDB5 => DB9) = (1:1:1, 1:1:1);
	(ADDB5 => DB10) = (1:1:1, 1:1:1);
	(ADDB5 => DB11) = (1:1:1, 1:1:1);
	(ADDB5 => DB12) = (1:1:1, 1:1:1);
	(ADDB5 => DB13) = (1:1:1, 1:1:1);
	(ADDB5 => DB14) = (1:1:1, 1:1:1);
	(ADDB5 => DB15) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);
	(ADDB5 => EDB1) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => DB8) = (1:1:1, 1:1:1);
	(ADDB6 => DB9) = (1:1:1, 1:1:1);
	(ADDB6 => DB10) = (1:1:1, 1:1:1);
	(ADDB6 => DB11) = (1:1:1, 1:1:1);
	(ADDB6 => DB12) = (1:1:1, 1:1:1);
	(ADDB6 => DB13) = (1:1:1, 1:1:1);
	(ADDB6 => DB14) = (1:1:1, 1:1:1);
	(ADDB6 => DB15) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);
	(ADDB6 => EDB1) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => DB8) = (1:1:1, 1:1:1);
	(ADDB7 => DB9) = (1:1:1, 1:1:1);
	(ADDB7 => DB10) = (1:1:1, 1:1:1);
	(ADDB7 => DB11) = (1:1:1, 1:1:1);
	(ADDB7 => DB12) = (1:1:1, 1:1:1);
	(ADDB7 => DB13) = (1:1:1, 1:1:1);
	(ADDB7 => DB14) = (1:1:1, 1:1:1);
	(ADDB7 => DB15) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);
	(ADDB7 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB256X18DAR_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};

not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
reg   [7:0]  WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56;

reg  AD_EQ;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK0 == 1'b1) && (WEN0!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
      begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	   begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	   end
   	else
		ramout_w_A = memA[ADDA];
      end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end

always @(posedge WR_CLK_B)
begin
    if ((RWCLK1 == 1'b1) && (WEN1!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_B;
	memA[latched_add_B] = 18'bx;
     end
end
	
always @(posedge WR_CLK_B)
begin : write_B
   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
     begin
	// if WRBD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_B] = DIN_B;
end

 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	  begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	  end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier12);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier13);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier14);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier20);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier21);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier22);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier33);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier34);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier35);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier36);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier37);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier38);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier40);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier42);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier43);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier44);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier45);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier46);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier47);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier48);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier49);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier50);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier51);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier52);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier53);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier54);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier55);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier56);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => DA8) = (1:1:1, 1:1:1);
	(ADDA0 => DA9) = (1:1:1, 1:1:1);
	(ADDA0 => DA10) = (1:1:1, 1:1:1);
	(ADDA0 => DA11) = (1:1:1, 1:1:1);
	(ADDA0 => DA12) = (1:1:1, 1:1:1);
	(ADDA0 => DA13) = (1:1:1, 1:1:1);
	(ADDA0 => DA14) = (1:1:1, 1:1:1);
	(ADDA0 => DA15) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);
	(ADDA0 => EDA1) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => DA8) = (1:1:1, 1:1:1);
	(ADDA1 => DA9) = (1:1:1, 1:1:1);
	(ADDA1 => DA10) = (1:1:1, 1:1:1);
	(ADDA1 => DA11) = (1:1:1, 1:1:1);
	(ADDA1 => DA12) = (1:1:1, 1:1:1);
	(ADDA1 => DA13) = (1:1:1, 1:1:1);
	(ADDA1 => DA14) = (1:1:1, 1:1:1);
	(ADDA1 => DA15) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);
	(ADDA1 => EDA1) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => DA8) = (1:1:1, 1:1:1);
	(ADDA2 => DA9) = (1:1:1, 1:1:1);
	(ADDA2 => DA10) = (1:1:1, 1:1:1);
	(ADDA2 => DA11) = (1:1:1, 1:1:1);
	(ADDA2 => DA12) = (1:1:1, 1:1:1);
	(ADDA2 => DA13) = (1:1:1, 1:1:1);
	(ADDA2 => DA14) = (1:1:1, 1:1:1);
	(ADDA2 => DA15) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);
	(ADDA2 => EDA1) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => DA8) = (1:1:1, 1:1:1);
	(ADDA3 => DA9) = (1:1:1, 1:1:1);
	(ADDA3 => DA10) = (1:1:1, 1:1:1);
	(ADDA3 => DA11) = (1:1:1, 1:1:1);
	(ADDA3 => DA12) = (1:1:1, 1:1:1);
	(ADDA3 => DA13) = (1:1:1, 1:1:1);
	(ADDA3 => DA14) = (1:1:1, 1:1:1);
	(ADDA3 => DA15) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);
	(ADDA3 => EDA1) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => DA8) = (1:1:1, 1:1:1);
	(ADDA4 => DA9) = (1:1:1, 1:1:1);
	(ADDA4 => DA10) = (1:1:1, 1:1:1);
	(ADDA4 => DA11) = (1:1:1, 1:1:1);
	(ADDA4 => DA12) = (1:1:1, 1:1:1);
	(ADDA4 => DA13) = (1:1:1, 1:1:1);
	(ADDA4 => DA14) = (1:1:1, 1:1:1);
	(ADDA4 => DA15) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);
	(ADDA4 => EDA1) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => DA8) = (1:1:1, 1:1:1);
	(ADDA5 => DA9) = (1:1:1, 1:1:1);
	(ADDA5 => DA10) = (1:1:1, 1:1:1);
	(ADDA5 => DA11) = (1:1:1, 1:1:1);
	(ADDA5 => DA12) = (1:1:1, 1:1:1);
	(ADDA5 => DA13) = (1:1:1, 1:1:1);
	(ADDA5 => DA14) = (1:1:1, 1:1:1);
	(ADDA5 => DA15) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);
	(ADDA5 => EDA1) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => DA8) = (1:1:1, 1:1:1);
	(ADDA6 => DA9) = (1:1:1, 1:1:1);
	(ADDA6 => DA10) = (1:1:1, 1:1:1);
	(ADDA6 => DA11) = (1:1:1, 1:1:1);
	(ADDA6 => DA12) = (1:1:1, 1:1:1);
	(ADDA6 => DA13) = (1:1:1, 1:1:1);
	(ADDA6 => DA14) = (1:1:1, 1:1:1);
	(ADDA6 => DA15) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);
	(ADDA6 => EDA1) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => DA8) = (1:1:1, 1:1:1);
	(ADDA7 => DA9) = (1:1:1, 1:1:1);
	(ADDA7 => DA10) = (1:1:1, 1:1:1);
	(ADDA7 => DA11) = (1:1:1, 1:1:1);
	(ADDA7 => DA12) = (1:1:1, 1:1:1);
	(ADDA7 => DA13) = (1:1:1, 1:1:1);
	(ADDA7 => DA14) = (1:1:1, 1:1:1);
	(ADDA7 => DA15) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);
	(ADDA7 => EDA1) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => DB8) = (1:1:1, 1:1:1);
	(ADDB0 => DB9) = (1:1:1, 1:1:1);
	(ADDB0 => DB10) = (1:1:1, 1:1:1);
	(ADDB0 => DB11) = (1:1:1, 1:1:1);
	(ADDB0 => DB12) = (1:1:1, 1:1:1);
	(ADDB0 => DB13) = (1:1:1, 1:1:1);
	(ADDB0 => DB14) = (1:1:1, 1:1:1);
	(ADDB0 => DB15) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);
	(ADDB0 => EDB1) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => DB8) = (1:1:1, 1:1:1);
	(ADDB1 => DB9) = (1:1:1, 1:1:1);
	(ADDB1 => DB10) = (1:1:1, 1:1:1);
	(ADDB1 => DB11) = (1:1:1, 1:1:1);
	(ADDB1 => DB12) = (1:1:1, 1:1:1);
	(ADDB1 => DB13) = (1:1:1, 1:1:1);
	(ADDB1 => DB14) = (1:1:1, 1:1:1);
	(ADDB1 => DB15) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);
	(ADDB1 => EDB1) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => DB8) = (1:1:1, 1:1:1);
	(ADDB2 => DB9) = (1:1:1, 1:1:1);
	(ADDB2 => DB10) = (1:1:1, 1:1:1);
	(ADDB2 => DB11) = (1:1:1, 1:1:1);
	(ADDB2 => DB12) = (1:1:1, 1:1:1);
	(ADDB2 => DB13) = (1:1:1, 1:1:1);
	(ADDB2 => DB14) = (1:1:1, 1:1:1);
	(ADDB2 => DB15) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);
	(ADDB2 => EDB1) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => DB8) = (1:1:1, 1:1:1);
	(ADDB3 => DB9) = (1:1:1, 1:1:1);
	(ADDB3 => DB10) = (1:1:1, 1:1:1);
	(ADDB3 => DB11) = (1:1:1, 1:1:1);
	(ADDB3 => DB12) = (1:1:1, 1:1:1);
	(ADDB3 => DB13) = (1:1:1, 1:1:1);
	(ADDB3 => DB14) = (1:1:1, 1:1:1);
	(ADDB3 => DB15) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);
	(ADDB3 => EDB1) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => DB8) = (1:1:1, 1:1:1);
	(ADDB4 => DB9) = (1:1:1, 1:1:1);
	(ADDB4 => DB10) = (1:1:1, 1:1:1);
	(ADDB4 => DB11) = (1:1:1, 1:1:1);
	(ADDB4 => DB12) = (1:1:1, 1:1:1);
	(ADDB4 => DB13) = (1:1:1, 1:1:1);
	(ADDB4 => DB14) = (1:1:1, 1:1:1);
	(ADDB4 => DB15) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);
	(ADDB4 => EDB1) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => DB8) = (1:1:1, 1:1:1);
	(ADDB5 => DB9) = (1:1:1, 1:1:1);
	(ADDB5 => DB10) = (1:1:1, 1:1:1);
	(ADDB5 => DB11) = (1:1:1, 1:1:1);
	(ADDB5 => DB12) = (1:1:1, 1:1:1);
	(ADDB5 => DB13) = (1:1:1, 1:1:1);
	(ADDB5 => DB14) = (1:1:1, 1:1:1);
	(ADDB5 => DB15) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);
	(ADDB5 => EDB1) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => DB8) = (1:1:1, 1:1:1);
	(ADDB6 => DB9) = (1:1:1, 1:1:1);
	(ADDB6 => DB10) = (1:1:1, 1:1:1);
	(ADDB6 => DB11) = (1:1:1, 1:1:1);
	(ADDB6 => DB12) = (1:1:1, 1:1:1);
	(ADDB6 => DB13) = (1:1:1, 1:1:1);
	(ADDB6 => DB14) = (1:1:1, 1:1:1);
	(ADDB6 => DB15) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);
	(ADDB6 => EDB1) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => DB8) = (1:1:1, 1:1:1);
	(ADDB7 => DB9) = (1:1:1, 1:1:1);
	(ADDB7 => DB10) = (1:1:1, 1:1:1);
	(ADDB7 => DB11) = (1:1:1, 1:1:1);
	(ADDB7 => DB12) = (1:1:1, 1:1:1);
	(ADDB7 => DB13) = (1:1:1, 1:1:1);
	(ADDB7 => DB14) = (1:1:1, 1:1:1);
	(ADDB7 => DB15) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);
	(ADDB7 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB256X18DSF (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


and I_01 (con0,  OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);



reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [7:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56,notifier57,notifier58;


parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;
   notifier57 = 1'b0;
   notifier58 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
 //if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK0 == 1'b0) && (WEN0!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  //10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADDA & ~ADDA) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 8'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b1;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
 //if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

always @(negedge RD_CLK_B)
begin
    if ((RWCLK1 == 1'b0) && (WEN1!= 1'b1))
     begin
	disable read_B;
	ramout_w_B = 18'bx;
     end
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  //10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(negedge RD_CLK_B)
begin : read_B
   if (|(ADDB & ~ADDB) === 1'bx)
     begin
	// if WRBD is x send RD to x immediately
	ramout_w_B = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_B = memA[RD_ADD_B];
end
 
always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

//////End data conflict check

specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier14);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier22);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier33);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier34);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier35);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier36);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier37);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier38);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier39);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier40);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier42);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier43);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier44);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier45);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier46);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier47);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier48);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier49);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier50);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier51);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier52);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier53);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier54);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier55);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier56);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier57);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier58);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => DA8) = (1:1:1, 1:1:1);
	(RWCLK0 => DA9) = (1:1:1, 1:1:1);
	(RWCLK0 => DA10) = (1:1:1, 1:1:1);
	(RWCLK0 => DA11) = (1:1:1, 1:1:1);
	(RWCLK0 => DA12) = (1:1:1, 1:1:1);
	(RWCLK0 => DA13) = (1:1:1, 1:1:1);
	(RWCLK0 => DA14) = (1:1:1, 1:1:1);
	(RWCLK0 => DA15) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA1) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => DB8) = (1:1:1, 1:1:1);
	(RWCLK1 => DB9) = (1:1:1, 1:1:1);
	(RWCLK1 => DB10) = (1:1:1, 1:1:1);
	(RWCLK1 => DB11) = (1:1:1, 1:1:1);
	(RWCLK1 => DB12) = (1:1:1, 1:1:1);
	(RWCLK1 => DB13) = (1:1:1, 1:1:1);
	(RWCLK1 => DB14) = (1:1:1, 1:1:1);
	(RWCLK1 => DB15) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB1) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18DSF_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;


wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  b_OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);



reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [7:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56,notifier57,notifier58;


parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;
   notifier57 = 1'b0;
   notifier58 = 1'b0;


   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK0 == 1'b0) && (WEN0!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  // 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADDA & ~ADDA) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 8'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b1;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

always @(negedge RD_CLK_B)
begin
    if ((RWCLK1 == 1'b0) && (WEN1!= 1'b1))
     begin
	disable read_B;
	ramout_w_B = 18'bx;
     end
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  // 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(negedge RD_CLK_B)
begin : read_B
   if (|(ADDB & ~ADDB) === 1'bx)
     begin
	// if WRBD is x send RD to x immediately
	ramout_w_B = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_B = memA[RD_ADD_B];
end
 
always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check

specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier14);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier22);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier33);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier34);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier35);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier36);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier37);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier38);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier39);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier40);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier42);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier43);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier44);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier45);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier46);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier47);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier48);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier49);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier50);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier51);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier52);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier53);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier54);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier55);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier56);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier57);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier58);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => DA8) = (1:1:1, 1:1:1);
	(RWCLK0 => DA9) = (1:1:1, 1:1:1);
	(RWCLK0 => DA10) = (1:1:1, 1:1:1);
	(RWCLK0 => DA11) = (1:1:1, 1:1:1);
	(RWCLK0 => DA12) = (1:1:1, 1:1:1);
	(RWCLK0 => DA13) = (1:1:1, 1:1:1);
	(RWCLK0 => DA14) = (1:1:1, 1:1:1);
	(RWCLK0 => DA15) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA1) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => DB8) = (1:1:1, 1:1:1);
	(RWCLK1 => DB9) = (1:1:1, 1:1:1);
	(RWCLK1 => DB10) = (1:1:1, 1:1:1);
	(RWCLK1 => DB11) = (1:1:1, 1:1:1);
	(RWCLK1 => DB12) = (1:1:1, 1:1:1);
	(RWCLK1 => DB13) = (1:1:1, 1:1:1);
	(RWCLK1 => DB14) = (1:1:1, 1:1:1);
	(RWCLK1 => DB15) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB1) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

//***************************************************

`celldefine
module RAMB256X18DSR (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;

wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


and I_01 (con0,  OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [7:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56,notifier57,notifier58;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] <= {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;
   notifier57 = 1'b0;
   notifier58 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end


//ct101505
always @(posedge RWCLK0)
begin: write_A
   if (WEN0 == 1'b0)
      if (|(ADDA & ~ ADDA) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=255;i=i+1)
            memA[i] <= 18'bx;
      else
         memA[ADDA] <= DA;
end

always @(posedge RWCLK0)
begin
   if ( WEN0 == 1'b1 && CE0 == 1'b0)
   begin
      if (|(ADDA & ~ADDA) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_A <= 18'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_A <= memA[RD_ADD_A];
   end
end

always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//-----------------------------------------
//// duplication for 2nd part
//-----------------------------------------

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 8'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b0;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end


//ct101505
always @(posedge RWCLK1)
begin : write_B
   if (WEN1 == 1'b0)
      if (|(ADDB & ~ ADDB) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=255;i=i+1)
            memA[i] <= 18'bx;
      else
         memA[ADDB] <= DB;
end

always @(posedge RWCLK1)
begin
   if ( WEN1 == 1'b1 && CE1 == 1'b0)
   begin
      if (|(ADDB & ~ADDB) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_B <= 18'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_B <= memA[RD_ADD_B];
   end
end

always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;


/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier14);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier22);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier33);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier34);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier35);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier36);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier37);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier38);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier39);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier40);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier42);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier43);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier44);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier45);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier46);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier47);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier48);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier49);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier50);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier51);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier52);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier53);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier54);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier55);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier56);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier57);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier58);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => DA8) = (1:1:1, 1:1:1);
	(RWCLK0 => DA9) = (1:1:1, 1:1:1);
	(RWCLK0 => DA10) = (1:1:1, 1:1:1);
	(RWCLK0 => DA11) = (1:1:1, 1:1:1);
	(RWCLK0 => DA12) = (1:1:1, 1:1:1);
	(RWCLK0 => DA13) = (1:1:1, 1:1:1);
	(RWCLK0 => DA14) = (1:1:1, 1:1:1);
	(RWCLK0 => DA15) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA1) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => DB8) = (1:1:1, 1:1:1);
	(RWCLK1 => DB9) = (1:1:1, 1:1:1);
	(RWCLK1 => DB10) = (1:1:1, 1:1:1);
	(RWCLK1 => DB11) = (1:1:1, 1:1:1);
	(RWCLK1 => DB12) = (1:1:1, 1:1:1);
	(RWCLK1 => DB13) = (1:1:1, 1:1:1);
	(RWCLK1 => DB14) = (1:1:1, 1:1:1);
	(RWCLK1 => DB15) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB1) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

//***************************************************

`celldefine
module RAMB256X18DSR_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, DA8, DA9, DA10, DA11, DA12, DA13, DA14, DA15, EDA0, EDA1;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, DB8, DB9, DB10, DB11, DB12, DB13, DB14, DB15, EDB0, EDB1;

wire  [17:0] DA, DB;
wire  [7:0] ADDA, ADDB;

assign ADDA[7:0] = {ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[7:0] = {ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};

not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins01 (EDA1,   DA[17], con0);
bufif0 ins02 (DA[17], EDA1, con0);

bufif1 ins03 (EDA0,   DA[16], con0);
bufif0 ins04 (DA[16], EDA0, con0);

bufif1 ins05 (DA15,   DA[15], con0);
bufif0 ins06 (DA[15], DA15, con0);

bufif1 ins07 (DA14,   DA[14], con0);
bufif0 ins08 (DA[14], DA14, con0);

bufif1 ins09 (DA13,   DA[13], con0);
bufif0 ins010 (DA[13], DA13, con0);

bufif1 ins011 (DA12,   DA[12], con0);
bufif0 ins012 (DA[12], DA12, con0);

bufif1 ins013 (DA11,   DA[11], con0);
bufif0 ins014 (DA[11], DA11, con0);

bufif1 ins015 (DA10,   DA[10], con0);
bufif0 ins016 (DA[10], DA10, con0);

bufif1 ins017 (DA9,   DA[9], con0);
bufif0 ins018 (DA[9], DA9, con0);

bufif1 ins019 (DA8,   DA[8], con0);
bufif0 ins020 (DA[8], DA8, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

//not I_10 (INV_WEN1, WEN1);
and I_11 (con1,  b_OE1, WEN1);

bufif1 ins11 (EDB1,   DB[17], con1);
bufif0 ins12 (DB[17], EDB1, con1);

bufif1 ins13 (EDB0,   DB[16], con1);
bufif0 ins14 (DB[16], EDB0, con1);

bufif1 ins15 (DB15,   DB[15], con1);
bufif0 ins16 (DB[15], DB15, con1);

bufif1 ins17 (DB14,   DB[14], con1);
bufif0 ins18 (DB[14], DB14, con1);

bufif1 ins19 (DB13,   DB[13], con1);
bufif0 ins110 (DB[13], DB13, con1);

bufif1 ins111 (DB12,   DB[12], con1);
bufif0 ins112 (DB[12], DB12, con1);

bufif1 ins113 (DB11,   DB[11], con1);
bufif0 ins114 (DB[11], DB11, con1);

bufif1 ins115 (DB10,   DB[10], con1);
bufif0 ins116 (DB[10], DB10, con1);

bufif1 ins117 (DB9,   DB[9], con1);
bufif0 ins118 (DB[9], DB9, con1);

bufif1 ins119 (DB8,   DB[8], con1);
bufif0 ins120 (DB[8], DB8, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [7:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [17:0] DIN_B;
reg   [17:0] ramout_w_B;
reg   [17:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42,notifier43,notifier44,notifier45,notifier46,notifier47,notifier48,notifier49,notifier50;
reg          notifier51,notifier52,notifier53,notifier54,notifier55,notifier56,notifier57,notifier58;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] <= {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;
   notifier43 = 1'b0;
   notifier44 = 1'b0;
   notifier45 = 1'b0;
   notifier46 = 1'b0;
   notifier47 = 1'b0;
   notifier48 = 1'b0;
   notifier49 = 1'b0;
   notifier50 = 1'b0;
   notifier51 = 1'b0;
   notifier52 = 1'b0;
   notifier53 = 1'b0;
   notifier54 = 1'b0;
   notifier55 = 1'b0;
   notifier56 = 1'b0;
   notifier57 = 1'b0;
   notifier58 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 18'bzzzz_zzzz_zzzz_zz;
   dataout_B  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 18'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

//ct101505
always @(posedge RWCLK0)
begin: write_A
   if (WEN0 == 1'b0)
      if (|(ADDA & ~ ADDA) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=255;i=i+1)
            memA[i] <= 18'bx;
      else
         memA[ADDA] <= DA;
end

always @(posedge RWCLK0)
begin
   if ( WEN0 == 1'b1 && CE0 == 1'b0)
   begin
      if (|(ADDA & ~ADDA) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_A <= 18'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_A <= memA[RD_ADD_A];
   end
end

always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1)
        dataout_A = ramout_w_A;
   else
        dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 8'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b0;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 8'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 18'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end

//ct101505
always @(posedge RWCLK1)
begin: write_B
   if (WEN1 == 1'b0)
      if (|(ADDB & ~ ADDB) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=255;i=i+1)
            memA[i] <= 18'bx;
      else
         memA[ADDB] <= DB;
end

always @(posedge RWCLK1)
begin
   if ( WEN1 == 1'b1 && CE1 == 1'b0)
   begin
      if (|(ADDB & ~ADDB) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_B <= 18'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_B <= memA[RD_ADD_B];
   end
end

always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1)
        dataout_B = ramout_w_B;
   else
        dataout_B = 18'bzzzz_zzzz_zzzz_zz;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier14);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier22);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA8, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA9, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA10, 1, 0, notifier33);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA11, 1, 0, notifier34);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA12, 1, 0, notifier35);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA13, 1, 0, notifier36);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA14, 1, 0, notifier37);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA15, 1, 0, notifier38);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier39);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA1, 1, 0, notifier40);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier42);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier43);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier44);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier45);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier46);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier47);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier48);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB8, 1, 0, notifier49);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB9, 1, 0, notifier50);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB10, 1, 0, notifier51);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB11, 1, 0, notifier52);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB12, 1, 0, notifier53);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB13, 1, 0, notifier54);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB14, 1, 0, notifier55);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB15, 1, 0, notifier56);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier57);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB1, 1, 0, notifier58);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => DA8) = (1:1:1, 1:1:1);
	(RWCLK0 => DA9) = (1:1:1, 1:1:1);
	(RWCLK0 => DA10) = (1:1:1, 1:1:1);
	(RWCLK0 => DA11) = (1:1:1, 1:1:1);
	(RWCLK0 => DA12) = (1:1:1, 1:1:1);
	(RWCLK0 => DA13) = (1:1:1, 1:1:1);
	(RWCLK0 => DA14) = (1:1:1, 1:1:1);
	(RWCLK0 => DA15) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA1) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => DB8) = (1:1:1, 1:1:1);
	(RWCLK1 => DB9) = (1:1:1, 1:1:1);
	(RWCLK1 => DB10) = (1:1:1, 1:1:1);
	(RWCLK1 => DB11) = (1:1:1, 1:1:1);
	(RWCLK1 => DB12) = (1:1:1, 1:1:1);
	(RWCLK1 => DB13) = (1:1:1, 1:1:1);
	(RWCLK1 => DB14) = (1:1:1, 1:1:1);
	(RWCLK1 => DB15) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB1) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => DA8) = (1:1:1, 1:1:1);
	(OE0 => DA9) = (1:1:1, 1:1:1);
	(OE0 => DA10) = (1:1:1, 1:1:1);
	(OE0 => DA11) = (1:1:1, 1:1:1);
	(OE0 => DA12) = (1:1:1, 1:1:1);
	(OE0 => DA13) = (1:1:1, 1:1:1);
	(OE0 => DA14) = (1:1:1, 1:1:1);
	(OE0 => DA15) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);
	(OE0 => EDA1) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => DB8) = (1:1:1, 1:1:1);
	(OE1 => DB9) = (1:1:1, 1:1:1);
	(OE1 => DB10) = (1:1:1, 1:1:1);
	(OE1 => DB11) = (1:1:1, 1:1:1);
	(OE1 => DB12) = (1:1:1, 1:1:1);
	(OE1 => DB13) = (1:1:1, 1:1:1);
	(OE1 => DB14) = (1:1:1, 1:1:1);
	(OE1 => DB15) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);
	(OE1 => EDB1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

//***************************************************
`celldefine
module RAMB256X18SAF (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, OE);


input  WEN, RWCLK, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};



and I_01 (con0,  OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier10);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier11);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D8, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D9, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), D10, 1, 0, notifier21);
	$setuphold  (negedge RWCLK &&& (WEN==0), D11, 1, 0, notifier22);
	$setuphold  (negedge RWCLK &&& (WEN==0), D12, 1, 0, notifier23);
	$setuphold  (negedge RWCLK &&& (WEN==0), D13, 1, 0, notifier24);
	$setuphold  (negedge RWCLK &&& (WEN==0), D14, 1, 0, notifier25);
	$setuphold  (negedge RWCLK &&& (WEN==0), D15, 1, 0, notifier26);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier27);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier28);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => D8) = (1:1:1, 1:1:1);
	(ADD0 => D9) = (1:1:1, 1:1:1);
	(ADD0 => D10) = (1:1:1, 1:1:1);
	(ADD0 => D11) = (1:1:1, 1:1:1);
	(ADD0 => D12) = (1:1:1, 1:1:1);
	(ADD0 => D13) = (1:1:1, 1:1:1);
	(ADD0 => D14) = (1:1:1, 1:1:1);
	(ADD0 => D15) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);
	(ADD0 => ED1) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => D8) = (1:1:1, 1:1:1);
	(ADD1 => D9) = (1:1:1, 1:1:1);
	(ADD1 => D10) = (1:1:1, 1:1:1);
	(ADD1 => D11) = (1:1:1, 1:1:1);
	(ADD1 => D12) = (1:1:1, 1:1:1);
	(ADD1 => D13) = (1:1:1, 1:1:1);
	(ADD1 => D14) = (1:1:1, 1:1:1);
	(ADD1 => D15) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);
	(ADD1 => ED1) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => D8) = (1:1:1, 1:1:1);
	(ADD2 => D9) = (1:1:1, 1:1:1);
	(ADD2 => D10) = (1:1:1, 1:1:1);
	(ADD2 => D11) = (1:1:1, 1:1:1);
	(ADD2 => D12) = (1:1:1, 1:1:1);
	(ADD2 => D13) = (1:1:1, 1:1:1);
	(ADD2 => D14) = (1:1:1, 1:1:1);
	(ADD2 => D15) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);
	(ADD2 => ED1) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => D8) = (1:1:1, 1:1:1);
	(ADD3 => D9) = (1:1:1, 1:1:1);
	(ADD3 => D10) = (1:1:1, 1:1:1);
	(ADD3 => D11) = (1:1:1, 1:1:1);
	(ADD3 => D12) = (1:1:1, 1:1:1);
	(ADD3 => D13) = (1:1:1, 1:1:1);
	(ADD3 => D14) = (1:1:1, 1:1:1);
	(ADD3 => D15) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);
	(ADD3 => ED1) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => D8) = (1:1:1, 1:1:1);
	(ADD4 => D9) = (1:1:1, 1:1:1);
	(ADD4 => D10) = (1:1:1, 1:1:1);
	(ADD4 => D11) = (1:1:1, 1:1:1);
	(ADD4 => D12) = (1:1:1, 1:1:1);
	(ADD4 => D13) = (1:1:1, 1:1:1);
	(ADD4 => D14) = (1:1:1, 1:1:1);
	(ADD4 => D15) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);
	(ADD4 => ED1) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => D8) = (1:1:1, 1:1:1);
	(ADD5 => D9) = (1:1:1, 1:1:1);
	(ADD5 => D10) = (1:1:1, 1:1:1);
	(ADD5 => D11) = (1:1:1, 1:1:1);
	(ADD5 => D12) = (1:1:1, 1:1:1);
	(ADD5 => D13) = (1:1:1, 1:1:1);
	(ADD5 => D14) = (1:1:1, 1:1:1);
	(ADD5 => D15) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);
	(ADD5 => ED1) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => D8) = (1:1:1, 1:1:1);
	(ADD6 => D9) = (1:1:1, 1:1:1);
	(ADD6 => D10) = (1:1:1, 1:1:1);
	(ADD6 => D11) = (1:1:1, 1:1:1);
	(ADD6 => D12) = (1:1:1, 1:1:1);
	(ADD6 => D13) = (1:1:1, 1:1:1);
	(ADD6 => D14) = (1:1:1, 1:1:1);
	(ADD6 => D15) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);
	(ADD6 => ED1) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => D8) = (1:1:1, 1:1:1);
	(ADD7 => D9) = (1:1:1, 1:1:1);
	(ADD7 => D10) = (1:1:1, 1:1:1);
	(ADD7 => D11) = (1:1:1, 1:1:1);
	(ADD7 => D12) = (1:1:1, 1:1:1);
	(ADD7 => D13) = (1:1:1, 1:1:1);
	(ADD7 => D14) = (1:1:1, 1:1:1);
	(ADD7 => D15) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);
	(ADD7 => ED1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SAF_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, OE);


input  WEN, RWCLK, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;


specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier10);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier11);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D8, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D9, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), D10, 1, 0, notifier21);
	$setuphold  (negedge RWCLK &&& (WEN==0), D11, 1, 0, notifier22);
	$setuphold  (negedge RWCLK &&& (WEN==0), D12, 1, 0, notifier23);
	$setuphold  (negedge RWCLK &&& (WEN==0), D13, 1, 0, notifier24);
	$setuphold  (negedge RWCLK &&& (WEN==0), D14, 1, 0, notifier25);
	$setuphold  (negedge RWCLK &&& (WEN==0), D15, 1, 0, notifier26);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier27);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier28);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => D8) = (1:1:1, 1:1:1);
	(ADD0 => D9) = (1:1:1, 1:1:1);
	(ADD0 => D10) = (1:1:1, 1:1:1);
	(ADD0 => D11) = (1:1:1, 1:1:1);
	(ADD0 => D12) = (1:1:1, 1:1:1);
	(ADD0 => D13) = (1:1:1, 1:1:1);
	(ADD0 => D14) = (1:1:1, 1:1:1);
	(ADD0 => D15) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);
	(ADD0 => ED1) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => D8) = (1:1:1, 1:1:1);
	(ADD1 => D9) = (1:1:1, 1:1:1);
	(ADD1 => D10) = (1:1:1, 1:1:1);
	(ADD1 => D11) = (1:1:1, 1:1:1);
	(ADD1 => D12) = (1:1:1, 1:1:1);
	(ADD1 => D13) = (1:1:1, 1:1:1);
	(ADD1 => D14) = (1:1:1, 1:1:1);
	(ADD1 => D15) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);
	(ADD1 => ED1) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => D8) = (1:1:1, 1:1:1);
	(ADD2 => D9) = (1:1:1, 1:1:1);
	(ADD2 => D10) = (1:1:1, 1:1:1);
	(ADD2 => D11) = (1:1:1, 1:1:1);
	(ADD2 => D12) = (1:1:1, 1:1:1);
	(ADD2 => D13) = (1:1:1, 1:1:1);
	(ADD2 => D14) = (1:1:1, 1:1:1);
	(ADD2 => D15) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);
	(ADD2 => ED1) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => D8) = (1:1:1, 1:1:1);
	(ADD3 => D9) = (1:1:1, 1:1:1);
	(ADD3 => D10) = (1:1:1, 1:1:1);
	(ADD3 => D11) = (1:1:1, 1:1:1);
	(ADD3 => D12) = (1:1:1, 1:1:1);
	(ADD3 => D13) = (1:1:1, 1:1:1);
	(ADD3 => D14) = (1:1:1, 1:1:1);
	(ADD3 => D15) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);
	(ADD3 => ED1) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => D8) = (1:1:1, 1:1:1);
	(ADD4 => D9) = (1:1:1, 1:1:1);
	(ADD4 => D10) = (1:1:1, 1:1:1);
	(ADD4 => D11) = (1:1:1, 1:1:1);
	(ADD4 => D12) = (1:1:1, 1:1:1);
	(ADD4 => D13) = (1:1:1, 1:1:1);
	(ADD4 => D14) = (1:1:1, 1:1:1);
	(ADD4 => D15) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);
	(ADD4 => ED1) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => D8) = (1:1:1, 1:1:1);
	(ADD5 => D9) = (1:1:1, 1:1:1);
	(ADD5 => D10) = (1:1:1, 1:1:1);
	(ADD5 => D11) = (1:1:1, 1:1:1);
	(ADD5 => D12) = (1:1:1, 1:1:1);
	(ADD5 => D13) = (1:1:1, 1:1:1);
	(ADD5 => D14) = (1:1:1, 1:1:1);
	(ADD5 => D15) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);
	(ADD5 => ED1) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => D8) = (1:1:1, 1:1:1);
	(ADD6 => D9) = (1:1:1, 1:1:1);
	(ADD6 => D10) = (1:1:1, 1:1:1);
	(ADD6 => D11) = (1:1:1, 1:1:1);
	(ADD6 => D12) = (1:1:1, 1:1:1);
	(ADD6 => D13) = (1:1:1, 1:1:1);
	(ADD6 => D14) = (1:1:1, 1:1:1);
	(ADD6 => D15) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);
	(ADD6 => ED1) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => D8) = (1:1:1, 1:1:1);
	(ADD7 => D9) = (1:1:1, 1:1:1);
	(ADD7 => D10) = (1:1:1, 1:1:1);
	(ADD7 => D11) = (1:1:1, 1:1:1);
	(ADD7 => D12) = (1:1:1, 1:1:1);
	(ADD7 => D13) = (1:1:1, 1:1:1);
	(ADD7 => D14) = (1:1:1, 1:1:1);
	(ADD7 => D15) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);
	(ADD7 => ED1) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SAR (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, OE);


input  WEN, RWCLK, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


and I_01 (con0,  OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37;


parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier3);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier12);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier13);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier14);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier15);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier16);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier17);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier18);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier19);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier21);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier22);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier23);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier24);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier25);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier26);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier27);
	$setuphold  (posedge RWCLK &&& (WEN==0), D8, 1, 0, notifier28);
	$setuphold  (posedge RWCLK &&& (WEN==0), D9, 1, 0, notifier29);
	$setuphold  (posedge RWCLK &&& (WEN==0), D10, 1, 0, notifier30);
	$setuphold  (posedge RWCLK &&& (WEN==0), D11, 1, 0, notifier31);
	$setuphold  (posedge RWCLK &&& (WEN==0), D12, 1, 0, notifier32);
	$setuphold  (posedge RWCLK &&& (WEN==0), D13, 1, 0, notifier33);
	$setuphold  (posedge RWCLK &&& (WEN==0), D14, 1, 0, notifier34);
	$setuphold  (posedge RWCLK &&& (WEN==0), D15, 1, 0, notifier35);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier36);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier37);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => D8) = (1:1:1, 1:1:1);
	(ADD0 => D9) = (1:1:1, 1:1:1);
	(ADD0 => D10) = (1:1:1, 1:1:1);
	(ADD0 => D11) = (1:1:1, 1:1:1);
	(ADD0 => D12) = (1:1:1, 1:1:1);
	(ADD0 => D13) = (1:1:1, 1:1:1);
	(ADD0 => D14) = (1:1:1, 1:1:1);
	(ADD0 => D15) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);
	(ADD0 => ED1) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => D8) = (1:1:1, 1:1:1);
	(ADD1 => D9) = (1:1:1, 1:1:1);
	(ADD1 => D10) = (1:1:1, 1:1:1);
	(ADD1 => D11) = (1:1:1, 1:1:1);
	(ADD1 => D12) = (1:1:1, 1:1:1);
	(ADD1 => D13) = (1:1:1, 1:1:1);
	(ADD1 => D14) = (1:1:1, 1:1:1);
	(ADD1 => D15) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);
	(ADD1 => ED1) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => D8) = (1:1:1, 1:1:1);
	(ADD2 => D9) = (1:1:1, 1:1:1);
	(ADD2 => D10) = (1:1:1, 1:1:1);
	(ADD2 => D11) = (1:1:1, 1:1:1);
	(ADD2 => D12) = (1:1:1, 1:1:1);
	(ADD2 => D13) = (1:1:1, 1:1:1);
	(ADD2 => D14) = (1:1:1, 1:1:1);
	(ADD2 => D15) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);
	(ADD2 => ED1) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => D8) = (1:1:1, 1:1:1);
	(ADD3 => D9) = (1:1:1, 1:1:1);
	(ADD3 => D10) = (1:1:1, 1:1:1);
	(ADD3 => D11) = (1:1:1, 1:1:1);
	(ADD3 => D12) = (1:1:1, 1:1:1);
	(ADD3 => D13) = (1:1:1, 1:1:1);
	(ADD3 => D14) = (1:1:1, 1:1:1);
	(ADD3 => D15) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);
	(ADD3 => ED1) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => D8) = (1:1:1, 1:1:1);
	(ADD4 => D9) = (1:1:1, 1:1:1);
	(ADD4 => D10) = (1:1:1, 1:1:1);
	(ADD4 => D11) = (1:1:1, 1:1:1);
	(ADD4 => D12) = (1:1:1, 1:1:1);
	(ADD4 => D13) = (1:1:1, 1:1:1);
	(ADD4 => D14) = (1:1:1, 1:1:1);
	(ADD4 => D15) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);
	(ADD4 => ED1) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => D8) = (1:1:1, 1:1:1);
	(ADD5 => D9) = (1:1:1, 1:1:1);
	(ADD5 => D10) = (1:1:1, 1:1:1);
	(ADD5 => D11) = (1:1:1, 1:1:1);
	(ADD5 => D12) = (1:1:1, 1:1:1);
	(ADD5 => D13) = (1:1:1, 1:1:1);
	(ADD5 => D14) = (1:1:1, 1:1:1);
	(ADD5 => D15) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);
	(ADD5 => ED1) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => D8) = (1:1:1, 1:1:1);
	(ADD6 => D9) = (1:1:1, 1:1:1);
	(ADD6 => D10) = (1:1:1, 1:1:1);
	(ADD6 => D11) = (1:1:1, 1:1:1);
	(ADD6 => D12) = (1:1:1, 1:1:1);
	(ADD6 => D13) = (1:1:1, 1:1:1);
	(ADD6 => D14) = (1:1:1, 1:1:1);
	(ADD6 => D15) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);
	(ADD6 => ED1) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => D8) = (1:1:1, 1:1:1);
	(ADD7 => D9) = (1:1:1, 1:1:1);
	(ADD7 => D10) = (1:1:1, 1:1:1);
	(ADD7 => D11) = (1:1:1, 1:1:1);
	(ADD7 => D12) = (1:1:1, 1:1:1);
	(ADD7 => D13) = (1:1:1, 1:1:1);
	(ADD7 => D14) = (1:1:1, 1:1:1);
	(ADD7 => D15) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);
	(ADD7 => ED1) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SAR_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, OE);


input  WEN, RWCLK, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28;


parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end


always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 18'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier10);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier11);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier12);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D8, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), D9, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), D10, 1, 0, notifier21);
	$setuphold  (posedge RWCLK &&& (WEN==0), D11, 1, 0, notifier22);
	$setuphold  (posedge RWCLK &&& (WEN==0), D12, 1, 0, notifier23);
	$setuphold  (posedge RWCLK &&& (WEN==0), D13, 1, 0, notifier24);
	$setuphold  (posedge RWCLK &&& (WEN==0), D14, 1, 0, notifier25);
	$setuphold  (posedge RWCLK &&& (WEN==0), D15, 1, 0, notifier26);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier27);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier28);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => D8) = (1:1:1, 1:1:1);
	(ADD0 => D9) = (1:1:1, 1:1:1);
	(ADD0 => D10) = (1:1:1, 1:1:1);
	(ADD0 => D11) = (1:1:1, 1:1:1);
	(ADD0 => D12) = (1:1:1, 1:1:1);
	(ADD0 => D13) = (1:1:1, 1:1:1);
	(ADD0 => D14) = (1:1:1, 1:1:1);
	(ADD0 => D15) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);
	(ADD0 => ED1) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => D8) = (1:1:1, 1:1:1);
	(ADD1 => D9) = (1:1:1, 1:1:1);
	(ADD1 => D10) = (1:1:1, 1:1:1);
	(ADD1 => D11) = (1:1:1, 1:1:1);
	(ADD1 => D12) = (1:1:1, 1:1:1);
	(ADD1 => D13) = (1:1:1, 1:1:1);
	(ADD1 => D14) = (1:1:1, 1:1:1);
	(ADD1 => D15) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);
	(ADD1 => ED1) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => D8) = (1:1:1, 1:1:1);
	(ADD2 => D9) = (1:1:1, 1:1:1);
	(ADD2 => D10) = (1:1:1, 1:1:1);
	(ADD2 => D11) = (1:1:1, 1:1:1);
	(ADD2 => D12) = (1:1:1, 1:1:1);
	(ADD2 => D13) = (1:1:1, 1:1:1);
	(ADD2 => D14) = (1:1:1, 1:1:1);
	(ADD2 => D15) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);
	(ADD2 => ED1) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => D8) = (1:1:1, 1:1:1);
	(ADD3 => D9) = (1:1:1, 1:1:1);
	(ADD3 => D10) = (1:1:1, 1:1:1);
	(ADD3 => D11) = (1:1:1, 1:1:1);
	(ADD3 => D12) = (1:1:1, 1:1:1);
	(ADD3 => D13) = (1:1:1, 1:1:1);
	(ADD3 => D14) = (1:1:1, 1:1:1);
	(ADD3 => D15) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);
	(ADD3 => ED1) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => D8) = (1:1:1, 1:1:1);
	(ADD4 => D9) = (1:1:1, 1:1:1);
	(ADD4 => D10) = (1:1:1, 1:1:1);
	(ADD4 => D11) = (1:1:1, 1:1:1);
	(ADD4 => D12) = (1:1:1, 1:1:1);
	(ADD4 => D13) = (1:1:1, 1:1:1);
	(ADD4 => D14) = (1:1:1, 1:1:1);
	(ADD4 => D15) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);
	(ADD4 => ED1) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => D8) = (1:1:1, 1:1:1);
	(ADD5 => D9) = (1:1:1, 1:1:1);
	(ADD5 => D10) = (1:1:1, 1:1:1);
	(ADD5 => D11) = (1:1:1, 1:1:1);
	(ADD5 => D12) = (1:1:1, 1:1:1);
	(ADD5 => D13) = (1:1:1, 1:1:1);
	(ADD5 => D14) = (1:1:1, 1:1:1);
	(ADD5 => D15) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);
	(ADD5 => ED1) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => D8) = (1:1:1, 1:1:1);
	(ADD6 => D9) = (1:1:1, 1:1:1);
	(ADD6 => D10) = (1:1:1, 1:1:1);
	(ADD6 => D11) = (1:1:1, 1:1:1);
	(ADD6 => D12) = (1:1:1, 1:1:1);
	(ADD6 => D13) = (1:1:1, 1:1:1);
	(ADD6 => D14) = (1:1:1, 1:1:1);
	(ADD6 => D15) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);
	(ADD6 => ED1) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => D8) = (1:1:1, 1:1:1);
	(ADD7 => D9) = (1:1:1, 1:1:1);
	(ADD7 => D10) = (1:1:1, 1:1:1);
	(ADD7 => D11) = (1:1:1, 1:1:1);
	(ADD7 => D12) = (1:1:1, 1:1:1);
	(ADD7 => D13) = (1:1:1, 1:1:1);
	(ADD7 => D14) = (1:1:1, 1:1:1);
	(ADD7 => D15) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);
	(ADD7 => ED1) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SSF (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;

wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


and I_01 (con0,  OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK == 1'b0) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (negedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier11);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D8, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), D9, 1, 0, notifier21);
	$setuphold  (negedge RWCLK &&& (WEN==0), D10, 1, 0, notifier22);
	$setuphold  (negedge RWCLK &&& (WEN==0), D11, 1, 0, notifier23);
	$setuphold  (negedge RWCLK &&& (WEN==0), D12, 1, 0, notifier24);
	$setuphold  (negedge RWCLK &&& (WEN==0), D13, 1, 0, notifier25);
	$setuphold  (negedge RWCLK &&& (WEN==0), D14, 1, 0, notifier26);
	$setuphold  (negedge RWCLK &&& (WEN==0), D15, 1, 0, notifier27);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier28);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier29);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => D8) = (1:1:1, 1:1:1);
	(RWCLK => D9) = (1:1:1, 1:1:1);
	(RWCLK => D10) = (1:1:1, 1:1:1);
	(RWCLK => D11) = (1:1:1, 1:1:1);
	(RWCLK => D12) = (1:1:1, 1:1:1);
	(RWCLK => D13) = (1:1:1, 1:1:1);
	(RWCLK => D14) = (1:1:1, 1:1:1);
	(RWCLK => D15) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);
	(RWCLK => ED1) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SSF_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;

wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29;


parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK == 1'b0) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 18'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=255;i=i+1)
//		memA[i] = 18'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (negedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier11);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D8, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), D9, 1, 0, notifier21);
	$setuphold  (negedge RWCLK &&& (WEN==0), D10, 1, 0, notifier22);
	$setuphold  (negedge RWCLK &&& (WEN==0), D11, 1, 0, notifier23);
	$setuphold  (negedge RWCLK &&& (WEN==0), D12, 1, 0, notifier24);
	$setuphold  (negedge RWCLK &&& (WEN==0), D13, 1, 0, notifier25);
	$setuphold  (negedge RWCLK &&& (WEN==0), D14, 1, 0, notifier26);
	$setuphold  (negedge RWCLK &&& (WEN==0), D15, 1, 0, notifier27);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier28);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier29);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => D8) = (1:1:1, 1:1:1);
	(RWCLK => D9) = (1:1:1, 1:1:1);
	(RWCLK => D10) = (1:1:1, 1:1:1);
	(RWCLK => D11) = (1:1:1, 1:1:1);
	(RWCLK => D12) = (1:1:1, 1:1:1);
	(RWCLK => D13) = (1:1:1, 1:1:1);
	(RWCLK => D14) = (1:1:1, 1:1:1);
	(RWCLK => D15) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);
	(RWCLK => ED1) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB256X18SSR (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

and I_01 (con0,  OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge RD_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(posedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (posedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier11);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), D8, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), D9, 1, 0, notifier21);
	$setuphold  (posedge RWCLK &&& (WEN==0), D10, 1, 0, notifier22);
	$setuphold  (posedge RWCLK &&& (WEN==0), D11, 1, 0, notifier23);
	$setuphold  (posedge RWCLK &&& (WEN==0), D12, 1, 0, notifier24);
	$setuphold  (posedge RWCLK &&& (WEN==0), D13, 1, 0, notifier25);
	$setuphold  (posedge RWCLK &&& (WEN==0), D14, 1, 0, notifier26);
	$setuphold  (posedge RWCLK &&& (WEN==0), D15, 1, 0, notifier27);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier28);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier29);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => D8) = (1:1:1, 1:1:1);
	(RWCLK => D9) = (1:1:1, 1:1:1);
	(RWCLK => D10) = (1:1:1, 1:1:1);
	(RWCLK => D11) = (1:1:1, 1:1:1);
	(RWCLK => D12) = (1:1:1, 1:1:1);
	(RWCLK => D13) = (1:1:1, 1:1:1);
	(RWCLK => D14) = (1:1:1, 1:1:1);
	(RWCLK => D15) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);
	(RWCLK => ED1) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB256X18SSR_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7;
inout  D0, D1, D2, D3, D4, D5, D6, D7, D8, D9, D10, D11, D12, D13, D14, D15, ED0, ED1;


wire  [17:0] D;
wire  [7:0] ADD;

assign ADD[7:0] = {ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins01 (ED1,   D[17], con0);
bufif0 ins02 (D[17], ED1, con0);

bufif1 ins03 (ED0,   D[16], con0);
bufif0 ins04 (D[16], ED0, con0);

bufif1 ins05 (D15,   D[15], con0);
bufif0 ins06 (D[15], D15, con0);

bufif1 ins07 (D14,   D[14], con0);
bufif0 ins08 (D[14], D14, con0);

bufif1 ins09 (D13,   D[13], con0);
bufif0 ins010 (D[13], D13, con0);

bufif1 ins011 (D12,   D[12], con0);
bufif0 ins012 (D[12], D12, con0);

bufif1 ins013 (D11,   D[11], con0);
bufif0 ins014 (D[11], D11, con0);

bufif1 ins015 (D10,   D[10], con0);
bufif0 ins016 (D[10], D10, con0);

bufif1 ins017 (D9,   D[9], con0);
bufif0 ins018 (D[9], D9, con0);

bufif1 ins019 (D8,   D[8], con0);
bufif0 ins020 (D[8], D8, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [7:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [17:0] DIN_A;
reg   [17:0] ramout_w_A;
reg   [17:0] dataout_A;
reg   [17:0] memA [255:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29;

parameter  [255:0]init12  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init11  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init10  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0F  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0E  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0D  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0C  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0B  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init0A  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init09  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init08  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init07  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init06  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init05  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init04  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init03  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init02  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [255:0]init01  = 256'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 256; i = i+1)
   begin
        memA[i] = {init12[i],init11[i],init10[i],init0F[i],init0E[i],init0D[i],init0C[i],init0B[i],init0A[i],init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 18'bzzzz_zzzz_zzzz_zz;
   dataout_A  = 18'bzzzz_zzzz_zzzz_zz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 8'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 8'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 18'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge RD_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 18'bx;
     end
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 18'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=255;i=i+1)
		memA[i] = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(posedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 18'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 18'bzzzz_zzzz_zzzz_zz;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (posedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier11);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), D8, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), D9, 1, 0, notifier21);
	$setuphold  (posedge RWCLK &&& (WEN==0), D10, 1, 0, notifier22);
	$setuphold  (posedge RWCLK &&& (WEN==0), D11, 1, 0, notifier23);
	$setuphold  (posedge RWCLK &&& (WEN==0), D12, 1, 0, notifier24);
	$setuphold  (posedge RWCLK &&& (WEN==0), D13, 1, 0, notifier25);
	$setuphold  (posedge RWCLK &&& (WEN==0), D14, 1, 0, notifier26);
	$setuphold  (posedge RWCLK &&& (WEN==0), D15, 1, 0, notifier27);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier28);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED1, 1, 0, notifier29);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => D8) = (1:1:1, 1:1:1);
	(RWCLK => D9) = (1:1:1, 1:1:1);
	(RWCLK => D10) = (1:1:1, 1:1:1);
	(RWCLK => D11) = (1:1:1, 1:1:1);
	(RWCLK => D12) = (1:1:1, 1:1:1);
	(RWCLK => D13) = (1:1:1, 1:1:1);
	(RWCLK => D14) = (1:1:1, 1:1:1);
	(RWCLK => D15) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);
	(RWCLK => ED1) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => D8) = (1:1:1, 1:1:1);
	(OE => D9) = (1:1:1, 1:1:1);
	(OE => D10) = (1:1:1, 1:1:1);
	(OE => D11) = (1:1:1, 1:1:1);
	(OE => D12) = (1:1:1, 1:1:1);
	(OE => D13) = (1:1:1, 1:1:1);
	(OE => D14) = (1:1:1, 1:1:1);
	(OE => D15) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);
	(OE => ED1) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DAF (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};



and I_01 (con0,  OE0, WEN0);

bufif1 ins019 (EDA0,  DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A ;
reg   [8:0] WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;

reg AD_EQ;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  // 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
     begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADDA];
     end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end


//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  // 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check

specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA8, 1, 0, notifier13);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier14);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB8, 1, 0, notifier22);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier31);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier32);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier33);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier34);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier35);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier36);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier37);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier38);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier40);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);

	(ADDA8 => DA0) = (1:1:1, 1:1:1);
	(ADDA8 => DA1) = (1:1:1, 1:1:1);
	(ADDA8 => DA2) = (1:1:1, 1:1:1);
	(ADDA8 => DA3) = (1:1:1, 1:1:1);
	(ADDA8 => DA4) = (1:1:1, 1:1:1);
	(ADDA8 => DA5) = (1:1:1, 1:1:1);
	(ADDA8 => DA6) = (1:1:1, 1:1:1);
	(ADDA8 => DA7) = (1:1:1, 1:1:1);
	(ADDA8 => EDA0) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);

	(ADDB8 => DB0) = (1:1:1, 1:1:1);
	(ADDB8 => DB1) = (1:1:1, 1:1:1);
	(ADDB8 => DB2) = (1:1:1, 1:1:1);
	(ADDB8 => DB3) = (1:1:1, 1:1:1);
	(ADDB8 => DB4) = (1:1:1, 1:1:1);
	(ADDB8 => DB5) = (1:1:1, 1:1:1);
	(ADDB8 => DB6) = (1:1:1, 1:1:1);
	(ADDB8 => DB7) = (1:1:1, 1:1:1);
	(ADDB8 => EDB0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DAF_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins119 (EDB0,  DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A ;
reg   [8:0] WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;

reg AD_EQ;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  // 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
     begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADDA];
     end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end


//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  // 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA8, 1, 0, notifier13);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier14);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier15);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB8, 1, 0, notifier22);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier31);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier32);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier33);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier34);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier35);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier36);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier37);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier38);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier40);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);

	(ADDA8 => DA0) = (1:1:1, 1:1:1);
	(ADDA8 => DA1) = (1:1:1, 1:1:1);
	(ADDA8 => DA2) = (1:1:1, 1:1:1);
	(ADDA8 => DA3) = (1:1:1, 1:1:1);
	(ADDA8 => DA4) = (1:1:1, 1:1:1);
	(ADDA8 => DA5) = (1:1:1, 1:1:1);
	(ADDA8 => DA6) = (1:1:1, 1:1:1);
	(ADDA8 => DA7) = (1:1:1, 1:1:1);
	(ADDA8 => EDA0) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);

	(ADDB8 => DB0) = (1:1:1, 1:1:1);
	(ADDB8 => DB1) = (1:1:1, 1:1:1);
	(ADDB8 => DB2) = (1:1:1, 1:1:1);
	(ADDB8 => DB3) = (1:1:1, 1:1:1);
	(ADDB8 => DB4) = (1:1:1, 1:1:1);
	(ADDB8 => DB5) = (1:1:1, 1:1:1);
	(ADDB8 => DB6) = (1:1:1, 1:1:1);
	(ADDB8 => DB7) = (1:1:1, 1:1:1);
	(ADDB8 => EDB0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DAR (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;

wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


and I_01 (con0,  OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A ;
reg   [8:0] WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;

reg   AD_EQ;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK0 == 1'b1) && (WEN0!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
     begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADDA];
     end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end


always @(posedge WR_CLK_B)
begin
    if ((RWCLK1 == 1'b1) && (WEN1!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_B;
	memA[latched_add_B] = 9'bx;
     end
end
	
always @(posedge WR_CLK_B)
begin : write_B
   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
     begin
	// if WRBD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_B] = DIN_B;
end

 
always @(WEN1 or ADDB or memA[ADDA])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA8, 1, 0, notifier13);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier14);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB8, 1, 0, notifier22);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier31);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier32);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier33);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier34);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier35);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier36);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier37);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier38);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier40);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);

	(ADDA8 => DA0) = (1:1:1, 1:1:1);
	(ADDA8 => DA1) = (1:1:1, 1:1:1);
	(ADDA8 => DA2) = (1:1:1, 1:1:1);
	(ADDA8 => DA3) = (1:1:1, 1:1:1);
	(ADDA8 => DA4) = (1:1:1, 1:1:1);
	(ADDA8 => DA5) = (1:1:1, 1:1:1);
	(ADDA8 => DA6) = (1:1:1, 1:1:1);
	(ADDA8 => DA7) = (1:1:1, 1:1:1);
	(ADDA8 => EDA0) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);

	(ADDB8 => DB0) = (1:1:1, 1:1:1);
	(ADDB8 => DB1) = (1:1:1, 1:1:1);
	(ADDB8 => DB2) = (1:1:1, 1:1:1);
	(ADDB8 => DB3) = (1:1:1, 1:1:1);
	(ADDB8 => DB4) = (1:1:1, 1:1:1);
	(ADDB8 => DB5) = (1:1:1, 1:1:1);
	(ADDB8 => DB6) = (1:1:1, 1:1:1);
	(ADDB8 => DB7) = (1:1:1, 1:1:1);
	(ADDB8 => EDB0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DAR_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;

wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};

not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A ;
reg   [8:0] WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B ;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;

reg  AD_EQ;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end


always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
 if (WEN0 == 1'b0)
	WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK0 == 1'b1) && (WEN0!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN0 or ADDA or memA[ADDA])
begin : read_A
   if (WEN0 == 1'b1)
     begin
   	if (|(ADDA & ~ADDA) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADDA];
     end
end
 
always @(ADDA or ADDB)
begin
	if (ADDA == ADDB)
	  AD_EQ = 1;
	else
	  AD_EQ =0;
end

always @(ramout_w_A or OE0 or WEN0 or WEN1 or AD_EQ or ADDB or memA[ADDB])
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1 && WEN1 == 1'b0 && AD_EQ == 1)
        dataout_A =memA[ADDB];
  else if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
 if (WEN1 == 1'b0)
	WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end


always @(posedge WR_CLK_B)
begin
    if ((RWCLK1 == 1'b1) && (WEN1!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_B;
	memA[latched_add_B] = 9'bx;
     end
end
	
always @(posedge WR_CLK_B)
begin : write_B
   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
     begin
	// if WRBD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_B] = DIN_B;
end

 
always @(WEN1 or ADDB or memA[ADDB])
begin : read_B
   if (WEN1 == 1'b1)
      begin
   	if (|(ADDB & ~ADDB) === 1'bx)
     	begin
		// if WRBD is x send RD to x immediately
		ramout_w_B = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_B = memA[ADDB];
      end
end
 
always @(ramout_w_B or OE1 or WEN1 or WEN0 or AD_EQ or ADDA or memA[ADDA])
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1 && WEN0 == 1'b0 && AD_EQ == 1)
        dataout_B =memA[ADDA];
  else if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 18'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier6);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA8, 1, 0, notifier13);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier14);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier15);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB8, 1, 0, notifier22);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier23);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier24);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier31);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier32);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier33);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier34);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier35);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier36);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier37);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier38);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier40);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);

	(ADDA0 => DA0) = (1:1:1, 1:1:1);
	(ADDA0 => DA1) = (1:1:1, 1:1:1);
	(ADDA0 => DA2) = (1:1:1, 1:1:1);
	(ADDA0 => DA3) = (1:1:1, 1:1:1);
	(ADDA0 => DA4) = (1:1:1, 1:1:1);
	(ADDA0 => DA5) = (1:1:1, 1:1:1);
	(ADDA0 => DA6) = (1:1:1, 1:1:1);
	(ADDA0 => DA7) = (1:1:1, 1:1:1);
	(ADDA0 => EDA0) = (1:1:1, 1:1:1);

	(ADDA1 => DA0) = (1:1:1, 1:1:1);
	(ADDA1 => DA1) = (1:1:1, 1:1:1);
	(ADDA1 => DA2) = (1:1:1, 1:1:1);
	(ADDA1 => DA3) = (1:1:1, 1:1:1);
	(ADDA1 => DA4) = (1:1:1, 1:1:1);
	(ADDA1 => DA5) = (1:1:1, 1:1:1);
	(ADDA1 => DA6) = (1:1:1, 1:1:1);
	(ADDA1 => DA7) = (1:1:1, 1:1:1);
	(ADDA1 => EDA0) = (1:1:1, 1:1:1);

	(ADDA2 => DA0) = (1:1:1, 1:1:1);
	(ADDA2 => DA1) = (1:1:1, 1:1:1);
	(ADDA2 => DA2) = (1:1:1, 1:1:1);
	(ADDA2 => DA3) = (1:1:1, 1:1:1);
	(ADDA2 => DA4) = (1:1:1, 1:1:1);
	(ADDA2 => DA5) = (1:1:1, 1:1:1);
	(ADDA2 => DA6) = (1:1:1, 1:1:1);
	(ADDA2 => DA7) = (1:1:1, 1:1:1);
	(ADDA2 => EDA0) = (1:1:1, 1:1:1);

	(ADDA3 => DA0) = (1:1:1, 1:1:1);
	(ADDA3 => DA1) = (1:1:1, 1:1:1);
	(ADDA3 => DA2) = (1:1:1, 1:1:1);
	(ADDA3 => DA3) = (1:1:1, 1:1:1);
	(ADDA3 => DA4) = (1:1:1, 1:1:1);
	(ADDA3 => DA5) = (1:1:1, 1:1:1);
	(ADDA3 => DA6) = (1:1:1, 1:1:1);
	(ADDA3 => DA7) = (1:1:1, 1:1:1);
	(ADDA3 => EDA0) = (1:1:1, 1:1:1);

	(ADDA4 => DA0) = (1:1:1, 1:1:1);
	(ADDA4 => DA1) = (1:1:1, 1:1:1);
	(ADDA4 => DA2) = (1:1:1, 1:1:1);
	(ADDA4 => DA3) = (1:1:1, 1:1:1);
	(ADDA4 => DA4) = (1:1:1, 1:1:1);
	(ADDA4 => DA5) = (1:1:1, 1:1:1);
	(ADDA4 => DA6) = (1:1:1, 1:1:1);
	(ADDA4 => DA7) = (1:1:1, 1:1:1);
	(ADDA4 => EDA0) = (1:1:1, 1:1:1);

	(ADDA5 => DA0) = (1:1:1, 1:1:1);
	(ADDA5 => DA1) = (1:1:1, 1:1:1);
	(ADDA5 => DA2) = (1:1:1, 1:1:1);
	(ADDA5 => DA3) = (1:1:1, 1:1:1);
	(ADDA5 => DA4) = (1:1:1, 1:1:1);
	(ADDA5 => DA5) = (1:1:1, 1:1:1);
	(ADDA5 => DA6) = (1:1:1, 1:1:1);
	(ADDA5 => DA7) = (1:1:1, 1:1:1);
	(ADDA5 => EDA0) = (1:1:1, 1:1:1);

	(ADDA6 => DA0) = (1:1:1, 1:1:1);
	(ADDA6 => DA1) = (1:1:1, 1:1:1);
	(ADDA6 => DA2) = (1:1:1, 1:1:1);
	(ADDA6 => DA3) = (1:1:1, 1:1:1);
	(ADDA6 => DA4) = (1:1:1, 1:1:1);
	(ADDA6 => DA5) = (1:1:1, 1:1:1);
	(ADDA6 => DA6) = (1:1:1, 1:1:1);
	(ADDA6 => DA7) = (1:1:1, 1:1:1);
	(ADDA6 => EDA0) = (1:1:1, 1:1:1);

	(ADDA7 => DA0) = (1:1:1, 1:1:1);
	(ADDA7 => DA1) = (1:1:1, 1:1:1);
	(ADDA7 => DA2) = (1:1:1, 1:1:1);
	(ADDA7 => DA3) = (1:1:1, 1:1:1);
	(ADDA7 => DA4) = (1:1:1, 1:1:1);
	(ADDA7 => DA5) = (1:1:1, 1:1:1);
	(ADDA7 => DA6) = (1:1:1, 1:1:1);
	(ADDA7 => DA7) = (1:1:1, 1:1:1);
	(ADDA7 => EDA0) = (1:1:1, 1:1:1);

	(ADDA8 => DA0) = (1:1:1, 1:1:1);
	(ADDA8 => DA1) = (1:1:1, 1:1:1);
	(ADDA8 => DA2) = (1:1:1, 1:1:1);
	(ADDA8 => DA3) = (1:1:1, 1:1:1);
	(ADDA8 => DA4) = (1:1:1, 1:1:1);
	(ADDA8 => DA5) = (1:1:1, 1:1:1);
	(ADDA8 => DA6) = (1:1:1, 1:1:1);
	(ADDA8 => DA7) = (1:1:1, 1:1:1);
	(ADDA8 => EDA0) = (1:1:1, 1:1:1);

	(ADDB0 => DB0) = (1:1:1, 1:1:1);
	(ADDB0 => DB1) = (1:1:1, 1:1:1);
	(ADDB0 => DB2) = (1:1:1, 1:1:1);
	(ADDB0 => DB3) = (1:1:1, 1:1:1);
	(ADDB0 => DB4) = (1:1:1, 1:1:1);
	(ADDB0 => DB5) = (1:1:1, 1:1:1);
	(ADDB0 => DB6) = (1:1:1, 1:1:1);
	(ADDB0 => DB7) = (1:1:1, 1:1:1);
	(ADDB0 => EDB0) = (1:1:1, 1:1:1);

	(ADDB1 => DB0) = (1:1:1, 1:1:1);
	(ADDB1 => DB1) = (1:1:1, 1:1:1);
	(ADDB1 => DB2) = (1:1:1, 1:1:1);
	(ADDB1 => DB3) = (1:1:1, 1:1:1);
	(ADDB1 => DB4) = (1:1:1, 1:1:1);
	(ADDB1 => DB5) = (1:1:1, 1:1:1);
	(ADDB1 => DB6) = (1:1:1, 1:1:1);
	(ADDB1 => DB7) = (1:1:1, 1:1:1);
	(ADDB1 => EDB0) = (1:1:1, 1:1:1);

	(ADDB2 => DB0) = (1:1:1, 1:1:1);
	(ADDB2 => DB1) = (1:1:1, 1:1:1);
	(ADDB2 => DB2) = (1:1:1, 1:1:1);
	(ADDB2 => DB3) = (1:1:1, 1:1:1);
	(ADDB2 => DB4) = (1:1:1, 1:1:1);
	(ADDB2 => DB5) = (1:1:1, 1:1:1);
	(ADDB2 => DB6) = (1:1:1, 1:1:1);
	(ADDB2 => DB7) = (1:1:1, 1:1:1);
	(ADDB2 => EDB0) = (1:1:1, 1:1:1);

	(ADDB3 => DB0) = (1:1:1, 1:1:1);
	(ADDB3 => DB1) = (1:1:1, 1:1:1);
	(ADDB3 => DB2) = (1:1:1, 1:1:1);
	(ADDB3 => DB3) = (1:1:1, 1:1:1);
	(ADDB3 => DB4) = (1:1:1, 1:1:1);
	(ADDB3 => DB5) = (1:1:1, 1:1:1);
	(ADDB3 => DB6) = (1:1:1, 1:1:1);
	(ADDB3 => DB7) = (1:1:1, 1:1:1);
	(ADDB3 => EDB0) = (1:1:1, 1:1:1);

	(ADDB4 => DB0) = (1:1:1, 1:1:1);
	(ADDB4 => DB1) = (1:1:1, 1:1:1);
	(ADDB4 => DB2) = (1:1:1, 1:1:1);
	(ADDB4 => DB3) = (1:1:1, 1:1:1);
	(ADDB4 => DB4) = (1:1:1, 1:1:1);
	(ADDB4 => DB5) = (1:1:1, 1:1:1);
	(ADDB4 => DB6) = (1:1:1, 1:1:1);
	(ADDB4 => DB7) = (1:1:1, 1:1:1);
	(ADDB4 => EDB0) = (1:1:1, 1:1:1);

	(ADDB5 => DB0) = (1:1:1, 1:1:1);
	(ADDB5 => DB1) = (1:1:1, 1:1:1);
	(ADDB5 => DB2) = (1:1:1, 1:1:1);
	(ADDB5 => DB3) = (1:1:1, 1:1:1);
	(ADDB5 => DB4) = (1:1:1, 1:1:1);
	(ADDB5 => DB5) = (1:1:1, 1:1:1);
	(ADDB5 => DB6) = (1:1:1, 1:1:1);
	(ADDB5 => DB7) = (1:1:1, 1:1:1);
	(ADDB5 => EDB0) = (1:1:1, 1:1:1);

	(ADDB6 => DB0) = (1:1:1, 1:1:1);
	(ADDB6 => DB1) = (1:1:1, 1:1:1);
	(ADDB6 => DB2) = (1:1:1, 1:1:1);
	(ADDB6 => DB3) = (1:1:1, 1:1:1);
	(ADDB6 => DB4) = (1:1:1, 1:1:1);
	(ADDB6 => DB5) = (1:1:1, 1:1:1);
	(ADDB6 => DB6) = (1:1:1, 1:1:1);
	(ADDB6 => DB7) = (1:1:1, 1:1:1);
	(ADDB6 => EDB0) = (1:1:1, 1:1:1);

	(ADDB7 => DB0) = (1:1:1, 1:1:1);
	(ADDB7 => DB1) = (1:1:1, 1:1:1);
	(ADDB7 => DB2) = (1:1:1, 1:1:1);
	(ADDB7 => DB3) = (1:1:1, 1:1:1);
	(ADDB7 => DB4) = (1:1:1, 1:1:1);
	(ADDB7 => DB5) = (1:1:1, 1:1:1);
	(ADDB7 => DB6) = (1:1:1, 1:1:1);
	(ADDB7 => DB7) = (1:1:1, 1:1:1);
	(ADDB7 => EDB0) = (1:1:1, 1:1:1);

	(ADDB8 => DB0) = (1:1:1, 1:1:1);
	(ADDB8 => DB1) = (1:1:1, 1:1:1);
	(ADDB8 => DB2) = (1:1:1, 1:1:1);
	(ADDB8 => DB3) = (1:1:1, 1:1:1);
	(ADDB8 => DB4) = (1:1:1, 1:1:1);
	(ADDB8 => DB5) = (1:1:1, 1:1:1);
	(ADDB8 => DB6) = (1:1:1, 1:1:1);
	(ADDB8 => DB7) = (1:1:1, 1:1:1);
	(ADDB8 => EDB0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DSF (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


and I_01 (con0,  OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [8:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK0 == 1'b0) && (WEN0!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  // 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADDA & ~ADDA) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 9'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b1;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

always @(negedge RD_CLK_B)
begin
    if ((RWCLK1 == 1'b0) && (WEN1!= 1'b1))
     begin
	disable read_B;
	ramout_w_B = 9'bx;
     end
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)   // 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(negedge RD_CLK_B)
begin : read_B
   if (|(ADDB & ~ADDB) === 1'bx)
     begin
	// if WRBD is x send RD to x immediately
	ramout_w_B = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_B = memA[RD_ADD_B];
end
 
always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 9'bx;
    end
end

//////End data conflict check

specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier14);
	$setuphold  (negedge RWCLK0, ADDA8, 1, 0, notifier15);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier22);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier23);
	$setuphold  (negedge RWCLK1, ADDB8, 1, 0, notifier24);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier33);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier34);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier35);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier36);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier37);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier38);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier40);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier42);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9DSF_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [8:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin
   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b1;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK0 == 1'b0) && (WEN0!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK0 == 1'b0) && (WEN0!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)  // 10/01/02
begin : write_A
  if (WEN0 == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADDA & ~ADDA) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;

//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 9'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b1;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(negedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b0)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b1;
end

always @(negedge RD_CLK_B)
begin
    if ((RWCLK1 == 1'b0) && (WEN1!= 1'b1))
     begin
	disable read_B;
	ramout_w_B = 9'bx;
     end
end

//always @(negedge WR_CLK_B)
//begin
//    if ((RWCLK1 == 1'b0) && (WEN1!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_B;
//	memA[latched_add_B] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_B)
//begin : write_B
//   if (|(WR_ADD_B & ~WR_ADD_B) === 1'bx)
//     begin
//	// if WRBD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_B] = DIN_B;
//end

always @(negedge WR_CLK_B)  // 10/01/02
begin : write_B
  if (WEN1 == 1'b0)
     memA[WR_ADD_B] = DIN_B;
end
 
always @(negedge RD_CLK_B)
begin : read_B
   if (|(ADDB & ~ADDB) === 1'bx)
     begin
	// if WRBD is x send RD to x immediately
	ramout_w_B = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_B = memA[RD_ADD_B];
end
 
always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1)
	dataout_B = ramout_w_B;
   else
	dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(negedge WR_CLK_A)
        clk_a_time = $realtime;

always @(negedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 9'bx;
    end
end

//////End data conflict check

specify

	$width (negedge RWCLK0, 1, 0, notifier1);
	$width (negedge RWCLK1, 1, 0, notifier2);

	$setuphold  (negedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (negedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (negedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (negedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (negedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (negedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (negedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (negedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (negedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (negedge RWCLK0, ADDA7, 1, 0, notifier14);
	$setuphold  (negedge RWCLK0, ADDA8, 1, 0, notifier15);

	$setuphold  (negedge RWCLK1, ADDB0, 1, 0, notifier16);
	$setuphold  (negedge RWCLK1, ADDB1, 1, 0, notifier17);
	$setuphold  (negedge RWCLK1, ADDB2, 1, 0, notifier18);
	$setuphold  (negedge RWCLK1, ADDB3, 1, 0, notifier19);
	$setuphold  (negedge RWCLK1, ADDB4, 1, 0, notifier20);
	$setuphold  (negedge RWCLK1, ADDB5, 1, 0, notifier21);
	$setuphold  (negedge RWCLK1, ADDB6, 1, 0, notifier22);
	$setuphold  (negedge RWCLK1, ADDB7, 1, 0, notifier23);
	$setuphold  (negedge RWCLK1, ADDB8, 1, 0, notifier24);

	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier25);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier26);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier27);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier28);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier29);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier30);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier31);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier32);
	$setuphold  (negedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier33);

	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier34);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier35);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier36);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier37);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier38);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier39);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier40);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier41);
	$setuphold  (negedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier42);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

//********************************************************************
`celldefine
module RAMB512X9DSR (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


and I_01 (con0,  OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [8:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] <= {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

//ct101505
always @(posedge RWCLK0)
begin: write_A
   if (WEN0 == 1'b0)
      if (|(ADDA & ~ ADDA) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=511;i=i+1)
            memA[i] <= 9'bx;
      else
         memA[ADDA] <= DA;
end

always @(posedge RWCLK0)
begin
   if ( WEN0 == 1'b1 && CE0 == 1'b0)
   begin
      if (|(ADDA & ~ADDA) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_A <= 9'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_A <= memA[RD_ADD_A];
   end
end

always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b1 && WEN0 == 1'b1)
        dataout_A = ramout_w_A;
   else
        dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;
//----------------------------------------
//// duplication for 2nd part
//----------------------------------------
always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 9'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b0;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end

//ct101505
always @(posedge RWCLK1)
begin: write_B
   if (WEN1 == 1'b0)
      if (|(ADDB & ~ ADDB) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=511;i=i+1)
            memA[i] <= 9'bx;
      else
         memA[ADDB] <= DB;
end

always @(posedge RWCLK1)
begin
   if ( WEN1 == 1'b1 && CE1 == 1'b0)
   begin
      if (|(ADDB & ~ADDB) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_B <= 9'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_B <= memA[RD_ADD_B];
   end
end

always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b1 && WEN1 == 1'b1)
        dataout_B = ramout_w_B;
   else
        dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;


//------------------------------------------
/////Data conflict check
//-------------------------------------------
realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 9'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier14);
	$setuphold  (posedge RWCLK0, ADDA8, 1, 0, notifier15);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier22);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier23);
	$setuphold  (posedge RWCLK1, ADDB8, 1, 0, notifier24);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier33);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier34);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier35);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier36);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier37);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier38);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier40);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier42);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);


endspecify

endmodule
`endcelldefine

//***************************************************************
`celldefine
module RAMB512X9DSR_1 (ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8, ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8, DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0, DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0, WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1);


input  WEN0, WEN1, RWCLK0, RWCLK1, CE0, CE1, OE0, OE1;
input  ADDA0, ADDA1, ADDA2, ADDA3, ADDA4, ADDA5, ADDA6, ADDA7, ADDA8;
input  ADDB0, ADDB1, ADDB2, ADDB3, ADDB4, ADDB5, ADDB6, ADDB7, ADDB8;
inout  DA0, DA1, DA2, DA3, DA4, DA5, DA6, DA7, EDA0;
inout  DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7, EDB0;


wire  [8:0] DA, DB;
wire  [8:0] ADDA, ADDB;

assign ADDA[8:0] = {ADDA8, ADDA7, ADDA6, ADDA5, ADDA4, ADDA3, ADDA2, ADDA1, ADDA0};
assign ADDB[8:0] = {ADDB8, ADDB7,ADDB6, ADDB5, ADDB4, ADDB3, ADDB2, ADDB1, ADDB0};


not inv_00 (b_OE0, OE0);
not inv_01 (b_OE1, OE1);

and I_01 (con0,  b_OE0, WEN0);

bufif1 ins019 (EDA0,   DA[8], con0);
bufif0 ins020 (DA[8], EDA0, con0);

bufif1 ins021 (DA7,   DA[7], con0);
bufif0 ins022 (DA[7], DA7, con0);

bufif1 ins023 (DA6,   DA[6], con0);
bufif0 ins024 (DA[6], DA6, con0);

bufif1 ins025 (DA5,   DA[5], con0);
bufif0 ins026 (DA[5], DA5, con0);

bufif1 ins027 (DA4,   DA[4], con0);
bufif0 ins028 (DA[4], DA4, con0);

bufif1 ins029 (DA3,   DA[3], con0);
bufif0 ins030 (DA[3], DA3, con0);

bufif1 ins031 (DA2,   DA[2], con0);
bufif0 ins032 (DA[2], DA2, con0);

bufif1 ins033 (DA1,   DA[1], con0);
bufif0 ins034 (DA[1], DA1, con0);

bufif1 ins035 (DA0,   DA[0], con0);
bufif0 ins036 (DA[0], DA0, con0);

and I_11 (con1,  b_OE1, WEN1);

bufif1 ins119 (EDB0,   DB[8], con1);
bufif0 ins120 (DB[8], EDB0, con1);

bufif1 ins121 (DB7,   DB[7], con1);
bufif0 ins122 (DB[7], DB7, con1);

bufif1 ins123 (DB6,   DB[6], con1);
bufif0 ins124 (DB[6], DB6, con1);

bufif1 ins125 (DB5,   DB[5], con1);
bufif0 ins126 (DB[5], DB5, con1);

bufif1 ins127 (DB4,   DB[4], con1);
bufif0 ins128 (DB[4], DB4, con1);

bufif1 ins129 (DB3,   DB[3], con1);
bufif0 ins130 (DB[3], DB3, con1);

bufif1 ins131 (DB2,   DB[2], con1);
bufif0 ins132 (DB[2], DB2, con1);

bufif1 ins133 (DB1,   DB[1], con1);
bufif0 ins134 (DB[1], DB1, con1);

bufif1 ins135 (DB0,   DB[0], con1);
bufif0 ins136 (DB[0], DB0, con1);


reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
reg   [8:0]  RD_ADD_B, WR_ADD_B, latched_add_B;
reg   [8:0] DIN_B;
reg   [8:0] ramout_w_B;
reg   [8:0] dataout_B;
reg          WR_CLK_B, RD_CLK_B;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21,notifier22,notifier23,notifier24,notifier25,notifier26,notifier27,notifier28,notifier29,notifier30;
reg          notifier31,notifier32,notifier33,notifier34,notifier35,notifier36,notifier37,notifier38,notifier39,notifier40;
reg          notifier41,notifier42;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;


initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] <= {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;
   notifier22 = 1'b0;
   notifier23 = 1'b0;
   notifier24 = 1'b0;
   notifier25 = 1'b0;
   notifier26 = 1'b0;
   notifier27 = 1'b0;
   notifier28 = 1'b0;
   notifier29 = 1'b0;
   notifier30 = 1'b0;
   notifier31 = 1'b0;
   notifier32 = 1'b0;
   notifier33 = 1'b0;
   notifier34 = 1'b0;
   notifier35 = 1'b0;
   notifier36 = 1'b0;
   notifier37 = 1'b0;
   notifier38 = 1'b0;
   notifier39 = 1'b0;
   notifier40 = 1'b0;
   notifier41 = 1'b0;
   notifier42 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
   WR_CLK_B   = 1'b0;
   RD_CLK_B   = 1'b0;
   ramout_w_B = 9'bzzzzz_zzzz;
   dataout_B  = 9'bzzzzz_zzzz;
end

always @(WEN0  or ADDA)
begin
 if ( WEN0 == 1'b1)
	RD_ADD_A = ADDA;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK0)
begin
 if (  WEN0 == 1'b1 && CE0 == 1'b0)
	RD_CLK_A = RWCLK0;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN0 or ADDA)
begin
 if (WEN0 == 1'b0)
	WR_ADD_A = ADDA;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN0 or DA)
begin
 if (WEN0 == 1'b0)
	DIN_A = DA;
 else
	DIN_A = 9'bx;
end

always @(RWCLK0)
begin
// if (WEN0 == 1'b0 && CE0 == 1'b0)
 if (WEN0 == 1'b0)
	#1 WR_CLK_A = RWCLK0;
 else
	WR_CLK_A = 1'b0;
end

//ct101505
always @(posedge RWCLK0)
begin: write_A
   if (WEN0 == 1'b0)
      if (|(ADDA & ~ ADDA) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=511;i=i+1)
            memA[i] <= 9'bx;
      else
         memA[ADDA] <= DA;
end

always @(posedge RWCLK0)
begin
   if ( WEN0 == 1'b1 && CE0 == 1'b0)
   begin
      if (|(ADDA & ~ADDA) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_A <= 9'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_A <= memA[RD_ADD_A];
   end
end

always @(ramout_w_A or OE0 or WEN0)
begin
  if (OE0 == 1'b0 && WEN0 == 1'b1)
        dataout_A = ramout_w_A;
   else
        dataout_A = 9'bzzzz_zzzz_z;
end

assign DA = dataout_A;
//// duplication for 2nd part

always @(WEN1  or ADDB)
begin
 if ( WEN1 == 1'b1)
	RD_ADD_B = ADDB;
 else
	RD_ADD_B = 9'bx;
end
 
always @(RWCLK1)
begin
 if (  WEN1 == 1'b1 && CE1 == 1'b0)
	RD_CLK_B = RWCLK1;
 else
	RD_CLK_B = 1'b0;
end

always @(WEN1 or ADDB)
begin
 if (WEN1 == 1'b0)
	WR_ADD_B = ADDB;
 else
	WR_ADD_B = 9'bx;
end

always @(posedge WR_CLK_B)
begin
  if (WR_CLK_B == 1'b1)
	latched_add_B = WR_ADD_B;
end

always @(WEN1 or DB)
begin
 if (WEN1 == 1'b0)
	DIN_B = DB;
 else
	DIN_B = 9'bx;
end

always @(RWCLK1)
begin
// if (WEN1 == 1'b0 && CE1 == 1'b0)
 if (WEN1 == 1'b0)
	#1 WR_CLK_B = RWCLK1;
 else
	WR_CLK_B = 1'b0;
end


//ct101505
always @(posedge RWCLK1)
begin: write_B
   if (WEN1 == 1'b0)
      if (|(ADDB & ~ ADDB) === 1'bx)
         // write x into all the memory locations
         for(i=0; i<=511;i=i+1)
            memA[i] <= 9'bx;
      else
         memA[ADDB] <= DB;
end

always @(posedge RWCLK1)
begin
   if ( WEN1 == 1'b1 && CE1 == 1'b0)
   begin
      if (|(ADDB & ~ADDB) === 1'bx)
      begin
        // if WRAD is x send RD to x immediately
        ramout_w_B <= 9'bx;
        //$display("(error) illegal address input at the rising edge of WRCLK so WRDATA goes x: @ %.3f ",$realtime);
      end
      else
         ramout_w_B <= memA[RD_ADD_B];
   end
end

always @(ramout_w_B or OE1 or WEN1)
begin
  if (OE1 == 1'b0 && WEN1 == 1'b1)
        dataout_B = ramout_w_B;
   else
        dataout_B = 9'bzzzz_zzzz_z;
end

assign DB = dataout_B;

/////Data conflict check

realtime clk_a_time, clk_b_time;

always @(posedge WR_CLK_A)
        clk_a_time = $realtime;

always @(posedge WR_CLK_B)
        clk_b_time = $realtime;

always @ ( clk_a_time or clk_b_time)
begin
    if (((clk_b_time - clk_a_time) == 0) && (WR_ADD_B == WR_ADD_A) && (DIN_B != DIN_A))
    begin
        disable write_B;
        disable write_A;
        //$display("(error) RWCLK0 and RWCLK1 are writing at same time, same address %b but different data, writing X  at time %.3f", WR_ADD_B, $realtime);
        memA[WR_ADD_B] = 9'bx;
    end
end

//////End data conflict check
specify

	$width (posedge RWCLK0, 1, 0, notifier1);
	$width (posedge RWCLK1, 1, 0, notifier2);

	$setuphold  (posedge RWCLK0, WEN0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK1, WEN1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK0, CE0, 1, 0, notifier5);
	$setuphold  (posedge RWCLK1, CE1, 1, 0, notifier6);

	$setuphold  (posedge RWCLK0, ADDA0, 1, 0, notifier7);
	$setuphold  (posedge RWCLK0, ADDA1, 1, 0, notifier8);
	$setuphold  (posedge RWCLK0, ADDA2, 1, 0, notifier9);
	$setuphold  (posedge RWCLK0, ADDA3, 1, 0, notifier10);
	$setuphold  (posedge RWCLK0, ADDA4, 1, 0, notifier11);
	$setuphold  (posedge RWCLK0, ADDA5, 1, 0, notifier12);
	$setuphold  (posedge RWCLK0, ADDA6, 1, 0, notifier13);
	$setuphold  (posedge RWCLK0, ADDA7, 1, 0, notifier14);
	$setuphold  (posedge RWCLK0, ADDA8, 1, 0, notifier15);

	$setuphold  (posedge RWCLK1, ADDB0, 1, 0, notifier16);
	$setuphold  (posedge RWCLK1, ADDB1, 1, 0, notifier17);
	$setuphold  (posedge RWCLK1, ADDB2, 1, 0, notifier18);
	$setuphold  (posedge RWCLK1, ADDB3, 1, 0, notifier19);
	$setuphold  (posedge RWCLK1, ADDB4, 1, 0, notifier20);
	$setuphold  (posedge RWCLK1, ADDB5, 1, 0, notifier21);
	$setuphold  (posedge RWCLK1, ADDB6, 1, 0, notifier22);
	$setuphold  (posedge RWCLK1, ADDB7, 1, 0, notifier23);
	$setuphold  (posedge RWCLK1, ADDB8, 1, 0, notifier24);

	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA0, 1, 0, notifier25);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA1, 1, 0, notifier26);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA2, 1, 0, notifier27);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA3, 1, 0, notifier28);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA4, 1, 0, notifier29);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA5, 1, 0, notifier30);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA6, 1, 0, notifier31);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), DA7, 1, 0, notifier32);
	$setuphold  (posedge RWCLK0 &&& (WEN0==0), EDA0, 1, 0, notifier33);

	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB0, 1, 0, notifier34);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB1, 1, 0, notifier35);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB2, 1, 0, notifier36);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB3, 1, 0, notifier37);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB4, 1, 0, notifier38);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB5, 1, 0, notifier39);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB6, 1, 0, notifier40);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), DB7, 1, 0, notifier41);
	$setuphold  (posedge RWCLK1 &&& (WEN1==0), EDB0, 1, 0, notifier42);

	(RWCLK0 => DA0) = (1:1:1, 1:1:1);
	(RWCLK0 => DA1) = (1:1:1, 1:1:1);
	(RWCLK0 => DA2) = (1:1:1, 1:1:1);
	(RWCLK0 => DA3) = (1:1:1, 1:1:1);
	(RWCLK0 => DA4) = (1:1:1, 1:1:1);
	(RWCLK0 => DA5) = (1:1:1, 1:1:1);
	(RWCLK0 => DA6) = (1:1:1, 1:1:1);
	(RWCLK0 => DA7) = (1:1:1, 1:1:1);
	(RWCLK0 => EDA0) = (1:1:1, 1:1:1);

	(RWCLK1 => DB0) = (1:1:1, 1:1:1);
	(RWCLK1 => DB1) = (1:1:1, 1:1:1);
	(RWCLK1 => DB2) = (1:1:1, 1:1:1);
	(RWCLK1 => DB3) = (1:1:1, 1:1:1);
	(RWCLK1 => DB4) = (1:1:1, 1:1:1);
	(RWCLK1 => DB5) = (1:1:1, 1:1:1);
	(RWCLK1 => DB6) = (1:1:1, 1:1:1);
	(RWCLK1 => DB7) = (1:1:1, 1:1:1);
	(RWCLK1 => EDB0) = (1:1:1, 1:1:1);

	(OE0 => DA0) = (1:1:1, 1:1:1);
	(OE0 => DA1) = (1:1:1, 1:1:1);
	(OE0 => DA2) = (1:1:1, 1:1:1);
	(OE0 => DA3) = (1:1:1, 1:1:1);
	(OE0 => DA4) = (1:1:1, 1:1:1);
	(OE0 => DA5) = (1:1:1, 1:1:1);
	(OE0 => DA6) = (1:1:1, 1:1:1);
	(OE0 => DA7) = (1:1:1, 1:1:1);
	(OE0 => EDA0) = (1:1:1, 1:1:1);

	(OE1 => DB0) = (1:1:1, 1:1:1);
	(OE1 => DB1) = (1:1:1, 1:1:1);
	(OE1 => DB2) = (1:1:1, 1:1:1);
	(OE1 => DB3) = (1:1:1, 1:1:1);
	(OE1 => DB4) = (1:1:1, 1:1:1);
	(OE1 => DB5) = (1:1:1, 1:1:1);
	(OE1 => DB6) = (1:1:1, 1:1:1);
	(OE1 => DB7) = (1:1:1, 1:1:1);
	(OE1 => EDB0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine
//***********************************************************
`celldefine
module RAMB512X9SAF (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, OE);


input  WEN, RWCLK,  OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;


wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


and I_01 (con0,  OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD8, 1, 0, notifier11);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier20);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);

	(ADD8 => D0) = (1:1:1, 1:1:1);
	(ADD8 => D1) = (1:1:1, 1:1:1);
	(ADD8 => D2) = (1:1:1, 1:1:1);
	(ADD8 => D3) = (1:1:1, 1:1:1);
	(ADD8 => D4) = (1:1:1, 1:1:1);
	(ADD8 => D5) = (1:1:1, 1:1:1);
	(ADD8 => D6) = (1:1:1, 1:1:1);
	(ADD8 => D7) = (1:1:1, 1:1:1);
	(ADD8 => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SAF_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, OE);


input  WEN, RWCLK,  OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;


wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);


reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b1;
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the falling edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD8, 1, 0, notifier11);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier20);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);

	(ADD8 => D0) = (1:1:1, 1:1:1);
	(ADD8 => D1) = (1:1:1, 1:1:1);
	(ADD8 => D2) = (1:1:1, 1:1:1);
	(ADD8 => D3) = (1:1:1, 1:1:1);
	(ADD8 => D4) = (1:1:1, 1:1:1);
	(ADD8 => D5) = (1:1:1, 1:1:1);
	(ADD8 => D6) = (1:1:1, 1:1:1);
	(ADD8 => D7) = (1:1:1, 1:1:1);
	(ADD8 => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SAR (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, OE);


input  WEN, RWCLK,  OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};



and I_01 (con0,  OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);



reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD8, 1, 0, notifier11);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier20);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);

	(ADD8 => D0) = (1:1:1, 1:1:1);
	(ADD8 => D1) = (1:1:1, 1:1:1);
	(ADD8 => D2) = (1:1:1, 1:1:1);
	(ADD8 => D3) = (1:1:1, 1:1:1);
	(ADD8 => D4) = (1:1:1, 1:1:1);
	(ADD8 => D5) = (1:1:1, 1:1:1);
	(ADD8 => D6) = (1:1:1, 1:1:1);
	(ADD8 => D7) = (1:1:1, 1:1:1);
	(ADD8 => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SAR_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, OE);


input  WEN, RWCLK,  OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);



reg   [8:0] WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;

   WR_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(WEN or ADD)
begin : read_A
   if (WEN == 1'b1)
     begin
   	if (|(ADD & ~ADD) === 1'bx)
     	begin
		// if WRAD is x send RD to x immediately
		ramout_w_A = 9'bx;
		//$display("(error) illegal address input at the rising edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     	end
   	else
		ramout_w_A = memA[ADD];
     end
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier3);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD8, 1, 0, notifier11);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier12);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier20);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

	(ADD0 => D0) = (1:1:1, 1:1:1);
	(ADD0 => D1) = (1:1:1, 1:1:1);
	(ADD0 => D2) = (1:1:1, 1:1:1);
	(ADD0 => D3) = (1:1:1, 1:1:1);
	(ADD0 => D4) = (1:1:1, 1:1:1);
	(ADD0 => D5) = (1:1:1, 1:1:1);
	(ADD0 => D6) = (1:1:1, 1:1:1);
	(ADD0 => D7) = (1:1:1, 1:1:1);
	(ADD0 => ED0) = (1:1:1, 1:1:1);

	(ADD1 => D0) = (1:1:1, 1:1:1);
	(ADD1 => D1) = (1:1:1, 1:1:1);
	(ADD1 => D2) = (1:1:1, 1:1:1);
	(ADD1 => D3) = (1:1:1, 1:1:1);
	(ADD1 => D4) = (1:1:1, 1:1:1);
	(ADD1 => D5) = (1:1:1, 1:1:1);
	(ADD1 => D6) = (1:1:1, 1:1:1);
	(ADD1 => D7) = (1:1:1, 1:1:1);
	(ADD1 => ED0) = (1:1:1, 1:1:1);

	(ADD2 => D0) = (1:1:1, 1:1:1);
	(ADD2 => D1) = (1:1:1, 1:1:1);
	(ADD2 => D2) = (1:1:1, 1:1:1);
	(ADD2 => D3) = (1:1:1, 1:1:1);
	(ADD2 => D4) = (1:1:1, 1:1:1);
	(ADD2 => D5) = (1:1:1, 1:1:1);
	(ADD2 => D6) = (1:1:1, 1:1:1);
	(ADD2 => D7) = (1:1:1, 1:1:1);
	(ADD2 => ED0) = (1:1:1, 1:1:1);

	(ADD3 => D0) = (1:1:1, 1:1:1);
	(ADD3 => D1) = (1:1:1, 1:1:1);
	(ADD3 => D2) = (1:1:1, 1:1:1);
	(ADD3 => D3) = (1:1:1, 1:1:1);
	(ADD3 => D4) = (1:1:1, 1:1:1);
	(ADD3 => D5) = (1:1:1, 1:1:1);
	(ADD3 => D6) = (1:1:1, 1:1:1);
	(ADD3 => D7) = (1:1:1, 1:1:1);
	(ADD3 => ED0) = (1:1:1, 1:1:1);

	(ADD4 => D0) = (1:1:1, 1:1:1);
	(ADD4 => D1) = (1:1:1, 1:1:1);
	(ADD4 => D2) = (1:1:1, 1:1:1);
	(ADD4 => D3) = (1:1:1, 1:1:1);
	(ADD4 => D4) = (1:1:1, 1:1:1);
	(ADD4 => D5) = (1:1:1, 1:1:1);
	(ADD4 => D6) = (1:1:1, 1:1:1);
	(ADD4 => D7) = (1:1:1, 1:1:1);
	(ADD4 => ED0) = (1:1:1, 1:1:1);

	(ADD5 => D0) = (1:1:1, 1:1:1);
	(ADD5 => D1) = (1:1:1, 1:1:1);
	(ADD5 => D2) = (1:1:1, 1:1:1);
	(ADD5 => D3) = (1:1:1, 1:1:1);
	(ADD5 => D4) = (1:1:1, 1:1:1);
	(ADD5 => D5) = (1:1:1, 1:1:1);
	(ADD5 => D6) = (1:1:1, 1:1:1);
	(ADD5 => D7) = (1:1:1, 1:1:1);
	(ADD5 => ED0) = (1:1:1, 1:1:1);

	(ADD6 => D0) = (1:1:1, 1:1:1);
	(ADD6 => D1) = (1:1:1, 1:1:1);
	(ADD6 => D2) = (1:1:1, 1:1:1);
	(ADD6 => D3) = (1:1:1, 1:1:1);
	(ADD6 => D4) = (1:1:1, 1:1:1);
	(ADD6 => D5) = (1:1:1, 1:1:1);
	(ADD6 => D6) = (1:1:1, 1:1:1);
	(ADD6 => D7) = (1:1:1, 1:1:1);
	(ADD6 => ED0) = (1:1:1, 1:1:1);

	(ADD7 => D0) = (1:1:1, 1:1:1);
	(ADD7 => D1) = (1:1:1, 1:1:1);
	(ADD7 => D2) = (1:1:1, 1:1:1);
	(ADD7 => D3) = (1:1:1, 1:1:1);
	(ADD7 => D4) = (1:1:1, 1:1:1);
	(ADD7 => D5) = (1:1:1, 1:1:1);
	(ADD7 => D6) = (1:1:1, 1:1:1);
	(ADD7 => D7) = (1:1:1, 1:1:1);
	(ADD7 => ED0) = (1:1:1, 1:1:1);

	(ADD8 => D0) = (1:1:1, 1:1:1);
	(ADD8 => D1) = (1:1:1, 1:1:1);
	(ADD8 => D2) = (1:1:1, 1:1:1);
	(ADD8 => D3) = (1:1:1, 1:1:1);
	(ADD8 => D4) = (1:1:1, 1:1:1);
	(ADD8 => D5) = (1:1:1, 1:1:1);
	(ADD8 => D6) = (1:1:1, 1:1:1);
	(ADD8 => D7) = (1:1:1, 1:1:1);
	(ADD8 => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SSF (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


and I_01 (con0,  OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);

reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK == 1'b0) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (negedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier11);
	$setuphold  (negedge RWCLK, ADD8, 1, 0, notifier12);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier21);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SSF_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;

assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};


not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);

reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;

reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end

   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b1;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(negedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b0)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(negedge RD_CLK_A)
begin
    if ((RWCLK == 1'b0) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

//always @(negedge WR_CLK_A)
//begin
//    if ((RWCLK == 1'b0) && (WEN!=1'b0))
//     begin
//	// if WEN toggles from 1 when WRCLK is high write x into the memory location
//	disable write_A;
//	memA[latched_add_A] = 9'bx;
//     end
//end
	
//always @(negedge WR_CLK_A)
//begin : write_A
//   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
//     begin
//	// if WRAD is x write x into all the memory locations
//	for(i=0; i<=511;i=i+1)
//		memA[i] = 9'bx;
//	//$display("(error) illegal address input at the falling edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
//     end
//   else
//	memA[WR_ADD_A] = DIN_A;
//end

always @(negedge WR_CLK_A)   // 10/01/02
begin : write_A
  if (WEN == 1'b0)
     memA[WR_ADD_A] = DIN_A;
end
 
always @(negedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the falling edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (negedge RWCLK, 1, 0, notifier1);

	$setuphold  (negedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (negedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (negedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (negedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (negedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (negedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (negedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (negedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (negedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (negedge RWCLK, ADD7, 1, 0, notifier11);
	$setuphold  (negedge RWCLK, ADD8, 1, 0, notifier12);

	$setuphold  (negedge RWCLK &&& (WEN==0), D0, 1, 0, notifier13);
	$setuphold  (negedge RWCLK &&& (WEN==0), D1, 1, 0, notifier14);
	$setuphold  (negedge RWCLK &&& (WEN==0), D2, 1, 0, notifier15);
	$setuphold  (negedge RWCLK &&& (WEN==0), D3, 1, 0, notifier16);
	$setuphold  (negedge RWCLK &&& (WEN==0), D4, 1, 0, notifier17);
	$setuphold  (negedge RWCLK &&& (WEN==0), D5, 1, 0, notifier18);
	$setuphold  (negedge RWCLK &&& (WEN==0), D6, 1, 0, notifier19);
	$setuphold  (negedge RWCLK &&& (WEN==0), D7, 1, 0, notifier20);
	$setuphold  (negedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier21);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SSR (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;
wire  D8_1, D7_1,D6_1, D5_1, D4_1, D3_1,  D2_1, D1_1, D0_1;

assign D[8:0] = {D8_1, D7_1, D6_1, D5_1, D4_1, D3_1,  D2_1, D1_1, D0_1} ;
assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};



and I_01 (con0,  OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);

reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge RD_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(posedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b1 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (posedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier11);
	$setuphold  (posedge RWCLK, ADD8, 1, 0, notifier12);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier21);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine

`celldefine
module RAMB512X9SSR_1 (ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8, D0, D1, D2, D3, D4, D5, D6, D7, ED0, WEN, RWCLK, CE, OE);


input  WEN, RWCLK, CE, OE;
input  ADD0, ADD1, ADD2, ADD3, ADD4, ADD5, ADD6, ADD7, ADD8;
inout  D0, D1, D2, D3, D4, D5, D6, D7, ED0;

wire  [8:0] D;
wire  [8:0] ADD;
wire  D8_1, D7_1,D6_1, D5_1, D4_1, D3_1,  D2_1, D1_1, D0_1;

assign D[8:0] = {D8_1, D7_1, D6_1, D5_1, D4_1, D3_1,  D2_1, D1_1, D0_1} ;
assign ADD[8:0] = {ADD8, ADD7, ADD6, ADD5, ADD4, ADD3, ADD2, ADD1, ADD0};

not inv_00 (b_OE, OE);

and I_01 (con0,  b_OE, WEN);

bufif1 ins019 (ED0,   D[8], con0);
bufif0 ins020 (D[8], ED0, con0);

bufif1 ins021 (D7,   D[7], con0);
bufif0 ins022 (D[7], D7, con0);

bufif1 ins023 (D6,   D[6], con0);
bufif0 ins024 (D[6], D6, con0);

bufif1 ins025 (D5,   D[5], con0);
bufif0 ins026 (D[5], D5, con0);

bufif1 ins027 (D4,   D[4], con0);
bufif0 ins028 (D[4], D4, con0);

bufif1 ins029 (D3,   D[3], con0);
bufif0 ins030 (D[3], D3, con0);

bufif1 ins031 (D2,   D[2], con0);
bufif0 ins032 (D[2], D2, con0);

bufif1 ins033 (D1,   D[1], con0);
bufif0 ins034 (D[1], D1, con0);

bufif1 ins035 (D0,   D[0], con0);
bufif0 ins036 (D[0], D0, con0);

reg   [8:0]  RD_ADD_A, WR_ADD_A, latched_add_A;
reg   [8:0] DIN_A;
reg   [8:0] ramout_w_A;
reg   [8:0] dataout_A;
reg   [8:0] memA [511:0];
reg          WR_CLK_A, RD_CLK_A;
integer      output_delay;
integer      output_delay_w;
integer      i;
reg          notifier1,notifier2,notifier3,notifier4,notifier5,notifier6, notifier7, notifier8, notifier9, notifier10;
reg          notifier11,notifier12,notifier13,notifier14,notifier15,notifier16,notifier17,notifier18,notifier19,notifier20;
reg          notifier21;

parameter  [511:0]init09  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init08  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init07  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init06  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init05  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init04  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init03  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init02  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;
parameter  [511:0]init01  = 512'hFFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF_FFFF;



initial
begin

   for (i= 0; i< 512; i = i+1)
   begin
        memA[i] = {init09[i],init08[i],init07[i],init06[i],init05[i],init04[i],init03[i],init02[i],init01[i]};
   end


   notifier1  = 1'b0;
   notifier2  = 1'b0;
   notifier3  = 1'b0;
   notifier4  = 1'b0;
   notifier5  = 1'b0;
   notifier6  = 1'b0;
   notifier7  = 1'b0;
   notifier8  = 1'b0;
   notifier9  = 1'b0;
   notifier10 = 1'b0;
   notifier11 = 1'b0;
   notifier12 = 1'b0;
   notifier13 = 1'b0;
   notifier14 = 1'b0;
   notifier15 = 1'b0;
   notifier16 = 1'b0;
   notifier17 = 1'b0;
   notifier18 = 1'b0;
   notifier19 = 1'b0;
   notifier20 = 1'b0;
   notifier21 = 1'b0;

   WR_CLK_A   = 1'b0;
   RD_CLK_A   = 1'b0;
   ramout_w_A = 9'bzzzzz_zzzz;
   dataout_A  = 9'bzzzzz_zzzz;
end

always @(WEN  or ADD)
begin
 if ( WEN == 1'b1)
	RD_ADD_A = ADD;
 else
	RD_ADD_A = 9'bx;
end
 
always @(RWCLK)
begin
 if (  WEN == 1'b1 && CE == 1'b0)
	RD_CLK_A = RWCLK;
 else
	RD_CLK_A = 1'b0;
end

always @(WEN or ADD)
begin
 if (WEN == 1'b0)
	WR_ADD_A = ADD;
 else
	WR_ADD_A = 9'bx;
end

always @(posedge WR_CLK_A)
begin
  if (WR_CLK_A == 1'b1)
	latched_add_A = WR_ADD_A;
end

always @(WEN or D)
begin
 if (WEN == 1'b0)
	DIN_A = D;
 else
	DIN_A = 9'bx;
end

always @(RWCLK)
begin
// if (WEN == 1'b0 && CE == 1'b0)
 if (WEN == 1'b0)
	WR_CLK_A = RWCLK;
 else
	WR_CLK_A = 1'b0;
end

always @(posedge RD_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!= 1'b1))
     begin
	disable read_A;
	ramout_w_A = 9'bx;
     end
end

always @(posedge WR_CLK_A)
begin
    if ((RWCLK == 1'b1) && (WEN!=1'b0))
     begin
	// if WEN toggles from 1 when WRCLK is high write x into the memory location
	disable write_A;
	memA[latched_add_A] = 9'bx;
     end
end
	
always @(posedge WR_CLK_A)
begin : write_A
   if (|(WR_ADD_A & ~WR_ADD_A) === 1'bx)
     begin
	// if WRAD is x write x into all the memory locations
	for(i=0; i<=511;i=i+1)
		memA[i] = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so writing X in all of the memory locations: @ %.3f ",$realtime);
     end
   else
	memA[WR_ADD_A] = DIN_A;
end

 
always @(posedge RD_CLK_A)
begin : read_A
   if (|(ADD & ~ADD) === 1'bx)
     begin
	// if WRAD is x send RD to x immediately
	ramout_w_A = 9'bx;
	//$display("(error) illegal address input at the rising edge of WRCLK so WRDTA goes x: @ %.3f ",$realtime);
     end
   else
	ramout_w_A = memA[RD_ADD_A];
end
 
always @(ramout_w_A or OE or WEN)
begin
  if (OE == 1'b0 && WEN == 1'b1)
	dataout_A = ramout_w_A;
   else
	dataout_A = 9'bzzzz_zzzz_z;
end

assign D = dataout_A;

specify

	$width (posedge RWCLK, 1, 0, notifier1);

	$setuphold  (posedge RWCLK, WEN, 1, 0, notifier2);
	$setuphold  (posedge RWCLK, CE, 1, 0, notifier3);

	$setuphold  (posedge RWCLK, ADD0, 1, 0, notifier4);
	$setuphold  (posedge RWCLK, ADD1, 1, 0, notifier5);
	$setuphold  (posedge RWCLK, ADD2, 1, 0, notifier6);
	$setuphold  (posedge RWCLK, ADD3, 1, 0, notifier7);
	$setuphold  (posedge RWCLK, ADD4, 1, 0, notifier8);
	$setuphold  (posedge RWCLK, ADD5, 1, 0, notifier9);
	$setuphold  (posedge RWCLK, ADD6, 1, 0, notifier10);
	$setuphold  (posedge RWCLK, ADD7, 1, 0, notifier11);
	$setuphold  (posedge RWCLK, ADD8, 1, 0, notifier12);

	$setuphold  (posedge RWCLK &&& (WEN==0), D0, 1, 0, notifier13);
	$setuphold  (posedge RWCLK &&& (WEN==0), D1, 1, 0, notifier14);
	$setuphold  (posedge RWCLK &&& (WEN==0), D2, 1, 0, notifier15);
	$setuphold  (posedge RWCLK &&& (WEN==0), D3, 1, 0, notifier16);
	$setuphold  (posedge RWCLK &&& (WEN==0), D4, 1, 0, notifier17);
	$setuphold  (posedge RWCLK &&& (WEN==0), D5, 1, 0, notifier18);
	$setuphold  (posedge RWCLK &&& (WEN==0), D6, 1, 0, notifier19);
	$setuphold  (posedge RWCLK &&& (WEN==0), D7, 1, 0, notifier20);
	$setuphold  (posedge RWCLK &&& (WEN==0), ED0, 1, 0, notifier21);

	(RWCLK => D0) = (1:1:1, 1:1:1);
	(RWCLK => D1) = (1:1:1, 1:1:1);
	(RWCLK => D2) = (1:1:1, 1:1:1);
	(RWCLK => D3) = (1:1:1, 1:1:1);
	(RWCLK => D4) = (1:1:1, 1:1:1);
	(RWCLK => D5) = (1:1:1, 1:1:1);
	(RWCLK => D6) = (1:1:1, 1:1:1);
	(RWCLK => D7) = (1:1:1, 1:1:1);
	(RWCLK => ED0) = (1:1:1, 1:1:1);

	(OE => D0) = (1:1:1, 1:1:1);
	(OE => D1) = (1:1:1, 1:1:1);
	(OE => D2) = (1:1:1, 1:1:1);
	(OE => D3) = (1:1:1, 1:1:1);
	(OE => D4) = (1:1:1, 1:1:1);
	(OE => D5) = (1:1:1, 1:1:1);
	(OE => D6) = (1:1:1, 1:1:1);
	(OE => D7) = (1:1:1, 1:1:1);
	(OE => ED0) = (1:1:1, 1:1:1);

endspecify

endmodule
`endcelldefine


`celldefine 
`timescale 10 ps / 1 fs

module CDRX_10B12B (SIN, REFCLK, CDRRST, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RXD6, RXD7, RXD8, RXD9, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "12";
parameter   pll_dly    = "0";
//parameter   sympat     = "00000011111111111111";
parameter   sympat     = "00000000111111000000";
parameter   lock_cyc   = 2;

parameter   IN_FREQ    = "";
parameter   DIV        = "";
parameter   MULT       = "";
parameter   PLL_DLY    = "";
parameter   SYMPAT     = "";

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h0f;
parameter   F_LKTBW    = 8'h3f;
parameter   F_TKDBW    = 8'h1f;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  SIN;
input  REFCLK,CDRRST;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9;
output SYDT;


wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;
wire   RXD8;
wire   RXD9;

reg    CDRLOCK;

reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = (SYMPAT == "") ? sympat : SYMPAT;
initial sympat_r[19] = convert_binary(symstr_r[7:0]); 
initial sympat_r[18] = convert_binary(symstr_r[15:8]); 
initial sympat_r[17] = convert_binary(symstr_r[23:16]); 
initial sympat_r[16] = convert_binary(symstr_r[31:24]); 
initial sympat_r[15] = convert_binary(symstr_r[39:32]); 
initial sympat_r[14] = convert_binary(symstr_r[47:40]); 
initial sympat_r[13] = convert_binary(symstr_r[55:48]); 
initial sympat_r[12] = convert_binary(symstr_r[63:56]); 
initial sympat_r[11] = convert_binary(symstr_r[71:64]); 
initial sympat_r[10] = convert_binary(symstr_r[79:72]); 
initial sympat_r[9] = convert_binary(symstr_r[87:80]); 
initial sympat_r[8] = convert_binary(symstr_r[95:88]); 
initial sympat_r[7] = convert_binary(symstr_r[103:96]); 
initial sympat_r[6] = convert_binary(symstr_r[111:104]); 
initial sympat_r[5] = convert_binary(symstr_r[119:112]); 
initial sympat_r[4] = convert_binary(symstr_r[127:120]); 
initial sympat_r[3] = convert_binary(symstr_r[135:128]); 
initial sympat_r[2] = convert_binary(symstr_r[143:136]); 
initial sympat_r[1] = convert_binary(symstr_r[151:144]); 
initial sympat_r[0] = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########
time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = (MULT == "") ? mult : MULT;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = (DIV == "") ? div : DIV;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = (PLL_DLY == "") ? pll_dly : PLL_DLY;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    //081804 if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    //081804 if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0);

assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 10)
      data_ina <= 1'bx;
   else
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;
always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;
always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    totcmp <= 1'b0;
else
    totcmp <= totce;

reg totcmp_d;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    totcmp_d <= 1'b0;
else
    totcmp_d <= totcmp;

assign cntrst = CDRRST || totcmp;
assign pcntrst = CDRRST || totcmp_d;

reg pre_pull, pre_push;
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end
else
    begin
       push <= pre_push;
       pull <= pre_pull;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = CDRRST || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(CDRRST or lock_pulse)
if (CDRRST)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk or posedge CDRRST)
if (CDRRST)
    begin
       lock0 <= 1'b0;
       lock1 <= 1'b1;
    end
else
    begin
       lock0 <= lock_int;
       lock1 <= lock0;
    end

wire #(10) lock2 = lock1;

always @(posedge RECCLK_reg or posedge CDRRST)
if (CDRRST)
    CDRLOCK <= 1'b0;
else
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align;
always@(posedge sclk or posedge CDRRST)
if (CDRRST)
        pre_align <= 1'b0;
else
        pre_align <= (shift_buffer[15:4] == sympat_r[19:8]);

reg rsypt0, rsypt1;
always@(posedge sclk or posedge CDRRST)
if (CDRRST)
    begin
        align <= 1'b0;
        rsypt0 <= 1'b0;
    end
else
    begin
        align <= pre_align; 
        rsypt0 <= pre_align; 
    end

always @(posedge sclk or posedge CDRRST)
if(CDRRST)
    rsypt1 <= 1'b0;
else
    rsypt1 <= rsypt0;

wire #(10) rsypt2 = rsypt1;

reg[2:0] divcnt;
wire intrecclk1 = !(divcnt == 3'b010);
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b010)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;
    
reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg or posedge CDRRST)
if (CDRRST)
    SYDT <= 1'b0;
else
    SYDT <= rsypt2;

wire[15:0] #(10) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[2];
assign RXD1 = store_buffer[3];
assign RXD2 = store_buffer[4];
assign RXD3 = store_buffer[5];
assign RXD4 = store_buffer[6];
assign RXD5 = store_buffer[7];
assign RXD6 = store_buffer[8];
assign RXD7 = store_buffer[9];
assign RXD8 = store_buffer[10];
assign RXD9 = store_buffer[11];

assign RECCLK = RECCLK_reg;

//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(REFCLK => RECCLK)   =   0:0:0, 0:0:0;
(REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 

`celldefine 
`timescale 100 fs / 1 fs

module CDRX_8B10B (SIN, REFCLK, CDRRST, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RXD6, RXD7, RXD8, RXD9, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "10";
parameter   pll_dly    = "0";
//parameter   sympat     = "01011111001010000011";
parameter   sympat     = "11000001010011111010";
parameter   lock_cyc   = 2;

parameter   IN_FREQ    = "";
parameter   DIV        = "";
parameter   MULT       = "";
parameter   PLL_DLY    = "";
parameter   SYMPAT     = "";

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h19;
parameter   F_LKTBW    = 8'h7f;
parameter   F_TKDBW    = 8'h19;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  SIN;
input  REFCLK,CDRRST;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9;
output SYDT;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;
wire   RXD8;
wire   RXD9;

reg    CDRLOCK;

reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = (SYMPAT == "") ? sympat : SYMPAT;
initial sympat_r[19] = convert_binary(symstr_r[7:0]); 
initial sympat_r[18] = convert_binary(symstr_r[15:8]); 
initial sympat_r[17] = convert_binary(symstr_r[23:16]); 
initial sympat_r[16] = convert_binary(symstr_r[31:24]); 
initial sympat_r[15] = convert_binary(symstr_r[39:32]); 
initial sympat_r[14] = convert_binary(symstr_r[47:40]); 
initial sympat_r[13] = convert_binary(symstr_r[55:48]); 
initial sympat_r[12] = convert_binary(symstr_r[63:56]); 
initial sympat_r[11] = convert_binary(symstr_r[71:64]); 
initial sympat_r[10] = convert_binary(symstr_r[79:72]); 
initial sympat_r[9]  = convert_binary(symstr_r[87:80]); 
initial sympat_r[8]  = convert_binary(symstr_r[95:88]); 
initial sympat_r[7]  = convert_binary(symstr_r[103:96]); 
initial sympat_r[6]  = convert_binary(symstr_r[111:104]); 
initial sympat_r[5]  = convert_binary(symstr_r[119:112]); 
initial sympat_r[4]  = convert_binary(symstr_r[127:120]); 
initial sympat_r[3]  = convert_binary(symstr_r[135:128]); 
initial sympat_r[2]  = convert_binary(symstr_r[143:136]); 
initial sympat_r[1]  = convert_binary(symstr_r[151:144]); 
initial sympat_r[0]  = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = (MULT == "") ? mult : MULT;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = (DIV == "") ? div :DIV;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = (PLL_DLY == "") ? pll_dly : PLL_DLY;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0);
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period*2*div_i/mult_i) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 1000)
      data_ina <= 1'bx;
   else 
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;
always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;
always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    totcmp <= 1'b0;
else
    totcmp <= totce;

reg totcmp_d;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    totcmp_d <= 1'b0;
else
    totcmp_d <= totcmp;

assign cntrst = CDRRST || totcmp;
assign pcntrst = CDRRST || totcmp_d;

reg pre_pull, pre_push;
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end
else
    begin
       push <= pre_push;
       pull <= pre_pull;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = CDRRST || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge CDRRST)
if (CDRRST)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(CDRRST or lock_pulse)
if (CDRRST)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk or posedge CDRRST)
if (CDRRST)
    begin
       lock0 <= 1'b0;
       lock1 <= 1'b1;
    end
else
    begin
       lock0 <= lock_int;
       lock1 <= lock0;
    end

wire #(100) lock2 = lock1;

always @(posedge RECCLK_reg or posedge CDRRST)
if (CDRRST)
    CDRLOCK <= 1'b0;
else
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align1, pre_align2;
always@(posedge sclk or posedge CDRRST)
if (CDRRST)
    begin
        pre_align1 <= 1'b0;
        pre_align2 <= 1'b0;
    end
else
    begin
        pre_align1 <= (shift_buffer[15:6] == sympat_r[9:0]);
        pre_align2 <= (shift_buffer[15:6] == sympat_r[19:10]);
    end

reg rsypt0, rsypt1;
always@(posedge sclk or negedge CDRRST)
if (CDRRST)
    begin
        align <= 1'b0;
        rsypt0 <= 1'b0;
    end
else
    begin
        align <= pre_align1 || pre_align2; 
        rsypt0 <= pre_align1 || pre_align2; 
    end

always @(posedge sclk or posedge CDRRST)
if(CDRRST)
    rsypt1 <= 1'b0;
else
    rsypt1 <= rsypt0;

wire #(100) rsypt2 = rsypt1;

reg[2:0] divcnt;
wire intrecclk1 = !(divcnt == 3'b011);
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b011)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;
    
reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg or posedge CDRRST)
if (CDRRST)
    SYDT <= 1'b0;
else
    SYDT <= rsypt2;

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[3];
assign RXD1 = store_buffer[4];
assign RXD2 = store_buffer[5];
assign RXD3 = store_buffer[6];
assign RXD4 = store_buffer[7];
assign RXD5 = store_buffer[8];
assign RXD6 = store_buffer[9];
assign RXD7 = store_buffer[10];
assign RXD8 = store_buffer[11];
assign RXD9 = store_buffer[12];

assign RECCLK = RECCLK_reg;

//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(REFCLK => RECCLK)   =   0:0:0, 0:0:0;
(REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
`timescale 100 fs / 1 fs

module CDRX_SS_4(CAL,SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "4";
parameter   pll_dly    = "0.0";
parameter   sympat     = "00110011001111111111";
parameter   lock_cyc   = 2;

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h0f;
parameter   F_LKTBW    = 8'h3f;
parameter   F_TKDBW    = 8'h1f;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  CAL;
input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3;
output SYDT;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;

reg    CDRLOCK;
reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = sympat;
initial sympat_r[0] = convert_binary(symstr_r[7:0]); 
initial sympat_r[1] = convert_binary(symstr_r[15:8]); 
initial sympat_r[2] = convert_binary(symstr_r[23:16]); 
initial sympat_r[3] = convert_binary(symstr_r[31:24]); 
initial sympat_r[4] = convert_binary(symstr_r[39:32]); 
initial sympat_r[5] = convert_binary(symstr_r[47:40]); 
initial sympat_r[6] = convert_binary(symstr_r[55:48]); 
initial sympat_r[7] = convert_binary(symstr_r[63:56]); 
initial sympat_r[8] = convert_binary(symstr_r[71:64]); 
initial sympat_r[9] = convert_binary(symstr_r[79:72]); 
initial sympat_r[10] = convert_binary(symstr_r[87:80]); 
initial sympat_r[11] = convert_binary(symstr_r[95:88]); 
initial sympat_r[12] = convert_binary(symstr_r[103:96]); 
initial sympat_r[13] = convert_binary(symstr_r[111:104]); 
initial sympat_r[14] = convert_binary(symstr_r[119:112]); 
initial sympat_r[15] = convert_binary(symstr_r[127:120]); 
initial sympat_r[16] = convert_binary(symstr_r[135:128]); 
initial sympat_r[17] = convert_binary(symstr_r[143:136]); 
initial sympat_r[18] = convert_binary(symstr_r[151:144]); 
initial sympat_r[19] = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg cal_d1, cal_d2;
wire calrst = cal_d1 && ~cal_d2;

always @(posedge aclk)
begin
    cal_d1 <= CAL;
    cal_d2 <= cal_d1;
end

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 100)
      data_ina <= 1'bx;
   else
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;
initial
dn_cnt0 <= 8'h00;
always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;
initial
up_cnt0 <= 8'h00;
always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk)
totcmp <= totce;

reg totcmp_d;
always @(posedge aclk)
totcmp_d <= totcmp;

assign cntrst = totcmp;
assign pcntrst = totcmp_d;

reg pre_pull, pre_push;
initial
begin
  pre_push <= 1'b0;
  pre_pull <= 1'b0;
end
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk)
if (CAL)
    begin
       push <= pre_push;
       pull <= pre_pull;
    end
else
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge calrst)
if (calrst)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = calrst || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge calrst)
if (calrst)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(calrst or lock_pulse)
if (calrst)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk)
begin
   lock0 <= lock_int;
   lock1 <= lock0;
end

wire #(100) lock2 = lock1;

always @(posedge RECCLK_reg)
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align;
always@(posedge sclk)
pre_align <= (shift_buffer[15:4] == sympat_r[19:8]);

reg rsypt0, rsypt1;
always@(posedge sclk)
rsypt0 <= pre_align; 

wire align_rst = ~lock1;
always@(posedge sclk)
if (~align_rst)
    align <= 1'b0;
else
    align <= pre_align; 

always @(posedge sclk)
rsypt1 <= rsypt0;

wire #(100) rsypt2 = rsypt1;

reg[2:0] divcnt;

initial
    divcnt <= 3'b111;

wire intrecclk1 = !(divcnt == 3'b110);
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b110)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;

reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg)
SYDT <= rsypt2;

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[9];
assign RXD1 = store_buffer[10];
assign RXD2 = store_buffer[11];
assign RXD3 = store_buffer[12];

assign RECCLK = RECCLK_reg;

//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 

`celldefine 
`timescale 100 fs / 1 fs

module CDRX_SS_6(CAL,SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "6";
parameter   pll_dly    = "0.0";
parameter   sympat     = "00011100011111111111";
parameter   lock_cyc   = 2;

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h0f;
parameter   F_LKTBW    = 8'h3f;
parameter   F_TKDBW    = 8'h1f;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  CAL;
input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5;
output SYDT;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;

reg    CDRLOCK;
reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = sympat;
initial sympat_r[0] = convert_binary(symstr_r[7:0]); 
initial sympat_r[1] = convert_binary(symstr_r[15:8]); 
initial sympat_r[2] = convert_binary(symstr_r[23:16]); 
initial sympat_r[3] = convert_binary(symstr_r[31:24]); 
initial sympat_r[4] = convert_binary(symstr_r[39:32]); 
initial sympat_r[5] = convert_binary(symstr_r[47:40]); 
initial sympat_r[6] = convert_binary(symstr_r[55:48]); 
initial sympat_r[7] = convert_binary(symstr_r[63:56]); 
initial sympat_r[8] = convert_binary(symstr_r[71:64]); 
initial sympat_r[9] = convert_binary(symstr_r[79:72]); 
initial sympat_r[10] = convert_binary(symstr_r[87:80]); 
initial sympat_r[11] = convert_binary(symstr_r[95:88]); 
initial sympat_r[12] = convert_binary(symstr_r[103:96]); 
initial sympat_r[13] = convert_binary(symstr_r[111:104]); 
initial sympat_r[14] = convert_binary(symstr_r[119:112]); 
initial sympat_r[15] = convert_binary(symstr_r[127:120]); 
initial sympat_r[16] = convert_binary(symstr_r[135:128]); 
initial sympat_r[17] = convert_binary(symstr_r[143:136]); 
initial sympat_r[18] = convert_binary(symstr_r[151:144]); 
initial sympat_r[19] = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg cal_d1, cal_d2;
wire calrst = cal_d1 && ~cal_d2;

always @(posedge aclk)
begin
    cal_d1 <= CAL;
    cal_d2 <= cal_d1;
end

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 100)
      data_ina <= 1'bx;
   else
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;
initial
    dn_cnt0 <= 8'h00;

always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;
initial
    up_cnt0 <= 8'h00;
always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk)
totcmp <= totce;

reg totcmp_d;
always @(posedge aclk)
totcmp_d <= totcmp;

assign cntrst = totcmp;
assign pcntrst = totcmp_d;

reg pre_pull, pre_push;
initial
begin
  pre_push <= 1'b0;
  pre_pull <= 1'b0;
end
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk)
if (CAL)
    begin
       push <= pre_push;
       pull <= pre_pull;
    end
else
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge calrst)
if (calrst)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = calrst || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge calrst)
if (calrst)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(calrst or lock_pulse)
if (calrst)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk)
begin
   lock0 <= lock_int;
   lock1 <= lock0;
end

wire #(100) lock2 = lock1;

always @(posedge RECCLK_reg)
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align;
always@(posedge sclk)
pre_align <= (shift_buffer[15:4] == sympat_r[19:8]);

reg rsypt0, rsypt1;
always@(posedge sclk)
rsypt0 <= pre_align; 

wire align_rst = ~lock1;
always@(posedge sclk)
if (~align_rst)
    align <= 1'b0;
else
    align <= pre_align; 

always @(posedge sclk)
rsypt1 <= rsypt0;

wire #(100) rsypt2 = rsypt1;

reg[2:0] divcnt;
wire intrecclk1 = !(divcnt == 3'b101);

initial 
    divcnt <= 3'b111;
   
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b101)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;
    
reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

initial 
intrecclk <= 1'b0;
always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg)
SYDT <= rsypt2;

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[7];
assign RXD1 = store_buffer[8];
assign RXD2 = store_buffer[9];
assign RXD3 = store_buffer[10];
assign RXD4 = store_buffer[11];
assign RXD5 = store_buffer[12];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
`timescale 100 fs / 1 fs

module CDRX_SS_8(CAL,SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RXD6, RXD7, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "8";
parameter   pll_dly    = "0.0";
parameter   sympat     = "00001111000011111111";
parameter   lock_cyc   = 2;

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h0f;
parameter   F_LKTBW    = 8'h3f;
parameter   F_TKDBW    = 8'h1f;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  CAL;
input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7;
output SYDT;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;

reg    CDRLOCK;
reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = sympat;
initial sympat_r[0] = convert_binary(symstr_r[7:0]); 
initial sympat_r[1] = convert_binary(symstr_r[15:8]); 
initial sympat_r[2] = convert_binary(symstr_r[23:16]); 
initial sympat_r[3] = convert_binary(symstr_r[31:24]); 
initial sympat_r[4] = convert_binary(symstr_r[39:32]); 
initial sympat_r[5] = convert_binary(symstr_r[47:40]); 
initial sympat_r[6] = convert_binary(symstr_r[55:48]); 
initial sympat_r[7] = convert_binary(symstr_r[63:56]); 
initial sympat_r[8] = convert_binary(symstr_r[71:64]); 
initial sympat_r[9] = convert_binary(symstr_r[79:72]); 
initial sympat_r[10] = convert_binary(symstr_r[87:80]); 
initial sympat_r[11] = convert_binary(symstr_r[95:88]); 
initial sympat_r[12] = convert_binary(symstr_r[103:96]); 
initial sympat_r[13] = convert_binary(symstr_r[111:104]); 
initial sympat_r[14] = convert_binary(symstr_r[119:112]); 
initial sympat_r[15] = convert_binary(symstr_r[127:120]); 
initial sympat_r[16] = convert_binary(symstr_r[135:128]); 
initial sympat_r[17] = convert_binary(symstr_r[143:136]); 
initial sympat_r[18] = convert_binary(symstr_r[151:144]); 
initial sympat_r[19] = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg cal_d1, cal_d2;
wire calrst = cal_d1 && ~cal_d2;

always @(posedge aclk)
begin
    cal_d1 <= CAL;
    cal_d2 <= cal_d1;
end

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 100)
      data_ina <= 1'bx;
   else
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;

initial
    dn_cnt0 <= 8'h00;

always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;

initial
    up_cnt0 <= 8'h00;

always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk)
totcmp <= totce;

reg totcmp_d;
always @(posedge aclk)
totcmp_d <= totcmp;

assign cntrst = totcmp;
assign pcntrst = totcmp_d;

reg pre_pull, pre_push;
initial
begin
  pre_push <= 1'b0;
  pre_pull <= 1'b0;
end
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk)
if (CAL)
    begin
       push <= pre_push;
       pull <= pre_pull;
    end
else
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge calrst)
if (calrst)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = calrst || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge calrst)
if (calrst)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(calrst or lock_pulse)
if (calrst)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk)
begin
   lock0 <= lock_int;
   lock1 <= lock0;
end

wire #(100) lock2 = lock1;

always @(posedge RECCLK_reg)
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align;
always@(posedge sclk)
pre_align <= (shift_buffer[15:4] == sympat_r[19:8]);

reg rsypt0, rsypt1;
always@(posedge sclk)
rsypt0 <= pre_align; 

wire align_rst = ~lock1;
always@(posedge sclk)
if (~align_rst)
    align <= 1'b0;
else
    align <= pre_align; 

always @(posedge sclk)
rsypt1 <= rsypt0;

wire #(100) rsypt2 = rsypt1;

reg[2:0] divcnt;

initial
    divcnt <= 3'b111;

wire intrecclk1 = !(divcnt == 3'b100);
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b100)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;
    
reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg)
SYDT <= rsypt2;

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[5];
assign RXD1 = store_buffer[6];
assign RXD2 = store_buffer[7];
assign RXD3 = store_buffer[8];
assign RXD4 = store_buffer[9];
assign RXD5 = store_buffer[10];
assign RXD6 = store_buffer[11];
assign RXD7 = store_buffer[12];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
`timescale 100 fs / 1 fs

module CDRX_SS_10(CAL,SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RXD6, RXD7, RXD8, RXD9, RECCLK, CSLOCK, SYDT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "10";
parameter   pll_dly    = "0.0";
parameter   sympat     = "00000111110000011111";
parameter   lock_cyc   = 2;

//###########################
//#digital filter parameters#
//###########################

parameter   F_LKDBW    = 8'h0f;
parameter   F_LKTBW    = 8'h3f;
parameter   F_TKDBW    = 8'h1f;
parameter   F_TKTBW    = 8'h7f;
parameter   F_LOCK     = 3'b011;

integer     clockboost;

input  CAL;
input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9;
output SYDT;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;
wire   RXD8;
wire   RXD9;

reg    CDRLOCK;
reg    RECCLK_reg;
wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;

wire   clkin_in;

reg    align;
reg    SYDT;

reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    aclk, sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [159:0] symstr_r;
reg [19:0] sympat_r;
initial symstr_r = sympat;
initial sympat_r[0] = convert_binary(symstr_r[7:0]); 
initial sympat_r[1] = convert_binary(symstr_r[15:8]); 
initial sympat_r[2] = convert_binary(symstr_r[23:16]); 
initial sympat_r[3] = convert_binary(symstr_r[31:24]); 
initial sympat_r[4] = convert_binary(symstr_r[39:32]); 
initial sympat_r[5] = convert_binary(symstr_r[47:40]); 
initial sympat_r[6] = convert_binary(symstr_r[55:48]); 
initial sympat_r[7] = convert_binary(symstr_r[63:56]); 
initial sympat_r[8] = convert_binary(symstr_r[71:64]); 
initial sympat_r[9] = convert_binary(symstr_r[79:72]); 
initial sympat_r[10] = convert_binary(symstr_r[87:80]); 
initial sympat_r[11] = convert_binary(symstr_r[95:88]); 
initial sympat_r[12] = convert_binary(symstr_r[103:96]); 
initial sympat_r[13] = convert_binary(symstr_r[111:104]); 
initial sympat_r[14] = convert_binary(symstr_r[119:112]); 
initial sympat_r[15] = convert_binary(symstr_r[127:120]); 
initial sympat_r[16] = convert_binary(symstr_r[135:128]); 
initial sympat_r[17] = convert_binary(symstr_r[143:136]); 
initial sympat_r[18] = convert_binary(symstr_r[151:144]); 
initial sympat_r[19] = convert_binary(symstr_r[159:152]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 

//#################
//#digitial filter#
//#################

reg cal_d1, cal_d2;
wire calrst = cal_d1 && ~cal_d2;

always @(posedge aclk)
begin
    cal_d1 <= CAL;
    cal_d2 <= cal_d1;
end

reg data_ins;
reg data_ina;
always @(posedge sclk)
   data_ins <= SIN;

time time_data;
time time_clock;
time time_delta;

always @(SIN)
   time_data = $time;

always @(posedge aclk)
   time_clock = $time;

always @(time_data or time_clock)
   if (time_data >= time_clock)
       time_delta = time_data - time_clock;
   else
       time_delta = time_clock- time_data;

reg data_inaa;
always @(posedge aclk)
  data_inaa <= SIN;

always @(aclk or time_delta or data_inaa)
if (aclk)
   begin
   if (time_delta < 100)
      data_ina <= 1'bx;
   else
      data_ina <= data_inaa;
   end

wire transition = data_ins ^ data_ina;

reg dn_ss;
always @(sclk or transition)
if (sclk)
    dn_ss <= transition;

reg dn_s;
always @(posedge sclk)
    dn_s <= dn_ss;

reg up_s;
always @(posedge sclk)
    up_s <= transition;

wire dn_clk = dn_s && aclk;
wire up_clk = up_s && aclk;

wire cntrst;
wire pcntrst;

reg[7:0] dn_cnt0;

initial
    dn_cnt0 <= 8'h00;

always @(posedge dn_clk or posedge cntrst)
if (cntrst)
    dn_cnt0 <= 8'h00;
else
    dn_cnt0 <= dn_cnt0 + 1'b1;
    
reg[7:0] up_cnt0;

initial
    up_cnt0 <= 8'h00;

always @(posedge up_clk or posedge cntrst)
if (cntrst)
    up_cnt0 <= 8'h00;
else
    up_cnt0 <= up_cnt0 + 1'b1;
    
reg[7:0] dn_cnt, up_cnt;
always @(posedge aclk)
begin
   dn_cnt <= dn_cnt0;
   up_cnt <= up_cnt0;
end

reg[8:0] sub_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   sub_cnt <= 9'h000;
else
   sub_cnt <= dn_cnt - up_cnt;

reg[7:0] add_cnt;
always @(posedge aclk or posedge cntrst)
if (cntrst)
   add_cnt <= 8'h00;
else
   add_cnt <= dn_cnt + up_cnt;

wire[7:0] lkdbw = F_LKDBW;
wire[7:0] lktbw = F_LKTBW;
wire[7:0] tkdbw = F_TKDBW;
wire[7:0] tktbw = F_TKTBW;

wire[7:0] dbw = CDRLOCK? tkdbw: lkdbw;
wire[7:0] tbw = CDRLOCK? tktbw: lktbw;

reg[7:0] diff_cnt;
always @(sub_cnt)
if (sub_cnt[8])
    diff_cnt <= ~(sub_cnt[7:0]);
else
    diff_cnt <= sub_cnt[7:0];

reg diffcmp;
always @(posedge aclk or posedge cntrst)
if (cntrst)
    diffcmp <= 1'b0;
else
    if (diff_cnt >= dbw)
        diffcmp <= 1'b1;
    else
        diffcmp <= 1'b0;

reg totce;
always @(add_cnt or tbw)
if (add_cnt[7:1] == tbw[7:1])
    totce <= 1'b1;
else
    totce <= 1'b0;

reg totcmp;
always @(posedge aclk)
totcmp <= totce;

reg totcmp_d;
always @(posedge aclk)
totcmp_d <= totcmp;

assign cntrst = totcmp;
assign pcntrst = totcmp_d;

reg pre_pull, pre_push;
initial
begin
  pre_push <= 1'b0;
  pre_pull <= 1'b0;
end
always @(posedge aclk or posedge pcntrst)
if (pcntrst)
    begin
       pre_push <= 1'b0;
       pre_pull <= 1'b0;
    end
else
    begin
       if (totce)
           begin
               pre_push <= diffcmp && (~sub_cnt[8]);
               pre_pull <= diffcmp && sub_cnt[8];
           end
    end

reg push, pull;
always @(posedge aclk)
if (CAL)
    begin
       push <= pre_push;
       pull <= pre_pull;
    end
else
    begin
       push <= 1'b0;
       pull <= 1'b0;
    end

//########################
//#phase shift and select#
//########################

reg[15:0] sclksel;
always @(posedge aclk or posedge calrst)
if (calrst)
    sclksel <= 16'h0100;
else
    if (pull)
        sclksel <= {sclksel[0], sclksel[15:1]};
    else if (push)
        sclksel <= {sclksel[14:0], sclksel[15]};

always @(sclksel or inthsrecclk)
case (sclksel)
16'h0001: begin
             aclk <= inthsrecclk[8]; 
             sclk <= inthsrecclk[0]; 
          end
16'h0002: begin
             aclk <= inthsrecclk[9]; 
             sclk <= inthsrecclk[1]; 
          end
16'h0004: begin
             aclk <= inthsrecclk[10]; 
             sclk <= inthsrecclk[2]; 
          end
16'h0008: begin
             aclk <= inthsrecclk[11]; 
             sclk <= inthsrecclk[3]; 
          end
16'h0010: begin
             aclk <= inthsrecclk[12]; 
             sclk <= inthsrecclk[4]; 
          end
16'h0020: begin
             aclk <= inthsrecclk[13]; 
             sclk <= inthsrecclk[5]; 
          end
16'h0040: begin
             aclk <= inthsrecclk[14]; 
             sclk <= inthsrecclk[6]; 
          end
16'h0080: begin
             aclk <= inthsrecclk[15]; 
             sclk <= inthsrecclk[7]; 
          end
16'h0100: begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
16'h0200: begin
             aclk <= inthsrecclk[1]; 
             sclk <= inthsrecclk[9]; 
          end
16'h0400: begin
             aclk <= inthsrecclk[2]; 
             sclk <= inthsrecclk[10]; 
          end
16'h0800: begin
             aclk <= inthsrecclk[3]; 
             sclk <= inthsrecclk[11]; 
          end
16'h1000: begin
             aclk <= inthsrecclk[4]; 
             sclk <= inthsrecclk[12]; 
          end
16'h2000: begin
             aclk <= inthsrecclk[5]; 
             sclk <= inthsrecclk[13]; 
          end
16'h4000: begin
             aclk <= inthsrecclk[6]; 
             sclk <= inthsrecclk[14]; 
          end
16'h8000: begin
             aclk <= inthsrecclk[7]; 
             sclk <= inthsrecclk[15]; 
          end
default:  begin
             aclk <= inthsrecclk[0]; 
             sclk <= inthsrecclk[8]; 
          end
endcase

//#############
//#LOCK detect#
//#############

wire lock_rst = calrst || pull || push;

reg[2:0] lock_cnt;
always @(posedge totcmp or posedge lock_rst)
if (lock_rst)
    lock_cnt <= 3'b000;
else
    lock_cnt <= lock_cnt + 1'b1;

wire lockcmp = (lock_cnt == F_LOCK);

reg lockcmp_d1, lockcmp_d2;
always @(posedge aclk or posedge calrst)
if (calrst)
    begin
      lockcmp_d1 <= 1'b0;
      lockcmp_d2 <= 1'b0;
    end
else
    begin
      lockcmp_d1 <= lockcmp;
      lockcmp_d2 <= lockcmp_d1;
    end

wire lock_pulse = lockcmp_d1 && ~lockcmp_d2;

reg lock_int;
always @(calrst or lock_pulse)
if (calrst)
    lock_int <= 1'b0;
else
    if (lock_pulse)
        lock_int <= 1'b1;

reg lock0, lock1;
always @(posedge sclk)
begin
   lock0 <= lock_int;
   lock1 <= lock0;
end

wire #(100) lock2 = lock1;

always @(posedge RECCLK_reg)
    CDRLOCK <= lock2;

//######################################
//#SYNC detect & recover data and clock#
//######################################

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg pre_align;
always@(posedge sclk)
pre_align <= (shift_buffer[15:4] == sympat_r[19:8]);

reg rsypt0, rsypt1;
always@(posedge sclk)
rsypt0 <= pre_align; 

wire align_rst = ~lock1;
always@(posedge sclk)
if (~align_rst)
    align <= 1'b0;
else
    align <= pre_align; 

always @(posedge sclk)
rsypt1 <= rsypt0;

wire #(100) rsypt2 = rsypt1;

reg[2:0] divcnt;

initial
    divcnt <= 3'b111;

wire intrecclk1 = !(divcnt == 3'b011);
always @(posedge sclk or align)
if (align)
    divcnt <= 3'b111;
else
    if (divcnt == 3'b011)
        divcnt <= 3'b111;
    else
        divcnt <= divcnt - 1'b1;
    
reg intrecclk2;
always @(posedge sclk)
    intrecclk2 <= intrecclk1;

always @(posedge intrecclk2 or posedge align)
if (align)
    intrecclk <= 1'b0;
else
    intrecclk <= ~intrecclk;

always @(posedge sclk)
    RECCLK_reg <= intrecclk;

always @(posedge RECCLK_reg)
SYDT <= rsypt2;

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[2];
assign RXD1 = store_buffer[3];
assign RXD2 = store_buffer[4];
assign RXD3 = store_buffer[5];
assign RXD4 = store_buffer[6];
assign RXD5 = store_buffer[7];
assign RXD6 = store_buffer[8];
assign RXD7 = store_buffer[9];
assign RXD8 = store_buffer[11];
assign RXD9 = store_buffer[12];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
`timescale 10 ps / 10 ps

module HSLB_10B12B (REFCLK,CDRRST,TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9,RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9,RECCLK,CSLOCK);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "1";

input  REFCLK,CDRRST;
input TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;
wire   RXD8;
wire   RXD9;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

integer   cnt_m_div;
wire      clkin_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

assign RXD0 = TXD0;
assign RXD1 = TXD1;
assign RXD2 = TXD2;
assign RXD3 = TXD3;
assign RXD4 = TXD4;
assign RXD5 = TXD5;
assign RXD6 = TXD6;
assign RXD7 = TXD7;
assign RXD8 = TXD8;
assign RXD9 = TXD9;

assign RECCLK = REFCLK;
assign CSLOCK = 1'b1;

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(REFCLK => RECCLK)   =   0:0:0, 0:0:0;
(REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 
`celldefine 
`timescale 10 ps / 10 ps

module HSLB_8B10B (REFCLK,CDRRST,TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9,RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9,RECCLK,CSLOCK);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "1";

input  REFCLK,CDRRST;
input TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7,RXD8,RXD9;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;
wire   RXD8;
wire   RXD9;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

integer   cnt_m_div;
wire      clkin_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

assign RXD0 = TXD0;
assign RXD1 = TXD1;
assign RXD2 = TXD2;
assign RXD3 = TXD3;
assign RXD4 = TXD4;
assign RXD5 = TXD5;
assign RXD6 = TXD6;
assign RXD7 = TXD7;
assign RXD8 = TXD8;
assign RXD9 = TXD9;

assign RECCLK = REFCLK;
assign CSLOCK = 1'b1;

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(REFCLK => RECCLK)   =   0:0:0, 0:0:0;
(REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 
`celldefine 
`timescale 100 fs / 1 fs

module RX_SS_4(SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RECCLK,CSLOCK);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "4";
parameter   phase_adj    = "1000";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;

wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;
reg RECCLK_reg;

wire   clkin_in;

reg    [19:0] symstr_buffer;
reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [31:0] phaseadj_str;
reg [3:0] phaseadj;
initial phaseadj_str = phase_adj;
initial phaseadj[0] = convert_binary(phaseadj_str[7:0]); 
initial phaseadj[1] = convert_binary(phaseadj_str[15:8]); 
initial phaseadj[2] = convert_binary(phaseadj_str[23:16]); 
initial phaseadj[3] = convert_binary(phaseadj_str[31:24]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 


always @(phaseadj or inthsrecclk)
case (phaseadj)
4'b0000: sclk <= inthsrecclk[0]; 
4'b0001: sclk <= inthsrecclk[1]; 
4'b0010: sclk <= inthsrecclk[2]; 
4'b0011: sclk <= inthsrecclk[3]; 
4'b0100: sclk <= inthsrecclk[4]; 
4'b0101: sclk <= inthsrecclk[5]; 
4'b0110: sclk <= inthsrecclk[6]; 
4'b0111: sclk <= inthsrecclk[7]; 
4'b1000: sclk <= inthsrecclk[8]; 
4'b1001: sclk <= inthsrecclk[9]; 
4'b1010: sclk <= inthsrecclk[10]; 
4'b1011: sclk <= inthsrecclk[11]; 
4'b1100: sclk <= inthsrecclk[12]; 
4'b1101: sclk <= inthsrecclk[13]; 
4'b1110: sclk <= inthsrecclk[14]; 
4'b1111: sclk <= inthsrecclk[15]; 
default:  sclk <= inthsrecclk[8]; 
endcase

//########################
//#recover data and clock#
//########################

reg data_ins;
always @(posedge sclk)
   data_ins <= SIN;

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg intrecclk1;
reg intrecclk2;
always @(posedge sclk)
begin
    intrecclk1 <= clkin_in;
    intrecclk2 <= intrecclk1;
    intrecclk  <= intrecclk2;
    RECCLK_reg     <= intrecclk;
end

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[12];
assign RXD1 = store_buffer[13];
assign RXD2 = store_buffer[14];
assign RXD3 = store_buffer[15];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 
`celldefine 
`timescale 100 fs / 1 fs

module RX_SS_6(SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RECCLK, CSLOCK);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "6";
parameter   phase_adj    = "1000";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;

wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;
reg RECCLK_reg;

wire   clkin_in;

reg    [19:0] symstr_buffer;
reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [31:0] phaseadj_str;
reg [3:0] phaseadj;
initial phaseadj_str = phase_adj;
initial phaseadj[0] = convert_binary(phaseadj_str[7:0]); 
initial phaseadj[1] = convert_binary(phaseadj_str[15:8]); 
initial phaseadj[2] = convert_binary(phaseadj_str[23:16]); 
initial phaseadj[3] = convert_binary(phaseadj_str[31:24]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 


always @(phaseadj or inthsrecclk)
case (phaseadj)
4'b0000: sclk <= inthsrecclk[0]; 
4'b0001: sclk <= inthsrecclk[1]; 
4'b0010: sclk <= inthsrecclk[2]; 
4'b0011: sclk <= inthsrecclk[3]; 
4'b0100: sclk <= inthsrecclk[4]; 
4'b0101: sclk <= inthsrecclk[5]; 
4'b0110: sclk <= inthsrecclk[6]; 
4'b0111: sclk <= inthsrecclk[7]; 
4'b1000: sclk <= inthsrecclk[8]; 
4'b1001: sclk <= inthsrecclk[9]; 
4'b1010: sclk <= inthsrecclk[10]; 
4'b1011: sclk <= inthsrecclk[11]; 
4'b1100: sclk <= inthsrecclk[12]; 
4'b1101: sclk <= inthsrecclk[13]; 
4'b1110: sclk <= inthsrecclk[14]; 
4'b1111: sclk <= inthsrecclk[15]; 
default:  sclk <= inthsrecclk[8]; 
endcase

//########################
//#recover data and clock#
//########################

reg data_ins;
always @(posedge sclk)
   data_ins <= SIN;

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg intrecclk1;
reg intrecclk2;
always @(posedge sclk)
begin
    intrecclk1 <= clkin_in;
    intrecclk2 <= intrecclk1;
    intrecclk  <= intrecclk2;
    RECCLK_reg     <= intrecclk;
end

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[10];
assign RXD1 = store_buffer[11];
assign RXD2 = store_buffer[12];
assign RXD3 = store_buffer[13];
assign RXD4 = store_buffer[14];
assign RXD5 = store_buffer[15];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 
`celldefine 
`timescale 100fs / 1fs

module RX_SS_8(SIN, SS_CLKIN, RXD0, RXD1, RXD2, RXD3, RXD4, RXD5, RXD6, RXD7, RECCLK,CSLOCK);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "8";
parameter   phase_adj    = "1000";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  SIN;
input  SS_CLKIN;
output RECCLK,CSLOCK;
output RXD0,RXD1,RXD2,RXD3,RXD4,RXD5,RXD6,RXD7;

wire   RXD0;
wire   RXD1;
wire   RXD2;
wire   RXD3;
wire   RXD4;
wire   RXD5;
wire   RXD6;
wire   RXD7;

wire   CSLOCK;
wire[15:0] inthsrecclk;
reg    intrecclk;
reg RECCLK_reg;

wire   clkin_in;

reg    [19:0] symstr_buffer;
reg    [15:0]  store_buffer;
reg    [15:0]  shift_buffer;
reg    sclk;

time   new_delay;

time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

reg [31:0] phaseadj_str;
reg [3:0] phaseadj;
initial phaseadj_str = phase_adj;
initial phaseadj[0] = convert_binary(phaseadj_str[7:0]); 
initial phaseadj[1] = convert_binary(phaseadj_str[15:8]); 
initial phaseadj[2] = convert_binary(phaseadj_str[23:16]); 
initial phaseadj[3] = convert_binary(phaseadj_str[31:24]); 

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = 10 * mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end


buf buf_clkin (clkin_in, SS_CLKIN);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));

//#################
//#16-phase clocks#
//#################

assign inthsrecclk[0] = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign #(clklock_half_period/8) inthsrecclk[1] = inthsrecclk[0]; 
assign #(clklock_half_period/8) inthsrecclk[2] = inthsrecclk[1]; 
assign #(clklock_half_period/8) inthsrecclk[3] = inthsrecclk[2]; 
assign #(clklock_half_period/8) inthsrecclk[4] = inthsrecclk[3]; 
assign #(clklock_half_period/8) inthsrecclk[5] = inthsrecclk[4]; 
assign #(clklock_half_period/8) inthsrecclk[6] = inthsrecclk[5]; 
assign #(clklock_half_period/8) inthsrecclk[7] = inthsrecclk[6]; 
assign #(clklock_half_period/8) inthsrecclk[8] = inthsrecclk[7]; 
assign #(clklock_half_period/8) inthsrecclk[9] = inthsrecclk[8]; 
assign #(clklock_half_period/8) inthsrecclk[10] = inthsrecclk[9]; 
assign #(clklock_half_period/8) inthsrecclk[11] = inthsrecclk[10]; 
assign #(clklock_half_period/8) inthsrecclk[12] = inthsrecclk[11]; 
assign #(clklock_half_period/8) inthsrecclk[13] = inthsrecclk[12]; 
assign #(clklock_half_period/8) inthsrecclk[14] = inthsrecclk[13]; 
assign #(clklock_half_period/8) inthsrecclk[15] = inthsrecclk[14]; 


always @(phaseadj or inthsrecclk)
case (phaseadj)
4'b0000: sclk <= inthsrecclk[0]; 
4'b0001: sclk <= inthsrecclk[1]; 
4'b0010: sclk <= inthsrecclk[2]; 
4'b0011: sclk <= inthsrecclk[3]; 
4'b0100: sclk <= inthsrecclk[4]; 
4'b0101: sclk <= inthsrecclk[5]; 
4'b0110: sclk <= inthsrecclk[6]; 
4'b0111: sclk <= inthsrecclk[7]; 
4'b1000: sclk <= inthsrecclk[8]; 
4'b1001: sclk <= inthsrecclk[9]; 
4'b1010: sclk <= inthsrecclk[10]; 
4'b1011: sclk <= inthsrecclk[11]; 
4'b1100: sclk <= inthsrecclk[12]; 
4'b1101: sclk <= inthsrecclk[13]; 
4'b1110: sclk <= inthsrecclk[14]; 
4'b1111: sclk <= inthsrecclk[15]; 
default:  sclk <= inthsrecclk[8]; 
endcase

//########################
//#recover data and clock#
//########################

reg data_ins;
always @(posedge sclk)
   data_ins <= SIN;

always@(posedge sclk)
begin
     shift_buffer[15]   <= data_ins;
     shift_buffer[14:0] <= shift_buffer[15:1];
end

reg intrecclk1;
reg intrecclk2;
always @(posedge sclk)
begin
    intrecclk1 <= clkin_in;
    intrecclk2 <= intrecclk1;
    intrecclk  <= intrecclk2;
    RECCLK_reg     <= intrecclk;
end

wire[15:0] #(100) shift_buffer_d = shift_buffer;

always @(posedge RECCLK_reg)
    store_buffer <= shift_buffer_d;

assign RXD0 = store_buffer[8];
assign RXD1 = store_buffer[9];
assign RXD2 = store_buffer[10];
assign RXD3 = store_buffer[11];
assign RXD4 = store_buffer[12];
assign RXD5 = store_buffer[13];
assign RXD6 = store_buffer[14];
assign RXD7 = store_buffer[15];

assign RECCLK = RECCLK_reg;
//##############
//## function ##
//##############

function convert_binary;
input [7:0] sym_str;
  begin

    if (sym_str == "1")
      convert_binary = 1'b1;
    else if (sym_str == "0")
      convert_binary = 1'b0;
    else 
      convert_binary = 1'b0;
  end
endfunction

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;
  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 
 
(SS_CLKIN => RECCLK)   =   0:0:0, 0:0:0;
(SS_CLKIN => CSLOCK)    =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 

`celldefine 
`timescale 10 ps / 10 ps

module TX_10B12B (TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9,REFCLK,CSLOCK,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "12";
parameter   pll_dly    = "0";
parameter   lock_cyc   = 2;

integer     clockboost;

parameter   IN_FREQ    = "";
parameter   DIV        = "";
parameter   MULT       = "";
parameter   PLL_DLY    = "";

input  TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9;
input  REFCLK;
output SOUT, CSLOCK;
reg   SOUT_int;

wire   CSLOCK;

wire   clkin_in;

reg    [11:0] shift_buffer;

wire   inthsrecclk;
wire   intrecclk;

//#########
//## PLL ##
//#########

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   refclk_half_period1;
time   refclk_half_period0;
time   refclk_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = (MULT == "") ? mult : MULT;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = (DIV == "") ? div : DIV;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = (PLL_DLY == "") ? pll_dly : PLL_DLY;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       refclk_half_period0 = ($time - clklock_last_falling_edge);
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       refclk_half_period1 = ($time - clklock_last_rising_edge);
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i; 
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
refclk_half_period = (refclk_half_period0 + refclk_half_period1)/2.0; 
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = CLK_OUT_plus_delay;

//########
//## TX ##
//########

assign intrecclk = REFCLK;

reg [3:0] cnt;
wire [11:0] data_out;

initial 
begin
  cnt = 4'b0000;
  shift_buffer = 12'b000000000000;
end

always @(posedge inthsrecclk)
begin
   if (cnt == 4'b1100)
        cnt = 4'b0001;
   else
        cnt = cnt + 1;
end

assign data_out[0] = (cnt == 4'b1100) ? 1'b1 : shift_buffer[1]; 
assign data_out[1] = (cnt == 4'b1100) ? TXD0 : shift_buffer[2]; 
assign data_out[2] = (cnt == 4'b1100) ? TXD1 : shift_buffer[3]; 
assign data_out[3] = (cnt == 4'b1100) ? TXD2 : shift_buffer[4]; 
assign data_out[4] = (cnt == 4'b1100) ? TXD3 : shift_buffer[5]; 
assign data_out[5] = (cnt == 4'b1100) ? TXD4 : shift_buffer[6]; 
assign data_out[6] = (cnt == 4'b1100) ? TXD5 : shift_buffer[7]; 
assign data_out[7] = (cnt == 4'b1100) ? TXD6 : shift_buffer[8]; 
assign data_out[8] = (cnt == 4'b1100) ? TXD7 : shift_buffer[9]; 
assign data_out[9] = (cnt == 4'b1100) ? TXD8 : shift_buffer[10]; 
assign data_out[10] = (cnt == 4'b1100) ? TXD9 : shift_buffer[11]; 
assign data_out[11] = (cnt == 4'b1100) ? 1'b0 : shift_buffer[0]; 

always @(posedge inthsrecclk)
begin
     SOUT_int = data_out[0];
     shift_buffer[1] = data_out[1];
     shift_buffer[2] = data_out[2];
     shift_buffer[3] = data_out[3];
     shift_buffer[4] = data_out[4];
     shift_buffer[5] = data_out[5];
     shift_buffer[6] = data_out[6];
     shift_buffer[7] = data_out[7];
     shift_buffer[8] = data_out[8];
     shift_buffer[9] = data_out[9];
     shift_buffer[10] = data_out[10];
     shift_buffer[11] = data_out[11];
end


assign  #(refclk_half_period*2*div_i/mult_i) SOUT = SOUT_int;



//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
	$setuphold  (posedge REFCLK, TXD4, 1, 0);
	$setuphold  (posedge REFCLK, TXD5, 1, 0);
	$setuphold  (posedge REFCLK, TXD6, 1, 0);
	$setuphold  (posedge REFCLK, TXD7, 1, 0);
	$setuphold  (posedge REFCLK, TXD8, 1, 0);
	$setuphold  (posedge REFCLK, TXD9, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 

`celldefine 
`timescale 10 ps / 10 ps

module TX_8B10B (TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9,REFCLK,CSLOCK,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "10";
parameter   pll_dly    = "0";
parameter   lock_cyc   = 2;

integer     clockboost;

parameter   IN_FREQ    = "";
parameter   DIV        = "";
parameter   MULT       = "";
parameter   PLL_DLY    = "";

input  TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9;
input  REFCLK;
output SOUT, CSLOCK;

reg   SOUT_int;
wire  SOUT_int1, SOUT;
wire   CSLOCK;

wire   clkin_in;

reg    [9:0] shift_buffer;

wire   inthsrecclk;
wire   intrecclk;

//#########
//## PLL ##
//#########

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   refclk_half_period1;
time   refclk_half_period0;
time   refclk_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = (MULT == "") ? mult : MULT;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = (DIV == "") ? div : DIV;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] pll_dly_r;
real pll_dly_re, pll_dly_re_temp;
initial pll_dly_r = (PLL_DLY == "") ? pll_dly : PLL_DLY;
initial 
      pll_dly_re_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
         pll_dly_re = 0.25 * convert_int(pll_dly_r[7:0]);
      else
         pll_dly_re = pll_dly_re_temp;


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = 0.25 * convert_int(pll_dly_r[7:0]) * 100.0;
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       refclk_half_period0 = ($time - clklock_last_falling_edge);
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       refclk_half_period1 = ($time - clklock_last_rising_edge);
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_dly_re; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
refclk_half_period = (refclk_half_period0 + refclk_half_period1)/2.0; 
end

integer   i, j, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (j = 1; j <= 2* clockboost ; j = j +1)
           begin
                clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
                #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = CLK_OUT_plus_delay;

assign intrecclk = REFCLK;

//########
//## TX ##
//########

reg [3:0] cnt;
wire [9:0] data_out;

initial 
begin
  cnt = 4'b0000;
  shift_buffer = 10'b0000000000;
end

always @(posedge inthsrecclk)
begin
   if (cnt == 4'b1010)
        cnt = 4'b0001;
   else
        cnt = cnt + 1;
end

assign data_out[0] = (cnt == 4'b1010) ? TXD0 : shift_buffer[1]; 
assign data_out[1] = (cnt == 4'b1010) ? TXD1 : shift_buffer[2]; 
assign data_out[2] = (cnt == 4'b1010) ? TXD2 : shift_buffer[3]; 
assign data_out[3] = (cnt == 4'b1010) ? TXD3 : shift_buffer[4]; 
assign data_out[4] = (cnt == 4'b1010) ? TXD4 : shift_buffer[5]; 
assign data_out[5] = (cnt == 4'b1010) ? TXD5 : shift_buffer[6]; 
assign data_out[6] = (cnt == 4'b1010) ? TXD6 : shift_buffer[7]; 
assign data_out[7] = (cnt == 4'b1010) ? TXD7 : shift_buffer[8]; 
assign data_out[8] = (cnt == 4'b1010) ? TXD8 : shift_buffer[9]; 
assign data_out[9] = (cnt == 4'b1010) ? TXD9 : shift_buffer[0]; 

always @(posedge inthsrecclk)
begin
     SOUT_int = data_out[0];
     shift_buffer[1] = data_out[1];
     shift_buffer[2] = data_out[2];
     shift_buffer[3] = data_out[3];
     shift_buffer[4] = data_out[4];
     shift_buffer[5] = data_out[5];
     shift_buffer[6] = data_out[6];
     shift_buffer[7] = data_out[7];
     shift_buffer[8] = data_out[8];
     shift_buffer[9] = data_out[9];
end

assign  #(refclk_half_period*2*div_i/mult_i) SOUT_int1 = SOUT_int;
assign  #(refclk_half_period*2*div_i/mult_i) SOUT = SOUT_int1;

//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
	$setuphold  (posedge REFCLK, TXD4, 1, 0);
	$setuphold  (posedge REFCLK, TXD5, 1, 0);
	$setuphold  (posedge REFCLK, TXD6, 1, 0);
	$setuphold  (posedge REFCLK, TXD7, 1, 0);
	$setuphold  (posedge REFCLK, TXD8, 1, 0);
	$setuphold  (posedge REFCLK, TXD9, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
`timescale 100 fs / 1 fs

module TX_SS_4 (TXD0,TXD1,TXD2,TXD3,REFCLK,CSLOCK,SS_CLKOUT,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "4";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  TXD0,TXD1,TXD2,TXD3;
input  REFCLK;
output SS_CLKOUT, SOUT, CSLOCK;
wire   SS_CLKOUT, SOUT;

wire   RECCLK, CSLOCK;

wire   clkin_in;

reg    [9:0] store_buffer;
reg    [11:0] shift_buffer;

wire   inthsrecclk;
wire   hstxclk;
wire   intrecclk;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end

buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign hstxclk = ~inthsrecclk;

//########
//## TX ##
//########

assign intrecclk = REFCLK;
assign SS_CLKOUT = intrecclk;

wire sload;
reg  intrecclk_d;
reg  intrecclk_2d;

assign sload = intrecclk_d && ~intrecclk_2d;

always @(negedge hstxclk)
begin
     intrecclk_d <= intrecclk;
     intrecclk_2d <= intrecclk_d;
end

always @(posedge intrecclk)
begin
    store_buffer[0] <= TXD0;
    store_buffer[1] <= TXD1;
    store_buffer[2] <= TXD2;
    store_buffer[3] <= TXD3;
end

reg[9:0] store_buffer_d;
always @(negedge hstxclk)
    store_buffer_d <= store_buffer;

assign SOUT = shift_buffer[0];

always @(negedge hstxclk)
if (sload)
    shift_buffer <= {1'b1, 1'b0, store_buffer_d};
else
    shift_buffer <= {1'b0, shift_buffer[11:1]};

//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 


endmodule

`endcelldefine 
`celldefine 
`timescale 100 fs / 1 fs

module TX_SS_6 (TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,REFCLK,CSLOCK,SS_CLKOUT,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "6";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  TXD0,TXD1,TXD2,TXD3,TXD4,TXD5;
input  REFCLK;
output SS_CLKOUT, SOUT, CSLOCK;
wire   SS_CLKOUT, SOUT;

wire   RECCLK, CSLOCK;

wire   clkin_in;

reg    [9:0] store_buffer;
reg    [11:0] shift_buffer;

wire   inthsrecclk;
wire   hstxclk;
wire   intrecclk;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end

buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign hstxclk = ~inthsrecclk;

//########
//## TX ##
//########

assign intrecclk = REFCLK;
assign SS_CLKOUT = intrecclk;

wire sload;
reg  intrecclk_d;
reg  intrecclk_2d;

assign sload = intrecclk_d && ~intrecclk_2d;

always @(negedge hstxclk)
begin
     intrecclk_d <= intrecclk;
     intrecclk_2d <= intrecclk_d;
end

always @(posedge intrecclk)
begin
    store_buffer[0] <= TXD0;
    store_buffer[1] <= TXD1;
    store_buffer[2] <= TXD2;
    store_buffer[3] <= TXD3;
    store_buffer[4] <= TXD4;
    store_buffer[5] <= TXD5;
end

reg[9:0] store_buffer_d;
always @(negedge hstxclk)
    store_buffer_d <= store_buffer;

assign SOUT = shift_buffer[0];

always @(negedge hstxclk)
if (sload)
    shift_buffer <= {1'b1, 1'b0, store_buffer_d};
else
    shift_buffer <= {1'b0, shift_buffer[11:1]};

//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
	$setuphold  (posedge REFCLK, TXD4, 1, 0);
	$setuphold  (posedge REFCLK, TXD5, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 


endmodule

`endcelldefine 
`celldefine 
`timescale 100 fs / 1 fs

module TX_SS_8 (TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,REFCLK,CSLOCK,SS_CLKOUT,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "8";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7;
input  REFCLK;
output SS_CLKOUT, SOUT, CSLOCK;
wire   SS_CLKOUT, SOUT;

wire   RECCLK, CSLOCK;

wire   clkin_in;

reg    [9:0] store_buffer;
reg    [11:0] shift_buffer;

wire   inthsrecclk;
wire   hstxclk;
wire   intrecclk;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end

buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign hstxclk = ~inthsrecclk;

//########
//## TX ##
//########

assign intrecclk = REFCLK;
assign SS_CLKOUT = intrecclk;

wire sload;
reg  intrecclk_d;
reg  intrecclk_2d;

assign sload = intrecclk_d && ~intrecclk_2d;

always @(negedge hstxclk)
begin
     intrecclk_d <= intrecclk;
     intrecclk_2d <= intrecclk_d;
end

always @(posedge intrecclk)
begin
    store_buffer[0] <= TXD0;
    store_buffer[1] <= TXD1;
    store_buffer[2] <= TXD2;
    store_buffer[3] <= TXD3;
    store_buffer[4] <= TXD4;
    store_buffer[5] <= TXD5;
    store_buffer[6] <= TXD6;
    store_buffer[7] <= TXD7;
end

reg[9:0] store_buffer_d;
always @(negedge hstxclk)
    store_buffer_d <= store_buffer;

assign SOUT = shift_buffer[0];

always @(negedge hstxclk)
if (sload)
    shift_buffer <= {1'b1, 1'b0, store_buffer_d};
else
    shift_buffer <= {1'b0, shift_buffer[11:1]};

//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
	$setuphold  (posedge REFCLK, TXD4, 1, 0);
	$setuphold  (posedge REFCLK, TXD5, 1, 0);
	$setuphold  (posedge REFCLK, TXD6, 1, 0);
	$setuphold  (posedge REFCLK, TXD7, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 


endmodule

`endcelldefine 

`celldefine 
`timescale 100 fs / 1 fs

module TX_SS_10 (TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9,REFCLK,CSLOCK,SS_CLKOUT,SOUT);

parameter   in_freq    = "100.0";
parameter   div        = "1";
parameter   mult       = "10";
parameter   pll_dly    = "0.0";
parameter   lock_cyc   = 2;

integer     clockboost;

input  TXD0,TXD1,TXD2,TXD3,TXD4,TXD5,TXD6,TXD7,TXD8,TXD9;
input  REFCLK;
output SS_CLKOUT, SOUT, CSLOCK;
wire   SS_CLKOUT, SOUT;

wire   RECCLK, CSLOCK;

wire   clkin_in;

reg    [9:0] store_buffer;
reg    [11:0] shift_buffer;

wire   inthsrecclk;
wire   hstxclk;
wire   intrecclk;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_half_period;
time   clklock_half_period_minus_dly;

//#########
//## PLL ##
//#########

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [31:0] pll_dly_r;
real pll_dly_re;
initial pll_dly_r = pll_dly;
initial pll_dly_re = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]));

initial begin
  clklock_half_period = 0;
  clockboost     = mult_i/div_i;
  new_delay      = pll_dly_re * 10.0;
end

buf buf_clkin (clkin_in, REFCLK);

integer clklock_rising_edge_count;

initial
begin
        clklock_rising_edge_count = 0;
end

always @(posedge clkin_in) begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in) begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly = clklock_half_period + 10.0 * pll_dly_re; 
end

integer   i, n, clock_count;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count >2 )
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

wire CLK_OUT_sig_2d;
wire CLK_OUT_sig_3d;
wire CLK_OUT_sig_dly;
wire CLK_OUT_plus_delay;

assign #clklock_half_period CLK_OUT_sig_2d = CLK_OUT_sig_d;
assign #clklock_half_period_minus_dly CLK_OUT_sig_3d = CLK_OUT_sig_2d;
assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign CSLOCK = (PLL_LOCK_plus && (pll_dly_re>=0) || PLL_LOCK_minus && (pll_dly_re<0));
assign inthsrecclk = !CSLOCK && clock_out_sig || CSLOCK && (CLK_OUT_plus_delay && (pll_dly_re >=0) || CLK_OUT_sig_3d && (pll_dly_re<0));
assign hstxclk = ~inthsrecclk;

//########
//## TX ##
//########

assign intrecclk = REFCLK;
assign SS_CLKOUT = intrecclk;

wire sload;
reg  intrecclk_d;
reg  intrecclk_2d;

assign sload = intrecclk_d && ~intrecclk_2d;

always @(negedge hstxclk)
begin
     intrecclk_d <= intrecclk;
     intrecclk_2d <= intrecclk_d;
end

always @(posedge intrecclk)
begin
    store_buffer[0] <= TXD0;
    store_buffer[1] <= TXD1;
    store_buffer[2] <= TXD2;
    store_buffer[3] <= TXD3;
    store_buffer[4] <= TXD4;
    store_buffer[5] <= TXD5;
    store_buffer[6] <= TXD6;
    store_buffer[7] <= TXD7;
    store_buffer[8] <= TXD8;
    store_buffer[9] <= TXD9;
end

reg[9:0] store_buffer_d;
always @(negedge hstxclk)
    store_buffer_d <= store_buffer;

assign SOUT = shift_buffer[0];

always @(negedge hstxclk)
if (sload)
    shift_buffer <= {1'b1, 1'b0, store_buffer_d};
else
    shift_buffer <= {1'b0, shift_buffer[11:1]};

//##############
//## function ##
//##############

function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction


specify 

	$setuphold  (posedge REFCLK, TXD0, 1, 0);
	$setuphold  (posedge REFCLK, TXD1, 1, 0);
	$setuphold  (posedge REFCLK, TXD2, 1, 0);
	$setuphold  (posedge REFCLK, TXD3, 1, 0);
	$setuphold  (posedge REFCLK, TXD4, 1, 0);
	$setuphold  (posedge REFCLK, TXD5, 1, 0);
	$setuphold  (posedge REFCLK, TXD6, 1, 0);
	$setuphold  (posedge REFCLK, TXD7, 1, 0);
	$setuphold  (posedge REFCLK, TXD8, 1, 0);
	$setuphold  (posedge REFCLK, TXD9, 1, 0);
 
        (REFCLK => CSLOCK)    =   0:0:0, 0:0:0;
        (REFCLK => SOUT)      =   0:0:0, 0:0:0;
 
endspecify 


endmodule

`endcelldefine 

primitive LAVA1_LATCH_1(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   1    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?1)  1   1      ?       :  ?  :  -  ;
    ?  (0x)  1   1      ?       :  ?  :  -  ;
    0  (x0)  ?   1      ?       :  ?  :  0  ;
    1  (x0)  1   ?      ?       :  ?  :  1  ;
    0  (1x)  1   1      ?       :  0  :  0  ;
    1  (1x)  1   1      ?       :  1  :  1  ;
  (?0)  0    ?   1      ?       :  ?  :  0  ;
  (?1)  0    1   ?      ?       :  ?  :  1  ;
    0  (10)  ?   1      ?       :  ?  :  0  ;
    1  (10)  1   ?      ?       :  ?  :  1  ;
    ?   1    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   1   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   0    ?  (?1)    ?       :  ?  :  0  ;
    1   0   (?1) ?      ?       :  ?  :  1  ;
    1   0    1  (?1)    ?       :  ?  :  1  ;
    0   0   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  -  ;

endtable
 
endprimitive
primitive LAVA1_LATCH_1_X(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   1    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?1)  1   1      ?       :  ?  :  -  ;
    ?  (0x)  1   1      ?       :  ?  :  -  ;
    0  (x0)  ?   1      ?       :  ?  :  0  ;
    1  (x0)  1   ?      ?       :  ?  :  1  ;
    0  (1x)  1   1      ?       :  0  :  0  ;
    1  (1x)  1   1      ?       :  1  :  1  ;
  (?0)  0    ?   1      ?       :  ?  :  0  ;
  (?1)  0    1   ?      ?       :  ?  :  1  ;
    0  (10)  ?   1      ?       :  ?  :  0  ;
    1  (10)  1   ?      ?       :  ?  :  1  ;
    ?   1    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   1   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   0    ?  (?1)    ?       :  ?  :  0  ;
    1   0   (?1) ?      ?       :  ?  :  1  ;
    1   0    1  (?1)    ?       :  ?  :  1  ;
    0   0   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  x  ;
endtable
 
endprimitive
primitive LAVA1_LATCHS_1(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW SYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   1    ?   ?      ?       :  ?  :  -  ;
    ?   0    0   1      ?       :  ?  :  0  ;
    ?   0    1   0      ?       :  ?  :  1  ;
    ?  (?1)  ?   ?      ?       :  ?  :  -  ;
    ?  (0x)  ?   ?      ?       :  ?  :  -  ;
    0  (x0)  ?   1      ?       :  ?  :  0  ;
    1  (x0)  1   ?      ?       :  ?  :  1  ;
    0  (1x)  1   1      ?       :  0  :  0  ;
    1  (1x)  1   1      ?       :  1  :  1  ;
  (?0)  0    ?   1      ?       :  ?  :  0  ;
  (?1)  0    1   ?      ?       :  ?  :  1  ;
    0  (10)  ?   1      ?       :  ?  :  0  ;
    1  (10)  1   ?      ?       :  ?  :  1  ;
    ?   1    ?  (??)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   1   (??) ?      ?       :  ?  :  -  ; // ignore edge on RE
    0   0    ?  (?1)    ?       :  ?  :  0  ;
    1   0   (?1) ?      ?       :  ?  :  1  ;
    1   0    1  (?1)    ?       :  ?  :  1  ;
    0   0   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  -  ;

endtable
 
endprimitive
primitive LAVA1_LATCHS_1_X(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : NEGATIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW SYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   1    ?   ?      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?1)  ?   ?      ?       :  ?  :  -  ;
    ?  (0x)  ?   ?      ?       :  ?  :  -  ;
    0  (x0)  ?   1      ?       :  ?  :  0  ;
    1  (x0)  1   ?      ?       :  ?  :  1  ;
    0  (1x)  1   1      ?       :  0  :  0  ;
    1  (1x)  1   1      ?       :  1  :  1  ;
  (?0)  0    ?   1      ?       :  ?  :  0  ;
  (?1)  0    1   ?      ?       :  ?  :  1  ;
    0  (10)  ?   1      ?       :  ?  :  0  ;
    1  (10)  1   ?      ?       :  ?  :  1  ;
    ?   1    ?  (??)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   1   (??) ?      ?       :  ?  :  -  ; // ignore edge on RE
    0   0    ?  (?1)    ?       :  ?  :  0  ;
    1   0   (?1) ?      ?       :  ?  :  1  ;
    1   0    1  (?1)    ?       :  ?  :  1  ;
    0   0   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  x  ;
endtable
 
endprimitive
primitive LAVA1_LATCHS(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW SYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    ?   ?      ?       :  ?  :  -  ;
    ?   1    0   1      ?       :  ?  :  0  ;
    ?   1    1   0      ?       :  ?  :  1  ;
    ?  (?0)  ?   ?      ?       :  ?  :  -  ;
    ?  (1x)  ?   ?      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    ?  (??)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (??) ?      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  -  ;

endtable
 
endprimitive
primitive LAVA1_LATCHS_X(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW SYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    ?   ?      ?       :  ?  :  -  ;
    ?   1    0   1      ?       :  ?  :  0  ;
    ?   1    1   0      ?       :  ?  :  1  ;
    ?  (?0)  ?   ?      ?       :  ?  :  -  ;
    ?  (1x)  ?   ?      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    ?  (??)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (??) ?      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  x  ;
endtable
 
endprimitive
primitive  LAVA1_DFF_1(Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   (10)      ?       :   0   :   x;  // pessimism
  ?       0      0   (10)      ?       :   0   :   x;  // pessimism
  ?       1      0   (10)      ?       :   0   :   x;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      (10)   0      ?       :   1   :   x;  // pessimism
  ?       0      (10)   0      ?       :   1   :   x;  // pessimism
  ?       1      (10)   0      ?       :   1   :   x;  // pessimism

  1       n      1   1      ?       :   1   :   1;  // reducing pessimism
  0       n      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?1)    ?   ?      ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   -;
 
endtable
endprimitive
primitive  LAVA1_DFF_1_X (Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input D, CLK, R,S, NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   *      ?       :   0   :   0;  // pessimism
  ?       0      0   *      ?       :   0   :   0;  // pessimism
  ?       1      0   *      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      *   0      ?       :   1   :   1;  // pessimism
  ?       0      *   0      ?       :   1   :   1;  // pessimism
  ?       1      *   0      ?       :   1   :   1;  // pessimism

  1       n      1   1      ?       :   1   :   1;  // reducing pessimism
  0       n      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?1)    ?   ?      ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   x;
 
endtable
endprimitive
primitive  LAVA1_DFFS_1_X (Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input D, CLK, R,S, NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              SYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   *      ?       :   0   :   0;  // pessimism
  ?       0      0   *      ?       :   0   :   0;  // pessimism
  ?       1      0   *      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      *   0      ?       :   1   :   1;  // pessimism
  ?       0      *   0      ?       :   1   :   1;  // pessimism
  ?       1      *   0      ?       :   1   :   1;  // pessimism

  1       n      1   1      ?       :   1   :   1;  // reducing pessimism
  0       n      1   1      ?       :   0   :   0;
 
  ?      (10)    0   1      ?       :   ?   :   0;  // synchronous clear
  ?      (10)    1   0      ?       :   ?   :   1;  // synchronous set

  ?      (?1)    ?   ?      ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   x;
 
endtable
endprimitive
primitive  LAVA1_DFFS_1(Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              SYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   (10)      ?       :   0   :   0;  // pessimism
  ?       0      0   (10)      ?       :   0   :   0;  // pessimism
  ?       1      0   (10)      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      (10)   0      ?       :   1   :   1;  // pessimism
  ?       0      (10)   0      ?       :   1   :   1;  // pessimism
  ?       1      (10)   0      ?       :   1   :   1;  // pessimism

  1       n      1   1      ?       :   1   :   1;  // reducing pessimism
  0       n      1   1      ?       :   0   :   0;
 
  ?      (10)    0   1      ?       :   ?   :   0;  // synchronous clear
  ?      (10)    1   0      ?       :   ?   :   1;  // synchronous set

  ?      (?1)    ?   ?      ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   -;
 
endtable
endprimitive
primitive  LAVA1_DFFS(Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              SYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   (10)      ?       :   0   :   0;  // pessimism
  ?       0      0   (10)      ?       :   0   :   0;  // pessimism
  ?       1      0   (10)      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      (10)   0      ?       :   1   :   1;  // pessimism
  ?       0      (10)   0      ?       :   1   :   1;  // pessimism
  ?       1      (10)   0      ?       :   1   :   1;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?      (01)    0   1      ?       :   ?   :   0;  // synchronous clear
  ?      (01)    1   0      ?       :   ?   :   1;  // synchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   -;
 
endtable
endprimitive
primitive  LAVA1_DFFS_X (Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input D, CLK, R,S, NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              SYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   *      ?       :   0   :   0;  // pessimism
  ?       0      0   *      ?       :   0   :   0;  // pessimism
  ?       1      0   *      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      *   0      ?       :   1   :   1;  // pessimism
  ?       0      *   0      ?       :   1   :   1;  // pessimism
  ?       1      *   0      ?       :   1   :   1;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?      (01)    0   1      ?       :   ?   :   0;  // synchronous clear
  ?      (01)    1   0      ?       :   ?   :   1;  // synchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   x;
 
endtable
endprimitive
primitive  LAVA1_DFF_CE_1(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      CE,  //clock enable active high
      NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?   1       ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1   1       ?       :   ?   :   0;  // clocked data

  1       ?      1   *   1       ?       :   1   :   1;  // pessimism
  ?       0      1   *   1       ?       :   1   :   1;  // pessimism
  ?       1      1   *   1       ?       :   1   :   1;  // pessimism

  0       ?      *   1   1       ?       :   0   :   0;  // pessimism
  ?       0      *   1   1       ?       :   0   :   0;  // pessimism
  ?       1      *   1   1       ?       :   0   :   0;  // pessimism

  1       n      1   1   1       ?       :   1   :   1;  // reducing pessimism
  0       n      1   1   1       ?       :   0   :   0;
 
  ?       ?      0   1   ?       ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?       ?       :   ?   :   1;  // asynchronous set

//  ?      (?1)    ?   ?   1       ?       :   ?   :   -;  // ignore rising clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?1)    ?   ?   ?       ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       ?      1   1   0       ?       :   ?   :   -;
  ?	  ?      ?   ?   ?       *       :   ?   :   -;
  ?       ?      1   1   *       ?       :   ?   :   -; 
endtable
endprimitive
primitive  LAVA1_DFF_CE_1_X(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK, D, R,S, CE, NOTIFIER;  //clock enable active high

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER Q(t)    Q(t+1)
       
  1      (10)    1   ?   1      ?:   ?   :   1;  // clocked data
  0      (10)    ?   1   1      ?:   ?   :   0;  // clocked data

  1       ?      1   *   1      ?:   1   :   1;  // pessimism
  ?       0      1   *   1      ?:   1   :   1;  // pessimism
  ?       1      1   *   1      ?:   1   :   1;  // pessimism

  
  0       ?      *   1   1      ?:   0   :   0;  // pessimism
  ?       0      *   1   1      ?:   0   :   0;  // pessimism
  ?       1      *   1   1      ?:   0   :   0;  // pessimism

  1       n      1   1   1      ?:   1   :   1;  // reducing pessimism
  0       n      1   1   1      ?:   0   :   0;
 
  ?       ?      0   1   ?      ?:   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?      ?:   ?   :   1;  // asynchronous set

//  ?      (?1)    ?   ?   1      ?:   ?   :   -;  // ignore rising clock
//  0      (?x)    ?   ?   1      ?:   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1      ?:   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1      ?:   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1      ?:   ?   :   -;  // ignore data edges

  ?      (?1)    ?   ?   ?      ?:   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?   ?      ?:   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?      ?:   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?      ?:   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?      ?:   ?   :   -;  // ignore data edges

  ?       ?      1   1   0      ?:   ?   :   -;
  ?       ?      ?   ?   ?      *:   ?   :   x;
  ?       ?      1   1   *      ?:   ?   :   -; 
 
endtable
endprimitive
primitive  LAVA1_DFFS_CE_1(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      CE,  //clock enable active high
      NOTIFIER;

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW SYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER      Q(t)    Q(t+1)
       
  1      (10)    1   ?   1       ?       :   ?   :   1;  // clocked data
  0      (10)    ?   1   1       ?       :   ?   :   0;  // clocked data

  1       ?      1   *   1       ?       :   1   :   1;  // pessimism
  ?       0      1   *   1       ?       :   1   :   1;  // pessimism
  ?       1      1   *   1       ?       :   1   :   1;  // pessimism

  0       ?      *   1   1       ?       :   0   :   0;  // pessimism
  ?       0      *   1   1       ?       :   0   :   0;  // pessimism
  ?       1      *   1   1       ?       :   0   :   0;  // pessimism

  1       n      1   1   1       ?       :   1   :   1;  // reducing pessimism
  0       n      1   1   1       ?       :   0   :   0;
 
  ?      (10)    0   1   1       ?       :   ?   :   0;  // synchronous clear
  ?      (10)    1   0   1       ?       :   ?   :   1;  // synchronous set

//  ?      (?1)    ?   ?   1       ?       :   ?   :   -;  // ignore rising clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?1)    ?   ?   ?       ?       :   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       ?      ?   ?   0       ?       :   ?   :   -;
  ?	  ?      ?   ?   ?       *       :   ?   :   -;
  ?       ?      ?   ?   *       ?       :   ?   :   -; 
endtable
endprimitive
primitive  LAVA1_DFFS_CE_1_X(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK, D, R,S, CE, NOTIFIER;  //clock enable active high

// FUNCTION : NEGATIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW SYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER Q(t)    Q(t+1)
       
  1      (10)    1   ?   1      ?:   ?   :   1;  // clocked data
  0      (10)    ?   1   1      ?:   ?   :   0;  // clocked data

  1       ?      1   *   1      ?:   1   :   1;  // pessimism
  ?       0      1   *   1      ?:   1   :   1;  // pessimism
  ?       1      1   *   1      ?:   1   :   1;  // pessimism

  
  0       ?      *   1   1      ?:   0   :   0;  // pessimism
  ?       0      *   1   1      ?:   0   :   0;  // pessimism
  ?       1      *   1   1      ?:   0   :   0;  // pessimism

  1       n      1   1   1      ?:   1   :   1;  // reducing pessimism
  0       n      1   1   1      ?:   0   :   0;
 
  ?      (10)    0   1   1      ?:   ?   :   0;  // synchronous clear
  ?      (10)    1   0   1      ?:   ?   :   1;  // synchronous set

//  ?      (?1)    ?   ?   1      ?:   ?   :   -;  // ignore rising clock
//  0      (?x)    ?   ?   1      ?:   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1      ?:   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1      ?:   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1      ?:   ?   :   -;  // ignore data edges

  ?      (?1)    ?   ?   ?      ?:   ?   :   -;  // ignore rising clock
  0      (?x)    ?   ?   ?      ?:   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?      ?:   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?      ?:   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?      ?:   ?   :   -;  // ignore data edges

  ?       ?      ?   ?   0      ?:   ?   :   -;
  ?       ?      ?   ?   ?      *:   ?   :   x;
  ?       ?      ?   ?   *      ?:   ?   :   -; 
 
endtable
endprimitive
primitive  LAVA1_DFFS_CE(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      CE,  //clock enable active high
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW SYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?   1       ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1   1       ?       :   ?   :   0;  // clocked data

  1       ?      1   *   1       ?       :   1   :   1;  // pessimism
  ?       0      1   *   1       ?       :   1   :   1;  // pessimism
  ?       1      1   *   1       ?       :   1   :   1;  // pessimism

  0       ?      *   1   1       ?       :   0   :   0;  // pessimism
  ?       0      *   1   1       ?       :   0   :   0;  // pessimism
  ?       1      *   1   1       ?       :   0   :   0;  // pessimism

  1       p      1   1   1       ?       :   1   :   1;  // reducing pessimism
  0       p      1   1   1       ?       :   0   :   0;
 
  ?      (01)    0   1   1       ?       :   ?   :   0;  // synchronous clear
  ?      (01)    1   0   1       ?       :   ?   :   1;  // synchronous set

//  ?      (?0)    ?   ?   1       ?       :   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   ?       ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       ?      ?   ?   0       ?       :   ?   :   -;
  ?	  ?      ?   ?   ?       *       :   ?   :   -;
  ?       ?      ?   ?   *       ?       :   ?   :   -; 
endtable
endprimitive
primitive  LAVA1_DFFS_CE_X(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK, D, R,S, CE, NOTIFIER;  //clock enable active high

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW SYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER Q(t)    Q(t+1)
       
  1      (01)    1   ?   1      ?:   ?   :   1;  // clocked data
  0      (01)    ?   1   1      ?:   ?   :   0;  // clocked data

  1       ?      1   *   1      ?:   1   :   1;  // pessimism
  ?       0      1   *   1      ?:   1   :   1;  // pessimism
  ?       1      1   *   1      ?:   1   :   1;  // pessimism

  
  0       ?      *   1   1      ?:   0   :   0;  // pessimism
  ?       0      *   1   1      ?:   0   :   0;  // pessimism
  ?       1      *   1   1      ?:   0   :   0;  // pessimism

  1       p      1   1   1      ?:   1   :   1;  // reducing pessimism
  0       p      1   1   1      ?:   0   :   0;
 
  ?      (01)    0   1   1      ?:   ?   :   0;  // synchronous clear
  ?      (01)    1   0   1      ?:   ?   :   1;  // synchronous set

//  ?      (?0)    ?   ?   1      ?:   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1      ?:   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1      ?:   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1      ?:   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1      ?:   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   1      ?:   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   1      ?:   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   1      ?:   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   1      ?:   ?   :   -;  // ignore data edges
  *       0      ?   ?   1      ?:   ?   :   -;  // ignore data edges

  ?       ?      ?   ?   0      ?:   ?   :   -;
  ?       ?      ?   ?   ?      *:   ?   :   x;
  ?       ?      ?   ?   *      ?:   ?   :   -; 
 
endtable
endprimitive

primitive LAVA1_DFF(Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   (10)      ?       :   0   :   x;  // pessimism
  ?       0      0   (10)      ?       :   0   :   x;  // pessimism
  ?       1      0   (10)      ?       :   0   :   x;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      (10)   0      ?       :   1   :   x;  // pessimism
  ?       0      (10)   0      ?       :   1   :   x;  // pessimism
  ?       1      (10)   0      ?       :   1   :   x;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   -;
 
endtable

endprimitive

primitive LAVA1_DFF_CE(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      CE,  //clock enable active high
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?   1       ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1   1       ?       :   ?   :   0;  // clocked data

  1       ?      1   *   1       ?       :   1   :   1;  // pessimism
  ?       0      1   *   1       ?       :   1   :   1;  // pessimism
  ?       1      1   *   1       ?       :   1   :   1;  // pessimism

  0       ?      *   1   1       ?       :   0   :   0;  // pessimism
  ?       0      *   1   1       ?       :   0   :   0;  // pessimism
  ?       1      *   1   1       ?       :   0   :   0;  // pessimism

  1       p      1   1   1       ?       :   1   :   1;  // reducing pessimism
  0       p      1   1   1       ?       :   0   :   0;
 
  ?       ?      0   1   ?       ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?       ?       :   ?   :   1;  // asynchronous set

//  ?      (?0)    ?   ?   1       ?       :   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   ?       ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       r    ?   ?   0       ?       :   ?   :   -;  //added 03/18/03 for bug 16278
  ?       r    ?   ?   x       ?       :   ?   :   -;  //added 03/18/03 for bug 16278

  ?       ?      1   1   0       ?       :   ?   :   -;
  ?	  ?      ?   ?   ?       *       :   ?   :   -;
  ?       ?      1   1   *       ?       :   ?   :   -; 
endtable

endprimitive

primitive LAVA1_DFF_CE_X(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK, D, R,S, CE, NOTIFIER;  //clock enable active high

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER Q(t)    Q(t+1)
       
  1      (01)    1   ?   1      ?:   ?   :   1;  // clocked data
  0      (01)    ?   1   1      ?:   ?   :   0;  // clocked data

  1       ?      1   *   1      ?:   1   :   1;  // pessimism
  ?       0      1   *   1      ?:   1   :   1;  // pessimism
  ?       1      1   *   1      ?:   1   :   1;  // pessimism

  
  0       ?      *   1   1      ?:   0   :   0;  // pessimism
  ?       0      *   1   1      ?:   0   :   0;  // pessimism
  ?       1      *   1   1      ?:   0   :   0;  // pessimism

  1       p      1   1   1      ?:   1   :   1;  // reducing pessimism
  0       p      1   1   1      ?:   0   :   0;
 
  ?       ?      0   1   ?      ?:   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?      ?:   ?   :   1;  // asynchronous set

//  ?      (?0)    ?   ?   1      ?:   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1      ?:   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1      ?:   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1      ?:   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1      ?:   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   ?       ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       r    ?   ?   0       ?       :   ?   :   -;  //added 03/18/03
  ?       r    ?   ?   x       ?       :   ?   :   -;  //added 03/18/03

  ?       ?      1   1   0      ?:   ?   :   -;
  ?       ?      ?   ?   ?      *:   ?   :   x;
  ?       ?      1   1   *      ?:   ?   :   -; 
 
endtable

endprimitive

primitive LAVA1_DFF_X (Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input D, CLK, R,S, NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   *      ?       :   0   :   0;  // pessimism
  ?       0      0   *      ?       :   0   :   0;  // pessimism
  ?       1      0   *      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      *   0      ?       :   1   :   1;  // pessimism
  ?       0      *   0      ?       :   1   :   1;  // pessimism
  ?       1      *   0      ?       :   1   :   1;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   x;
 
endtable

endprimitive

primitive LAVA1_LATCH(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?0)  1   1      ?       :  ?  :  -  ;
    ?  (1x)  1   1      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  -  ;

endtable
 

endprimitive

primitive LAVA1_LATCH_X(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?0)  1   1      ?       :  ?  :  -  ;
    ?  (1x)  1   1      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  x  ;
endtable
 

endprimitive

primitive LAVA1_TFF(Q,CLK,T,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      T,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;


table

// CLK  T      S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?      0   1     ?       : ? :    1;
    ?   ?      *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?      1   0     ?       : ? :    0;
    ?   ?      1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0      1   1     ?       : ? :    -;
    r   1      1   1     ?       : 1 :    0;
    r   1      1   1     ?       : 0 :    1;
    f   ?      ?   ?     ?       : ? :    - ;   
                                   // T  transition cases
    b   *      ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0      1   1     ?       : ? :    -;
    p   0      1   ?     ?       : 0 :    -;
    p   0      ?   1     ?       : 1 :    -;
   (x0) ?      ?   ?     ?       : ? :    -;
   (1x) 0      1   1     ?       : ? :    -;
   (1x) ?      ?   1     ?       : 1 :    -;
     x  0      1   ?     ?       : 0 :    -;
     ?  ?      ?   ?     *       : ? :    -;

endtable

endprimitive

primitive LAVA1_TFF_X(Q,CLK,T,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      T,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;


table

// CLK  T      S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?      0   1     ?       : ? :    1;
    ?   ?      *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?      1   0     ?       : ? :    0;
    ?   ?      1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0      1   1     ?       : ? :    -;
    r   1      1   1     ?       : 1 :    0;
    r   1      1   1     ?       : 0 :    1;
    f   ?      ?   ?     ?       : ? :    - ;   
                                   // T  transition cases
    b   *      ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0      1   1     ?       : ? :    -;
    p   0      1   ?     ?       : 0 :    -;
    p   0      ?   1     ?       : 1 :    -;
   (x0) ?      ?   ?     ?       : ? :    -;
   (1x) 0      1   1     ?       : ? :    -;
   (1x) ?      ?   1     ?       : 1 :    -;
     x  0      1   ?     ?       : 0 :    -;
     ?  ?      ?   ?     *       : ? :    x;
endtable

endprimitive

primitive LAVA_lut_mux2 (o, i0, i1, s0);

output o;
input  i0, i1, s0;

table

//  i0    i1    s0     out;

     0     ?     0  :  0;
     1     ?     0  :  1;
     ?     0     1  :  0;
     ?     1     1  :  1;
     0     0     x  :  0;
     1     1     x  :  1;

endtable

endprimitive


primitive LAVA_lut_mux4 (o, i3, i2, i1, i0, s1, s0);

output o;
input i3, i2, i1, i0;
input s1, s0;

table

//   i3  i2  i1  i0  s1  s0 : o;

     ?   ?   ?   1   0   0  : 1;
     ?   ?   ?   0   0   0  : 0;
     ?   ?   1   ?   0   1  : 1;
     ?   ?   0   ?   0   1  : 0;
     ?   1   ?   ?   1   0  : 1;
     ?   0   ?   ?   1   0  : 0;
     1   ?   ?   ?   1   1  : 1;
     0   ?   ?   ?   1   1  : 0;

     ?   ?   0   0   0   x  : 0;
     ?   ?   1   1   0   x  : 1;
     0   0   ?   ?   1   x  : 0;
     1   1   ?   ?   1   x  : 1;

     ?   0   ?   0   x   0  : 0;
     ?   1   ?   1   x   0  : 1;
     0   ?   0   ?   x   1  : 0;
     1   ?   1   ?   x   1  : 1;

     0   0   0   0   x   x  : 0;
     1   1   1   1   x   x  : 1;

endtable

endprimitive

`celldefine
module L_ABS(Data,
             Result,
             Overflow);

             parameter lpm_type   = "LPM_ABS";
             parameter lpm_width  = 1;

             input  [lpm_width-1:0]   Data;
             output [lpm_width-1:0]   Result;
             output Overflow;

             reg  [lpm_width-1:0] tmp_result;
             reg  [lpm_width-1:0] a_int;
             reg  Overflow;
             integer i;

             always @(Data)
               begin
                 Overflow = 0;
                 if (Data[lpm_width-1] == 1)
                   begin
                     a_int = 0;
                     for (i = 0; i < lpm_width - 1; i = i + 1)
                       a_int[i] = Data[i] ^ 1;
                     tmp_result = (a_int + 1);
                     Overflow = (tmp_result == (1<<(lpm_width-1)));
                   end
                 else tmp_result = Data;
               end

               assign Result = tmp_result;

endmodule // lpm_abs
`endcelldefine

`celldefine
module L_ADD_SUB(Result,
                 DataA,
                 DataB,
                 Cin, 
                 Add_Sub, 
                 Clock, 
                 Aclr, 
                 Cout, 
                 Overflow);

                 parameter lpm_type   = "LPM_ADD_SUB";
                 parameter lpm_width  = 1;
                 parameter lpm_pipeline = 0;
                 parameter lpm_representation = "UNSIGNED";
                 parameter lpm_direction = "UNUSED";

                 input [lpm_width-1:0]   DataA, DataB;
                 input Add_Sub, Cin;
                 input Clock;
                 input Aclr;
                 output [lpm_width-1:0]   Result;
                 output Cout, Overflow;

                 reg  [lpm_width-1:0] tmp_result;
                 reg  [lpm_width-1:0] tmp_result2 [lpm_pipeline:0];
                 reg  [lpm_pipeline:0] tmp_cout2;
                 reg  [lpm_pipeline:0] tmp_overflow2;
                 reg  tmp_cout;
                 reg  tmp_overflow;
                 reg  [lpm_width-2:0] tmp_a, tmp_b;
                 integer i, j, k, n;
                 integer compare, borrow;

                 reg [lpm_width-1:0] dataa_int, datab_int, result_int;

                 always @(Cin or DataA or DataB or Add_Sub)
                 begin
                  begin
                   borrow = Cin?0:1;
                   if (lpm_direction == "ADD" || Add_Sub == 1)
                     begin
                       {tmp_cout, tmp_result} = DataA + DataB + Cin;
                       tmp_overflow = tmp_cout;
                     end
                   else if (lpm_direction == "SUB" || Add_Sub == 0)
                     begin
                       {tmp_overflow, tmp_result} = DataA - DataB - borrow;
                       tmp_cout = (DataA >= (DataB+borrow))?1:0;
                     end

                   if (lpm_representation == "SIGNED")
                     begin
                       if (DataA[lpm_width-1] == 1)
                         begin
                           for (j = 0; j < lpm_width - 1; j = j + 1)
                             tmp_a[j] = DataA[j] ^ 1;
                           dataa_int = (tmp_a + 1) * (-1);
                         end
                       else
                         dataa_int = DataA;

                       if (DataB[lpm_width-1] == 1)
                         begin
                           for (k = 0; k < lpm_width - 1; k = k + 1)
                             tmp_b[k] = DataB[k] ^ 1;
                           datab_int = (tmp_b + 1) * (-1);
                         end
                       else
                         datab_int = DataB;

                       if (lpm_direction == "ADD" || Add_Sub == 1)
                         result_int = dataa_int + datab_int + Cin;
                       else
                         if (lpm_direction == "SUB" || Add_Sub == 0)
                           result_int = dataa_int - datab_int - borrow;
                       tmp_result = result_int;

                       compare = 1 << (lpm_width -1);
                       if ((result_int > (compare -1)) || (result_int < (-1)*(compare)))
                          tmp_overflow = 1;
                       else
                          tmp_overflow = 0;
                     end
                  end
                 end

                 always @(posedge Clock or posedge Aclr)
                 begin
                   if (Aclr)
                     begin
                       for (i = 0; i <= lpm_pipeline; i = i + 1)
                         begin
                           tmp_result2[i] = 'b0;
                           tmp_cout2[i] = 1'b0;
                           tmp_overflow2[i] = 1'b0;
                         end
                     end
                   else
                     begin
                       tmp_result2[lpm_pipeline] = tmp_result;
                       tmp_cout2[lpm_pipeline] = tmp_cout;
                       tmp_overflow2[lpm_pipeline] = tmp_overflow;
                       for (n = 0;  n < lpm_pipeline; n = n + 1)
                         begin
                           tmp_result2[n] = tmp_result2[n+1];
                           tmp_cout2[n] = tmp_cout2[n+1];
                           tmp_overflow2[n] = tmp_overflow2[n+1];
                         end
                     end
                 end

                 assign Result = (lpm_pipeline > 0) ? tmp_result2[0] : tmp_result;
                 assign Cout = (lpm_pipeline > 0) ? tmp_cout2[0] : tmp_cout;
                 assign Overflow = (lpm_pipeline > 0) ? tmp_overflow2[0] : tmp_overflow;

endmodule // lpm_add_sub
`endcelldefine

`celldefine
module L_CLSHIFT(Data,
                 Distance,
                 Direction, 
                 Result, 
                 Overflow, 
                 Underflow);

                 parameter lpm_type   = "LPM_CLSHIFT";
                 parameter lpm_width  = 1;
                 parameter lpm_widthdist  = 1;
                 parameter lpm_shifttype  = 1;

                 input [lpm_width-1:0]   Data;
                 input [lpm_widthdist-1:0]   Distance;
                 input Direction;
                 output [lpm_width-1:0]  Result;
                 output Overflow, Underflow;

                 reg  [lpm_width-1:0] tmp_buf;
                 integer i;

                 always @(Data or Direction or Distance)
                 begin
                   tmp_buf = Data;
                   if ((Direction) && (Distance > 0))
                     begin
                       tmp_buf = (Data >> Distance) | (Data << (lpm_width - Distance));
                     end
                   else if (Distance > 0)
                     begin
                       tmp_buf = (Data << Distance) | (Data >> (lpm_width - Distance));
                     end
                 end

                 assign Result = tmp_buf;

endmodule // lpm_clshift
`endcelldefine

`celldefine
module L_COMPARE(DataA,
                 DataB,
                 AGB, 
                 AGEB, 
                 AEB, 
                 ANEB, 
                 ALB, 
                 ALEB, 
                 Clock, 
                 Aclr); 

                 parameter lpm_type   = "LPM_COMPARE";
                 parameter lpm_width  = 1;
                 parameter lpm_pipeline = 0;
                 parameter lpm_representation = "UNSIGNED";

                 input [lpm_width-1:0]   DataA, DataB;
                 input Clock;
                 input Aclr;
                 output AGB, AGEB, AEB, ANEB, ALB, ALEB;

                 reg  tmp_alb, tmp_aeb, tmp_agb;
                 reg  tmp_aleb, tmp_aneb, tmp_ageb;
                 reg  [lpm_pipeline:0] tmp_alb2, tmp_aeb2, tmp_agb2;
                 reg  [lpm_pipeline:0] tmp_aleb2, tmp_aneb2, tmp_ageb2;
                 reg  [lpm_width-1:0] a_int;
                 reg  [lpm_width-2:0] tmp_a, tmp_b;
                 integer i, j, k, l, m, n, o, p, u, dataa_int, datab_int;

                 always @(DataA or DataB)
                 begin
                   if (lpm_representation == "UNSIGNED")
                     begin
                       dataa_int = DataA[lpm_width-1:0];
                       datab_int = DataB[lpm_width-1:0];
                     end
                   else if (lpm_representation == "SIGNED")
                     begin
                       if (DataA[lpm_width-1] == 1)
                         begin
                           a_int = 0;
                           for (i = 0; i < lpm_width - 1; i = i + 1)
                             a_int[i] = DataA[i] ^ 1;
                           dataa_int = (a_int + 1) * (-1);
                         end
                       else
                         dataa_int = DataA[lpm_width-1:0];

                       if (DataB[lpm_width-1] == 1)
                         begin
                           a_int = 0;
                           for (j = 0; j < lpm_width - 1; j = j + 1)
                             a_int[j] = DataB[j] ^ 1;
                           datab_int = (a_int + 1) * (-1);
                         end
                       else
                         datab_int = DataB[lpm_width-1:0];
                     end
                   tmp_alb = (dataa_int < datab_int);
                   tmp_aeb = (dataa_int ==  datab_int);
                   tmp_agb = (dataa_int > datab_int);
                   tmp_aleb = (dataa_int <= datab_int);
                   tmp_aneb = (dataa_int != datab_int);
                   tmp_ageb = (dataa_int >= datab_int);
                 end

                 always @(posedge Clock or posedge Aclr)
                 begin
                   if (Aclr)
                     begin
                       for (u = 0; u <= lpm_pipeline; u = u + 1)
                         begin
                           tmp_aeb2[u] = 'b0;
                           tmp_agb2[u] = 'b0;
                           tmp_alb2[u] = 'b1;
                           tmp_aleb2[u] = 'b1;
                           tmp_aneb2[u] = 'b1;
                           tmp_ageb2[u] = 'b0;
                         end
                     end
                   else
                     begin
                       tmp_alb2[lpm_pipeline] = tmp_alb;
                       tmp_aeb2[lpm_pipeline] = tmp_aeb;
                       tmp_agb2[lpm_pipeline] = tmp_agb;
                       tmp_aleb2[lpm_pipeline] = tmp_aleb;
                       tmp_aneb2[lpm_pipeline] = tmp_aneb;
                       tmp_ageb2[lpm_pipeline] = tmp_ageb;

                       for (k = 0;  k < lpm_pipeline; k = k + 1)
                         tmp_alb2[k] = tmp_alb2[k+1];
                       for (l = 0;  l < lpm_pipeline; l = l + 1)
                         tmp_aeb2[l] = tmp_aeb2[l+1];
                       for (m = 0;  m < lpm_pipeline; m = m + 1)
                         tmp_agb2[m] = tmp_agb2[m+1];
                       for (n = 0;  n < lpm_pipeline; n = n + 1)
                         tmp_aleb2[n] = tmp_aleb2[n+1];
                       for (o = 0;  o < lpm_pipeline; o = o + 1)
                         tmp_aneb2[o] = tmp_aneb2[o+1];
                       for (p = 0;  p < lpm_pipeline; p = p + 1)
                         tmp_ageb2[p] = tmp_ageb2[p+1];
                     end
                 end

                 assign ALB = (lpm_pipeline > 0) ? tmp_alb2[0] : tmp_alb;
                 assign AEB = (lpm_pipeline > 0) ? tmp_aeb2[0] : tmp_aeb;
                 assign AGB = (lpm_pipeline > 0) ? tmp_agb2[0] : tmp_agb;
                 assign ALEB = (lpm_pipeline > 0) ? tmp_aleb2[0] : tmp_aleb;
                 assign ANEB = (lpm_pipeline > 0) ? tmp_aneb2[0] : tmp_aneb;
                 assign AGEB = (lpm_pipeline > 0) ? tmp_ageb2[0] : tmp_ageb;

endmodule // lpm_compare
`endcelldefine

`celldefine
module L_COUNTER(Q,
                 Data,
                 Clock, 
                 Cin, 
                 Cout, 
                 Clk_En, 
                 Cnt_En, 
                 UpDown, 
                 Aset, 
                 Aclr,
                 Aload,
                 Sset,
                 Sclr,
                 Sload); 

                 parameter lpm_type   = "LPM_COUNTER";
                 parameter lpm_width  = 1;
                 parameter lpm_modulus = 0;
                 parameter lpm_avalue = "UNUSED";
                 parameter lpm_svalue = "UNUSED";
                 parameter lpm_direction = "UNUSED";

                 input [lpm_width-1:0]   Data;
                 input Cin, Clk_En, Cnt_En, UpDown, Clock;
                 input Aset, Aload, Sset, Sclr, Sload, Aclr;
                 output [lpm_width-1:0]  Q;
                 output Cout;

                 reg  [lpm_width-1:0] tmp_count;
                 reg  [lpm_width-1:0] re_start;
                 integer up_limit;


                 always @(posedge Clock or posedge Aclr or posedge Aset or posedge Aload)
                 begin :asyn_block
                   if (Aclr)
                     begin
                       tmp_count = 0;
                     end
                   else if (Aset)
                     begin
                       tmp_count = lpm_avalue;
                     end
                   else if (Aload)
                     begin
                       tmp_count = Data;
                     end
                   else
                     begin :syn_block
                       if (Clk_En)
                         begin
                           if (Sclr)
                             begin :syn_clr
                               tmp_count = 0;
                             end
                           else if (Sset)
                             begin :syn_set
                               tmp_count = lpm_svalue;
                             end
                           else if (Sload)
                             begin :syn_load
                               tmp_count = Data;
                             end
                           else if (Cnt_En)
                             begin
                               up_limit = (lpm_direction == "UP")?(lpm_modulus - 1):0;
                               re_start = (lpm_direction == "UP")?0:(lpm_modulus - 1);
                               if (((tmp_count >= up_limit) && (lpm_direction == "UP")) ||
                                   ((tmp_count == up_limit) && (lpm_direction == "DOWN")) )
                                 tmp_count = re_start;
                               else
                                 tmp_count = (lpm_direction == "UP")?tmp_count+1:tmp_count-1;
                             end
                         end
                     end
                 end

                 assign Q = tmp_count;
endmodule // lpm_counter
`endcelldefine

`celldefine
module L_DECODE(Data,
                Enable,
                EQ, 
                Clock, 
                ClkEn, 
                Aclr);

                parameter lpm_type   = "LPM_DECODE";
                parameter lpm_width  = 1;
                parameter lpm_decodes  = 1;
                parameter lpm_pipeline  = 0;

                input [lpm_width-1:0]   Data;
                input Enable, Clock, ClkEn, Aclr;
                output [lpm_decodes-1:0]  EQ;


                reg  [lpm_decodes-1:0] tmp_eq2 [lpm_pipeline:0];
                reg  [lpm_decodes-1:0] tmp_eq;
                integer  i, j;

                always @(Data or Enable)
                begin
                  tmp_eq = 0;
                  if (Enable)
                    begin
                      if ((Data < lpm_decodes))
                        begin
                          tmp_eq[Data] = 1'b1;
                        end
                      else
                        tmp_eq = 0;
                  end
                end

                always @(posedge Clock or posedge Aclr)
                begin
                  if (Aclr)
                    begin
                      for (i = 0; i <= lpm_pipeline; i = i+1)
                        tmp_eq2[i] = 1'b0;
                    end
                  else
                    begin
                      tmp_eq2[lpm_pipeline] = tmp_eq;
                      for (j = 0; j < lpm_pipeline; j = j+1)
                        tmp_eq2[j] = tmp_eq2[j+1];
                    end
                end

                assign EQ = (lpm_pipeline > 0) ? tmp_eq2[0] : tmp_eq;
endmodule // lpm_decode
`endcelldefine

`celldefine
module L_FIFO(Data,
              Clock, 
              Aclr,
              Sclr,
              RdReq,
              WrReq,
              EDI,
              EDO,
              Full,
              Empty,
              UsedW,
              Q);

             parameter lpm_type   = "LPM_FIFO";
             parameter lpm_width  = 1;
             parameter lpm_widthu  = 1;
             parameter lpm_parity_width  = 0;
             parameter lpm_numwords  = 0;
             parameter lpm_showahead  = "OFF";

             input [lpm_width - 1:0]   Data;
             input [lpm_parity_width - 1:0]   EDI;
             input Clock, Aclr, Sclr, RdReq, WrReq;
             output [lpm_width + lpm_parity_width - 1:0]  Q;
             output [lpm_widthu + lpm_parity_width - 1:0]  UsedW;
             output [lpm_parity_width - 1:0]  EDO;
             output Full, Empty;


             reg  [lpm_widthu + lpm_parity_width - 1:0]  tmp_usedw;
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_q;
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_data;
             reg  [lpm_width + lpm_parity_width - 1:0]   SRAM [lpm_numwords - 1:0];
             integer full_flag,empty_flag;
             integer rdidx,wridx,count;
             integer i,j;

             initial
             begin
               full_flag = 0;
               empty_flag = 1;
               rdidx = 0;
               wridx = 0;
               count = 0;
             end

             always @(posedge Clock or posedge Aclr)
             begin
               if (lpm_parity_width > 0)
                 begin
                   for (i = 0; i < lpm_width; i = i + 1)
                     tmp_data[i] = Data[i];
                   for (j = 0; j < lpm_parity_width; j = j + 1)
                     tmp_data[lpm_width+lpm_parity_width-j-1] = EDI[j];
                 end
               else
                 begin
                     tmp_data = Data;
                 end
               if (Aclr)
                 begin
                   tmp_q = SRAM[rdidx];
                   tmp_usedw = 0;
                   rdidx = 0;
                   wridx = 0;
                   count = 0;
                   full_flag = 0;
                   empty_flag = 1;
                   if (lpm_showahead == "ON")
                      tmp_q = SRAM[0];
                 end
               else
               if (RdReq && WrReq)
                 begin
                   if (full_flag == 0 && empty_flag == 0)
                     begin
                       SRAM[wridx] = tmp_data;
                       if (wridx >= lpm_numwords-1)
                         wridx = 0;
                       else
                         wridx = wridx + 1;
                       tmp_q = SRAM[rdidx]; 
                       if (lpm_showahead == "ON")
                         tmp_q = SRAM[rdidx+1];
                       if (rdidx >= lpm_numwords-1)
                         rdidx = 0;
                       else
                         rdidx = rdidx + 1;
                     end
                 end
               else if (RdReq)
                 begin
                   if (empty_flag == 0)
                     begin
                       tmp_q = SRAM[rdidx]; 
                       full_flag = 0;
                       count = count - 1;
                       if (count < 1)
                         begin
                           empty_flag = 1;
                           count = 0;
                         end
                       if (rdidx >= lpm_numwords-1)
                         begin
                           rdidx = 0;
                           if (lpm_showahead == "ON")
                             tmp_q = SRAM[0]; 
                         end
                       else
                         begin
                           if (lpm_showahead == "ON")
                             tmp_q = SRAM[rdidx+1]; 
                           rdidx = rdidx + 1;
                         end
                     end
                 end
               else if (WrReq)
                 begin
                   if (full_flag == 0)
                     begin
                       SRAM[wridx] = tmp_data; 
                       if (lpm_showahead == "ON")
                         tmp_q = SRAM[rdidx]; 
                       count = count + 1;
                       empty_flag = 0;
                       if (count > lpm_numwords-1)
                         begin
                           full_flag = 1;
                           count = lpm_numwords;
                         end
                       if (wridx >= lpm_numwords-1)
                         wridx = 0;
                       else
                         wridx = wridx + 1;
                     end
                 end

             end

             assign Q = tmp_q;
             assign UsedW = count;
             assign Empty = empty_flag;
             assign Full = full_flag;

endmodule // lpm_fifo
`endcelldefine

`celldefine
module L_MULT(DataA,
                    DataB,
                    Sum, 
                    Result, 
                    Clock, 
                    ClkEn, 
                    Aclr);

                    parameter lpm_type   = "LPM_MULT";
                    parameter lpm_widtha  = 1;
                    parameter lpm_widthb  = 1;
                    parameter lpm_widths  = 1;
                    parameter lpm_widthp  = 1;
                    parameter lpm_pipeline = 0;
                    parameter lpm_representation = "UNUSED";

                    input [lpm_widtha-1:0]   DataA;
                    input [lpm_widthb-1:0]   DataB;
                    input [lpm_widths-1:0]   Sum;
                    input Clock, ClkEn, Aclr;
                    output [lpm_widthp-1:0]  Result;

                    reg  [lpm_widthp-1:0] tmp_result;
                    reg  [lpm_widthp-1:0] tmp_result2 [lpm_pipeline:0];
                    reg  [lpm_widtha-2:0] a_int;
                    reg  [lpm_widthb-2:0] b_int;
                    reg  [lpm_widths-2:0] s_int;
                    reg  [lpm_widthp-2:0] p_reg;
                    reg  [lpm_widthp-1:0] p_int;
                    integer i, j, k, m, n, p, maxs_mn;
                    integer int_datas, int_sum;
                    reg  [lpm_widthp-1:0] int_dataa;
                    reg  [lpm_widthp-1:0] int_datab;
                    reg  [lpm_widthp-1:0] int_result;

                    always @(DataA or DataB or Sum)
                    begin
                      if (lpm_representation == "UNSIGNED")
                        begin
                          int_dataa = DataA;
                          int_datab = DataB;
                          int_sum   = Sum;
                        end
                      else if (lpm_representation == "SIGNED")
                        begin
                          if (DataA[lpm_widtha-1] == 1)
                            begin
                              int_dataa = 0;
                              for (i = 0; i < lpm_widtha - 1; i = i + 1)
                                a_int[i] = DataA[i] ^ 1;
                              int_dataa = (a_int + 1) * (-1);
                            end
                          else int_dataa = DataA;

                          if (DataB[lpm_widthb-1] == 1)
                            begin
                              int_datab = 0;
                              for (j = 0; j < lpm_widthb - 1; j = j + 1)
                                b_int[j] = DataB[j] ^ 1;
                              int_datab = (b_int + 1) * (-1);
                            end
                          else int_datab = DataB;

                          if (Sum[lpm_widths-1] == 1)
                            begin
                              int_sum = 0;
                              for (k = 0; k < lpm_widths - 1; k = k + 1)
                                s_int[k] = Sum[k] ^ 1;
                              int_sum = (s_int + 1) * (-1);
                            end
                          else int_sum = Sum;
                        end
                      else
                        begin
                          int_dataa = {lpm_widtha{1'bx}};
                          int_datab = {lpm_widthb{1'bx}};
                          int_datas = {lpm_widths{1'bx}};
                        end

                      p_int = int_dataa * int_datab;
                      maxs_mn = ((lpm_widtha+lpm_widthb)>lpm_widths)?lpm_widtha+lpm_widthb:lpm_widths;
                      if (lpm_widthp >= maxs_mn)
                        tmp_result = p_int;
                      else
                        begin
                          p_reg = p_int;
                          for (m = 0; m < lpm_widthp; m = m + 1)
                            tmp_result[lpm_widthp-1-m] = p_reg[maxs_mn-1-m];
                        end
                    end

                    always @(posedge Clock or posedge Aclr)
                    begin
                      if (Aclr)
                        begin
                          for (p = 0; p <= lpm_pipeline; p = p + 1)
                            tmp_result2[p] = 'b0;
                        end
                      else
                        begin :syn_block
                          tmp_result2[lpm_pipeline] = tmp_result;
                          for (n = 0;  n < lpm_pipeline; n = n + 1)
                            tmp_result2[n] = tmp_result2[n+1];
                        end
                    end

                    assign Result = (lpm_pipeline > 0) ? tmp_result2[0] : tmp_result;
endmodule // lpm_multiplier
`endcelldefine

`celldefine
module L_MUX(Data,
             Result,
             Sel, 
             Clock, 
             ClkEn, 
             Aclr);

             parameter lpm_type   = "LPM_MUX";
             parameter lpm_width  = 1;
             parameter lpm_size  = 1;
             parameter lpm_widths  = 1;
             parameter lpm_pipeline  = 0;

             input [(lpm_size * lpm_width)-1:0]   Data;
             input [lpm_widths-1:0]   Sel;
             input Clock, ClkEn, Aclr;
             output [lpm_width-1:0]  Result;


             reg  [lpm_width-1:0]  tmp_result;
             reg  [lpm_width-1:0]  tmp_result2 [lpm_pipeline:0];
             integer i, j, m, n;

             always @(Data or Sel)
             begin
               tmp_result = 0;
                for (m=0; m<lpm_width; m=m+1)
                  begin
                    n = Sel * lpm_width + m;
                    tmp_result[m] = Data[n];
                  end
                end

             always @(posedge Clock or posedge Aclr)
             begin
               if (Aclr)
                 begin
                  for (i = 0; i <= lpm_pipeline; i = i+1)
                     tmp_result2[i] = 'b0;
                 end
               else
                 begin
                   tmp_result2[lpm_pipeline] = tmp_result;
                   for (j = 0; j < lpm_pipeline; j = j+ 1)
                     tmp_result2[j] = tmp_result2[j+1];
                 end
               end

             assign Result = (lpm_pipeline > 0) ? tmp_result2[0] : tmp_result;
endmodule // lpm_mux
`endcelldefine

`celldefine
module L_RAM_DP(Data,
                RdAddress, 
                WrAddress,
                RdClock, 
                WrClock,
                RdClken, 
                WrClken,
                RdEn, 
                WrEn,
                EDI,
                EDO,
                Q);

             parameter lpm_type   = "LPM_RAM_DP";
             parameter lpm_file   = "UNKNOWN";
             parameter lpm_width  = 1;
             parameter lpm_parity_width  = 0;
             parameter lpm_numwords  = 0;
             parameter lpm_widthad  = 0;

             input [lpm_width - 1:0]   Data;
             input [lpm_parity_width - 1:0]   EDI;
             input [lpm_widthad  - 1:0]  RdAddress;
             input [lpm_widthad  - 1:0]  WrAddress;
             input RdClock, WrClock, RdClken, WrClken, RdEn, WrEn;
             output [lpm_width + lpm_parity_width - 1:0]  Q;
             output [lpm_parity_width - 1:0]  EDO;


             reg  [lpm_width + lpm_parity_width - 1:0]   SRAM [lpm_numwords - 1:0];
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_data;
             reg  [lpm_width + lpm_parity_width - 1:0]   ONES;
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_result;
             integer i, j;

             initial
             begin
               for (i = 0; i < lpm_width + lpm_parity_width; i = i + 1)
                 ONES[i] = 1'b1;
               for (i = 0; i < lpm_numwords; i = i + 1)
                 SRAM[i] = ONES;
             end

             always @(posedge WrClock)
             begin
               if (lpm_parity_width > 0)
                 begin
                   for (i = 0; i < lpm_width; i = i + 1)
                     tmp_data[i] = Data[i];
                   for (j = 0; j < lpm_parity_width; j = j + 1)
                     tmp_data[lpm_width+lpm_parity_width-j-1] = EDI[j];
                 end
               else
                 begin
                   tmp_data = Data;
                 end
               if (WrEn)
                 begin
                   SRAM[WrAddress] = tmp_data;
                 end

             end

             always @(posedge RdClock)
             begin
               if (RdEn)
                 begin
                   tmp_result = SRAM[RdAddress];
                 end
             end

             always @(RdAddress)
             begin
                 tmp_result = SRAM[RdAddress];
             end

             assign Q = tmp_result;

endmodule // lpm_ram_dp
`endcelldefine



`celldefine
`timescale 1ns/100ps 
`define RD_PULSE_DLY_1 0
`define RD_PULSE_DLY_2 1
`define WR_PULSE_DLY_1 3
`define WR_PULSE_DLY_2 4


module SC_DPRAM_16K_L (
   CENA,CLKA,WRA,CSA,RSTA,DIA,ADA,DOA,
   CENB,CLKB,WRB,CSB,RSTB,DIB,ADB,DOB);

	parameter DEVICE_FAMILY = "LAVA1";
	parameter ADDR_WIDTH_A = 13;
	parameter DATA_WIDTH_A = 2;
	parameter ADDR_WIDTH_B = 14;
	parameter DATA_WIDTH_B = 1;
	parameter ARRAY_SIZE = 16384;    
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input CENA;
	input CLKA;
	input WRA;
	input [1:0] CSA;
	input RSTA;
	input [DATA_WIDTH_A -1:0] DIA;
	input [ADDR_WIDTH_A -1:0] ADA;
	output [DATA_WIDTH_A -1:0] DOA;
	reg [DATA_WIDTH_A -1:0] DOA;
        //wire [DATA_WIDTH_A -1:0] DOA;

	input CENB;
	input CLKB;
	input WRB;
	input [1:0] CSB;
	input RSTB;
	input [DATA_WIDTH_B -1:0] DIB;
	input [ADDR_WIDTH_B -1:0] ADB;
	output [DATA_WIDTH_B -1:0] DOB;
	reg [DATA_WIDTH_B -1:0] DOB;
        //wire [DATA_WIDTH_B -1:0] DOB;


	wire CENA_node;
	wire CLKA_node;
	wire WRA_node;
	wire [1:0] CSA_node;
	wire RSTA_node;
	wire [DATA_WIDTH_A -1:0] DIA_node;
	wire [ADDR_WIDTH_A -1:0] ADA_node;
	wire [DATA_WIDTH_A -1:0] DOA_node;

			
	reg [DATA_WIDTH_A -1:0] DIA_reg;
	reg [ADDR_WIDTH_A -1:0] ADA_reg;
	reg ENA_reg;
	reg RENA_reg;
			
	wire CENB_node;
	wire CLKB_node;
	wire WRB_node;
	wire [1:0] CSB_node;
	wire RSTB_node;
	wire [DATA_WIDTH_B -1:0] DIB_node;
	wire [ADDR_WIDTH_B -1:0] ADB_node;
	wire [DATA_WIDTH_B -1:0] DOB_node;
			
	reg [DATA_WIDTH_B -1:0] DIB_reg;
	reg [ADDR_WIDTH_B -1:0] ADB_reg;
	reg ENB_reg;
	reg RENB_reg;
	integer i;
        integer v_MEM[ARRAY_SIZE-1:0]; 

        //ct042505
	wire CLKA_node_wr_dly_1, CLKA_node_wr_dly_2;
	wire CLKB_node_wr_dly_1, CLKB_node_wr_dly_2; 
	wire CLKA_node_rd_dly_1, CLKA_node_rd_dly_2;
	wire CLKB_node_rd_dly_1, CLKB_node_rd_dly_2;
	reg ENA_pulse, ENB_pulse, RENA_pulse, RENB_pulse;

SC_BRAM_16K_L hInstance(
   .WEA(ENA_pulse),.REA(RENA_pulse),.WEB(ENB_pulse),.REB(RENB_pulse),
   .WADA(ADA_reg),.WDA(DIA_reg), .RADA(ADA_reg),.RDA(DOA_node),
   .WADB(ADB_reg),.WDB(DIB_reg),.RADB(ADB_reg),.RDB(DOB_node)
);

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.ARRAY_SIZE =  ARRAY_SIZE;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;
        initial
        begin
           for(i=0;i<ARRAY_SIZE;i=i+1)
            begin
                v_MEM[i] = 1;
            end
        end

assign CENA_node = CENA;
assign CLKA_node = CLKA;
assign WRA_node  = WRA;
assign CSA_node  = CSA;
assign RSTA_node = RSTA;
assign DIA_node  = DIA;
assign ADA_node  = ADA;

assign CENB_node = CENB;
assign CLKB_node = CLKB;
assign WRB_node  = WRB;
assign CSB_node  = CSB;
assign RSTB_node = RSTB;
assign DIB_node  = DIB;
assign ADB_node  = ADB;

//ct042505
assign #(`RD_PULSE_DLY_1) CLKA_node_rd_dly_1 = CLKA_node;
assign #(`RD_PULSE_DLY_2) CLKA_node_rd_dly_2 = CLKA_node;
assign #(`WR_PULSE_DLY_1) CLKA_node_wr_dly_1 = CLKA_node;
assign #(`WR_PULSE_DLY_2) CLKA_node_wr_dly_2 = CLKA_node;

assign #(`RD_PULSE_DLY_1) CLKB_node_rd_dly_1 = CLKB_node;
assign #(`RD_PULSE_DLY_2) CLKB_node_rd_dly_2 = CLKB_node;
assign #(`WR_PULSE_DLY_1) CLKB_node_wr_dly_1 = CLKB_node;
assign #(`WR_PULSE_DLY_2) CLKB_node_wr_dly_2 = CLKB_node;

/**
assign DOA = DOA_node;
assign DOB = DOB_node;
**/

always @ (posedge CLKA_node or posedge RSTA_node)
begin
   if (RSTA_node)
   begin
      DIA_reg <= 0;
      ADA_reg <= 0;

   end
   else if (CENA_node == 1)
   begin
      DIA_reg <= DIA_node;
      ADA_reg <= ADA_node;
   end
end

always @ (posedge CLKB_node or posedge RSTB_node)
begin
   if (RSTB_node)
   begin
      DIB_reg <= 0;
      ADB_reg <= 0;

   end
   else if (CENB_node == 1)
   begin
      DIB_reg <= DIB_node;
      ADB_reg <= ADB_node;
   end
end

always @ (posedge CLKA_node or posedge RSTA_node )
begin
   if (RSTA_node) 
      ENA_reg <= 0;
   else
      ENA_reg <= CENA_node & WRA_node & CSA_node[0] & CSA_node[1];
end

always @ (posedge CLKB_node or posedge RSTB_node )
begin
   if (RSTB_node) 
      ENB_reg <= 0;
   else
      ENB_reg <= CENB_node & WRB_node & CSB_node[0] & CSB_node[1];
end

always @ (posedge CLKA_node or posedge RSTA_node )
begin
   if (RSTA_node) 
      RENA_reg <= 0;
   else
      RENA_reg <= CENA_node & ~WRA_node & CSA_node[0] & CSA_node[1];
end

always @ (posedge CLKB_node or posedge RSTB_node )
begin
   if (RSTB_node)
      RENB_reg <= 0;
   else
      RENB_reg <= CENB_node & ~WRB_node & CSB_node[0] & CSB_node[1];
end


always @ (posedge CLKA_node_wr_dly_1 or posedge CLKA_node_wr_dly_2
          or posedge RSTA_node  )
begin
   if (RSTA_node | CLKA_node_wr_dly_2)
      ENA_pulse <= 0;
   else 
      ENA_pulse <= CENA_node & WRA_node & CSA_node[0] & CSA_node[1];
end

always @ (posedge CLKB_node_wr_dly_1 or posedge CLKB_node_wr_dly_2 
          or posedge RSTB_node  )
begin
   if (RSTB_node | CLKB_node_wr_dly_2)
      ENB_pulse <= 0;
   else 
      ENB_pulse <= CENB_node & WRB_node & CSB_node[0] & CSB_node[1];
end


always @ (posedge CLKA_node_rd_dly_1 or posedge CLKA_node_rd_dly_2
          or posedge RSTA_node  )
begin
   if (RSTA_node | CLKA_node_rd_dly_2)
      RENA_pulse <= 0;
   else 
      RENA_pulse <= CENA_node & ~WRA_node & CSA_node[0] & CSA_node[1];
end

always @ (posedge CLKB_node_rd_dly_1 or posedge CLKB_node_rd_dly_2 
          or posedge RSTB_node  )
begin
   if (RSTB_node | CLKB_node_rd_dly_2)
      RENB_pulse <= 0;
   else
      RENB_pulse <= CENB_node & ~WRB_node & CSB_node[0] & CSB_node[1];
end


//*****************************************************
// DOA/DOB
//*****************************************************



always @ (RSTA_node or DOA_node or ENA_reg or RENA_reg or DIA_reg) //latch
begin
   if (RSTA_node)
      DOA = 0;
   else if (RENA_reg)
      DOA = DOA_node;
   else if (ENA_reg)
      DOA = DIA_reg;
end

always @ (RSTB_node or DOB_node or ENB_reg or RENB_reg or DIB_reg) //latch
begin
   if (RSTB_node)
      DOB = 0;
   else if (RENB_reg)
      DOB = DOB_node;
   else if (ENB_reg)
      DOB = DIB_reg;
end


endmodule
`endcelldefine




`celldefine
`timescale 1ns / 100ps
module SC_BRAM_16K_L (
   	WEA,REA,WEB,REB,
   	WADA,WDA,RADA,RDA,
   	WADB,WDB,RADB,RDB);

 	parameter  DEVICE_FAMILY = "LAVA1";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

	//integer v_MEM[ARRAY_SIZE - 1:0];
   	reg  [ARRAY_SIZE - 1:0] v_MEM;
	
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j,k,l,m;
	reg [WDATA_WIDTH_A-1:0] bitval;
	reg [WDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/WDATA_WIDTH_A-1];
	reg [WDATA_WIDTH_A-1:0] allOne;
	
	wire [19:0] waddr_a_msb, waddr_a_lsb, waddr_b_msb, waddr_b_lsb;
        wire [19:0] raddr_a_msb, raddr_a_lsb, raddr_b_msb, raddr_b_lsb;
	wire [19:0] wr_a_wr_b_overlap_lsb, wr_a_wr_b_overlap_msb;
	wire [19:0] rd_a_wr_b_overlap_lsb, rd_a_wr_b_overlap_msb;
	wire [19:0] wr_a_rd_b_overlap_lsb, wr_a_rd_b_overlap_msb;

	wire [19:0] wr_a_wr_b_min_lsb, wr_a_wr_b_max_msb;
        wire wr_a_wr_b_collide, wr_a_rd_b_collide, rd_a_wr_b_collide;
	wire valid_wr_a, valid_wr_b, valid_rd_a, valid_rd_b;
     	integer wda_node_bit, wdb_node_bit;

//******************************************************
// Initialize v_MEM
//******************************************************
initial
begin
   for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
      RDA_node[i] = 'bx;
   for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
      RDB_node[i] = 'bx;
   for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
      v_MEM[i] = 1'b1;
   for ( i = 0;i < WDATA_WIDTH_A ; i=i+1 )
      allOne[i] = 1'b1;

   if( MEM_INIT_FLAG == 1 )
   begin
      for ( i = 0 ; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
         VMEMTEMP[i] = allOne;

      $readmemb(MEM_INIT_FILE,VMEMTEMP,0, ARRAY_SIZE/WDATA_WIDTH_A -1);
      for ( i = 0; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
      begin  
         for ( j = 0; j < WDATA_WIDTH_A; j = j + 1)
         begin
            bitval = (1'b1 << j);			
            v_MEM[i*WDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
         end
      end
   end
end
//****************************************************
// Compute lsb/msb of array, collision 
//****************************************************

assign waddr_a_lsb = WADA_node * WDATA_WIDTH_A;
assign waddr_b_lsb = WADB_node * WDATA_WIDTH_B;
assign raddr_a_lsb = RADA_node * RDATA_WIDTH_A;
assign raddr_b_lsb = RADB_node * RDATA_WIDTH_B;

assign waddr_a_msb = waddr_a_lsb + WDATA_WIDTH_A - 1;
assign waddr_b_msb = waddr_b_lsb + WDATA_WIDTH_B - 1;
assign raddr_a_msb = raddr_a_lsb + RDATA_WIDTH_A - 1;
assign raddr_b_msb = raddr_b_lsb + RDATA_WIDTH_B - 1;


assign wr_a_wr_b_collide = (waddr_b_msb >= waddr_a_lsb) && (waddr_a_msb >= waddr_b_lsb);
assign wr_a_rd_b_collide = (raddr_b_msb >= waddr_a_lsb) && (waddr_a_msb >= raddr_b_lsb);
assign rd_a_wr_b_collide = (waddr_b_msb >= raddr_a_lsb) && (raddr_a_msb >= waddr_b_lsb);


assign wr_a_wr_b_overlap_lsb = 
   waddr_a_lsb > waddr_b_lsb ? waddr_a_lsb : waddr_b_lsb;//max

assign wr_a_wr_b_min_lsb =
   waddr_a_lsb < waddr_b_lsb ? waddr_a_lsb : waddr_b_lsb;//min

assign wr_a_wr_b_overlap_msb = 
   waddr_a_msb < waddr_b_msb ? waddr_a_msb : waddr_b_msb;//min

assign wr_a_wr_b_max_msb =
   waddr_a_msb > waddr_b_msb ? waddr_a_msb : waddr_b_msb;//max



assign rd_a_wr_b_overlap_lsb = 
   raddr_a_lsb > waddr_b_lsb ? raddr_a_lsb : waddr_b_lsb;
assign rd_a_wr_b_overlap_msb = 
   raddr_a_msb < waddr_b_msb ? raddr_a_msb : waddr_b_msb;

assign wr_a_rd_b_overlap_lsb = 
   waddr_a_lsb > raddr_b_lsb ? waddr_a_lsb : raddr_b_lsb;
assign wr_a_rd_b_overlap_msb = 
   waddr_a_msb < raddr_b_msb ? waddr_a_msb : raddr_b_msb;

//**************************************************
// Display Warnings Upon Collision
//**************************************************
always @ (valid_wr_a or valid_wr_b or wr_a_wr_b_collide )
begin
   if (valid_wr_a & valid_wr_b & wr_a_wr_b_collide) begin
      $display ("\nsimulation time: ",$time);
      $display ("Write collision. Writing to the same memory location using Port A and Port B");
      //$stop;
   end
end
/***************************
always @ (WEA_node or REB_node or wr_a_rd_b_collide)
begin
   if (WEA_node & wr_a_rd_b_collide) begin
      $display ("\nsimulation time: ",$time);
      $display ("Write/Read collision. Reading from port B the same location port A is writing");
      //$stop;
   end
end

always @ (WEB_node or REA_node or rd_a_wr_b_collide)
begin
   if (WEB_node & rd_a_wr_b_collide) begin
      $display ("\nsimulation time: ",$time);
      $display ("Write/Read collision. Reading from port A the same location port B is writing");
      //$stop;
   end
end

***************************/


assign valid_wr_a = WEA_node & (^WADA_node!==1'bx);
assign valid_wr_b = WEB_node & (^WADB_node!==1'bx);
assign valid_rd_a = REA_node & (^RADA_node!==1'bx);
assign valid_rd_b = REB_node & (^RADB_node!==1'bx);



//**************************************************
// Write 
//**************************************************
always @ ( WEA_node or WEB_node or
           wr_a_wr_b_min_lsb or wr_a_wr_b_max_msb or 
           waddr_a_msb or waddr_a_lsb or
           waddr_b_msb or waddr_b_lsb or
           WDA_node or WDB_node or 
           valid_wr_a or  valid_wr_b
         )
begin
   //----------------------------------------------------
   if (valid_wr_a && (waddr_a_msb > ARRAY_SIZE - 1))
   begin
      $display ("Fatal Error. Write address A exceeds the array boundary ");
      $stop;
   end
   else if (valid_wr_b && (waddr_b_msb > ARRAY_SIZE - 1))
   begin
      $display ("Fatal Error. Write address B exceeds the array boundary ");
      $stop;
   end
   //-----------------------------------------------------   
   if (valid_wr_a & valid_wr_b & wr_a_wr_b_collide)
   begin 
      for ( i = wr_a_wr_b_min_lsb; i < wr_a_wr_b_max_msb + 1; i=i+1 )
      begin
         //bit collided
         if  ( ((i <= waddr_a_msb) && (i >= waddr_a_lsb)) &&
               ((i <= waddr_b_msb) && (i >= waddr_b_lsb))
             ) 
         begin
            $display ("Bit %d collided", i);
            wda_node_bit = i - WADA_node * WDATA_WIDTH_A;
            wdb_node_bit = i - WADB_node * WDATA_WIDTH_B;
            if (WDA_node[wda_node_bit] !=  WDB_node[wdb_node_bit])
            begin
               /////////////$display ("Wrote x to v_MEM[%d]", i);
               v_MEM[i] = 1'bx;
            end
            else
            begin
               ////$display ("Wrote %b to v_MEM[%d]", WDA_node[wda_node_bit],i);
               v_MEM[i] = WDA_node[wda_node_bit];
            end
         end
         //this bit has no collision
         else if ( (i <= waddr_a_msb) && (i >= waddr_a_lsb) )
            v_MEM[i] = WDA_node[wda_node_bit];
         else if ( (i <= waddr_b_msb) && (i >= waddr_b_lsb) )
            v_MEM[i] = WDB_node[wdb_node_bit];

      end
   end 
   //--------------------------------------------
   else 
   begin
      if (valid_wr_a)
      begin
         for (j=0; j<WDATA_WIDTH_A; j = j + 1)
         begin 
            //////////$display ("Port A: Wrote %b to v_MEM[%d]",
                      //////////WDA_node[j], waddr_a_msb+j);
            v_MEM[waddr_a_lsb+j] = WDA_node[j]; 
         end
      end
      if (valid_wr_b)
      begin
         for (k=0; k<WDATA_WIDTH_B; k = k + 1)
         begin
            //////////$display ("Port B: Wrote %b to v_MEM[%d]",
                      /////////////WDB_node[k], waddr_b_msb+k);
            v_MEM[waddr_b_lsb+k] = WDB_node[k];   
         end
      end
   end 
   //-------------------------------------------- 
end //always
//**************************************************
// Read
//**************************************************

always @ (valid_rd_a or v_MEM or raddr_a_msb or raddr_a_lsb) //ct101305
begin
   if (valid_rd_a)
   begin
      if (raddr_a_msb > ARRAY_SIZE - 1)
      begin
         $display ("Fatal Error. Read address A exceeds the array boundary ");
         $stop;
      end
      else
      begin
         for (l=0; l < RDATA_WIDTH_A;l=l+1)
            RDA_node[l] = v_MEM[raddr_a_lsb+l];
      end
   end
end

always @ (valid_rd_b or v_MEM or raddr_b_msb or raddr_b_lsb) //ct101305
begin
   if (valid_rd_b)
   begin
      if (raddr_b_msb > ARRAY_SIZE - 1)
      begin
         $display ("Fatal Error. Read address B exceeds the array boundary ");
         $stop;
      end
      else
      begin
         for (m=0; m < RDATA_WIDTH_B;m=m+1)
            RDB_node[m] = v_MEM[raddr_b_lsb+m];
      end
   end
end


//**************************************************
// Endmodule
//**************************************************
endmodule
`endcelldefine


//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

`celldefine

module L_RAM_DPX(
           QA,
           QB,
           DataInA,
           AddressA,
           DataInB,
           AddressB,
           ClockA,
           ClockEnA,
           ClockB,
           ClockEnB,
           WrA,
           WrB,
           ResetA,
           ResetB);
 
           parameter lpm_type = "LPM_RAM_DPX";
	   parameter lpm_widtha     = 1;
	   parameter lpm_widthada   = 1;
	   parameter lpm_numwordsa  = 1;
	   parameter lpm_widthb     = 1;
	   parameter lpm_widthadb   = 1;
   	   parameter lpm_numwordsb  = 1;
  	   parameter lpm_indata     = "REGISTERED";
	   parameter lpm_outdata    = "REGISTERED";
    	   parameter lpm_addressa_control  = "UNREGISTERED";
	   parameter lpm_addressb_control  = "UNREGISTERED";
	   parameter lpm_hint = "UNUSED";
	   parameter lpm_init_file = "";

           output [lpm_widtha-1:0] QA;
           output [lpm_widthb-1:0] QB;
           input [lpm_widtha-1:0] DataInA;
           input [lpm_widthada-1:0] AddressA;
           input [lpm_widthb-1:0] DataInB;
           input [lpm_widthadb-1:0] AddressB;
           input ClockA,ClockEnA,ClockB,ClockEnB,WrA,WrB,ResetA,ResetB;

           parameter lpm_init_flag = (lpm_init_file == "") ? 0 : 1 ;


           wire [lpm_widtha-1:0] QA_int;
           wire [lpm_widthb-1:0] QB_int;
           reg [lpm_widtha-1:0] QA_int_reg;
           reg [lpm_widthb-1:0] QB_int_reg;
           reg [lpm_widtha-1:0] QA;
           reg [lpm_widthb-1:0] QB;

           wire [1:0] csa,csb;
           assign csa = 2'b11;
           assign csb = 2'b11;

          always @ (posedge ClockA or posedge ResetA)
            begin
               if (ResetA)
                 QA_int_reg = 0;
               else
                 QA_int_reg = QA_int;
            end

          always @ (posedge ClockB or posedge ResetB)
            begin
               if (ResetB)
                 QB_int_reg = 0;
               else
                 QB_int_reg = QB_int;
            end

          always @ (QA_int or QA_int_reg)
            begin
              if(ResetA)
                     QA = 0;
              else if(lpm_outdata == "REGISTERED" && lpm_addressa_control == "UNREGISTERED")
                     QA = QA_int;
              else if(lpm_outdata == "REGISTERED" && lpm_addressa_control == "REGISTERED")
                     QA = QA_int_reg;
            end
     

          always @ (QB_int or QB_int_reg)
            begin
              if(ResetB)
                     QB = 0;
              else if(lpm_outdata == "REGISTERED" && lpm_addressb_control == "UNREGISTERED")
                     QB = QB_int;
              else if(lpm_outdata == "REGISTERED" && lpm_addressb_control == "REGISTERED")
                     QB = QB_int_reg;
            end
                    

//	SC_DP_RAM INST_U0(.CENA(ClockEnA),
	SC_DPRAM_16K_L INST_U0(.CENA(ClockEnA),
                          .CLKA(ClockA),
                          .WRA(WrA),
                          .CSA(csa),
                          .RSTA(ResetA),
			  .DIA(DataInA),
                          .ADA(AddressA),
                          .DOA(QA_int),
                          .CENB(ClockEnB),
                          .CLKB(ClockB),
                          .WRB(WrB),
                          .CSB(csb),
                          .RSTB(ResetB),
                          .DIB(DataInB),
                          .ADB(AddressB),
                          .DOB(QB_int));

	defparam INST_U0.ADDR_WIDTH_A = lpm_widthada;
	defparam INST_U0.DATA_WIDTH_A = lpm_widtha;
	defparam INST_U0.ADDR_WIDTH_B = lpm_widthadb;
	defparam INST_U0.DATA_WIDTH_B = lpm_widthb;
	defparam INST_U0.MEM_INIT_FILE = lpm_init_file;
	defparam INST_U0.MEM_INIT_FLAG = lpm_init_flag;
        defparam INST_U0.ARRAY_SIZE=lpm_numwordsa*lpm_widtha;

endmodule // lpm_cam

`endcelldefine
`celldefine
module L_RAM_DQ(Data,
                Address, 
                InClock, 
                OutClock,
                WE,
                EDI,
                EDO,
                Q);

             parameter lpm_type   = "LPM_RAM_DQ";
             parameter lpm_file   = "init_file";
             parameter lpm_width  = 1;
             parameter lpm_parity_width  = 1;
             parameter lpm_numwords  = 1;
             parameter lpm_widthad  = 1;

             input [lpm_width - 1:0]   Data;
             input [lpm_parity_width - 1:0]   EDI;
             input [lpm_widthad  - 1:0]  Address;
             input InClock, OutClock, WE;
             output [lpm_width + lpm_parity_width - 1:0]  Q;
             output [lpm_parity_width - 1:0]  EDO;


             reg  [lpm_width + lpm_parity_width - 1:0]   SRAM [lpm_numwords - 1:0];
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_data;
             reg  [lpm_width + lpm_parity_width - 1:0]   ONES;
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_result;
             integer i, j;

             initial
             begin
               for (i = 0; i < lpm_width + lpm_parity_width; i = i + 1)
                 ONES[i] = 1'b1;
               for (i = 0; i < lpm_numwords; i = i + 1)
                 SRAM[i] = ONES;
             end

             always @(posedge InClock or posedge OutClock)
             begin
               if (lpm_parity_width > 0)
                 begin
                   for (i = 0; i < lpm_width; i = i + 1)
                     tmp_data[i] = Data[i];
                   for (j = 0; j < lpm_parity_width; j = j + 1)
                     tmp_data[lpm_width+lpm_parity_width-j-1] = EDI[j];
                 end
               else
                 begin
                   tmp_data = Data;
                 end
               if (WE)
                 begin
                   if (InClock)
                      SRAM[Address] = tmp_data;
                 end
               else
                 begin
                   if (OutClock)
                     tmp_result = SRAM[Address];
                   else
                     tmp_result = SRAM[Address];
                 end

             end

             assign Q = tmp_result;

endmodule // lpm_ram_dq
`endcelldefine

`celldefine
module L_ROM(Address,  
             OutClock,
             MemEnab,
             EDO,
             Q);

             parameter lpm_type   = "LPM_ROM";
             parameter lpm_file   = "init_file";
             parameter lpm_width  = 1;
             parameter lpm_parity_width  = 1;
             parameter lpm_numwords  = 1;
             parameter lpm_widthad  = 1;

             input [lpm_widthad  - 1:0]  Address;
             input OutClock, MemEnab;
             output [lpm_width + lpm_parity_width - 1:0]  Q;
             output [lpm_parity_width - 1:0]  EDO;


             reg  [lpm_width - 1:0]   SROM [lpm_numwords - 1:0];
             reg  [lpm_width + lpm_parity_width - 1:0]   tmp_result;
             reg  [lpm_width - 1:0]   temp_result;
             reg  [lpm_width + lpm_parity_width - 1:0]   ALLZ;
             integer i, j;



             initial
             begin
               for (i = 0; i < lpm_width + lpm_parity_width; i = i + 1)
                 ALLZ[i] = 1'bz;
             end

             initial
             begin
               $readmemb(lpm_file, SROM, 0, lpm_numwords-1);
             end

             always @(posedge OutClock)
             begin
               if (MemEnab)
                 begin
                     temp_result = SROM[Address];
                     if (lpm_parity_width > 0)
                       begin
                         for (i = 0; i < lpm_width; i = i + 1)
                           tmp_result[i] = temp_result[i];
                         for (j = 0; j < lpm_parity_width; j = j + 1)
                           tmp_result[lpm_width+lpm_parity_width-j-1] = EDO[j];
                       end
                 end
               else  tmp_result = ALLZ;
             end

             assign Q = tmp_result;

endmodule // lpm_rom
`endcelldefine

`celldefine
module L_SHIFTREG(Data,
                  Clock,
                  Enable, 
                  ShiftIn, 
                  Load, 
                  Q, 
                  ShiftOut, 
                  Aset, 
                  Aclr, 
                  Sset, 
                  Sclr); 

                  parameter lpm_type   = "LPM_SHIFTREG";
                  parameter lpm_width  = 1;
                  parameter lpm_shift_value  = 0;
                  parameter lpm_avalue  = "UNUSED";
                  parameter lpm_svalue  = "UNUSED";
                  parameter lpm_direction  = "LEFT";

                 input [lpm_width-1:0]   Data;
                 input Clock, Enable, ShiftIn, Load, Aset, Aclr, Sset, Sclr;
                 output [lpm_width-1:0]  Q;
                 output ShiftOut;

                 reg  [lpm_width-1:0] tmp_q;
                 reg  [lpm_width-1:0] tmp_q2 [lpm_shift_value:0];
                 reg  tmp_q3 [lpm_shift_value:0];
                 reg  abit, tmp_q1;
                 wire  tmp_shiftout, tmp_shiftout1;
                 integer i, j;


                 always @(posedge Clock or posedge Aclr or posedge Aset)
                 begin :asyn_block
                   if (Aclr)
                     begin
                       tmp_q = 0;
                       for (i = 0; i <= lpm_shift_value; i = i + 1)
                           tmp_q2[i] = 0;
                     end
                   else if (Aset)
                     begin
                       tmp_q = lpm_avalue;
                       for (i = 0; i <= lpm_shift_value; i = i + 1)
                           tmp_q2[i] = lpm_avalue;
                     end
                   else
                     begin :syn_block
                       if (Enable)
                         begin
                           if (Sclr)
                             begin
                               tmp_q = 0;
                               for (i = 0; i <= lpm_shift_value; i = i + 1)
                                   tmp_q2[i] = 0;
                             end
                           else if (Sset)
                             begin
                               tmp_q = lpm_svalue;
                               for (i = 0; i <= lpm_shift_value; i = i + 1)
                                   tmp_q2[i] = lpm_svalue;
                             end
                           else if (Load)
                             begin
                               tmp_q = Data;
                             end
                           // else if (!Load)
                           else
                             begin
                               if (lpm_direction == "LEFT")
                                 begin
                                   {abit, tmp_q} = {tmp_q, ShiftIn};
                                   tmp_q2[lpm_shift_value] = tmp_q;
                                   for (j = 0; j < lpm_shift_value; j = j + 1)
                                       tmp_q2[j] = tmp_q2[j+1];
                                   {abit, tmp_q1} = {tmp_q1, ShiftIn};
                                   tmp_q3[lpm_shift_value] = tmp_q1;
                                   for (j = 0; j < lpm_shift_value; j = j + 1)
                                       tmp_q3[j] = tmp_q3[j+1];
                                 end
                               else if (lpm_direction == "RIGHT")
                                 begin
                                   {tmp_q, abit} = {ShiftIn, tmp_q};
                                   for (j = 0; j < lpm_shift_value; j = j + 1)
                                       tmp_q2[j] = tmp_q2[j+1];
                                 end
                             end
                         end
                     end
                 end

                 assign tmp_shiftout = (lpm_direction == "LEFT") ? tmp_q[lpm_width-1]:tmp_q[0];
                 assign tmp_shiftout1 = tmp_q3[0];
                 assign Q = (lpm_shift_value > 0) ? tmp_q2[0] : tmp_q;
                 assign ShiftOut = (lpm_shift_value > 0) ? tmp_shiftout1 : tmp_shiftout;
endmodule // lpm_shiftreg
`endcelldefine

/* New set of L model*/
`celldefine

`timescale 1ns / 100ps
module SC_BRAM_16K_L_SYNC (WCLK, RCLK, WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,
                           WADB,WDB,RADB,RDB, RESET);

   parameter  DEVICE_FAMILY = "LAVA1";
   parameter  MEM_INIT_FLAG = "";
   parameter  MEM_INIT_FILE = 0;

   parameter  WADDR_WIDTH_A = 14;
   parameter  RADDR_WIDTH_A = 12;
   parameter  WADDR_WIDTH_B = 14;
   parameter  RADDR_WIDTH_B = 12;
   parameter  WDATA_WIDTH_A = 1;
   parameter  RDATA_WIDTH_A = 4;
   parameter  WDATA_WIDTH_B = 1;
   parameter  RDATA_WIDTH_B = 4;
   parameter  ARRAY_SIZE = 262144;

   input      WCLK, RCLK, RESET;
   input      WEA,REA,WEB,REB;
   input [WADDR_WIDTH_A -1:0] WADA;
   input [WDATA_WIDTH_A -1:0] WDA ;
   input [RADDR_WIDTH_A -1:0] RADA;
   output [RDATA_WIDTH_A -1:0] RDA ;
   input [WADDR_WIDTH_B -1:0]  WADB;
   input [WDATA_WIDTH_B -1:0]  WDB ;
   input [RADDR_WIDTH_B -1:0]  RADB;
   output [RDATA_WIDTH_B -1:0] RDB ;

   wire                        WEA_node,REA_node,WEB_node,REB_node;
   wire [WADDR_WIDTH_A -1:0]   WADA_node;
   wire [WDATA_WIDTH_A -1:0]   WDA_node;
   wire [RADDR_WIDTH_A -1:0]   RADA_node;
   reg [RDATA_WIDTH_A -1:0]    RDA_node;

   wire [WADDR_WIDTH_B -1:0]   WADB_node;
   wire [WDATA_WIDTH_B -1:0]   WDB_node;
   wire [RADDR_WIDTH_B -1:0]   RADB_node;
   reg [RDATA_WIDTH_B -1:0]    RDB_node;

   assign                      WADA_node = WADA;
   assign                      WEA_node  = WEA;
   assign                      WDA_node  = WDA;
   assign                      RADA_node = RADA;
   assign                      REA_node  = REA;
   assign                      RDA       = RDA_node;
   
   assign                      WADB_node = WADB;
   assign                      WEB_node  = WEB;
   assign                      WDB_node  = WDB;
   assign                      RADB_node = RADB;
   assign                      REB_node  = REB;
   assign                      RDB       = RDB_node;

   integer                     v_MEM[ARRAY_SIZE*WDATA_WIDTH_A - 1:0];
   
   integer                     v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
   integer                     wr_address_collision;
   integer                     flag1[3:0],loopCount1, loopCount2;
   integer                     bitval;

   reg [WDATA_WIDTH_A-1:0]     VMEMTEMP[0:ARRAY_SIZE-1];
   

   // Mimic the power on initial state of the RAM
   initial begin
      // Clear all of the A side read addresses to 'x'
      for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_A ;
            loopCount1=loopCount1+1)
         RDA_node[loopCount1] = 'bx;
      // Clear all of the B side read addresses to 'x'
      for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B ;
            loopCount1=loopCount1+1)
         RDB_node[loopCount1] = 'bx;
      // Clear the memory cells to '0'
      for (loopCount1 = 0;loopCount1 < ARRAY_SIZE ;
           loopCount1=loopCount1+1)
         v_MEM[loopCount1] = 'b1;

      // The user has requested the memory be filled with a
      // specific pattern.  Initialize that data here.
      if( MEM_INIT_FLAG == 1 )
         begin
            for (loopCount1 = 0 ; loopCount1 < ARRAY_SIZE;
                 loopCount1=loopCount1+1)
               VMEMTEMP[loopCount1] = 'b1;

            $readmemb(MEM_INIT_FILE,VMEMTEMP,0, ARRAY_SIZE-1);
            for (loopCount1 = 0; loopCount1 < ARRAY_SIZE;
                 loopCount1=loopCount1+1)
               for (loopCount2 = 0; loopCount2 < WDATA_WIDTH_A;
                    loopCount2 = loopCount2 + 1)
                  begin
                     bitval = (1'b1 << loopCount2);                   
                     v_MEM[loopCount1*WDATA_WIDTH_A+loopCount2] = 
                          (VMEMTEMP[loopCount1] & bitval)>>loopCount2;
                  end
         end // if ( MEM_INIT_FLAG == 1 )
   end // initial begin
   
   always @(posedge(WCLK))
      begin
         v_WADDR_A = WADA_node;
         v_WADDR_B = WADB_node;  

         wr_address_collision = 0;

         if(v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
            (v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B)
            wr_address_collision = 1;
         else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A)
            wr_address_collision = 1;
         else if (v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A &&
                  (v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B)
            wr_address_collision = 1;
         else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
                  (v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A)
            wr_address_collision = 1;
         
 
         if (wr_address_collision != 0 && WEA_node == 1 && WEB_node == 1)
            begin
               $display ("\nsimulation time: ",$time);
               $display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
               $stop;
            end

         for ( loopCount1 = 0; loopCount1 < 4 ; loopCount1=loopCount1+1 )
            flag1[loopCount1] = 0;
         
         // Check to see if there is 'x' or 'z' on the bus.
         if (^WADA_node === 1'bx )
            begin
               flag1[0] = 1;
            end
         if (^WADB_node === 1'bx )
            begin
               flag1[1] = 1;
            end


         if (WEA_node == 1)
            begin: signal1
               if(flag1[0] == 1)
                  disable signal1;
               if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A)
                  begin
                     $display ("Fatal Error. Write address A exceeds the array boundary ");
                     $stop;
                  end

               for (loopCount1 = 0; loopCount1 < WDATA_WIDTH_A; 
                    loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_A*WDATA_WIDTH_A+loopCount1] = 
                          WDA_node[loopCount1];
                  end
            end

         if (WEB_node == 1)
            begin: signal2
               if(flag1[1] == 1)
                  disable signal2;

               if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_B)
                  begin
                     $display ("Fatal Error. Write address B exceeds the array boundary ");
                     $stop;
                  end

               for (loopCount1 = 0; loopCount1 < WDATA_WIDTH_B;
                    loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_B*WDATA_WIDTH_B+loopCount1] =
                          WDB_node[loopCount1];
                  end
            end // block: signal2
      end // always @ (posedge(WCLK))
   
   always @ (posedge(RCLK))
      begin
         v_RADDR_A = RADA_node;  
         v_RADDR_B = RADB_node;  
         if (^RADA_node === 1'bx)
            begin
               if (REA_node != 1)
                  for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_A; 
                       loopCount1=loopCount1+1 )
                     RDA_node[loopCount1] = 'bx;      
               flag1[2] = 1;
            end
         if (^RADB_node === 1'bx )
            begin
               if (REB_node != 1)
                  for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_B; 
                       loopCount1=loopCount1+1 )
                     RDB_node[loopCount1] = 'bx;      
               flag1[3] = 1;
            end


         if (REA_node == 1)
            begin: signal3
               if(flag1[2] == 1)
                  disable signal3;
               if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A
                   - WDATA_WIDTH_A)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end
               for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_A;
                    loopCount1=loopCount1+1 )
                  begin
                     RDA_node[loopCount1] <= 
                         v_MEM[v_RADDR_A*RDATA_WIDTH_A+loopCount1];
                  end
            end // block: signal3
        // else
        //    RDA_node <= 'bx;
   

         if (REB_node == 1)
            begin: signal4
               if(flag1[3] == 1)
                  disable signal4;

               if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_B)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end
               for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B; loopCount1=loopCount1+1 )
                  begin
                     RDB_node[loopCount1] <= 
                         v_MEM[v_RADDR_B*RDATA_WIDTH_B+loopCount1];
                  end
            end // block: signal4
      end // always @ (posedge(RCLK))

endmodule

`endcelldefine

`timescale 1ns / 100ps
module SC_BRAM_PDP_16K_L (WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,WADB,WDB,RADB,RDB);

	parameter  DEVICE_FAMILY = "LAVA1";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

	integer v_MEM[ARRAY_SIZE - 1:0];
	
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j;
	reg [RDATA_WIDTH_A-1:0] bitval;
	reg [RDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/RDATA_WIDTH_A-1];
	reg [RDATA_WIDTH_A-1:0] allOne;
	

	initial	begin
		for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
			RDA_node[i] = 'bx;
		for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
			RDB_node[i] = 'bx;
		for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
			v_MEM[i] = 1'b1;
		for ( i = 0;i < RDATA_WIDTH_A ; i=i+1 )
			allOne[i] = 1'b1;


		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < ARRAY_SIZE/RDATA_WIDTH_A; i = i + 1)
				VMEMTEMP[i] = allOne;

			$readmemb(MEM_INIT_FILE,VMEMTEMP);
			for ( i = 0; i < ARRAY_SIZE/RDATA_WIDTH_A; i = i + 1)
				for ( j = 0; j < RDATA_WIDTH_A; j = j + 1)
				begin
					bitval = (1'b1 << j);			
					v_MEM[i*RDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
				end
		end
	end
		
	always @(WADA_node or WEA_node or WDA_node or RADA_node or REA_node or WADB_node or WEB_node or WDB_node or RADB_node or REB_node)
	begin
		v_WADDR_A = WADA_node;
		v_WADDR_B = WADB_node;	
		v_RADDR_A = RADA_node;	
		v_RADDR_B = RADB_node;	

		flag = 0;

		if(v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B)
			flag = 1;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A)
			flag = 2;
		else if (v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B)
			flag = 3;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A)
			flag = 4;
			

		if (flag != 0 && WEA_node == 1 && WEB_node == 1)
		   begin
			$display ("\nsimulation time: ",$time);
			$display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
			$stop;
		   end

		for ( i = 0; i < 4 ; i = i + 1 )
			flag1[i] = 0;
		
		if (^WADA_node === 1'bx ) // if there is 'x' or 'z' in the bit of the bus.
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port A is invalid.");
				flag1[0] = 1;
			end
		if (^WADB_node === 1'bx )
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port B is invalid.");
				flag1[1] = 2;
			end
		if (^RADA_node === 1'bx )
			begin
				if (REA_node != 1)
					for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
						RDA_node[i] = 'bx;	
//				$display ("\nRead address of port A is invalid.");
				flag1[2] = 3;
			end
		if (^RADB_node === 1'bx )
			begin
				if (REB_node != 1)
					for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
						RDB_node[i] = 'bx;	
//				$display ("\nRead address of port B is invalid.");
				flag1[3] = 4;
			end


		if (WEA_node == 1)
			begin: signal1
				if(flag1[0] == 1)
					disable signal1;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port A...");
				$display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
				//if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - WDATA_WIDTH_A)

				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - 1)
//				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_A)
					begin
						$display ("Fatal Error. Write address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_A; i=i+1 )
					begin
						v_MEM[v_WADDR_A*WDATA_WIDTH_A+i] = WDA_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+i);
						$display ("WDA_node[%d] = %b",i,WDA_node[i]);
`endif
					end
			end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port A disabled");
			end
`endif

		if (WEB_node == 1)
			begin: signal2
				if(flag1[1] == 2)
					disable signal2;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port B...");
				$display ("Writing address from %d -- %d",v_WADDR_B*WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
				//if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - WDATA_WIDTH_B)
				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - 1)
//				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_B)
					begin
						$display ("Fatal Error. Write address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_B; i=i+1 )
					begin
						v_MEM[v_WADDR_B*WDATA_WIDTH_B+i] = WDB_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+i);
						$display ("WDB_node[%d] = %b",i,WDB_node[i]);
`endif
					end
		end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port B disabled");
			end
`endif

		if (REA_node == 1)
			begin: signal3
				if(flag1[2] == 3)
					disable signal3;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port A...");
				$display ("Reading address from %d -- %d",v_RADDR_A*RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif

				//if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - WDATA_WIDTH_A)
				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - 1)
//				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_A)
					begin
						$display ("Fatal Error. Read address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
					begin
						RDA_node[i] = v_MEM[v_RADDR_A*RDATA_WIDTH_A+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+i);
						$display ("RDA_node[%d] = %b",i,RDA_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port A disabled.");
				$display ("Reading address from %d -- %d",v_RADDR_B*RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
//				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
//					RDA_node[i] = 'bx;	
			end


		if (REB_node == 1)
			begin: signal4
				if(flag1[3] == 4)
					disable signal4;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port B...");
`endif
				//if (v_RADDR_A*RDATA_WIDTH_B > ARRAY_SIZE - WDATA_WIDTH_B)
				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE - 1)
//				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_B - WDATA_WIDTH_B)
					begin
						$display ("Fatal Error. Read address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
					begin
					RDB_node[i] = v_MEM[v_RADDR_B*RDATA_WIDTH_B+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+i);
						$display ("RDB_node[%d] = %b",i,RDB_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port B disabled.");
`endif

//				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
//					RDB_node[i] = 'bx;
			end
						
	end

endmodule

`celldefine

`timescale 1ns / 100ps

`timescale 1ns / 100ps

module READ_POINTER_CTRL (GLOBAL_RST,RESET_RP,READ_EN,READ_CLK,
                          EMPTY_FLAG,READ_POINTER,TERMINAL_COUNT,
                          READ_POINTER_WRAPPED, WRITE_POINTER, 
                          WRITE_POINTER_WRAPPED);

   parameter RPOINTER_WIDTH = 9;

   input     GLOBAL_RST;
   input     RESET_RP;
   input     READ_EN;
   input     READ_CLK;
   input     EMPTY_FLAG;
   input     [RPOINTER_WIDTH -1:0] WRITE_POINTER;
   input                           WRITE_POINTER_WRAPPED;
   input     [RPOINTER_WIDTH -1:0] TERMINAL_COUNT;
   output    [RPOINTER_WIDTH -1:0] READ_POINTER;
   output                          READ_POINTER_WRAPPED;

   reg [RPOINTER_WIDTH -1:0]       READ_POINTER_reg;
   reg                             WRAPPED_STATE;
   
   assign                          READ_POINTER = READ_POINTER_reg;
   assign                          READ_POINTER_WRAPPED = WRAPPED_STATE;

   always @(GLOBAL_RST or RESET_RP)
      begin
         if (GLOBAL_RST == 1 || RESET_RP == 1)
            begin
               assign READ_POINTER_reg = 0;
               assign WRAPPED_STATE = 0;
            end
         else
            begin
               deassign READ_POINTER_reg;
               deassign WRAPPED_STATE;
            end
      end
   
   always @(posedge READ_CLK)
      begin

         if (READ_EN == 1 && EMPTY_FLAG != 0)
            begin
               if (READ_POINTER_reg == TERMINAL_COUNT)
                  begin
                     // Wrap around to first memory location
                     READ_POINTER_reg <= 0;
                     WRAPPED_STATE <= ~WRAPPED_STATE;
                  end
               else if ((READ_POINTER_reg != WRITE_POINTER) || 
                        (READ_POINTER_WRAPPED != WRITE_POINTER_WRAPPED))
                  // if the read pointer has not met up with the write
                  // pointer, increment the read pointer.
                  READ_POINTER_reg <= READ_POINTER_reg + 1;
            end // if (READ_EN == 1 && EMPTY_FLAG != 0)
      end

endmodule
`timescale 1ns / 100ps
module WRITE_POINTER_CTRL (GLOBAL_RST,WRITE_EN,WRITE_CLK,FULL_FLAG,
                           WRITE_POINTER,TERMINAL_COUNT,WRITE_POINTER_WRAPPED);

   parameter WPOINTER_WIDTH = 9;
   parameter WDATA_WIDTH = 32;

   input     GLOBAL_RST;
   input     WRITE_EN;
   input     WRITE_CLK;
   input     FULL_FLAG;
   input [WPOINTER_WIDTH -1:0] TERMINAL_COUNT;
   output [WPOINTER_WIDTH -1:0] WRITE_POINTER;
   output                       WRITE_POINTER_WRAPPED;

   reg [WPOINTER_WIDTH -1:0]    WRITE_POINTER_reg;
   reg                          WRAPPED_STATE;
   
   assign                       WRITE_POINTER = WRITE_POINTER_reg;
   assign                       WRITE_POINTER_WRAPPED = WRAPPED_STATE;

   always @(GLOBAL_RST)
      begin
         if (GLOBAL_RST == 1)
            begin
               assign WRITE_POINTER_reg = 0;
               assign WRAPPED_STATE = 0;
            end
         else
            begin
               deassign WRITE_POINTER_reg;
               deassign WRAPPED_STATE;
            end
      end // always @ (GLOBAL_RST)

   always @(posedge WRITE_CLK)
      begin
         if (WRITE_EN == 1 && FULL_FLAG != 1)
            if (WRITE_POINTER_reg == TERMINAL_COUNT)
               begin
                  WRITE_POINTER_reg <= 0;
                  WRAPPED_STATE <= ~WRAPPED_STATE;
               end
            else 
               WRITE_POINTER_reg <= WRITE_POINTER_reg + 1;
      end // always @ (posedge WRITE_CLK)


endmodule
`timescale 1ns / 100ps
module FLAG_LOGIC (R_POINTER,W_POINTER,GLOBAL_RST,READ_EN,READ_CLK,WRITE_EN,
                   WRITE_CLK,WRITE_POINTER_WRAPPED, READ_POINTER_WRAPPED,
                   FULL_D,EMPTY_D,AMFULL_D,AMEMPTY_D);

   parameter POINTER_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter AMFULL_X = 1;
   parameter AMEMPTY_Y = 1;
   parameter TERMINAL_COUNT = 1;
   

   input [POINTER_WIDTH -1:0] R_POINTER;
   input [POINTER_WIDTH -1:0] W_POINTER;

   input                      GLOBAL_RST;
   input                      READ_EN;
   input                      READ_CLK;
   input                      WRITE_EN;
   input                      WRITE_CLK;

   input                      WRITE_POINTER_WRAPPED;
   input                      READ_POINTER_WRAPPED;

   output                     FULL_D;
   output                     EMPTY_D;
   output                     AMFULL_D;
   output                     AMEMPTY_D;
   
   reg                        FULL_D_reg;
   reg                        EMPTY_D_reg;
   reg                        AMFULL_D_reg;
   reg                        AMEMPTY_D_reg;

   wire                       full_node;
   wire                       empty_node;
   wire                       aempty_node;
   wire                       afull_node;

   assign                     FULL_D    = READ_EN ? full_node : FULL_D_reg;
   assign                     AMFULL_D  = READ_EN ? afull_node : AMFULL_D_reg;
   assign                     EMPTY_D   = EMPTY_D_reg;
   assign                     AMEMPTY_D = AMEMPTY_D_reg;

   always @(GLOBAL_RST)
      begin
         if (GLOBAL_RST == 1)
            begin
               assign EMPTY_D_reg = 1'b0;
               assign AMEMPTY_D_reg = 1'b0;
               assign FULL_D_reg = 1'b0;
               assign AMFULL_D_reg = 1'b0;
            end
         else
            begin
               deassign EMPTY_D_reg;
               deassign AMEMPTY_D_reg;
               deassign FULL_D_reg;
               deassign AMFULL_D_reg;
            end
      end
   
   assign full_node  = fifo_full(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                 R_POINTER, W_POINTER, TERMINAL_COUNT,
                                 WRITE_EN);

   assign afull_node = fifo_afull(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                  R_POINTER, W_POINTER, AMFULL_X,
                                  TERMINAL_COUNT);
   
   assign empty_node = fifo_empty(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                  R_POINTER, W_POINTER, TERMINAL_COUNT,
                                  READ_EN);

   assign aempty_node = fifo_aempty(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                    R_POINTER, W_POINTER, AMEMPTY_Y,
                                    TERMINAL_COUNT, READ_EN);
   
   always @(posedge(WRITE_CLK))
      begin
         FULL_D_reg <= full_node;
         AMFULL_D_reg <= afull_node;
     end

   always @(posedge(READ_CLK))
      begin
         EMPTY_D_reg    <= empty_node;
         AMEMPTY_D_reg  <= aempty_node;
      end

   function fifo_full;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        WRITE_EN;
      
      parameter FIFO_FULL = 1'b1;
      parameter FIFO_N_FULL = 1'b0;
      begin
         if (WP == TERMINAL_COUNT)
            begin
               // Write pointer is about to wrap around, so
               // WP+1 == 0.  Also since this is the last entry, and
               // has already been determined as being writable
               // (i.e. wasn't already FULL) the wrapped pointers by
               // default do not match.  So there is no need to
               // compare them for mis-match.  Thus if RP == 0 then
               // the WP has caught up to the RP.
               if ((RP == 0) && WRITE_EN)
                  fifo_full = FIFO_FULL;
               else if ((RP == WP) && (RP_W != WP_W))
                  fifo_full = FIFO_FULL;
               else
                  fifo_full = FIFO_N_FULL;
            end
         else
            begin
               // check to see if the write pointer has caught up to
               // the read pointer.  If it has then signal the fifo is
               // FULL.
               if ((RP == WP+1) && WRITE_EN)
                  fifo_full = FIFO_FULL;
               else if ((RP == WP) && (RP_W != WP_W))
                  fifo_full = FIFO_FULL;
               else
                  fifo_full = FIFO_N_FULL;
            end
      end
      
   endfunction

   function fifo_afull;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] AFULL_THRESHOLD;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      
      parameter F_AFULL = 1'b1;
      parameter F_NOT_AFULL = 1'b0;
      begin
         if (RP_W != WP_W)
            begin
               // we need to do calculations comparing the read
               // pointer and write pointer across the end/begin fifo
               // boundary.
               if (RP - WP <= AFULL_THRESHOLD)
                  fifo_afull = F_AFULL;
               else
                  fifo_afull = F_NOT_AFULL;
            end // if (RP_W != WP_W)
         else
            if (TERMINAL_COUNT - (WP - RP) <= AFULL_THRESHOLD)
               fifo_afull = F_AFULL;
            else
               fifo_afull = F_NOT_AFULL;
      end
      
   endfunction

   function fifo_empty;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        READ_EN;
      
      
      parameter F_EMPTY = 1'b0;
      parameter F_NOT_EMPTY = 1'b1;
      begin
         if (RP == TERMINAL_COUNT)
            begin
               // Read pointer is about to wrap around, so
               // RP+1 == 0.  Also since this is the last entry, and
               // the FIFO was not empty on the last clock, by default
               // the write pointer has wrapped.  So there is no need to
               // compare the wrapped flags.  Thus if WP == 0 then
               // the RP has caught up to the WP.
               if ((WP == 0) && READ_EN)
                  fifo_empty = F_EMPTY;
               else if ((RP_W == WP_W) && (WP == RP))
                  fifo_empty = F_EMPTY;
               else
                  fifo_empty = F_NOT_EMPTY;
            end
         else
            begin
               // check to see if the read pointer has caught up to
               // the write pointer.  If it has then signal the fifo is
               // EMPTY.
               if ((RP_W == WP_W) && (WP == RP))
                  // The write and read pointers match exactly, so the
                  // fifo is EMPTY
                  fifo_empty = F_EMPTY;
               else if ((RP_W == WP_W) && (WP == RP+1) && READ_EN)
                  // the read pointer just caught up with the write
                  // pointer, so the fifo is EMPTY
                  fifo_empty = F_EMPTY;
               else
                  fifo_empty = F_NOT_EMPTY;
            end // else: !if(RP == TERMINAL_COUNT)
      end
      
   endfunction

   function fifo_aempty;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] AEMPTY_THRESHOLD;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        READ_EN;
      
      parameter F_AEMPTY = 1'b0;
      parameter F_NOT_AEMPTY = 1'b1;
      begin
         if (READ_EN)
            begin
               if (RP_W != WP_W)
                  begin
                     // Calculations required due to the WP wrapping
                     // around the end of the fifo.
                     if ((TERMINAL_COUNT + 1 - RP) + WP <=
                         AEMPTY_THRESHOLD + 1)
                        fifo_aempty = F_AEMPTY;
                     else
                        fifo_aempty = F_NOT_AEMPTY;
                  end // if (RP_W != WP_W)
               else
                  if (WP - RP <= AEMPTY_THRESHOLD + 1)
                     fifo_aempty = F_AEMPTY;
                  else
                     fifo_aempty = F_NOT_AEMPTY;
            end // if (READ_EN)
         else
            begin
               if (RP_W != WP_W)
                  begin
                     // we need to do calculations comparing the read
                     // pointer and write pointer across the end/begin fifo
                     // boundary.
                     if ((TERMINAL_COUNT + 1 - RP) + WP > AEMPTY_THRESHOLD)
                        fifo_aempty = F_NOT_AEMPTY;
                     else
                        fifo_aempty = F_AEMPTY;
                  end // if (RP_W != WP_W)
               else
                  // Degenerate case where both pointers have not wrapped
                  if (WP - RP > AEMPTY_THRESHOLD)
                     fifo_aempty = F_NOT_AEMPTY;
                  else
                     fifo_aempty = F_AEMPTY;
            end // else: !if(READ_EN)
      end
   endfunction

endmodule

//**********************************************************************************************
//** SC_FIFO_DC_16K_L 
//**********************************************************************************************
`timescale 1ns / 100ps
`define NUM_SYNC_STAGES  2
`define ACTIVE_HIGH_EMPTY 1

module SC_FIFO_DC_16K_L (WE,WCLK,RST,RPRST,RE,RCLK,FULLIN,EMPTYIN,DI,FULL,EMPTY,AMFULL,AMEMPTY,DO);
   parameter DEVICE_FAMILY = "LAVA1";
   parameter TERMINAL_COUNT = 511;
   parameter ADDR_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter ALMOST_FULL_X = 1;
   parameter ALMOST_EMPTY_Y = 1;

   input     WE;
   input     WCLK;
   input     RST;
   input     RPRST;
   input     RE;
   input     RCLK;
   input     FULLIN;
   input     EMPTYIN;
   input [DATA_WIDTH -1:0] DI;

   output                  FULL;
   output                  EMPTY;
   output                  AMFULL;
   output                  AMEMPTY;
   output [DATA_WIDTH -1:0] DO;



//----------------------------------------------------------------------------
// REG WIRE DECLARATIONS
//----------------------------------------------------------------------------
reg	[ADDR_WIDTH:0]		wptr_wrap_appended, rptr_wrap_appended;
//wire	[ADDR_WIDTH:0]		wptr_wrap_appended, rptr_wrap_appended;

wire	[ADDR_WIDTH-1:0]	wptr, rptr;
wire				wptr_wrap_bit, rptr_wrap_bit;

wire	[ADDR_WIDTH:0]		next_cycle_num_empty_loc, next_cycle_num_unread_loc ;
wire	[ADDR_WIDTH:0]		next_wptr_wrap_appended, next_rptr_wrap_appended;
wire	[ADDR_WIDTH-1:0]	next_wptr, next_rptr;


wire	we_ram, re_ram;
reg	full_bit, empty_bit, am_full_bit, am_empty_bit;
wire	[ADDR_WIDTH:0]		DEPTH = TERMINAL_COUNT + 1;

reg	[ADDR_WIDTH:0]		wptr_wrap_appended_rdomain;
reg	[ADDR_WIDTH:0]		rptr_wrap_appended_wdomain;
wire	[ADDR_WIDTH-1:0]		wptr_rdomain, rptr_wdomain;
wire	wptr_wrap_bit_rdomain,  rptr_wrap_bit_wdomain; 

reg	[ADDR_WIDTH:0]		rptr_wsync1, wptr_rsync1;

//----------------------------------------------------------------------------
// ASSIGNMENTS
//----------------------------------------------------------------------------

assign we_ram = WE & ~full_bit;
assign re_ram = RE & ~empty_bit;

assign wptr = wptr_wrap_appended [ADDR_WIDTH-1:0];
assign rptr = rptr_wrap_appended [ADDR_WIDTH-1:0];
assign wptr_wrap_bit = wptr_wrap_appended[ADDR_WIDTH];
assign rptr_wrap_bit = rptr_wrap_appended[ADDR_WIDTH];

assign next_wptr_wrap_appended = next_ptr(wptr_wrap_bit, wptr, TERMINAL_COUNT, we_ram);
assign next_rptr_wrap_appended = next_ptr(rptr_wrap_bit, rptr, TERMINAL_COUNT, re_ram);
assign next_wptr = next_wptr_wrap_appended [ADDR_WIDTH-1:0];
assign next_rptr = next_rptr_wrap_appended [ADDR_WIDTH-1:0];
assign next_wptr_wrap_bit = next_wptr_wrap_appended[ADDR_WIDTH];
assign next_rptr_wrap_bit = next_rptr_wrap_appended[ADDR_WIDTH];

assign wptr_rdomain = wptr_wrap_appended_rdomain[ADDR_WIDTH-1:0];
assign rptr_wdomain = rptr_wrap_appended_wdomain[ADDR_WIDTH-1:0];
assign wptr_wrap_bit_rdomain = wptr_wrap_appended_rdomain[ADDR_WIDTH];
assign rptr_wrap_bit_wdomain = rptr_wrap_appended_wdomain[ADDR_WIDTH];

/******************************************************************
assign num_empty_loc = (rptr_wrap_bit_wdomain == wptr_wrap_bit) ?
   (DEPTH + rptr_wdomain) - wptr:
   {1'b0, rptr_wdomain - wptr};
assign num_unread_loc = (wptr_wrap_bit_rdomain != rptr_wrap_bit) ?
   (DEPTH + wptr_rdomain) - rptr:
   {1'b0, wptr_rdomain - rptr};
*****************************************************************/

//----------------------------------------------------------------------------
// FLAG LOGIC
//----------------------------------------------------------------------------
//used by full flag
assign next_cycle_num_empty_loc = (rptr_wrap_bit_wdomain == next_wptr_wrap_bit) ?
   (DEPTH + rptr_wdomain) - next_wptr:
   {1'b0, rptr_wdomain - next_wptr};
//used by empty flag
assign next_cycle_num_unread_loc = (wptr_wrap_bit_rdomain != next_rptr_wrap_bit) ?
   (DEPTH + wptr_rdomain) - next_rptr:
   {1'b0, wptr_rdomain - next_rptr};

/****************************************************
assign full_bit = (num_empty_loc == 0);
assign empty_bit = (num_unread_loc == 0);

assign am_full_bit = (num_empty_loc <= ALMOST_FULL_X);
assign am_empty_bit = (num_unread_loc <= ALMOST_EMPTY_Y);
****************************************************/
always @ (posedge WCLK or posedge RST)
begin
   if (RST) begin
      full_bit <= 0;
      am_full_bit = 0;
   end
   else begin
      full_bit <= #1 (next_cycle_num_empty_loc == 0);
      am_full_bit <=  #1 (next_cycle_num_empty_loc <= ALMOST_FULL_X);
   end
end

always @ (posedge RCLK or posedge RST)
begin
   if (RST) begin
      empty_bit <= 1;
      am_empty_bit = 1;
   end
   else begin
      empty_bit <= #1 (next_cycle_num_unread_loc == 0);
      am_empty_bit <=  #1 (next_cycle_num_unread_loc <= ALMOST_EMPTY_Y);
   end
end

assign FULL = full_bit;
assign EMPTY = `ACTIVE_HIGH_EMPTY ? empty_bit : ~empty_bit;
assign AMFULL = am_full_bit;
assign AMEMPTY = (`ACTIVE_HIGH_EMPTY  == 1) ? am_empty_bit : ~am_empty_bit;

//----------------------------------------------------------------------------
// WRITE/READ POINTERS
//----------------------------------------------------------------------------
always @ (posedge WCLK or posedge RST)
   if (RST)
      wptr_wrap_appended <= 0;
   else if (WE & ~full_bit)
      wptr_wrap_appended <= #1 next_wptr_wrap_appended;

always @ (posedge RCLK or posedge RST)
   if (RST)
      rptr_wrap_appended <= 0;
   else if (RE & ~empty_bit)
      rptr_wrap_appended <= #1 next_rptr_wrap_appended;

//*****************************************************************************
// POINTER SYNCHRONIZATIONS: SIMPLY DONE TO MATCH GATE-LEVEL MODEL 
//*****************************************************************************
always @ (posedge WCLK or posedge RST) begin
   if (RST) begin
      rptr_wrap_appended_wdomain <= 0;
      rptr_wsync1 <= 0;
   end
   else begin
      rptr_wsync1 <= #1 rptr_wrap_appended;
      case (`NUM_SYNC_STAGES)
         1: rptr_wrap_appended_wdomain <= #1 rptr_wrap_appended;
         2: rptr_wrap_appended_wdomain <= #1 rptr_wsync1;
         default: rptr_wrap_appended_wdomain <= #1 rptr_wsync1;  
      endcase
   end
end

always @ (posedge RCLK or posedge RST) begin
   if (RST) begin
      wptr_wrap_appended_rdomain <= 0;
      wptr_rsync1 <= 0;
   end
   else begin
      wptr_rsync1 <= #1 wptr_wrap_appended;
      case (`NUM_SYNC_STAGES)
         1: wptr_wrap_appended_rdomain <= #1 wptr_wrap_appended;
         2: wptr_wrap_appended_rdomain <= #1 wptr_rsync1;
         default: wptr_wrap_appended_rdomain <= #1 wptr_rsync1;  
      endcase
   end
end


//*****************************************************************************
// FUNCTIONS
//*****************************************************************************

function [ADDR_WIDTH:0] next_ptr;
input ptr_wrap_bit;
input [ADDR_WIDTH-1:0] ptr;
input [ADDR_WIDTH-1:0] TERMINAL_COUNT;
input add;

begin
   if (ptr == TERMINAL_COUNT)  begin
      if (add) begin
         next_ptr = {~ptr_wrap_bit, {ADDR_WIDTH{1'b0}}}; //add 1
      end
      else begin
         next_ptr = {ptr_wrap_bit, ptr};//don't add 1;
      end
   end
   else begin
      next_ptr = {ptr_wrap_bit, ptr} + add;
   end
end
endfunction


//*****************************************************************************
// MEMORY INSTANTIATIONS
//*****************************************************************************
SC_BRAM_16K_L_SYNC FIFO_BRAM_INST(
	.WADA(wptr),
	.WEA(we_ram),
	.WDA(DI),
	.RADA(rptr),
	.REA(re_ram),
	.RDA(DO),

	.WADB(wptr),
	.WEB(1'b0),
	.WDB(DI),
	.RADB(rptr),
	.REB(1'b0),
	.RDB(),

	.WCLK(WCLK),
	.RCLK(RCLK),
	.RESET(RST)
); 


   defparam FIFO_BRAM_INST.WADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.MEM_INIT_FILE = "";
   defparam FIFO_BRAM_INST.MEM_INIT_FLAG = 0;
   defparam FIFO_BRAM_INST.ARRAY_SIZE = TERMINAL_COUNT+1;




endmodule

//***************************************************************************
module SC_FIFO_16K_L (WE,WCLK,RST,RPRST,RE,RCLK,FULLIN,EMPTYIN,DI,FULL,EMPTY,AMFULL,AMEMPTY,DO);
   parameter DEVICE_FAMILY = "LAVA1";
   parameter TERMINAL_COUNT = 511;
   parameter ADDR_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter ALMOST_FULL_X = 1;
   parameter ALMOST_EMPTY_Y = 1;

   input     WE;
   input     WCLK;
   input     RST;
   input     RPRST;
   input     RE;
   input     RCLK;
   input     FULLIN;
   input     EMPTYIN;
   input [DATA_WIDTH -1:0] DI;

   output                  FULL;
   output                  EMPTY;
   output                  AMFULL;
   output                  AMEMPTY;
   output [DATA_WIDTH -1:0] DO;

   reg [DATA_WIDTH -1:0]    DI_reg;
   reg                      FULLIN_reg;
   reg                      EMPTYIN_reg;

   wire                     WE_node;
   wire                     RE_node;
   wire                     FULL_node;
   wire                     EMPTY_node;
   wire                     AMFULL_node;
   wire                     AMEMPTY_node;
   wire [DATA_WIDTH -1:0]   DO_node;

   reg                      WE_reg;
   reg                      RE_reg;
   reg [ADDR_WIDTH - 1 : 0] TC_node;

   wire [ADDR_WIDTH -1:0]   RP_node;
   wire [ADDR_WIDTH -1:0]   WP_node;

   wire                     READ_POINTER_WRAPPED;
   wire                     WRITE_POINTER_WRAPPED;

   assign                   WE_node = WE & !FULL_node;
   assign                   RE_node = RE & EMPTY_node;
   assign                   FULL = FULL_node;
   assign                   AMFULL = AMFULL_node;
   assign                   EMPTY = EMPTY_node;
   assign                   AMEMPTY = AMEMPTY_node;
   
   assign                   DO = DO_node;    

   initial begin 
      TC_node = TERMINAL_COUNT;
   end
   
   always @(RST)
      begin
         if (RST == 1)
            begin
               assign DI_reg = 'b0;
               assign FULLIN_reg = 1'b0;
               assign EMPTYIN_reg = 1'b0;
               assign WE_reg = 1'b0;
               assign RE_reg = 1'b0;
            end
         else
            begin
               deassign DI_reg;
               deassign FULLIN_reg;
               deassign EMPTYIN_reg;
               deassign WE_reg;
               deassign RE_reg;
            end
      end
   
   always @(posedge WCLK)
      begin
         DI_reg <= DI;
         FULLIN_reg <= FULLIN;
         WE_reg <= WE_node;
      end

   always @(posedge RCLK)
      begin
         EMPTYIN_reg <= EMPTYIN;
         RE_reg <= RE_node;
      end

   READ_POINTER_CTRL FIFO_RPC_INST(.GLOBAL_RST(RST),
                                   .RESET_RP(RPRST),
                                   .READ_EN(RE_node),
                                   .READ_CLK(RCLK),
                                   .EMPTY_FLAG(EMPTY),
                                   .READ_POINTER(RP_node),
                                   .TERMINAL_COUNT(TC_node),
                                   .READ_POINTER_WRAPPED(READ_POINTER_WRAPPED),
                                   .WRITE_POINTER(WP_node),
                                   .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));
   defparam FIFO_RPC_INST.RPOINTER_WIDTH = ADDR_WIDTH;

   WRITE_POINTER_CTRL FIFO_WPC_INST(.GLOBAL_RST(RST),
                                    .WRITE_EN(WE_node),
                                    .WRITE_CLK(WCLK),
                                    .FULL_FLAG(FULL),
                                    .WRITE_POINTER(WP_node),
                                    .TERMINAL_COUNT(TC_node),
                                    .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));
   defparam FIFO_WPC_INST.WPOINTER_WIDTH = ADDR_WIDTH;
   defparam FIFO_WPC_INST.WDATA_WIDTH = DATA_WIDTH;


   FLAG_LOGIC FIFO_FL_INST(.R_POINTER(RP_node),
                           .W_POINTER(WP_node),
                           .GLOBAL_RST(RST),
                           .READ_EN(RE_node),
                           .READ_CLK(RCLK),
                           .WRITE_EN(WE_node),
                           .WRITE_CLK(WCLK),
                           .FULL_D(FULL_node),
                           .EMPTY_D(EMPTY_node),
                           .AMFULL_D(AMFULL_node),
                           .AMEMPTY_D(AMEMPTY_node),
                           .READ_POINTER_WRAPPED(READ_POINTER_WRAPPED),
                           .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));

   defparam FIFO_FL_INST.POINTER_WIDTH = ADDR_WIDTH;
   defparam FIFO_FL_INST.DATA_WIDTH = DATA_WIDTH;
   defparam FIFO_FL_INST.AMFULL_X = ALMOST_FULL_X;
   defparam FIFO_FL_INST.AMEMPTY_Y = ALMOST_EMPTY_Y;
   defparam FIFO_FL_INST.TERMINAL_COUNT = TERMINAL_COUNT;
   

   SC_BRAM_16K_L_SYNC FIFO_BRAM_INST(.WADA(WP_node),
                                     .WEA(WE_node),
                                     .WDA(DI),
                                     .RADA(RP_node),
                                     .REA(RE_node),
                                     .RDA(DO_node),
                                     .WADB(WP_node),
                                     .WEB(1'b0),
                                     .WDB(DI),
                                     .RADB(RP_node),
                                     .REB(1'b0),
                                     .RDB(),
                                     .WCLK(WCLK),
                                     .RCLK(RCLK),
                                     .RESET(RST)
                                     ); 

   defparam FIFO_BRAM_INST.WADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.MEM_INIT_FILE = "";
   defparam FIFO_BRAM_INST.MEM_INIT_FLAG = 0;
   defparam FIFO_BRAM_INST.ARRAY_SIZE = TERMINAL_COUNT+1;

endmodule
`endcelldefine`timescale 100ps / 1ps
module READ_POINTER_CTRL_V2 (GLOBAL_RST,RESET_RP,READ_EN,READ_CLK,EMPTY_FLAG,READ_POINTER,TERMINAL_COUNT); 

	parameter RPOINTER_WIDTH = 9;

        input GLOBAL_RST;
        input RESET_RP;
        input READ_EN;
        input READ_CLK;
        input EMPTY_FLAG;
	input [RPOINTER_WIDTH -1:0] TERMINAL_COUNT;	
        output [RPOINTER_WIDTH -1:0] READ_POINTER;

	reg [RPOINTER_WIDTH -1:0] s_READ_POINTER;
	reg [RPOINTER_WIDTH -1:0] s_READ_POINTER_temp;	
	integer i;
	
	assign READ_POINTER = s_READ_POINTER;


	initial	begin
		s_READ_POINTER = TERMINAL_COUNT;
	end
	
	always @(GLOBAL_RST or RESET_RP)
	begin
		if (GLOBAL_RST == 1 || RESET_RP == 1)
			assign s_READ_POINTER = TERMINAL_COUNT;	
		else
			deassign s_READ_POINTER;
	end
	
	always @(posedge READ_CLK)
	begin

		if (READ_EN == 1 && EMPTY_FLAG != 0)
			s_READ_POINTER = s_READ_POINTER + 1;

		s_READ_POINTER_temp = TERMINAL_COUNT + 1;	
		if (s_READ_POINTER == s_READ_POINTER_temp)	
		   s_READ_POINTER = 'b0;			
	end

endmodule

`timescale 100ps / 1ps
module WRITE_POINTER_CTRL_V2 (GLOBAL_RST,WRITE_EN,WRITE_CLK,FULL_FLAG,WRITE_POINTER,TERMINAL_COUNT); 

	parameter WPOINTER_WIDTH = 9;
	parameter WDATA_WIDTH = 32;

	input GLOBAL_RST;
	input WRITE_EN;
	input WRITE_CLK;
	input FULL_FLAG;
	input [WPOINTER_WIDTH -1:0] TERMINAL_COUNT; 
	output [WPOINTER_WIDTH -1:0] WRITE_POINTER;

	reg [WPOINTER_WIDTH -1:0] s_WRITE_POINTER;
	reg [WPOINTER_WIDTH -1:0] s_WRITE_POINTER_temp; 


	assign WRITE_POINTER = s_WRITE_POINTER;

	initial	begin
		s_WRITE_POINTER = TERMINAL_COUNT;
	end
	
	always @(GLOBAL_RST)
	begin
		if (GLOBAL_RST == 1)
			assign s_WRITE_POINTER = TERMINAL_COUNT; 
		else
			deassign s_WRITE_POINTER;
	end

	always @(posedge WRITE_CLK)
	begin
		if (WRITE_EN == 1 && FULL_FLAG != 1)
			s_WRITE_POINTER = s_WRITE_POINTER + 1;

		s_WRITE_POINTER_temp = 	TERMINAL_COUNT + 1; 
		if(s_WRITE_POINTER == s_WRITE_POINTER_temp) 
			s_WRITE_POINTER = 'b0; 
	end

endmodule

`timescale 100ps / 1ps
module FLAG_LOGIC_V2 (GLOBAL_RST,FIFO_CAP,FIFO_PTR,FULL_D,EMPTY_D,AMFULL_D,AMEMPTY_D); 

	parameter WDATA_WIDTH = 32;
	paramet